/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.io.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.ResizeableMappedFile;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentEnumeratorBase<Data>
implements Forceable,
Closeable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PersistentEnumerator");
    protected static final int NULL_ID = 0;
    private static final int META_DATA_OFFSET = 4;
    protected static final int DATA_START = 20;
    private static final CacheKey ourFlyweight = new FlyweightKey();
    protected final ResizeableMappedFile myStorage;
    private final boolean myAssumeDifferentSerializedBytesMeansObjectsInequality;
    private final AppendableStorageBackedByResizableMappedFile myKeyStorage;
    protected final KeyDescriptor<Data> myDataDescriptor;
    protected final File myFile;
    private final Version myVersion;
    private final boolean myDoCaching;
    private volatile boolean myDirtyStatusUpdateInProgress;
    private boolean myClosed;
    private boolean myDirty;
    private boolean myCorrupted;
    private RecordBufferHandler<PersistentEnumeratorBase> myRecordHandler;
    private Flushable myMarkCleanCallback;
    private static final int ENUMERATION_CACHE_SIZE;
    private static final SLRUMap<Object, Integer> ourEnumerationCache;

    private static CacheKey sharedKey(Object key, PersistentEnumeratorBase owner) {
        PersistentEnumeratorBase.ourFlyweight.key = key;
        PersistentEnumeratorBase.ourFlyweight.owner = owner;
        return ourFlyweight;
    }

    public static void clearCacheForTests() {
        ourEnumerationCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentEnumeratorBase(@NotNull File file, @NotNull ResizeableMappedFile storage, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @NotNull Version version, @NotNull RecordBufferHandler<? extends PersistentEnumeratorBase> recordBufferHandler, boolean doCaching) throws IOException {
        block25: {
            if (file == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(1);
            }
            if (dataDescriptor == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(2);
            }
            if (version == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(3);
            }
            if (recordBufferHandler == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(4);
            }
            this.myClosed = false;
            this.myDirty = false;
            this.myCorrupted = false;
            this.myDataDescriptor = dataDescriptor;
            this.myFile = file;
            this.myVersion = version;
            this.myRecordHandler = recordBufferHandler;
            this.myDoCaching = doCaching;
            if (!file.exists()) {
                FileUtil.delete(this.keystreamFile());
                if (!FileUtil.createIfDoesntExist(file)) {
                    throw new IOException("Cannot create empty file: " + file);
                }
            }
            this.myStorage = storage;
            this.lockStorage();
            try {
                int sign;
                if (this.myStorage.length() == 0L) {
                    try {
                        this.markDirty(true);
                        this.putMetaData(0L);
                        this.putMetaData2(0L);
                        this.setupEmptyFile();
                        break block25;
                    }
                    catch (RuntimeException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw new CorruptedException(file);
                    }
                }
                try {
                    sign = this.myStorage.getInt(0L);
                }
                catch (Exception e) {
                    LOG.info(e);
                    sign = this.myVersion.dirtyMagic;
                }
                if (sign != this.myVersion.correctlyClosedMagic) {
                    this.myStorage.close();
                    if (sign != this.myVersion.dirtyMagic) {
                        throw new VersionUpdatedException(file);
                    }
                    throw new CorruptedException(file);
                }
            }
            finally {
                this.unlockStorage();
            }
        }
        if (this.myDataDescriptor instanceof InlineKeyDescriptor) {
            this.myKeyStorage = null;
        } else {
            try {
                this.myKeyStorage = new AppendableStorageBackedByResizableMappedFile(this.keystreamFile(), initialSize, this.myStorage.getPagedFileStorage().getStorageLockContext(), 0x100000, false);
            }
            catch (IOException e) {
                this.myStorage.close();
                throw e;
            }
            catch (Throwable e) {
                LOG.info(e);
                this.myStorage.close();
                throw new CorruptedException(file);
            }
        }
        this.myAssumeDifferentSerializedBytesMeansObjectsInequality = this.myDataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy;
    }

    public void lockStorage() {
        this.myStorage.getPagedFileStorage().lock();
    }

    public void unlockStorage() {
        this.myStorage.getPagedFileStorage().unlock();
    }

    protected abstract void setupEmptyFile() throws IOException;

    @NotNull
    public final RecordBufferHandler<PersistentEnumeratorBase> getRecordHandler() {
        RecordBufferHandler<PersistentEnumeratorBase> recordBufferHandler = this.myRecordHandler;
        if (recordBufferHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(5);
        }
        return recordBufferHandler;
    }

    public void setRecordHandler(@NotNull RecordBufferHandler<PersistentEnumeratorBase> recordHandler) {
        if (recordHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(6);
        }
        this.myRecordHandler = recordHandler;
    }

    public void setMarkCleanCallback(Flushable markCleanCallback) {
        this.myMarkCleanCallback = markCleanCallback;
    }

    public Data getValue(int keyId, int processingKey) throws IOException {
        return this.valueOf(keyId);
    }

    protected int tryEnumerate(Data value) throws IOException {
        return this.doEnumerate(value, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnumerate(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        int id;
        if (this.myDoCaching && !saveNewValue) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                Integer cachedId = ourEnumerationCache.get(PersistentEnumeratorBase.sharedKey(value, this));
                if (cachedId != null) {
                    return cachedId;
                }
            }
        }
        try {
            id = this.enumerateImpl(value, onlyCheckForExisting, saveNewValue);
        }
        catch (Throwable e) {
            if (!this.isCorrupted()) {
                this.markCorrupted();
                LOG.info("Marking corrupted:" + this.myFile, e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        if (this.myDoCaching && id != 0) {
            SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
            synchronized (sLRUMap) {
                ourEnumerationCache.put(new CacheKey(value, this), id);
            }
        }
        return id;
    }

    public int enumerate(Data value) throws IOException {
        return this.doEnumerate(value, false, false);
    }

    protected void putMetaData(long data) throws IOException {
        this.lockStorage();
        try {
            if (this.myStorage.length() < 12L || this.getMetaData() != data) {
                this.myStorage.putLong(4L, data);
            }
        }
        finally {
            this.unlockStorage();
        }
    }

    protected long getMetaData() throws IOException {
        this.lockStorage();
        try {
            long l = this.myStorage.getLong(4L);
            return l;
        }
        finally {
            this.unlockStorage();
        }
    }

    protected void putMetaData2(long data) throws IOException {
        this.lockStorage();
        try {
            if (this.myStorage.length() < 20L || this.getMetaData2() != data) {
                this.myStorage.putLong(12L, data);
            }
        }
        finally {
            this.unlockStorage();
        }
    }

    protected long getMetaData2() throws IOException {
        this.lockStorage();
        try {
            long l = this.myStorage.getLong(12L);
            return l;
        }
        finally {
            this.unlockStorage();
        }
    }

    public boolean processAllDataObject(final Processor<Data> processor, final @Nullable DataFilter filter) throws IOException {
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record) throws IOException {
                if (filter == null || filter.accept(record)) {
                    return processor.process(PersistentEnumeratorBase.this.valueOf(record));
                }
                return true;
            }
        });
    }

    public Collection<Data> getAllDataObjects(@Nullable DataFilter filter) throws IOException {
        ArrayList values = new ArrayList();
        this.processAllDataObject(new CommonProcessors.CollectProcessor(values), filter);
        return values;
    }

    public abstract boolean traverseAllRecords(RecordsProcessor var1) throws IOException;

    protected abstract int enumerateImpl(Data var1, boolean var2, boolean var3) throws IOException;

    protected boolean isKeyAtIndex(Data value, int idx) throws IOException {
        if (this.myKeyStorage == null) {
            return false;
        }
        int addr = this.indexToAddr(idx);
        if (this.myKeyStorage.checkBytesAreTheSame(addr, value, this.myDataDescriptor)) {
            return true;
        }
        if (this.myAssumeDifferentSerializedBytesMeansObjectsInequality) {
            return false;
        }
        return this.myDataDescriptor.isEqual(this.valueOf(idx), value);
    }

    protected int writeData(Data value, int hashCode) {
        try {
            this.markDirty(true);
            int dataOff = this.doWriteData(value);
            return this.setupValueId(hashCode, dataOff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLargestId() {
        assert (this.myKeyStorage != null);
        return this.myKeyStorage.getCurrentLength();
    }

    protected int doWriteData(Data value) throws IOException {
        if (this.myKeyStorage != null) {
            return this.myKeyStorage.append(value, this.myDataDescriptor);
        }
        return ((InlineKeyDescriptor)this.myDataDescriptor).toInt(value);
    }

    protected int setupValueId(int hashCode, int dataOff) {
        byte[] buf = this.myRecordHandler.getRecordBuffer(this);
        this.myRecordHandler.setupRecord(this, hashCode, dataOff, buf);
        int pos = this.myRecordHandler.recordWriteOffset(this, buf);
        this.myStorage.put(pos, buf, 0, buf.length);
        return pos;
    }

    public boolean iterateData(Processor<Data> processor) throws IOException {
        if (this.myKeyStorage == null) {
            throw new UnsupportedOperationException("Iteration over InlineIntegerKeyDescriptors is not supported");
        }
        this.lockStorage();
        try {
            this.myKeyStorage.force();
        }
        finally {
            this.unlockStorage();
        }
        return this.myKeyStorage.processAll(processor, this.myDataDescriptor);
    }

    private File keystreamFile() {
        return new File(this.myFile.getPath() + ".keystream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Data valueOf(int idx) throws IOException {
        try {
            this.lockStorage();
            try {
                int addr = this.indexToAddr(idx);
                if (this.myKeyStorage == null) {
                    Object t = ((InlineKeyDescriptor)this.myDataDescriptor).fromInt(addr);
                    return (Data)t;
                }
                Data Data2 = this.myKeyStorage.read(addr, this.myDataDescriptor);
                return Data2;
            }
            finally {
                this.unlockStorage();
            }
        }
        catch (IOException io) {
            this.markCorrupted();
            throw io;
        }
        catch (Throwable e) {
            this.markCorrupted();
            throw new RuntimeException(e);
        }
    }

    int reenumerate(Data key) throws IOException {
        if (!this.canReEnumerate()) {
            throw new IncorrectOperationException();
        }
        return this.doEnumerate(key, false, true);
    }

    boolean canReEnumerate() {
        return false;
    }

    protected abstract int indexToAddr(int var1);

    @Override
    public synchronized void close() throws IOException {
        this.lockStorage();
        try {
            if (!this.myClosed) {
                this.myClosed = true;
                this.doClose();
            }
        }
        finally {
            this.unlockStorage();
        }
    }

    protected void doClose() throws IOException {
        try {
            if (this.myKeyStorage != null) {
                this.myKeyStorage.close();
            }
            this.flush();
        }
        finally {
            this.myStorage.close();
        }
    }

    public synchronized boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public synchronized boolean isDirty() {
        return this.myDirty;
    }

    public synchronized boolean isCorrupted() {
        return this.myCorrupted;
    }

    private synchronized void flush() throws IOException {
        this.lockStorage();
        try {
            if (this.myStorage.isDirty() || this.isDirty()) {
                this.doFlush();
            }
        }
        finally {
            this.unlockStorage();
        }
    }

    protected void doFlush() throws IOException {
        this.markDirty(false);
        this.myStorage.force();
    }

    @Override
    public synchronized void force() {
        this.lockStorage();
        try {
            if (this.myKeyStorage != null) {
                this.myKeyStorage.force();
            }
            this.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.unlockStorage();
        }
    }

    protected final void markDirty(boolean dirty) throws IOException {
        if (dirty && this.myDirty && !this.myDirtyStatusUpdateInProgress) {
            return;
        }
        this.lockStorage();
        try {
            if (this.myDirty) {
                if (!dirty) {
                    this.myDirtyStatusUpdateInProgress = true;
                    if (this.myMarkCleanCallback != null) {
                        this.myMarkCleanCallback.flush();
                    }
                    if (!this.myCorrupted) {
                        this.myStorage.putInt(0L, this.myVersion.correctlyClosedMagic);
                        this.myDirty = false;
                    }
                    this.myDirtyStatusUpdateInProgress = false;
                }
            } else if (dirty) {
                this.myDirtyStatusUpdateInProgress = true;
                this.myStorage.putInt(0L, this.myVersion.dirtyMagic);
                this.myDirtyStatusUpdateInProgress = false;
                this.myDirty = true;
            }
        }
        finally {
            this.unlockStorage();
        }
    }

    protected synchronized void markCorrupted() {
        if (!this.myCorrupted) {
            this.myCorrupted = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Marking corrupted:" + this.myFile, new Throwable());
            }
            try {
                this.markDirty(true);
                this.force();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        String property2 = System.getProperty("idea.enumerationCacheSize");
        ENUMERATION_CACHE_SIZE = property2 == null ? 8192 : Integer.valueOf(property2);
        ourEnumerationCache = new SLRUMap(ENUMERATION_CACHE_SIZE, ENUMERATION_CACHE_SIZE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordBufferHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRecordHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FlyweightKey
    extends CacheKey {
        public FlyweightKey() {
            super(null, null);
        }

        @Override
        public ShareableKey getStableCopy() {
            return new CacheKey(this.key, this.owner);
        }
    }

    public static abstract class RecordsProcessor {
        private int myKey;

        public abstract boolean process(int var1) throws IOException;

        void setCurrentKey(int key) {
            this.myKey = key;
        }

        int getCurrentKey() {
            return this.myKey;
        }
    }

    public static interface DataFilter {
        public boolean accept(int var1);
    }

    public static class VersionUpdatedException
    extends CorruptedException {
        public VersionUpdatedException(File file) {
            super("PersistentEnumerator storage corrupted " + file.getPath());
        }
    }

    public static class CorruptedException
    extends IOException {
        public CorruptedException(File file) {
            this("PersistentEnumerator storage corrupted " + file.getPath());
        }

        protected CorruptedException(String message) {
            super(message);
        }
    }

    private static class CacheKey
    implements ShareableKey {
        public PersistentEnumeratorBase owner;
        public Object key;

        private CacheKey(Object key, PersistentEnumeratorBase owner) {
            this.key = key;
            this.owner = owner;
        }

        @Override
        public ShareableKey getStableCopy() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.key.equals(cacheKey.key)) {
                return false;
            }
            return this.owner.equals(cacheKey.owner);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    public static abstract class RecordBufferHandler<T extends PersistentEnumeratorBase> {
        abstract int recordWriteOffset(T var1, byte[] var2);

        @NotNull
        abstract byte[] getRecordBuffer(T var1);

        abstract void setupRecord(T var1, int var2, int var3, byte[] var4);
    }

    public static class Version {
        private static final int DIRTY_MAGIC = -1161946761;
        private static final int CORRECTLY_CLOSED_MAGIC = 247118589;
        private final int correctlyClosedMagic;
        private final int dirtyMagic;

        public Version(int version) {
            this(247118589 + version, -1161946761);
        }

        private Version(int _correctlyClosedMagic, int _dirtyMagic) {
            this.correctlyClosedMagic = _correctlyClosedMagic;
            this.dirtyMagic = _dirtyMagic;
            assert (this.correctlyClosedMagic != this.dirtyMagic);
        }
    }
}

