/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.ThisPassedAsArgumentVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MismatchedCollectionQueryUpdateInspectionBase
extends BaseInspection {
    private static final CallMatcher TRANSFORMED = CallMatcher.staticCall("java.util.Collections", "asLifoQueue", "checkedCollection", "checkedList", "checkedMap", "checkedNavigableMap", "checkedNavigableSet", "checkedQueue", "checkedSet", "checkedSortedMap", "checkedSortedSet", "newSetFromMap", "synchronizedCollection", "synchronizedList", "synchronizedMap", "synchronizedNavigableMap", "synchronizedNavigableSet", "synchronizedSet", "synchronizedSortedMap", "synchronizedSortedSet");
    private static final CallMatcher DERIVED = CallMatcher.anyOf(CollectionUtils.DERIVED_COLLECTION, CallMatcher.instanceCall("java.util.List", "subList"), CallMatcher.instanceCall("java.util.SortedMap", "headMap", "tailMap", "subMap"), CallMatcher.instanceCall("java.util.SortedSet", "headSet", "tailSet", "subSet"));
    private static final CallMatcher COLLECTION_SAFE_ARGUMENT_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "addAll", "removeAll", "containsAll", "remove"), CallMatcher.instanceCall("java.util.Map", "putAll", "remove"));
    private static final Set<String> COLLECTIONS_QUERIES = ContainerUtil.set("binarySearch", "disjoint", "indexOfSubList", "lastIndexOfSubList", "max", "min");
    private static final Set<String> COLLECTIONS_UPDATES = ContainerUtil.set("addAll", "fill", "copy", "replaceAll", "sort");
    private static final Set<String> COLLECTIONS_ALL = StreamEx.of(COLLECTIONS_QUERIES).append(COLLECTIONS_UPDATES).toImmutableSet();
    public final ExternalizableStringSet queryNames = new ExternalizableStringSet("contains", "copyInto", "equals", "forEach", "get", "hashCode", "iterator", "parallelStream", "propertyNames", "replaceAll", "save", "size", "store", "stream", "toArray", "toString", "write");
    public final ExternalizableStringSet updateNames = new ExternalizableStringSet("add", "clear", "insert", "load", "merge", "offer", "poll", "pop", "push", "put", "remove", "replace", "retain", "set", "take");
    public final ExternalizableStringSet ignoredClasses = new ExternalizableStringSet(new String[0]);

    static boolean isEmptyCollectionInitializer(PsiExpression initializer) {
        PsiExpression[] arguments;
        if (!(initializer instanceof PsiNewExpression)) {
            return ConstructionUtils.isEmptyCollectionInitializer(initializer);
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return false;
            }
            if (CollectionUtils.isCollectionClassOrInterface(argumentType)) {
                return false;
            }
            if (!(argumentType instanceof PsiArrayType)) continue;
            return false;
        }
        return true;
    }

    static boolean isCollectionInitializer(PsiExpression initializer) {
        return MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(initializer) || ConstructionUtils.isPrepopulatedCollectionInitializer(initializer);
    }

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfCollection" == null) {
            MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(0);
        }
        return "MismatchedQueryAndUpdateOfCollection";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.update.collection.display.name", new Object[0]);
        if (string == null) {
            MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.descriptor.updated.not.queried", new Object[0]);
            if (string == null) {
                MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.update.collection.problem.description.queried.not.updated", new Object[0]);
        if (string == null) {
            MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedCollectionQueryUpdateVisitor();
    }

    private QueryUpdateInfo getCollectionQueryUpdateInfo(final @Nullable PsiVariable variable, PsiElement context) {
        final QueryUpdateInfo info = new QueryUpdateInfo();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression ref) {
                super.visitReferenceExpression(ref);
                if (variable == null) {
                    if (ref.getQualifierExpression() == null) {
                        this.makeUpdated();
                        this.makeQueried();
                    }
                } else if (ref.isReferenceTo(variable)) {
                    this.process(this.findEffectiveReference(ref));
                }
            }

            @Override
            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (variable == null) {
                    this.process(this.findEffectiveReference(expression));
                }
            }

            private void makeUpdated() {
                info.updated = true;
                if (info.queried) {
                    this.stopWalking();
                }
            }

            private void makeQueried() {
                info.queried = true;
                if (info.updated) {
                    this.stopWalking();
                }
            }

            private void process(PsiExpression reference) {
                PsiExpressionList args;
                PsiCallExpression surroundingCall;
                PsiMethodCallExpression qualifiedCall = ExpressionUtils.getCallForQualifier(reference);
                if (qualifiedCall != null) {
                    this.processQualifiedCall(qualifiedCall);
                    return;
                }
                PsiElement parent = reference.getParent();
                if (parent instanceof PsiExpressionList && (surroundingCall = ObjectUtils.tryCast((args = (PsiExpressionList)parent).getParent(), PsiCallExpression.class)) != null) {
                    if (surroundingCall instanceof PsiMethodCallExpression && this.processCollectionMethods((PsiMethodCallExpression)surroundingCall, reference)) {
                        return;
                    }
                    this.makeQueried();
                    if (!MismatchedCollectionQueryUpdateInspectionBase.isQueryMethod(surroundingCall) && !COLLECTION_SAFE_ARGUMENT_METHODS.matches(surroundingCall)) {
                        this.makeUpdated();
                    }
                    return;
                }
                if (parent instanceof PsiMethodReferenceExpression) {
                    this.processQualifiedMethodReference((PsiMethodReferenceExpression)parent);
                    return;
                }
                if (parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == reference) {
                    this.makeQueried();
                    return;
                }
                if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == reference) {
                    PsiExpression rValue = ((PsiAssignmentExpression)parent).getRExpression();
                    if (rValue == null) {
                        return;
                    }
                    if (ExpressionUtils.nonStructuralChildren(rValue).allMatch(MismatchedCollectionQueryUpdateInspectionBase::isEmptyCollectionInitializer)) {
                        return;
                    }
                    if (ExpressionUtils.nonStructuralChildren(rValue).allMatch(MismatchedCollectionQueryUpdateInspectionBase::isCollectionInitializer)) {
                        this.makeUpdated();
                        return;
                    }
                }
                if (parent instanceof PsiPolyadicExpression) {
                    IElementType tokenType = ((PsiPolyadicExpression)parent).getOperationTokenType();
                    if (tokenType.equals(JavaTokenType.PLUS)) {
                        this.makeQueried();
                        return;
                    }
                    if (tokenType.equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE)) {
                        return;
                    }
                }
                if (parent instanceof PsiInstanceOfExpression) {
                    return;
                }
                this.makeUpdated();
                this.makeQueried();
            }

            private void processQualifiedMethodReference(PsiMethodReferenceExpression expression) {
                PsiMethod method;
                String methodName = expression.getReferenceName();
                if (MismatchedCollectionQueryUpdateInspectionBase.this.isQueryMethodName(methodName)) {
                    this.makeQueried();
                }
                if (MismatchedCollectionQueryUpdateInspectionBase.this.isUpdateMethodName(methodName)) {
                    this.makeUpdated();
                }
                if ((method = ObjectUtils.tryCast(expression.resolve(), PsiMethod.class)) == null) {
                    return;
                }
                PsiType returnType = method.getReturnType();
                if (PsiType.VOID.equals(returnType)) {
                    return;
                }
                PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false);
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(expectedType);
                if (aClass == null || LambdaHighlightingUtil.checkInterfaceFunctional(aClass) != null) {
                    return;
                }
                PsiMethod functionalMethod = LambdaUtil.getFunctionalInterfaceMethod(aClass);
                if (functionalMethod == null || PsiType.VOID.equals(functionalMethod.getReturnType())) {
                    return;
                }
                this.makeQueried();
            }

            private boolean processCollectionMethods(PsiMethodCallExpression call, PsiExpression arg) {
                PsiExpressionList expressionList = call.getArgumentList();
                String name = call.getMethodExpression().getReferenceName();
                if (!COLLECTIONS_ALL.contains(name) || !MismatchedCollectionQueryUpdateInspectionBase.isCollectionsClassMethod(call)) {
                    return false;
                }
                if (COLLECTIONS_QUERIES.contains(name) && !(call.getParent() instanceof PsiExpressionStatement)) {
                    this.makeQueried();
                    return true;
                }
                if (COLLECTIONS_UPDATES.contains(name)) {
                    int index = ArrayUtil.indexOf(expressionList.getExpressions(), arg);
                    if (index == 0) {
                        this.makeUpdated();
                    } else {
                        this.makeQueried();
                    }
                    return true;
                }
                return false;
            }

            private void processQualifiedCall(PsiMethodCallExpression call) {
                boolean isStatement = call.getParent() instanceof PsiExpressionStatement;
                String name = call.getMethodExpression().getReferenceName();
                boolean queryQualifier = MismatchedCollectionQueryUpdateInspectionBase.this.isQueryMethodName(name);
                boolean updateQualifier = MismatchedCollectionQueryUpdateInspectionBase.this.isUpdateMethodName(name);
                if (queryQualifier && (!isStatement || PsiType.VOID.equals(call.getType()) || "toArray".equals(name) && !call.getArgumentList().isEmpty())) {
                    this.makeQueried();
                }
                if (updateQualifier) {
                    this.makeUpdated();
                    if (!isStatement) {
                        this.makeQueried();
                    }
                }
                if (!queryQualifier && !updateQualifier) {
                    if (!MismatchedCollectionQueryUpdateInspectionBase.isQueryMethod(call)) {
                        this.makeUpdated();
                    }
                    this.makeQueried();
                }
            }

            private PsiExpression findEffectiveReference(PsiExpression expression) {
                while (true) {
                    PsiMethodCallExpression grandParent;
                    PsiElement parent;
                    if ((parent = expression.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiConditionalExpression) {
                        expression = (PsiExpression)parent;
                        continue;
                    }
                    if (parent instanceof PsiReferenceExpression) {
                        grandParent = ObjectUtils.tryCast(parent.getParent(), PsiMethodCallExpression.class);
                        if (DERIVED.test(grandParent)) {
                            expression = grandParent;
                            continue;
                        }
                    }
                    if (!(parent instanceof PsiExpressionList)) break;
                    grandParent = ObjectUtils.tryCast(parent.getParent(), PsiMethodCallExpression.class);
                    if (!TRANSFORMED.test(grandParent)) break;
                    expression = grandParent;
                }
                return expression;
            }
        }
        Visitor visitor = new Visitor();
        context.accept(visitor);
        return info;
    }

    private boolean isQueryMethodName(String methodName) {
        return MismatchedCollectionQueryUpdateInspectionBase.isQueryUpdateMethodName(methodName, this.queryNames);
    }

    private boolean isUpdateMethodName(String methodName) {
        return MismatchedCollectionQueryUpdateInspectionBase.isQueryUpdateMethodName(methodName, this.updateNames);
    }

    private static boolean isQueryUpdateMethodName(String methodName, Set<String> myNames) {
        if (methodName == null) {
            return false;
        }
        if (myNames.contains(methodName)) {
            return true;
        }
        for (String updateName : myNames) {
            if (!methodName.startsWith(updateName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCollectionsClassMethod(PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return "java.util.Collections".equals(qualifiedName);
    }

    private static boolean isQueryMethod(@NotNull PsiCallExpression call) {
        PsiType type;
        boolean immutable;
        if (call == null) {
            MismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(4);
        }
        if (!(immutable = ClassUtils.isImmutable(type = call.getType()))) {
            immutable = call instanceof PsiNewExpression && CollectionUtils.isConcreteCollectionClass(type);
        }
        PsiMethod method = call.resolveMethod();
        if (!immutable && method != null) {
            PsiClass returnType = PsiUtil.resolveClassInClassTypeOnly(method.getReturnType());
            if (returnType instanceof PsiTypeParameter) {
                boolean bl = immutable = ((PsiTypeParameter)returnType).getExtendsList().getReferencedTypes().length == 0;
            }
            if (!immutable) {
                immutable = Mutability.getMutability(method).isUnmodifiable();
            }
        }
        return immutable && !SideEffectChecker.mayHaveSideEffects(call);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class QueryUpdateInfo {
        boolean updated;
        boolean queried;

        QueryUpdateInfo() {
        }
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends BaseInspectionVisitor {
        private MismatchedCollectionQueryUpdateVisitor() {
        }

        private void register(PsiVariable variable, boolean written) {
            List expressions;
            PsiExpression initializer;
            if (written && (initializer = variable.getInitializer()) != null && !(expressions = ExpressionUtils.nonStructuralChildren(initializer).collect(Collectors.toList())).stream().allMatch(MismatchedCollectionQueryUpdateInspectionBase::isCollectionInitializer)) {
                expressions.stream().filter(MismatchedCollectionQueryUpdateInspectionBase::isCollectionInitializer).forEach(emptyCollection -> this.registerError((PsiElement)emptyCollection, Boolean.TRUE));
                return;
            }
            this.registerVariableError(variable, written);
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            boolean read2;
            PsiClass aClass;
            if (field == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!(field.hasModifierProperty("private") || (aClass = field.getContainingClass()) != null && aClass.hasModifierProperty("private") && !field.hasModifierProperty("public"))) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!this.checkVariable(field, containingClass)) {
                return;
            }
            QueryUpdateInfo info = MismatchedCollectionQueryUpdateInspectionBase.this.getCollectionQueryUpdateInfo(field, containingClass);
            boolean written = info.updated || this.updatedViaInitializer(field);
            boolean bl = read2 = info.queried || this.queriedViaInitializer(field);
            if (read2 == written || UnusedSymbolUtil.isImplicitWrite(field) || UnusedSymbolUtil.isImplicitRead(field)) {
                return;
            }
            this.register(field, written);
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            boolean read2;
            if (variable == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!this.checkVariable(variable, codeBlock)) {
                return;
            }
            QueryUpdateInfo info = MismatchedCollectionQueryUpdateInspectionBase.this.getCollectionQueryUpdateInfo(variable, codeBlock);
            boolean written = info.updated || this.updatedViaInitializer(variable);
            boolean bl = read2 = info.queried || this.queriedViaInitializer(variable);
            if (read2 != written) {
                this.register(variable, written);
            }
        }

        private boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type = variable.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return false;
            }
            return MismatchedCollectionQueryUpdateInspectionBase.this.ignoredClasses.stream().noneMatch(className -> InheritanceUtil.isInheritor(type, className));
        }

        private boolean updatedViaInitializer(PsiVariable variable) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !ExpressionUtils.nonStructuralChildren(initializer).allMatch(MismatchedCollectionQueryUpdateInspectionBase::isEmptyCollectionInitializer)) {
                return true;
            }
            if (initializer instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)initializer).getAnonymousClass()) != null) {
                if (((MismatchedCollectionQueryUpdateInspectionBase)MismatchedCollectionQueryUpdateInspectionBase.this).getCollectionQueryUpdateInfo(null, (PsiElement)anonymousClass).updated) {
                    return true;
                }
                ThisPassedAsArgumentVisitor visitor = new ThisPassedAsArgumentVisitor();
                anonymousClass.accept(visitor);
                if (visitor.isPassed()) {
                    return true;
                }
            }
            return false;
        }

        private boolean queriedViaInitializer(PsiVariable variable) {
            PsiExpression initializer = variable.getInitializer();
            return initializer != null && ExpressionUtils.nonStructuralChildren(initializer).noneMatch(MismatchedCollectionQueryUpdateInspectionBase::isCollectionInitializer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

