/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityToSafeEqualsFix
extends InspectionGadgetsFix {
    private final boolean myNegated;

    private EqualityToSafeEqualsFix(boolean negated) {
        this.myNegated = negated;
    }

    @Nullable
    public static EqualityToSafeEqualsFix buildFix(PsiBinaryExpression expression) {
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiExpression lhs = ParenthesesUtils.stripParentheses(expression.getLOperand());
        if (lhs instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)lhs).resolve()) instanceof PsiModifierListOwner) {
            NullableNotNullManager.getInstance(expression.getProject());
            if (NullableNotNullManager.isNotNull((PsiModifierListOwner)target)) {
                return null;
            }
        }
        return new EqualityToSafeEqualsFix(JavaTokenType.NE.equals(expression.getOperationTokenType()));
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        String string = this.myNegated ? InspectionGadgetsBundle.message("inequality.to.safe.not.equals.quickfix", new Object[0]) : InspectionGadgetsBundle.message("equality.to.safe.equals.quickfix", new Object[0]);
        if (string == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("equality.to.safe.equals.quickfix", new Object[0]);
        if (string == null) {
            EqualityToSafeEqualsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement comparisonToken = descriptor.getPsiElement();
        PsiElement parent = comparisonToken.getParent();
        if (!(parent instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)parent;
        PsiExpression lhs = ParenthesesUtils.stripParentheses(expression.getLOperand());
        PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
        if (lhs == null || rhs == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        String lhsText = tracker.text(lhs);
        String rhsText = tracker.text(rhs);
        StringBuilder newExpression = new StringBuilder();
        if (PsiUtil.isLanguageLevel7OrHigher(expression) && ClassUtils.findClass("java.util.Objects", expression) != null) {
            if (JavaTokenType.NE.equals(expression.getOperationTokenType())) {
                newExpression.append('!');
            }
            newExpression.append("java.util.Objects.equals(").append(lhsText).append(',').append(rhsText).append(')');
        } else {
            newExpression.append(lhsText).append("==null?").append(rhsText).append(expression.getOperationSign().getText()).append(" null:");
            if (JavaTokenType.NE.equals(expression.getOperationTokenType())) {
                newExpression.append('!');
            }
            if (ParenthesesUtils.getPrecedence(lhs) > 1) {
                newExpression.append('(').append(lhsText).append(')');
            } else {
                newExpression.append(lhsText);
            }
            newExpression.append(".equals(").append(rhsText).append(')');
        }
        PsiReplacementUtil.replaceExpressionAndShorten(expression, newExpression.toString(), tracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/EqualityToSafeEqualsFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

