/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CharUsedInArithmeticContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.display.name", new Object[0]);
        if (string == null) {
            CharUsedInArithmeticContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.problem.descriptor", new Object[0]);
        if (string == null) {
            CharUsedInArithmeticContextInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiExpression binaryExpression;
        PsiType type;
        ArrayList<InspectionGadgetsFix> result2 = new ArrayList<InspectionGadgetsFix>();
        PsiElement expression = (PsiElement)infos[0];
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpression && (type = (binaryExpression = (PsiExpression)parent).getType()) instanceof PsiPrimitiveType && !type.equals(PsiType.CHAR)) {
            String typeText = type.getCanonicalText();
            result2.add(new CharUsedInArithmeticContentCastFix(typeText));
        }
        if (!(expression instanceof PsiLiteralExpression)) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = result2.toArray(new InspectionGadgetsFix[0]);
            if (inspectionGadgetsFixArray == null) {
                CharUsedInArithmeticContextInspection.$$$reportNull$$$0(2);
            }
            return inspectionGadgetsFixArray;
        }
        while (parent instanceof PsiPolyadicExpression) {
            if (ExpressionUtils.hasStringType((PsiExpression)parent)) {
                result2.add(new CharUsedInArithmeticContentFix());
                break;
            }
            parent = parent.getParent();
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result2.toArray(new InspectionGadgetsFix[0]);
        if (inspectionGadgetsFixArray == null) {
            CharUsedInArithmeticContextInspection.$$$reportNull$$$0(3);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CharUsedInArithmeticContextVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CharUsedInArithmeticContextVisitor
    extends BaseInspectionVisitor {
        private CharUsedInArithmeticContextVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (ComparisonUtils.isComparisonOperation(tokenType)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            PsiType leftType = operands[0].getType();
            for (int i = 1; i < operands.length; ++i) {
                PsiExpression operand = operands[i];
                PsiType rightType = operand.getType();
                PsiType expressionType = TypeConversionUtil.calcTypeForBinaryExpression(leftType, rightType, tokenType, true);
                if (TypeUtils.isJavaLangString(expressionType)) {
                    return;
                }
                if (PsiType.CHAR.equals(rightType)) {
                    this.registerError((PsiElement)operand, operand);
                }
                if (PsiType.CHAR.equals(leftType) && i == 1) {
                    this.registerError((PsiElement)operands[0], operands[0]);
                }
                leftType = rightType;
            }
        }
    }

    private static class CharUsedInArithmeticContentCastFix
    extends InspectionGadgetsFix {
        private final String typeText;

        CharUsedInArithmeticContentCastFix(String typeText) {
            this.typeText = typeText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.cast.quickfix", this.typeText);
            if (string == null) {
                CharUsedInArithmeticContentCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Insert cast" == null) {
                CharUsedInArithmeticContentCastFix.$$$reportNull$$$0(1);
            }
            return "Insert cast";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            CommentTracker commentTracker = new CommentTracker();
            String expressionText = commentTracker.text(expression);
            PsiReplacementUtil.replaceExpression(expression, '(' + this.typeText + ')' + expressionText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentCastFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class CharUsedInArithmeticContentFix
    extends InspectionGadgetsFix {
        private CharUsedInArithmeticContentFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("char.used.in.arithmetic.context.quickfix", new Object[0]);
            if (string == null) {
                CharUsedInArithmeticContentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            Object literal = literalExpression.getValue();
            if (!(literal instanceof Character)) {
                return;
            }
            String escaped = StringUtil.escapeStringCharacters(literal.toString());
            PsiReplacementUtil.replaceExpression(literalExpression, '\"' + escaped + '\"');
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CharUsedInArithmeticContextInspection$CharUsedInArithmeticContentFix", "getFamilyName"));
        }
    }
}

