/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import org.jetbrains.annotations.NotNull;

class RecursionVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean recursive;
    private final PsiMethod method;
    private final String methodName;

    RecursionVisitor(@NotNull PsiMethod method) {
        if (method == null) {
            RecursionVisitor.$$$reportNull$$$0(0);
        }
        this.method = method;
        this.methodName = method.getName();
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            RecursionVisitor.$$$reportNull$$$0(1);
        }
        if (!this.recursive) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            RecursionVisitor.$$$reportNull$$$0(2);
        }
        if (this.recursive) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String calledMethodName = methodExpression.getReferenceName();
        if (!this.methodName.equals(calledMethodName)) {
            return;
        }
        PsiMethod calledMethod = call.resolveMethod();
        if (!this.method.equals(calledMethod)) {
            return;
        }
        if (this.method.hasModifierProperty("static") || this.method.hasModifierProperty("private")) {
            this.recursive = true;
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            this.recursive = true;
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/RecursionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

