/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExecutionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.OrderedSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionCallback
implements Disposable {
    public static final ActionCallback DONE = new Done();
    public static final ActionCallback REJECTED = new Rejected();
    private final ExecutionCallback myDone;
    private final ExecutionCallback myRejected;
    protected String myError;
    private final String myName;

    public ActionCallback() {
        this(null);
    }

    public ActionCallback(String name) {
        this.myName = name;
        this.myDone = new ExecutionCallback();
        this.myRejected = new ExecutionCallback();
    }

    private ActionCallback(@NotNull ExecutionCallback done, @NotNull ExecutionCallback rejected) {
        if (done == null) {
            ActionCallback.$$$reportNull$$$0(0);
        }
        if (rejected == null) {
            ActionCallback.$$$reportNull$$$0(1);
        }
        this.myDone = done;
        this.myRejected = rejected;
        this.myName = null;
    }

    public ActionCallback(int countToDone) {
        this(null, countToDone);
    }

    public ActionCallback(String name, int countToDone) {
        this.myName = name;
        assert (countToDone >= 0) : "count=" + countToDone;
        this.myDone = new ExecutionCallback(countToDone >= 1 ? countToDone : 1);
        this.myRejected = new ExecutionCallback();
        if (countToDone < 1) {
            this.setDone();
        }
    }

    public void setDone() {
        if (this.myDone.setExecuted()) {
            this.myRejected.clear();
            Disposer.dispose(this);
        }
    }

    public boolean isDone() {
        return this.myDone.isExecuted();
    }

    public boolean isRejected() {
        return this.myRejected.isExecuted();
    }

    public boolean isProcessed() {
        return this.isDone() || this.isRejected();
    }

    public void setRejected() {
        if (this.myRejected.setExecuted()) {
            this.myDone.clear();
            Disposer.dispose(this);
        }
    }

    @NotNull
    public ActionCallback reject(String error) {
        this.myError = error;
        this.setRejected();
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(2);
        }
        return actionCallback;
    }

    @Nullable
    public String getError() {
        return this.myError;
    }

    @NotNull
    public final ActionCallback doWhenDone(@NotNull Runnable runnable) {
        if (runnable == null) {
            ActionCallback.$$$reportNull$$$0(3);
        }
        this.myDone.doWhenExecuted(runnable);
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(4);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback doWhenRejected(@NotNull Runnable runnable) {
        if (runnable == null) {
            ActionCallback.$$$reportNull$$$0(5);
        }
        this.myRejected.doWhenExecuted(runnable);
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(6);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback doWhenRejected(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            ActionCallback.$$$reportNull$$$0(7);
        }
        this.myRejected.doWhenExecuted(() -> {
            if (consumer == null) {
                ActionCallback.$$$reportNull$$$0(23);
            }
            consumer.consume(this.myError);
        });
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(8);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback doWhenProcessed(@NotNull Runnable runnable) {
        if (runnable == null) {
            ActionCallback.$$$reportNull$$$0(9);
        }
        this.doWhenDone(runnable);
        this.doWhenRejected(runnable);
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(10);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback notifyWhenDone(@NotNull ActionCallback child) {
        if (child == null) {
            ActionCallback.$$$reportNull$$$0(11);
        }
        ActionCallback actionCallback = this.doWhenDone(child.createSetDoneRunnable());
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(12);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback notifyWhenRejected(@NotNull ActionCallback child) {
        if (child == null) {
            ActionCallback.$$$reportNull$$$0(13);
        }
        ActionCallback actionCallback = this.doWhenRejected(() -> {
            if (child == null) {
                ActionCallback.$$$reportNull$$$0(22);
            }
            child.reject(this.myError);
        });
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(14);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback notify(@NotNull ActionCallback child) {
        if (child == null) {
            ActionCallback.$$$reportNull$$$0(15);
        }
        ActionCallback actionCallback = this.doWhenDone(child.createSetDoneRunnable()).notifyWhenRejected(child);
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(16);
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback processOnDone(@NotNull Runnable runnable, boolean requiresDone) {
        if (runnable == null) {
            ActionCallback.$$$reportNull$$$0(17);
        }
        if (requiresDone) {
            ActionCallback actionCallback = this.doWhenDone(runnable);
            if (actionCallback == null) {
                ActionCallback.$$$reportNull$$$0(18);
            }
            return actionCallback;
        }
        runnable.run();
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            ActionCallback.$$$reportNull$$$0(19);
        }
        return actionCallback;
    }

    @NonNls
    public String toString() {
        String name = this.myName != null ? this.myName : super.toString();
        return name + " done=[" + this.myDone + "] rejected=[" + this.myRejected + "]";
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public Runnable createSetDoneRunnable() {
        Runnable runnable = () -> this.setDone();
        if (runnable == null) {
            ActionCallback.$$$reportNull$$$0(20);
        }
        return runnable;
    }

    @Deprecated
    @NotNull
    public Runnable createSetRejectedRunnable() {
        Runnable runnable = () -> this.setRejected();
        if (runnable == null) {
            ActionCallback.$$$reportNull$$$0(21);
        }
        return runnable;
    }

    public boolean waitFor(long msTimeout) {
        if (this.isProcessed()) {
            return true;
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.doWhenProcessed(() -> semaphore.up());
        try {
            if (msTimeout == -1L) {
                semaphore.waitForUnsafe();
            } else if (!semaphore.waitForUnsafe(msTimeout)) {
                this.reject("Time limit exceeded");
                return false;
            }
        }
        catch (InterruptedException e) {
            this.reject(e.getMessage());
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "done";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejected";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ActionCallback";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ActionCallback";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenDone";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenRejected";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doWhenProcessed";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyWhenDone";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyWhenRejected";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "notify";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processOnDone";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetDoneRunnable";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetRejectedRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doWhenDone";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doWhenRejected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doWhenProcessed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyWhenDone";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "notifyWhenRejected";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processOnDone";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyWhenRejected$1";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doWhenRejected$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Chunk {
        private final Set<ActionCallback> myCallbacks = new OrderedSet<ActionCallback>();

        public void add(@NotNull ActionCallback callback) {
            if (callback == null) {
                Chunk.$$$reportNull$$$0(0);
            }
            this.myCallbacks.add(callback);
        }

        @NotNull
        public ActionCallback create() {
            if (this.isEmpty()) {
                ActionCallback actionCallback = DONE;
                if (actionCallback == null) {
                    Chunk.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }
            ActionCallback result = new ActionCallback(this.myCallbacks.size());
            Runnable doneRunnable = result.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenDone(doneRunnable).notifyWhenRejected(result);
            }
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                Chunk.$$$reportNull$$$0(2);
            }
            return actionCallback;
        }

        public boolean isEmpty() {
            return this.myCallbacks.isEmpty();
        }

        public int getSize() {
            return this.myCallbacks.size();
        }

        @NotNull
        public ActionCallback getWhenProcessed() {
            if (this.myCallbacks.isEmpty()) {
                ActionCallback actionCallback = DONE;
                if (actionCallback == null) {
                    Chunk.$$$reportNull$$$0(3);
                }
                return actionCallback;
            }
            ActionCallback result = new ActionCallback(this.myCallbacks.size());
            Runnable setDoneRunnable = result.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenProcessed(setDoneRunnable);
            }
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                Chunk.$$$reportNull$$$0(4);
            }
            return actionCallback;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/ActionCallback$Chunk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/ActionCallback$Chunk";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWhenProcessed";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IgnoreExecutionCallback
    extends ExecutionCallback {
        private IgnoreExecutionCallback() {
        }

        @Override
        void doWhenExecuted(@NotNull Runnable runnable) {
            if (runnable == null) {
                IgnoreExecutionCallback.$$$reportNull$$$0(0);
            }
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }

        @Override
        boolean isExecuted() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback$IgnoreExecutionCallback", "doWhenExecuted"));
        }
    }

    private static class ExecutedExecutionCallback
    extends ExecutionCallback {
        public ExecutedExecutionCallback() {
            super(0);
        }

        @Override
        void doWhenExecuted(@NotNull Runnable runnable) {
            if (runnable == null) {
                ExecutedExecutionCallback.$$$reportNull$$$0(0);
            }
            runnable.run();
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }

        @Override
        boolean isExecuted() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback$ExecutedExecutionCallback", "doWhenExecuted"));
        }
    }

    public static class Rejected
    extends ActionCallback {
        public Rejected() {
            super(new IgnoreExecutionCallback(), new ExecutedExecutionCallback());
        }
    }

    public static class Done
    extends ActionCallback {
        public Done() {
            super(new ExecutedExecutionCallback(), new IgnoreExecutionCallback());
        }
    }
}

