/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeConversionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.TypeConversionUtil");
    private static final boolean[][] IS_ASSIGNABLE_BIT_SET = new boolean[][]{{true, true, false, true, true, true, true}, {false, true, false, true, true, true, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, true, true, true}, {false, false, false, false, false, true, true}, {false, false, false, false, false, false, true}};
    private static final TObjectIntHashMap<PsiType> TYPE_TO_RANK_MAP = new TObjectIntHashMap();
    public static final int BYTE_RANK = 1;
    public static final int SHORT_RANK = 2;
    public static final int CHAR_RANK = 3;
    public static final int INT_RANK = 4;
    public static final int LONG_RANK = 5;
    private static final int FLOAT_RANK = 6;
    private static final int DOUBLE_RANK = 7;
    private static final int BOOL_RANK = 10;
    private static final int STRING_RANK = 100;
    private static final int MAX_NUMERIC_RANK = 7;
    public static final PsiType NULL_TYPE = new PsiEllipsisType(PsiType.NULL){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        public String getPresentableText(boolean annotated) {
            if ("FAKE TYPE" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "FAKE TYPE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$1", "getPresentableText"));
        }
    };
    private static final Key<PsiElement> ORIGINAL_CONTEXT = Key.create("ORIGINAL_CONTEXT");
    private static final Key<CachedValue<Set<String>>> POSSIBLE_BOXED_HOLDER_TYPES;
    private static final RecursionGuard ourGuard;
    private static final Set<String> INTEGER_NUMBER_TYPES;
    private static final Set<String> PRIMITIVE_TYPES;
    private static final Set<String> PRIMITIVE_WRAPPER_TYPES;
    private static final Caster[][] caster;
    private static final Map<Class, PsiType> WRAPPER_TO_PRIMITIVE;

    private TypeConversionUtil() {
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType) {
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(0);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(1);
        }
        return TypeConversionUtil.areTypesConvertible(fromType, toType, null);
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType, @Nullable LanguageLevel languageLevel) {
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(2);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(3);
        }
        if (fromType == toType) {
            return true;
        }
        boolean fromIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(fromType);
        boolean toIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(toType);
        if (fromIsPrimitive || toIsPrimitive) {
            if (TypeConversionUtil.isVoidType(fromType) || TypeConversionUtil.isVoidType(toType)) {
                return false;
            }
            int fromTypeRank = TypeConversionUtil.getTypeRank(fromType);
            int toTypeRank = TypeConversionUtil.getTypeRank(toType);
            if (!toIsPrimitive) {
                if (fromTypeRank == toTypeRank) {
                    return true;
                }
                if (toType instanceof PsiIntersectionType) {
                    for (PsiType type : ((PsiIntersectionType)toType).getConjuncts()) {
                        if (TypeConversionUtil.areTypesConvertible(fromType, type)) continue;
                        return false;
                    }
                    return true;
                }
                if (!(toType instanceof PsiClassType)) {
                    return false;
                }
                PsiClass toClass = ((PsiClassType)toType).resolve();
                if (toClass == null || toClass instanceof PsiTypeParameter) {
                    return false;
                }
                PsiClassType boxedType = ((PsiPrimitiveType)fromType).getBoxedType(toClass.getManager(), toType.getResolveScope());
                return boxedType != null && TypeConversionUtil.areTypesConvertible(boxedType, toType);
            }
            if (!fromIsPrimitive) {
                if ((fromTypeRank == 2 || fromTypeRank == 1) && toTypeRank == 3) {
                    return false;
                }
                if (fromType instanceof PsiClassType) {
                    if (languageLevel == null) {
                        languageLevel = ((PsiClassType)fromType).getLanguageLevel();
                    }
                    if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
                        PsiClassType classType = (PsiClassType)fromType;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass == null) {
                            return false;
                        }
                        PsiClassType boxedType = ((PsiPrimitiveType)toType).getBoxedType(psiClass.getManager(), psiClass.getResolveScope());
                        if (boxedType != null && TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, boxedType)) {
                            return true;
                        }
                    }
                }
                return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7 && fromTypeRank < toTypeRank;
            }
            return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7;
        }
        if (TypeConversionUtil.isAssignable(toType, fromType)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(fromType) || TypeConversionUtil.isNullType(toType)) {
            return true;
        }
        return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, toType);
    }

    private static boolean isNarrowingReferenceConversionAllowed(@NotNull PsiType fromType, @NotNull PsiType toType) {
        PsiSubstitutor derivedSubstitutor;
        PsiClass derived;
        PsiClassType.ClassResolveResult baseResult;
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(4);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(5);
        }
        if (toType instanceof PsiPrimitiveType || fromType instanceof PsiPrimitiveType) {
            return fromType.equals(toType);
        }
        if (toType instanceof PsiDiamondType || fromType instanceof PsiDiamondType) {
            return false;
        }
        if (toType instanceof PsiArrayType && !(fromType instanceof PsiArrayType)) {
            PsiClass resolved;
            if (fromType instanceof PsiClassType && (resolved = ((PsiClassType)fromType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(boundType, toType)) continue;
                    return false;
                }
                return true;
            }
            if (fromType instanceof PsiCapturedWildcardType) {
                return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiCapturedWildcardType)fromType).getUpperBound(), toType);
            }
            return TypeConversionUtil.isAssignable(fromType, toType);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass resolved;
            if (toType instanceof PsiClassType && (resolved = ((PsiClassType)toType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.areTypesConvertible(fromType, boundType)) continue;
                    return false;
                }
                return true;
            }
            return toType instanceof PsiArrayType && TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiArrayType)fromType).getComponentType(), ((PsiArrayType)toType).getComponentType());
        }
        if (fromType instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)fromType).getConjuncts()) {
                if (!TypeConversionUtil.isNarrowingReferenceConversionAllowed(conjunct, toType)) continue;
                return true;
            }
            return false;
        }
        if (toType instanceof PsiIntersectionType) {
            if (fromType instanceof PsiClassType && ((PsiClassType)fromType).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_8)) {
                for (PsiType conjunct : ((PsiIntersectionType)toType).getConjuncts()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, conjunct)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (fromType instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiDisjunctionType)fromType).getLeastUpperBound(), toType);
        }
        if (toType instanceof PsiDisjunctionType) {
            return false;
        }
        if (fromType instanceof PsiWildcardType) {
            PsiWildcardType fromWildcard = (PsiWildcardType)fromType;
            PsiType bound = fromWildcard.getBound();
            if (bound == null) {
                return true;
            }
            if (fromWildcard.isSuper()) {
                return TypeConversionUtil.isAssignable(toType, bound);
            }
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(bound, toType);
        }
        if (toType instanceof PsiWildcardType) {
            PsiWildcardType toWildcard = (PsiWildcardType)toType;
            if (toWildcard.isSuper()) {
                return false;
            }
            PsiType bound = toWildcard.getBound();
            return bound == null || TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, bound);
        }
        if (toType instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, ((PsiCapturedWildcardType)toType).getUpperBound());
        }
        if (fromType instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiCapturedWildcardType)fromType).getUpperBound(), toType);
        }
        if (TypeConversionUtil.isAssignable(fromType, toType)) {
            return true;
        }
        if (!(fromType instanceof PsiClassType) || !(toType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType fromClassType = (PsiClassType)fromType;
        PsiClassType toClassType = (PsiClassType)toType;
        PsiClassType.ClassResolveResult fromResult = fromClassType.resolveGenerics();
        PsiClass fromClass = fromResult.getElement();
        if (fromClass == null) {
            return false;
        }
        if (fromClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)fromClass), toType);
        }
        PsiClassType.ClassResolveResult toResult = toClassType.resolveGenerics();
        PsiClass toClass = toResult.getElement();
        if (toClass == null) {
            return false;
        }
        if (toClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)toClass));
        }
        PsiManager manager = fromClass.getManager();
        LanguageLevel languageLevel = toClassType.getLanguageLevel();
        if (!fromClass.isInterface()) {
            if (toClass.isInterface()) {
                return (!fromClass.hasModifierProperty("final") || fromClass.isInheritor(toClass, true)) && TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            if (manager.areElementsEquivalent(fromClass, toClass)) {
                return TypeConversionUtil.areSameParameterTypes(fromClassType, toClassType);
            }
            if (toClass.isInheritor(fromClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            if (fromClass.isInheritor(toClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            return false;
        }
        if (!toClass.isInterface()) {
            if (!toClass.hasModifierProperty("final")) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            PsiSubstitutor toSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(fromClass, toClass, toResult.getSubstitutor(), null);
            return toSubstitutor != null && TypeConversionUtil.areSameArgumentTypes(fromClass, fromResult.getSubstitutor(), toSubstitutor);
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            Collection<HierarchicalMethodSignature> fromClassMethodSignatures = fromClass.getVisibleSignatures();
            Collection<HierarchicalMethodSignature> toClassMethodSignatures = toClass.getVisibleSignatures();
            for (HierarchicalMethodSignature fromMethodSignature : fromClassMethodSignatures) {
                for (HierarchicalMethodSignature toMethodSignature : toClassMethodSignatures) {
                    if (!fromMethodSignature.equals(toMethodSignature)) continue;
                    PsiType fromClassReturnType = fromMethodSignature.getMethod().getReturnType();
                    PsiType toClassReturnType = toMethodSignature.getMethod().getReturnType();
                    if (fromClassReturnType == null || toClassReturnType == null || fromClassReturnType.equals(toClassReturnType)) continue;
                    return false;
                }
            }
            return true;
        }
        if (toClass.isInheritor(fromClass, true)) {
            baseResult = fromResult;
            derived = toClass;
            derivedSubstitutor = toResult.getSubstitutor();
        } else {
            baseResult = toResult;
            derived = fromClass;
            derivedSubstitutor = fromResult.getSubstitutor();
        }
        return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, derived, manager, derivedSubstitutor, null, languageLevel);
    }

    @NotNull
    private static PsiClassType obtainSafeSuperType(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType superType;
        PsiClassType.ClassResolveResult result;
        PsiClass superClass;
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(6);
        }
        if ((superClass = (result = (superType = typeParameter.getSuperTypes()[0]).resolveGenerics()).getElement()) != null) {
            PsiSubstitutor substitutor = result.getSubstitutor().put(typeParameter, null);
            PsiClassType psiClassType = JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(superClass, substitutor);
            if (psiClassType == null) {
                TypeConversionUtil.$$$reportNull$$$0(7);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = superType;
        if (psiClassType == null) {
            TypeConversionUtil.$$$reportNull$$$0(8);
        }
        return psiClassType;
    }

    private static boolean checkSuperTypesWithDifferentTypeArguments(@NotNull PsiClassType.ClassResolveResult baseResult, @NotNull PsiClass derived, @NotNull PsiManager manager, @NotNull PsiSubstitutor derivedSubstitutor, Set<PsiClass> visited, @NotNull LanguageLevel languageLevel) {
        if (baseResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(9);
        }
        if (derived == null) {
            TypeConversionUtil.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            TypeConversionUtil.$$$reportNull$$$0(11);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(12);
        }
        if (languageLevel == null) {
            TypeConversionUtil.$$$reportNull$$$0(13);
        }
        if (visited != null && visited.contains(derived)) {
            return true;
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            return true;
        }
        PsiClass base = baseResult.getElement();
        PsiClass[] supers = derived.getSupers();
        if (manager.areElementsEquivalent(base, derived)) {
            derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor);
            return TypeConversionUtil.areSameArgumentTypes(derived, baseResult.getSubstitutor(), derivedSubstitutor, 1);
        }
        PsiSubstitutor baseSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(derived, base, baseResult.getSubstitutor(), null);
        if (baseSubstitutor != null && !TypeConversionUtil.areSameArgumentTypes(derived, baseSubstitutor, derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor))) {
            return false;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        visited.add((PsiClass)derived);
        for (PsiClass aSuper : supers) {
            PsiSubstitutor s = TypeConversionUtil.getSuperClassSubstitutor(aSuper, derived, derivedSubstitutor);
            if (TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, aSuper, manager, s, (Set<PsiClass>)visited, languageLevel)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameParameterTypes(@NotNull PsiClassType type1, @NotNull PsiClassType type2) {
        if (type1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(15);
        }
        PsiClassType.ClassResolveResult resolveResult1 = type1.resolveGenerics();
        PsiClassType.ClassResolveResult resolveResult2 = type2.resolveGenerics();
        PsiClass aClass = resolveResult1.getElement();
        PsiClass bClass = resolveResult2.getElement();
        return aClass != null && bClass != null && aClass.getManager().areElementsEquivalent(aClass, bClass) && TypeConversionUtil.areSameArgumentTypes(aClass, resolveResult1.getSubstitutor(), resolveResult2.getSubstitutor(), 1);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        if (aClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(16);
        }
        if (substitutor1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(17);
        }
        if (substitutor2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(18);
        }
        return TypeConversionUtil.areSameArgumentTypes(aClass, substitutor1, substitutor2, 0);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2, int level) {
        if (aClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(19);
        }
        if (substitutor1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(20);
        }
        if (substitutor2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(21);
        }
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
            PsiType typeArg1 = substitutor1.substitute(typeParameter);
            PsiType typeArg2 = substitutor2.substitute(typeParameter);
            if (typeArg1 == null || typeArg2 == null) {
                return true;
            }
            if (!TypesDistinctProver.provablyDistinct(typeArg1, typeArg2, level)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveAndNotNull(PsiType type) {
        if (type instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isPrimitiveAndNotNull(((PsiCapturedWildcardType)type).getUpperBound());
        }
        return type instanceof PsiPrimitiveType && !TypeConversionUtil.isNullType(type);
    }

    public static boolean isEnumType(PsiType type) {
        if (type instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isEnumType(((PsiCapturedWildcardType)type).getUpperBound());
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass instanceof PsiTypeParameter) {
                return InheritanceUtil.isInheritor(psiClass, true, "java.lang.Enum");
            }
            return psiClass != null && psiClass.isEnum();
        }
        return false;
    }

    public static boolean isNullType(PsiType type) {
        return PsiType.NULL.equals(type);
    }

    public static boolean isFloatOrDoubleType(PsiType type) {
        return TypeConversionUtil.isFloatType(type) || TypeConversionUtil.isDoubleType(type);
    }

    public static boolean isDoubleType(PsiType type) {
        if (type instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isDoubleType(((PsiCapturedWildcardType)type).getUpperBound());
        }
        return PsiType.DOUBLE.equals(type) || PsiType.DOUBLE.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isFloatType(PsiType type) {
        if (type instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isFloatType(((PsiCapturedWildcardType)type).getUpperBound());
        }
        return PsiType.FLOAT.equals(type) || PsiType.FLOAT.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isLongType(PsiType type) {
        if (type instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isLongType(((PsiCapturedWildcardType)type).getUpperBound());
        }
        return PsiType.LONG.equals(type) || PsiType.LONG.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isVoidType(PsiType type) {
        return PsiType.VOID.equals(type);
    }

    public static boolean isBooleanType(@Nullable PsiType type) {
        if (type instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isBooleanType(((PsiCapturedWildcardType)type).getUpperBound());
        }
        return PsiType.BOOLEAN.equals(type) || PsiType.BOOLEAN.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isNumericType(int typeRank) {
        return typeRank <= 7;
    }

    public static boolean isNumericType(PsiType type) {
        return type != null && TypeConversionUtil.isNumericType(TypeConversionUtil.getTypeRank(type));
    }

    public static boolean isIntegralNumberType(PsiType type) {
        return type != null && TypeConversionUtil.getTypeRank(type) <= 5;
    }

    public static int getTypeRank(@NotNull PsiType type) {
        int rank;
        PsiPrimitiveType unboxedType;
        if (type == null) {
            TypeConversionUtil.$$$reportNull$$$0(22);
        }
        if (type instanceof PsiCapturedWildcardType) {
            type = ((PsiCapturedWildcardType)type).getUpperBound();
        }
        if ((unboxedType = PsiPrimitiveType.getUnboxedType(type)) != null) {
            type = unboxedType;
        }
        if ((rank = TYPE_TO_RANK_MAP.get((Object)type)) != 0) {
            return rank;
        }
        if (type.equalsToText("java.lang.String")) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiExpression lOperand, PsiExpression rOperand, boolean strict) {
        if (lOperand == null || rOperand == null) {
            return true;
        }
        PsiType ltype = lOperand.getType();
        PsiType rtype = rOperand.getType();
        return TypeConversionUtil.isBinaryOperatorApplicable(tokenType, ltype, rtype, strict);
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiType ltype, PsiType rtype, boolean strict) {
        if (ltype == null || rtype == null) {
            return true;
        }
        int resultTypeRank = 10;
        boolean isApplicable = false;
        int ltypeRank = TypeConversionUtil.getTypeRank(ltype);
        int rtypeRank = TypeConversionUtil.getTypeRank(rtype);
        if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype) && (TypeConversionUtil.isPrimitiveAndNotNull(ltype) || TypeConversionUtil.isPrimitiveAndNotNull(rtype))) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7 || ltypeRank == 10 && rtypeRank == 10;
            } else {
                if (TypeConversionUtil.isPrimitiveAndNotNull(ltype)) {
                    LanguageLevel languageLevel;
                    return rtype instanceof PsiClassType && (languageLevel = ((PsiClassType)rtype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_5) && !languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(ltype, rtype);
                }
                if (TypeConversionUtil.isPrimitiveAndNotNull(rtype)) {
                    LanguageLevel level;
                    return ltype instanceof PsiClassType && (level = ((PsiClassType)ltype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_7) && !level.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(rtype, ltype);
                }
                isApplicable = TypeConversionUtil.areTypesConvertible(ltype, rtype) || TypeConversionUtil.areTypesConvertible(rtype, ltype);
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (ltype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(rtype);
                resultTypeRank = 100;
            } else if (rtype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(ltype);
                resultTypeRank = 100;
            } else if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.ASTERISK || tokenType == JavaTokenType.DIV || tokenType == JavaTokenType.PERC || tokenType == JavaTokenType.MINUS) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.LTLT || tokenType == JavaTokenType.GTGT || tokenType == JavaTokenType.GTGTGT) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5;
                resultTypeRank = 4;
            }
        } else if (tokenType == JavaTokenType.AND || tokenType == JavaTokenType.OR || tokenType == JavaTokenType.XOR) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5 || TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
                resultTypeRank = ltypeRank <= 5 ? 4 : 10;
            }
        } else if ((tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
            boolean bl = isApplicable = TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
        }
        if (isApplicable && strict) {
            isApplicable = resultTypeRank > 7 ? ltypeRank == resultTypeRank || ltype.equalsToText("java.lang.Object") : ltypeRank <= 7;
        }
        return isApplicable;
    }

    public static boolean isPrimitiveAndNotNullOrWrapper(PsiType type) {
        if (type instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(((PsiCapturedWildcardType)type).getUpperBound());
        }
        if (type instanceof PsiClassType) {
            return PsiPrimitiveType.getUnboxedType(type) != null;
        }
        return TypeConversionUtil.isPrimitiveAndNotNull(type);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, PsiExpression operand) {
        if (token == null) {
            TypeConversionUtil.$$$reportNull$$$0(23);
        }
        if (operand == null) {
            return false;
        }
        PsiType type = operand.getType();
        return type != null && TypeConversionUtil.isUnaryOperatorApplicable(token, type);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, @NotNull PsiType type) {
        if (token == null) {
            TypeConversionUtil.$$$reportNull$$$0(24);
        }
        if (type == null) {
            TypeConversionUtil.$$$reportNull$$$0(25);
        }
        IElementType i = token.getTokenType();
        int typeRank = TypeConversionUtil.getTypeRank(type);
        if (i == JavaTokenType.MINUSMINUS || i == JavaTokenType.PLUSPLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.MINUS || i == JavaTokenType.PLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.TILDE) {
            return typeRank <= 5;
        }
        if (i == JavaTokenType.EXCL) {
            return typeRank == 10;
        }
        LOG.error("unknown token: " + token);
        return true;
    }

    public static boolean isLValue(PsiExpression element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)element;
            PsiElement resolved = expression.resolve();
            return resolved instanceof PsiVariable;
        }
        if (element instanceof PsiParenthesizedExpression) {
            return TypeConversionUtil.isLValue(((PsiParenthesizedExpression)element).getExpression());
        }
        if (element instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)element;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type = arrayExpression.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            PsiType indexType = indexExpression.getType();
            if (indexType == null) {
                return false;
            }
            if (TypeConversionUtil.getTypeRank(indexType) <= 4) {
                return true;
            }
        }
        return false;
    }

    public static boolean areTypesAssignmentCompatible(PsiType lType, PsiExpression rExpr) {
        if (lType == null || rExpr == null) {
            return true;
        }
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return false;
        }
        if (TypeConversionUtil.isAssignable(lType, rType)) {
            return true;
        }
        if (lType instanceof PsiClassType && (lType = PsiPrimitiveType.getUnboxedType(lType)) == null) {
            return false;
        }
        int rTypeRank = TypeConversionUtil.getTypeRank(rType);
        if (lType instanceof PsiPrimitiveType && rType instanceof PsiPrimitiveType && rTypeRank >= 1 && rTypeRank <= 4) {
            long value;
            Object rValue = JavaPsiFacade.getInstance(rExpr.getProject()).getConstantEvaluationHelper().computeConstantExpression(rExpr);
            if (rValue instanceof Number) {
                value = ((Number)rValue).longValue();
            } else if (rValue instanceof Character) {
                value = ((Character)rValue).charValue();
            } else {
                return false;
            }
            if (PsiType.BYTE.equals(lType)) {
                return -128L <= value && value <= 127L;
            }
            if (PsiType.SHORT.equals(lType)) {
                return -32768L <= value && value <= 32767L;
            }
            if (PsiType.CHAR.equals(lType)) {
                return 0L <= value && value <= 65535L;
            }
        }
        return false;
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(26);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(27);
        }
        return TypeConversionUtil.isAssignable(left, right, true);
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(28);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(29);
        }
        return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion, true);
    }

    private static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion, boolean capture) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(30);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(31);
        }
        if (left == right || left.equals(right)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(right)) {
            return !(left instanceof PsiPrimitiveType) || TypeConversionUtil.isNullType(left);
        }
        if (right instanceof PsiMethodReferenceType) {
            PsiMethodReferenceExpression methodReferenceExpression = ((PsiMethodReferenceType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiLambdaExpressionType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            if (left instanceof PsiMethodReferenceType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiMethodReferenceType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            return !(left instanceof PsiArrayType) && methodReferenceExpression.isAcceptable(left);
        }
        if (right instanceof PsiLambdaExpressionType) {
            PsiLambdaExpression rLambdaExpression = ((PsiLambdaExpressionType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiLambdaExpression lLambdaExpression = ((PsiLambdaExpressionType)left).getExpression();
                PsiType rType = rLambdaExpression.getFunctionalInterfaceType();
                PsiType lType = lLambdaExpression.getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            return !(left instanceof PsiArrayType) && rLambdaExpression.isAcceptable(left);
        }
        if (left instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.isAssignable(conjunct, right, allowUncheckedConversion, capture)) continue;
                return false;
            }
            return true;
        }
        if (right instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)right).getConjuncts()) {
                if (!TypeConversionUtil.isAssignable(left, conjunct, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isAssignable(left, ((PsiCapturedWildcardType)right).getUpperBound(capture), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiCapturedWildcardType) {
            return left.equals(right) || TypeConversionUtil.isAssignable(((PsiCapturedWildcardType)left).getLowerBound(), right, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableToWildcard((PsiWildcardType)left, right);
        }
        if (right instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableFromWildcard(left, (PsiWildcardType)right);
        }
        if (right instanceof PsiArrayType) {
            if (!(left instanceof PsiArrayType)) {
                if (left instanceof PsiPrimitiveType || PsiUtil.resolveClassInType(left) == null) {
                    return false;
                }
                PsiClass lClass = PsiUtil.resolveClassInType(left);
                if (lClass == null) {
                    return false;
                }
                if (lClass.isInterface()) {
                    String qualifiedName = lClass.getQualifiedName();
                    return "java.io.Serializable".equals(qualifiedName) || "java.lang.Cloneable".equals(qualifiedName);
                }
                return left.equalsToText("java.lang.Object");
            }
            PsiType lCompType = ((PsiArrayType)left).getComponentType();
            PsiType rCompType = ((PsiArrayType)right).getComponentType();
            if (lCompType instanceof PsiPrimitiveType) {
                return lCompType.equals(rCompType);
            }
            return !(rCompType instanceof PsiPrimitiveType) && TypeConversionUtil.isAssignable(lCompType, rCompType, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiDisjunctionType) {
            for (PsiType type : ((PsiDisjunctionType)left).getDisjunctions()) {
                if (!TypeConversionUtil.isAssignable(type, right, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isAssignable(left, ((PsiDisjunctionType)right).getLeastUpperBound(), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiArrayType) {
            return false;
        }
        if (right instanceof PsiPrimitiveType) {
            if (TypeConversionUtil.isVoidType(right)) {
                return false;
            }
            if (!(left instanceof PsiPrimitiveType)) {
                return left instanceof PsiClassType && TypeConversionUtil.isBoxable((PsiClassType)left, (PsiPrimitiveType)right);
            }
            int leftTypeIndex = TYPE_TO_RANK_MAP.get((Object)left) - 1;
            int rightTypeIndex = TYPE_TO_RANK_MAP.get((Object)right) - 1;
            return leftTypeIndex >= 0 && rightTypeIndex >= 0 && rightTypeIndex < IS_ASSIGNABLE_BIT_SET.length && leftTypeIndex < IS_ASSIGNABLE_BIT_SET.length && IS_ASSIGNABLE_BIT_SET[rightTypeIndex][leftTypeIndex];
        }
        if (!(right instanceof PsiClassType)) {
            return false;
        }
        if (left instanceof PsiPrimitiveType) {
            return TypeConversionUtil.isUnboxable((PsiPrimitiveType)left, (PsiClassType)right, new HashSet<PsiClassType>());
        }
        PsiClassType.ClassResolveResult leftResult = PsiUtil.resolveGenericsClassInType(left);
        PsiClassType.ClassResolveResult rightResult = PsiUtil.resolveGenericsClassInType(right);
        if (leftResult.getElement() == null || rightResult.getElement() == null) {
            String rText;
            if (leftResult.getElement() != rightResult.getElement()) {
                return false;
            }
            String lText = left.getPresentableText();
            if (lText.equals(rText = right.getPresentableText())) {
                return true;
            }
            if (lText.length() > rText.length() && lText.endsWith(rText) && lText.charAt(lText.length() - rText.length() - 1) == '.') {
                return true;
            }
            return rText.length() > lText.length() && rText.endsWith(lText) && rText.charAt(rText.length() - lText.length() - 1) == '.';
        }
        return TypeConversionUtil.isClassAssignable(leftResult, rightResult, allowUncheckedConversion, left.getResolveScope(), capture);
    }

    private static boolean isAssignableFromWildcard(@NotNull PsiType left, @NotNull PsiWildcardType rightWildcardType) {
        PsiClass aClass;
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(32);
        }
        if (rightWildcardType == null) {
            TypeConversionUtil.$$$reportNull$$$0(33);
        }
        if (rightWildcardType.isSuper() && (aClass = PsiUtil.resolveClassInType(rightWildcardType.getSuperBound())) instanceof PsiTypeParameter) {
            PsiClassType[] types;
            for (PsiClassType type : types = aClass.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable(left, type)) continue;
                return true;
            }
        }
        return TypeConversionUtil.isAssignable(left, rightWildcardType.getExtendsBound());
    }

    private static boolean isAssignableToWildcard(@NotNull PsiWildcardType wildcardType, @NotNull PsiType right) {
        if (wildcardType == null) {
            TypeConversionUtil.$$$reportNull$$$0(34);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(35);
        }
        if (wildcardType.isSuper()) {
            return TypeConversionUtil.isAssignable(wildcardType.getSuperBound(), right);
        }
        return TypeConversionUtil.isAssignable(wildcardType.getExtendsBound(), right);
    }

    private static boolean isUnboxable(@NotNull PsiPrimitiveType left, @NotNull PsiClassType right, @NotNull Set<PsiClassType> types) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(36);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(37);
        }
        if (types == null) {
            TypeConversionUtil.$$$reportNull$$$0(38);
        }
        if (!right.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = right.resolve();
        if (psiClass == null) {
            return false;
        }
        if (psiClass instanceof PsiTypeParameter) {
            for (PsiClassType bound : psiClass.getExtendsListTypes()) {
                if (!types.add(bound) || !TypeConversionUtil.isUnboxable(left, bound, types)) continue;
                return true;
            }
            return false;
        }
        PsiPrimitiveType rightUnboxedType = PsiPrimitiveType.getUnboxedType(right);
        return rightUnboxedType != null && TypeConversionUtil.isAssignable(left, rightUnboxedType);
    }

    public static boolean boxingConversionApplicable(PsiType left, PsiType right) {
        if (left instanceof PsiPrimitiveType && !PsiType.NULL.equals(left)) {
            return right instanceof PsiClassType && TypeConversionUtil.isAssignable(left, right);
        }
        if (left instanceof PsiIntersectionType) {
            for (PsiType lConjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.boxingConversionApplicable(lConjunct, right)) continue;
                return false;
            }
            return true;
        }
        return left instanceof PsiClassType && right instanceof PsiPrimitiveType && !PsiType.NULL.equals(right) && TypeConversionUtil.isAssignable(left, right);
    }

    private static boolean isBoxable(@NotNull PsiClassType left, @NotNull PsiPrimitiveType right) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(39);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(40);
        }
        if (!left.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = left.resolve();
        if (psiClass == null) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null || !(psiClass instanceof PsiTypeParameter) && !TypeConversionUtil.getAllBoxedTypeSupers(psiClass).contains(qname)) {
            return false;
        }
        PsiClassType rightBoxed = right.getBoxedType(psiClass.getManager(), left.getResolveScope());
        return rightBoxed != null && TypeConversionUtil.isAssignable(left, rightBoxed);
    }

    @NotNull
    private static Set<String> getAllBoxedTypeSupers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(41);
        }
        PsiManager manager = psiClass.getManager();
        Project project = psiClass.getProject();
        CachedValue<Set<String>> boxedHolderTypes = project.getUserData(POSSIBLE_BOXED_HOLDER_TYPES);
        if (boxedHolderTypes == null) {
            boxedHolderTypes = CachedValuesManager.getManager(manager.getProject()).createCachedValue(() -> {
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                THashSet set = new THashSet();
                for (String qname : PsiPrimitiveType.getAllBoxedTypeNames()) {
                    PsiClass boxedClass = facade.findClass(qname, GlobalSearchScope.allScope(project));
                    InheritanceUtil.processSupers(boxedClass, true, arg_0 -> TypeConversionUtil.lambda$null$0((Set)set, arg_0));
                }
                return CachedValueProvider.Result.create(set, ProjectRootModificationTracker.getInstance(project));
            }, false);
            project.putUserData(POSSIBLE_BOXED_HOLDER_TYPES, boxedHolderTypes);
        }
        Set<String> set = boxedHolderTypes.getValue();
        if (set == null) {
            TypeConversionUtil.$$$reportNull$$$0(42);
        }
        return set;
    }

    private static boolean isClassAssignable(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, GlobalSearchScope resolveScope, boolean capture) {
        if (leftResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(43);
        }
        if (rightResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(44);
        }
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        if (leftClass == null || rightClass == null) {
            return false;
        }
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(leftClass, rightClass, resolveScope, rightResult.getSubstitutor());
        return superSubstitutor != null && TypeConversionUtil.typeParametersAgree(leftResult, rightResult, allowUncheckedConversion, superSubstitutor, capture);
    }

    private static boolean typeParametersAgree(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, PsiSubstitutor superSubstitutor, boolean capture) {
        if (leftResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(45);
        }
        if (rightResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(46);
        }
        PsiSubstitutor rightSubstitutor = rightResult.getSubstitutor();
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        Iterator<PsiTypeParameter> li = PsiUtil.typeParametersIterator(leftClass);
        if (!li.hasNext()) {
            return true;
        }
        PsiSubstitutor leftSubstitutor = leftResult.getSubstitutor();
        if (!leftClass.getManager().areElementsEquivalent(leftClass, rightClass)) {
            rightSubstitutor = superSubstitutor;
            rightClass = leftClass;
        } else if (!PsiUtil.typeParametersIterator(rightClass).hasNext()) {
            return true;
        }
        Iterator<PsiTypeParameter> ri = PsiUtil.typeParametersIterator(rightClass);
        while (li.hasNext()) {
            PsiType typeRight;
            if (!ri.hasNext()) {
                return false;
            }
            PsiTypeParameter lp = li.next();
            PsiTypeParameter rp = ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType psiType = typeRight = PsiCapturedWildcardType.isCapture() && capture ? rightSubstitutor.substituteWithBoundsPromotion(rp) : rightSubstitutor.substitute(rp);
            if (typeRight == null) {
                return allowUncheckedConversion;
            }
            if (TypeConversionUtil.typesAgree(typeLeft, typeRight, allowUncheckedConversion)) continue;
            return false;
        }
        return true;
    }

    public static boolean typesAgree(@NotNull PsiType typeLeft, @NotNull PsiType typeRight, boolean allowUncheckedConversion) {
        if (typeLeft == null) {
            TypeConversionUtil.$$$reportNull$$$0(47);
        }
        if (typeRight == null) {
            TypeConversionUtil.$$$reportNull$$$0(48);
        }
        if (typeLeft instanceof PsiWildcardType) {
            PsiWildcardType leftWildcard = (PsiWildcardType)typeLeft;
            PsiType leftBound = leftWildcard.getBound();
            if (leftBound == null) {
                return true;
            }
            if (leftBound.equalsToText("java.lang.Object")) {
                if (!leftWildcard.isSuper()) {
                    return true;
                }
                if (typeRight.equalsToText("java.lang.Object")) {
                    return true;
                }
            }
            if (typeRight instanceof PsiWildcardType) {
                Boolean assignable;
                PsiWildcardType rightWildcard = (PsiWildcardType)typeRight;
                if (leftWildcard.isExtends()) {
                    return rightWildcard.isExtends() && TypeConversionUtil.isAssignable(leftBound, rightWildcard.getBound(), allowUncheckedConversion, false);
                }
                return rightWildcard.isSuper() && (assignable = ourGuard.doPreventingRecursion(rightWildcard, true, () -> TypeConversionUtil.isAssignable(rightWildcard.getBound(), leftBound, allowUncheckedConversion, false))) != null && assignable != false;
            }
            if (leftWildcard.isExtends()) {
                return TypeConversionUtil.isAssignable(leftBound, typeRight, false, false);
            }
            Boolean assignable = ourGuard.doPreventingRecursion(leftWildcard, true, () -> {
                if (typeRight == null) {
                    TypeConversionUtil.$$$reportNull$$$0(86);
                }
                return TypeConversionUtil.isAssignable(typeRight, leftBound, false, false);
            });
            return assignable == null || assignable != false;
        }
        return typeLeft.equals(typeRight);
    }

    @Nullable
    public static PsiSubstitutor getClassSubstitutor(@NotNull PsiClass superClassCandidate, @NotNull PsiClass derivedClassCandidate, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClassCandidate == null) {
            TypeConversionUtil.$$$reportNull$$$0(49);
        }
        if (derivedClassCandidate == null) {
            TypeConversionUtil.$$$reportNull$$$0(50);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(51);
        }
        if (superClassCandidate.getManager().areElementsEquivalent(superClassCandidate, derivedClassCandidate)) {
            PsiTypeParameter[] baseParams = superClassCandidate.getTypeParameters();
            PsiTypeParameter[] derivedParams = derivedClassCandidate.getTypeParameters();
            if (baseParams.length > 0 && derivedParams.length == 0) {
                return JavaPsiFacade.getInstance(superClassCandidate.getProject()).getElementFactory().createRawSubstitutor(superClassCandidate);
            }
            return derivedSubstitutor;
        }
        return TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClassCandidate, derivedSubstitutor, null);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(52);
        }
        if (derivedClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(53);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(54);
        }
        if (!superClass.hasTypeParameters() && superClass.getContainingClass() == null) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                TypeConversionUtil.$$$reportNull$$$0(55);
            }
            return psiSubstitutor;
        }
        THashSet visited = new THashSet();
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClass, derivedClass, derivedSubstitutor, (Set<PsiClass>)visited);
        if (substitutor == null) {
            JavaClassSupers.getInstance().reportHierarchyInconsistency(superClass, derivedClass);
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                TypeConversionUtil.$$$reportNull$$$0(56);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(57);
        }
        return psiSubstitutor;
    }

    @Nullable
    public static PsiSubstitutor getMaybeSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor, @Nullable Set<PsiClass> visited) {
        if (superClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(58);
        }
        if (derivedClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(59);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(60);
        }
        return JavaClassSupers.getInstance().getSuperClassSubstitutor(superClass, derivedClass, derivedClass.getResolveScope(), derivedSubstitutor);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClassType classType) {
        if (superClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(61);
        }
        if (classType == null) {
            TypeConversionUtil.$$$reportNull$$$0(62);
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, classResolveResult.getElement(), classResolveResult.getSubstitutor());
        if (psiSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(63);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static PsiType binaryNumericPromotion(PsiType type1, PsiType type2) {
        if (TypeConversionUtil.isDoubleType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(64);
            }
            return psiType;
        }
        if (TypeConversionUtil.isDoubleType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(65);
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(66);
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(67);
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(68);
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(69);
            }
            return psiType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            TypeConversionUtil.$$$reportNull$$$0(70);
        }
        return psiPrimitiveType;
    }

    @NotNull
    private static PsiType unbox(@NotNull PsiType type) {
        if (type == null) {
            TypeConversionUtil.$$$reportNull$$$0(71);
        }
        if (type instanceof PsiPrimitiveType) {
            PsiType psiType = type;
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(72);
            }
            return psiType;
        }
        if (type instanceof PsiClassType) {
            LOG.assertTrue((type = PsiPrimitiveType.getUnboxedType(type)) != null);
            PsiType psiType = type;
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(73);
            }
            return psiType;
        }
        LOG.error("Invalid type for unboxing " + type);
        PsiType psiType = type;
        if (psiType == null) {
            TypeConversionUtil.$$$reportNull$$$0(74);
        }
        return psiType;
    }

    public static boolean isIntegerNumber(String typeName) {
        return INTEGER_NUMBER_TYPES.contains(typeName);
    }

    public static boolean isPrimitive(String typeName) {
        return PRIMITIVE_TYPES.contains(typeName);
    }

    public static boolean isPrimitiveWrapper(String typeName) {
        return PRIMITIVE_WRAPPER_TYPES.contains(typeName);
    }

    @Contract(value="null -> false")
    public static boolean isAssignableFromPrimitiveWrapper(PsiType type) {
        if (type == null) {
            return false;
        }
        return TypeConversionUtil.isPrimitiveWrapper(type) || type.equalsToText("java.lang.Object") || type.equalsToText("java.lang.Number");
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveWrapper(PsiType type) {
        return type instanceof PsiClassType && TypeConversionUtil.isPrimitiveWrapper(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isComposite(PsiType type) {
        return type instanceof PsiDisjunctionType || type instanceof PsiIntersectionType;
    }

    public static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(75);
        }
        return TypeConversionUtil.typeParameterErasure(typeParameter, PsiSubstitutor.EMPTY);
    }

    private static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList;
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(76);
        }
        if (beforeSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(77);
        }
        if ((extendsList = typeParameter.getExtendsList().getReferencedTypes()).length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                THashSet visited = new THashSet();
                visited.add(psiClass);
                PsiTypeParameter boundTypeParameter = (PsiTypeParameter)psiClass;
                if (beforeSubstitutor.getSubstitutionMap().containsKey(boundTypeParameter)) {
                    return TypeConversionUtil.erasure(beforeSubstitutor.substitute(boundTypeParameter));
                }
                return TypeConversionUtil.typeParameterErasureInner(boundTypeParameter, (Set<PsiClass>)visited, beforeSubstitutor);
            }
            if (psiClass != null) {
                return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private static PsiClassType typeParameterErasureInner(PsiTypeParameter typeParameter, Set<PsiClass> visited, PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList = typeParameter.getExtendsList().getReferencedTypes();
        if (extendsList.length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                if (!visited.contains(psiClass)) {
                    visited.add(psiClass);
                    if (beforeSubstitutor.getSubstitutionMap().containsKey(psiClass)) {
                        return (PsiClassType)TypeConversionUtil.erasure(beforeSubstitutor.substitute((PsiTypeParameter)psiClass));
                    }
                    return TypeConversionUtil.typeParameterErasureInner((PsiTypeParameter)psiClass, visited, beforeSubstitutor);
                }
            } else if (psiClass != null) {
                return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    @Contract(value="null -> null")
    public static PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure(type, PsiSubstitutor.EMPTY);
    }

    @Contract(value="null, _ -> null")
    public static PsiType erasure(@Nullable PsiType type, final @NotNull PsiSubstitutor beforeSubstitutor) {
        if (beforeSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(78);
        }
        if (type == null) {
            return null;
        }
        return type.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            @Nullable
            public PsiType visitType(PsiType type) {
                return type;
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass instanceof PsiTypeParameter && !TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass)) {
                    return TypeConversionUtil.typeParameterErasure((PsiTypeParameter)aClass, beforeSubstitutor);
                }
                return classType.rawType();
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                return wildcardType;
            }

            @Override
            @Nullable
            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return capturedWildcardType.getUpperBound().accept(this);
            }

            @Override
            public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType;
            }

            @Override
            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                PsiType componentType = ellipsisType.getComponentType();
                PsiType newComponentType = componentType.accept(this);
                if (newComponentType == componentType) {
                    return ellipsisType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType newComponentType = componentType.accept(this);
                if (newComponentType == componentType) {
                    return arrayType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitDisjunctionType(PsiDisjunctionType disjunctionType) {
                PsiClassType lub = PsiTypesUtil.getLowestUpperBoundClassType(disjunctionType);
                return lub != null ? TypeConversionUtil.erasure(lub, beforeSubstitutor) : disjunctionType;
            }
        });
    }

    public static Object computeCastTo(Object operand, PsiType castType) {
        Object value;
        if (operand == null || castType == null) {
            return null;
        }
        if (operand instanceof String && castType.equalsToText("java.lang.String") || operand instanceof Boolean && PsiType.BOOLEAN.equals(castType)) {
            value = operand;
        } else {
            PsiType primitiveType = TypeConversionUtil.wrapperToPrimitive(operand);
            if (primitiveType == null) {
                return null;
            }
            if (castType.equals(primitiveType)) {
                return operand;
            }
            int rankFrom = TypeConversionUtil.getTypeRank(primitiveType);
            if (rankFrom > caster.length) {
                return null;
            }
            int rankTo = TypeConversionUtil.getTypeRank(castType);
            if (rankTo > caster.length) {
                return null;
            }
            value = caster[rankFrom - 1][rankTo - 1].cast(operand);
        }
        return value;
    }

    @NotNull
    public static PsiType unboxAndBalanceTypes(PsiType type1, PsiType type2) {
        if (type1 instanceof PsiClassType) {
            type1 = PsiPrimitiveType.getUnboxedType(type1);
        }
        if (type2 instanceof PsiClassType) {
            type2 = PsiPrimitiveType.getUnboxedType(type2);
        }
        if (PsiType.DOUBLE.equals(type1) || PsiType.DOUBLE.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(79);
            }
            return psiPrimitiveType;
        }
        if (PsiType.FLOAT.equals(type1) || PsiType.FLOAT.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(80);
            }
            return psiPrimitiveType;
        }
        if (PsiType.LONG.equals(type1) || PsiType.LONG.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(81);
            }
            return psiPrimitiveType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            TypeConversionUtil.$$$reportNull$$$0(82);
        }
        return psiPrimitiveType;
    }

    public static IElementType convertEQtoOperation(IElementType eqOpSign) {
        IElementType opSign = null;
        if (eqOpSign == JavaTokenType.ANDEQ) {
            opSign = JavaTokenType.AND;
        } else if (eqOpSign == JavaTokenType.ASTERISKEQ) {
            opSign = JavaTokenType.ASTERISK;
        } else if (eqOpSign == JavaTokenType.DIVEQ) {
            opSign = JavaTokenType.DIV;
        } else if (eqOpSign == JavaTokenType.GTGTEQ) {
            opSign = JavaTokenType.GTGT;
        } else if (eqOpSign == JavaTokenType.GTGTGTEQ) {
            opSign = JavaTokenType.GTGTGT;
        } else if (eqOpSign == JavaTokenType.LTLTEQ) {
            opSign = JavaTokenType.LTLT;
        } else if (eqOpSign == JavaTokenType.MINUSEQ) {
            opSign = JavaTokenType.MINUS;
        } else if (eqOpSign == JavaTokenType.OREQ) {
            opSign = JavaTokenType.OR;
        } else if (eqOpSign == JavaTokenType.PERCEQ) {
            opSign = JavaTokenType.PERC;
        } else if (eqOpSign == JavaTokenType.PLUSEQ) {
            opSign = JavaTokenType.PLUS;
        } else if (eqOpSign == JavaTokenType.XOREQ) {
            opSign = JavaTokenType.XOR;
        }
        return opSign;
    }

    @Nullable
    public static PsiType calcTypeForBinaryExpression(PsiType lType, PsiType rType, @NotNull IElementType sign, boolean accessLType) {
        if (sign == null) {
            TypeConversionUtil.$$$reportNull$$$0(83);
        }
        if (sign == JavaTokenType.PLUS) {
            if (rType == null) {
                return null;
            }
            if (rType.equalsToText("java.lang.String")) {
                return rType;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (lType.equalsToText("java.lang.String")) {
                return lType;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.MINUS || sign == JavaTokenType.ASTERISK || sign == JavaTokenType.DIV || sign == JavaTokenType.PERC) {
            if (rType == null) {
                return null;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.LTLT || sign == JavaTokenType.GTGT || sign == JavaTokenType.GTGTGT) {
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (PsiType.BYTE.equals(lType) || PsiType.CHAR.equals(lType) || PsiType.SHORT.equals(lType)) {
                return PsiType.INT;
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            return lType;
        }
        if (PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS.contains(sign)) {
            return PsiType.BOOLEAN;
        }
        if (sign == JavaTokenType.OR || sign == JavaTokenType.XOR || sign == JavaTokenType.AND) {
            if (rType instanceof PsiClassType) {
                rType = PsiPrimitiveType.getUnboxedType(rType);
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            if (rType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(rType)) {
                return PsiType.BOOLEAN;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(lType)) {
                return PsiType.BOOLEAN;
            }
            if (PsiType.LONG.equals(lType) || PsiType.LONG.equals(rType)) {
                return PsiType.LONG;
            }
            return PsiType.INT;
        }
        LOG.error("Unknown token: " + sign);
        return null;
    }

    public static boolean isFPZero(@NotNull String text) {
        if (text == null) {
            TypeConversionUtil.$$$reportNull$$$0(84);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) && c != '0') {
                return false;
            }
            char d = Character.toUpperCase(c);
            if (d == 'E' || d == 'P') break;
        }
        return true;
    }

    public static boolean areSameFreshVariables(PsiTypeParameter p1, PsiTypeParameter p2) {
        PsiElement originalContext = p1.getUserData(ORIGINAL_CONTEXT);
        return originalContext != null && originalContext == p2.getUserData(ORIGINAL_CONTEXT);
    }

    public static boolean isFreshVariable(PsiTypeParameter typeParameter) {
        return typeParameter.getUserData(ORIGINAL_CONTEXT) != null;
    }

    public static void markAsFreshVariable(PsiTypeParameter parameter, PsiElement context) {
        parameter.putUserData(ORIGINAL_CONTEXT, context);
    }

    private static PsiType wrapperToPrimitive(@NotNull Object o) {
        if (o == null) {
            TypeConversionUtil.$$$reportNull$$$0(85);
        }
        return WRAPPER_TO_PRIMITIVE.get(o.getClass());
    }

    private static /* synthetic */ boolean lambda$null$0(Set set, PsiClass psiClass1) {
        ContainerUtil.addIfNotNull(set, psiClass1.getQualifiedName());
        return true;
    }

    static {
        TYPE_TO_RANK_MAP.put((Object)PsiType.BYTE, 1);
        TYPE_TO_RANK_MAP.put((Object)PsiType.SHORT, 2);
        TYPE_TO_RANK_MAP.put((Object)PsiType.CHAR, 3);
        TYPE_TO_RANK_MAP.put((Object)PsiType.INT, 4);
        TYPE_TO_RANK_MAP.put((Object)PsiType.LONG, 5);
        TYPE_TO_RANK_MAP.put((Object)PsiType.FLOAT, 6);
        TYPE_TO_RANK_MAP.put((Object)PsiType.DOUBLE, 7);
        TYPE_TO_RANK_MAP.put((Object)PsiType.BOOLEAN, 10);
        POSSIBLE_BOXED_HOLDER_TYPES = Key.create("Types that may be possibly assigned from primitive ones");
        ourGuard = RecursionManager.createGuard("isAssignable");
        INTEGER_NUMBER_TYPES = new THashSet(5);
        INTEGER_NUMBER_TYPES.add(PsiType.BYTE.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.CHAR.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.LONG.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.INT.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES = new THashSet(9);
        PRIMITIVE_TYPES.add(PsiType.VOID.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BYTE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.CHAR.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.DOUBLE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.FLOAT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.LONG.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.INT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BOOLEAN.getCanonicalText());
        PRIMITIVE_WRAPPER_TYPES = new THashSet(8);
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Byte");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Character");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Double");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Float");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Long");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Integer");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Short");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Boolean");
        caster = new Caster[][]{{new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    3.$$$reportNull$$$0(0);
                }
                Object object = operand;
                if (object == null) {
                    3.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    4.$$$reportNull$$$0(0);
                }
                Short s = (short)((Number)operand).intValue();
                if (s == null) {
                    4.$$$reportNull$$$0(1);
                }
                return s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    5.$$$reportNull$$$0(0);
                }
                Character c = Character.valueOf((char)((Number)operand).intValue());
                if (c == null) {
                    5.$$$reportNull$$$0(1);
                }
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    6.$$$reportNull$$$0(0);
                }
                Integer n = ((Number)operand).intValue();
                if (n == null) {
                    6.$$$reportNull$$$0(1);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    7.$$$reportNull$$$0(0);
                }
                Long l = ((Number)operand).intValue();
                if (l == null) {
                    7.$$$reportNull$$$0(1);
                }
                return l;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    8.$$$reportNull$$$0(0);
                }
                Float f = Float.valueOf(((Number)operand).intValue());
                if (f == null) {
                    8.$$$reportNull$$$0(1);
                }
                return f;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    9.$$$reportNull$$$0(0);
                }
                Double d = ((Number)operand).intValue();
                if (d == null) {
                    9.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$9";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    10.$$$reportNull$$$0(0);
                }
                Byte by = (byte)((Short)operand).shortValue();
                if (by == null) {
                    10.$$$reportNull$$$0(1);
                }
                return by;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$10";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    11.$$$reportNull$$$0(0);
                }
                Object object = operand;
                if (object == null) {
                    11.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$11";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$11";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    12.$$$reportNull$$$0(0);
                }
                Character c = Character.valueOf((char)((Short)operand).shortValue());
                if (c == null) {
                    12.$$$reportNull$$$0(1);
                }
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$12";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$12";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    13.$$$reportNull$$$0(0);
                }
                Integer n = (int)((Short)operand);
                if (n == null) {
                    13.$$$reportNull$$$0(1);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$13";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$13";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    14.$$$reportNull$$$0(0);
                }
                Long l = (long)((Short)operand);
                if (l == null) {
                    14.$$$reportNull$$$0(1);
                }
                return l;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$14";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$14";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    15.$$$reportNull$$$0(0);
                }
                Float f = Float.valueOf(((Short)operand).shortValue());
                if (f == null) {
                    15.$$$reportNull$$$0(1);
                }
                return f;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$15";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$15";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    16.$$$reportNull$$$0(0);
                }
                Double d = (double)((Short)operand);
                if (d == null) {
                    16.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$16";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$16";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    17.$$$reportNull$$$0(0);
                }
                Byte by = (byte)((Character)operand).charValue();
                if (by == null) {
                    17.$$$reportNull$$$0(1);
                }
                return by;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$17";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$17";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    18.$$$reportNull$$$0(0);
                }
                Short s = (short)((Character)operand).charValue();
                if (s == null) {
                    18.$$$reportNull$$$0(1);
                }
                return s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$18";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$18";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    19.$$$reportNull$$$0(0);
                }
                Object object = operand;
                if (object == null) {
                    19.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$19";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$19";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    20.$$$reportNull$$$0(0);
                }
                Integer n = ((Character)operand).charValue();
                if (n == null) {
                    20.$$$reportNull$$$0(1);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$20";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$20";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    21.$$$reportNull$$$0(0);
                }
                Long l = ((Character)operand).charValue();
                if (l == null) {
                    21.$$$reportNull$$$0(1);
                }
                return l;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$21";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$21";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    22.$$$reportNull$$$0(0);
                }
                Float f = Float.valueOf(((Character)operand).charValue());
                if (f == null) {
                    22.$$$reportNull$$$0(1);
                }
                return f;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$22";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$22";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    23.$$$reportNull$$$0(0);
                }
                Double d = ((Character)operand).charValue();
                if (d == null) {
                    23.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$23";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$23";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    24.$$$reportNull$$$0(0);
                }
                Byte by = (byte)((Integer)operand).intValue();
                if (by == null) {
                    24.$$$reportNull$$$0(1);
                }
                return by;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$24";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$24";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    25.$$$reportNull$$$0(0);
                }
                Short s = (short)((Integer)operand).intValue();
                if (s == null) {
                    25.$$$reportNull$$$0(1);
                }
                return s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$25";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$25";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    26.$$$reportNull$$$0(0);
                }
                Character c = Character.valueOf((char)((Integer)operand).intValue());
                if (c == null) {
                    26.$$$reportNull$$$0(1);
                }
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$26";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$26";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    27.$$$reportNull$$$0(0);
                }
                Object object = operand;
                if (object == null) {
                    27.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$27";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$27";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    28.$$$reportNull$$$0(0);
                }
                Long l = (long)((Integer)operand);
                if (l == null) {
                    28.$$$reportNull$$$0(1);
                }
                return l;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$28";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$28";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    29.$$$reportNull$$$0(0);
                }
                Float f = Float.valueOf(((Integer)operand).intValue());
                if (f == null) {
                    29.$$$reportNull$$$0(1);
                }
                return f;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$29";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$29";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    30.$$$reportNull$$$0(0);
                }
                Double d = (double)((Integer)operand);
                if (d == null) {
                    30.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$30";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$30";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    31.$$$reportNull$$$0(0);
                }
                Byte by = (byte)((Long)operand).longValue();
                if (by == null) {
                    31.$$$reportNull$$$0(1);
                }
                return by;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$31";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$31";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    32.$$$reportNull$$$0(0);
                }
                Short s = (short)((Long)operand).longValue();
                if (s == null) {
                    32.$$$reportNull$$$0(1);
                }
                return s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$32";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$32";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    33.$$$reportNull$$$0(0);
                }
                Character c = Character.valueOf((char)((Long)operand).longValue());
                if (c == null) {
                    33.$$$reportNull$$$0(1);
                }
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$33";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$33";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    34.$$$reportNull$$$0(0);
                }
                Integer n = (int)((Long)operand).longValue();
                if (n == null) {
                    34.$$$reportNull$$$0(1);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$34";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$34";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    35.$$$reportNull$$$0(0);
                }
                Object object = operand;
                if (object == null) {
                    35.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$35";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$35";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    36.$$$reportNull$$$0(0);
                }
                Float f = Float.valueOf(((Long)operand).longValue());
                if (f == null) {
                    36.$$$reportNull$$$0(1);
                }
                return f;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$36";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$36";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    37.$$$reportNull$$$0(0);
                }
                Double d = (double)((Long)operand);
                if (d == null) {
                    37.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$37";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$37";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    38.$$$reportNull$$$0(0);
                }
                Byte by = (byte)((Float)operand).floatValue();
                if (by == null) {
                    38.$$$reportNull$$$0(1);
                }
                return by;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$38";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$38";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    39.$$$reportNull$$$0(0);
                }
                Short s = (short)((Float)operand).floatValue();
                if (s == null) {
                    39.$$$reportNull$$$0(1);
                }
                return s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$39";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$39";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    40.$$$reportNull$$$0(0);
                }
                Character c = Character.valueOf((char)((Float)operand).floatValue());
                if (c == null) {
                    40.$$$reportNull$$$0(1);
                }
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$40";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$40";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    41.$$$reportNull$$$0(0);
                }
                Integer n = (int)((Float)operand).floatValue();
                if (n == null) {
                    41.$$$reportNull$$$0(1);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$41";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$41";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    42.$$$reportNull$$$0(0);
                }
                Long l = (long)((Float)operand).floatValue();
                if (l == null) {
                    42.$$$reportNull$$$0(1);
                }
                return l;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$42";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$42";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    43.$$$reportNull$$$0(0);
                }
                Object object = operand;
                if (object == null) {
                    43.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$43";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$43";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    44.$$$reportNull$$$0(0);
                }
                Double d = ((Float)operand).floatValue();
                if (d == null) {
                    44.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$44";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$44";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    45.$$$reportNull$$$0(0);
                }
                Byte by = (byte)((Double)operand).doubleValue();
                if (by == null) {
                    45.$$$reportNull$$$0(1);
                }
                return by;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$45";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$45";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    46.$$$reportNull$$$0(0);
                }
                Short s = (short)((Double)operand).doubleValue();
                if (s == null) {
                    46.$$$reportNull$$$0(1);
                }
                return s;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$46";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$46";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    47.$$$reportNull$$$0(0);
                }
                Character c = Character.valueOf((char)((Double)operand).doubleValue());
                if (c == null) {
                    47.$$$reportNull$$$0(1);
                }
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$47";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$47";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    48.$$$reportNull$$$0(0);
                }
                Integer n = (int)((Double)operand).doubleValue();
                if (n == null) {
                    48.$$$reportNull$$$0(1);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$48";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$48";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    49.$$$reportNull$$$0(0);
                }
                Long l = (long)((Double)operand).doubleValue();
                if (l == null) {
                    49.$$$reportNull$$$0(1);
                }
                return l;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$49";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$49";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    50.$$$reportNull$$$0(0);
                }
                Float f = new Float((Double)operand);
                if (f == null) {
                    50.$$$reportNull$$$0(1);
                }
                return f;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$50";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$50";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    51.$$$reportNull$$$0(0);
                }
                Object object = operand;
                if (object == null) {
                    51.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil$51";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil$51";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cast";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "cast";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }}};
        WRAPPER_TO_PRIMITIVE = new THashMap(8);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, PsiType.BOOLEAN);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, PsiType.BYTE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, PsiType.CHAR);
        WRAPPER_TO_PRIMITIVE.put(Short.class, PsiType.SHORT);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, PsiType.INT);
        WRAPPER_TO_PRIMITIVE.put(Long.class, PsiType.LONG);
        WRAPPER_TO_PRIMITIVE.put(Float.class, PsiType.FLOAT);
        WRAPPER_TO_PRIMITIVE.put(Double.class, PsiType.DOUBLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 42: 
            case 55: 
            case 56: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 42: 
            case 55: 
            case 56: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 6: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 7: 
            case 8: 
            case 42: 
            case 55: 
            case 56: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseResult";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derived";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: 
            case 51: 
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor1";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor2";
                break;
            }
            case 22: 
            case 25: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 35: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightWildcardType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcardType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftResult";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightResult";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeLeft";
                break;
            }
            case 48: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRight";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassCandidate";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClassCandidate";
                break;
            }
            case 52: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 53: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClass";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeSubstitutor";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainSafeSuperType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBoxedTypeSupers";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassSubstitutor";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryNumericPromotion";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "unbox";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxAndBalanceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areTypesConvertible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNarrowingReferenceConversionAllowed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "obtainSafeSuperType";
                break;
            }
            case 7: 
            case 8: 
            case 42: 
            case 55: 
            case 56: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperTypesWithDifferentTypeArguments";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areSameParameterTypes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "areSameArgumentTypes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeRank";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isUnaryOperatorApplicable";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFromWildcard";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToWildcard";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isUnboxable";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isBoxable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAllBoxedTypeSupers";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isClassAssignable";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersAgree";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "typesAgree";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getClassSubstitutor";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getMaybeSuperClassSubstitutor";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "unbox";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "typeParameterErasure";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "erasure";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "calcTypeForBinaryExpression";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isFPZero";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "wrapperToPrimitive";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "lambda$typesAgree$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 42: 
            case 55: 
            case 56: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Caster {
        @NotNull
        public Object cast(@NotNull Object var1);
    }
}

