/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJavaFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.core.CoreJavaFileManager");
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();
    private final PsiManager myPsiManager;

    public CoreJavaFileManager(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    @Override
    public PsiPackage findPackage(@NotNull String packageName) {
        List<VirtualFile> files;
        if (packageName == null) {
            CoreJavaFileManager.$$$reportNull$$$0(0);
        }
        if (!(files = this.findDirectoriesByPackageName(packageName)).isEmpty()) {
            return new PsiPackageImpl(this.myPsiManager, packageName);
        }
        return null;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result.add(classDir);
        }
        return result;
    }

    @Nullable
    public PsiPackage getPackage(PsiDirectory dir) {
        VirtualFile file = dir.getVirtualFile();
        for (VirtualFile root : this.myClasspath) {
            String relativePath;
            if (!VfsUtilCore.isAncestor(root, file, false) || (relativePath = FileUtil.getRelativePath(root.getPath(), file.getPath(), '/')) == null) continue;
            return new PsiPackageImpl(this.myPsiManager, relativePath.replace('/', '.'));
        }
        return null;
    }

    @Override
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            CoreJavaFileManager.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            CoreJavaFileManager.$$$reportNull$$$0(2);
        }
        for (VirtualFile root : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, root, this.myPsiManager, scope);
            if (psiClass == null) continue;
            return psiClass;
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassInClasspathRoot(@NotNull String qName, @NotNull VirtualFile root, @NotNull PsiManager psiManager, @NotNull GlobalSearchScope scope) {
        String pathComponent;
        VirtualFile child;
        int dot;
        if (qName == null) {
            CoreJavaFileManager.$$$reportNull$$$0(3);
        }
        if (root == null) {
            CoreJavaFileManager.$$$reportNull$$$0(4);
        }
        if (psiManager == null) {
            CoreJavaFileManager.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            CoreJavaFileManager.$$$reportNull$$$0(6);
        }
        String pathRest = qName;
        VirtualFile cur = root;
        while ((dot = pathRest.indexOf(46)) >= 0 && (child = cur.findChild(pathComponent = pathRest.substring(0, dot))) != null) {
            pathRest = pathRest.substring(dot + 1);
            cur = child;
        }
        String classNameWithInnerClasses = pathRest;
        String topLevelClassName = CoreJavaFileManager.substringBeforeFirstDot(classNameWithInnerClasses);
        VirtualFile vFile = cur.findChild(topLevelClassName + ".class");
        if (vFile == null) {
            vFile = cur.findChild(topLevelClassName + ".java");
        }
        if (vFile == null) {
            return null;
        }
        if (!vFile.isValid()) {
            LOG.error("Invalid child of valid parent: " + vFile.getPath() + "; " + root.isValid() + " path=" + root.getPath());
            return null;
        }
        if (!scope.contains(vFile)) {
            return null;
        }
        PsiFile file = psiManager.findFile(vFile);
        if (!(file instanceof PsiClassOwner)) {
            return null;
        }
        return CoreJavaFileManager.findClassInPsiFile(classNameWithInnerClasses, (PsiClassOwner)file);
    }

    @NotNull
    private static String substringBeforeFirstDot(@NotNull String classNameWithInnerClasses) {
        int dot;
        if (classNameWithInnerClasses == null) {
            CoreJavaFileManager.$$$reportNull$$$0(7);
        }
        if ((dot = classNameWithInnerClasses.indexOf(46)) < 0) {
            String string = classNameWithInnerClasses;
            if (string == null) {
                CoreJavaFileManager.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = classNameWithInnerClasses.substring(0, dot);
        if (string == null) {
            CoreJavaFileManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static PsiClass findClassInPsiFile(@NotNull String classNameWithInnerClassesDotSeparated, @NotNull PsiClassOwner file) {
        if (classNameWithInnerClassesDotSeparated == null) {
            CoreJavaFileManager.$$$reportNull$$$0(10);
        }
        if (file == null) {
            CoreJavaFileManager.$$$reportNull$$$0(11);
        }
        for (PsiClass topLevelClass : file.getClasses()) {
            PsiClass candidate = CoreJavaFileManager.findClassByTopLevelClass(classNameWithInnerClassesDotSeparated, topLevelClass);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static PsiClass findClassByTopLevelClass(@NotNull String className, @NotNull PsiClass topLevelClass) {
        if (className == null) {
            CoreJavaFileManager.$$$reportNull$$$0(12);
        }
        if (topLevelClass == null) {
            CoreJavaFileManager.$$$reportNull$$$0(13);
        }
        if (className.indexOf(46) < 0) {
            return className.equals(topLevelClass.getName()) ? topLevelClass : null;
        }
        Iterator<String> segments = StringUtil.split(className, ".").iterator();
        if (!segments.hasNext() || !segments.next().equals(topLevelClass.getName())) {
            return null;
        }
        PsiClass curClass = topLevelClass;
        while (segments.hasNext()) {
            String innerClassName = segments.next();
            PsiClass innerClass = curClass.findInnerClassByName(innerClassName, false);
            if (innerClass == null) {
                return null;
            }
            curClass = innerClass;
        }
        return curClass;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            CoreJavaFileManager.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            CoreJavaFileManager.$$$reportNull$$$0(15);
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (VirtualFile file : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, file, this.myPsiManager, scope);
            if (psiClass == null) continue;
            result.add(psiClass);
        }
        PsiClass[] psiClassArray = result.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            CoreJavaFileManager.$$$reportNull$$$0(16);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            CoreJavaFileManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            CoreJavaFileManager.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            CoreJavaFileManager.$$$reportNull$$$0(19);
        }
        Set<PsiJavaModule> set = Collections.emptySet();
        if (set == null) {
            CoreJavaFileManager.$$$reportNull$$$0(20);
        }
        return set;
    }

    public void addToClasspath(VirtualFile root) {
        this.myClasspath.add(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 6: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameWithInnerClasses";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/core/CoreJavaFileManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameWithInnerClassesDotSeparated";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/core/CoreJavaFileManager";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeFirstDot";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonTrivialPackagePrefixes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClassInClasspathRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeFirstDot";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClassInPsiFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findClassByTopLevelClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

