/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegionTreeElement
implements StructureViewTreeElement {
    private final PsiElement myStartElement;
    private int myEndOffset;
    private final Collection<StructureViewTreeElement> myChildElements;
    private final CustomFoldingProvider myProvider;
    private final CustomRegionTreeElement myParent;
    private List<CustomRegionTreeElement> mySubRegions;

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider, @Nullable CustomRegionTreeElement parent) {
        if (startElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(1);
        }
        this.myEndOffset = Integer.MAX_VALUE;
        this.myChildElements = new ArrayList<StructureViewTreeElement>();
        this.myStartElement = startElement;
        this.myProvider = provider;
        this.myParent = parent;
    }

    public CustomRegionTreeElement(@NotNull PsiElement startElement, @NotNull CustomFoldingProvider provider) {
        if (startElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(3);
        }
        this(startElement, provider, null);
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void navigate(boolean requestFocus) {
        ((Navigatable)((Object)this.myStartElement)).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return this.myStartElement instanceof Navigatable && ((Navigatable)((Object)this.myStartElement)).canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            @Override
            @Nullable
            public String getPresentableText() {
                return CustomRegionTreeElement.this.myProvider.getPlaceholderText(CustomRegionTreeElement.this.myStartElement.getText());
            }

            @Override
            @Nullable
            public String getLocationString() {
                return null;
            }

            @Override
            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Nodes.CustomRegion;
            }
        };
        if (itemPresentation == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(4);
        }
        return itemPresentation;
    }

    public void addChild(@NotNull StructureViewTreeElement childElement) {
        if (childElement == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(5);
        }
        if (this.mySubRegions != null) {
            for (CustomRegionTreeElement subRegion : this.mySubRegions) {
                if (!subRegion.containsElement(childElement)) continue;
                subRegion.addChild(childElement);
                return;
            }
        }
        this.myChildElements.add(childElement);
    }

    @Override
    @NotNull
    public TreeElement[] getChildren() {
        if (this.mySubRegions == null || this.mySubRegions.isEmpty()) {
            TreeElement[] treeElementArray = this.myChildElements.toArray(StructureViewTreeElement.EMPTY_ARRAY);
            if (treeElementArray == null) {
                CustomRegionTreeElement.$$$reportNull$$$0(6);
            }
            return treeElementArray;
        }
        TreeElement[] allElements = new StructureViewTreeElement[this.myChildElements.size() + this.mySubRegions.size()];
        int index = 0;
        for (StructureViewTreeElement structureViewTreeElement : this.myChildElements) {
            allElements[index++] = structureViewTreeElement;
        }
        for (StructureViewTreeElement structureViewTreeElement : this.mySubRegions) {
            allElements[index++] = structureViewTreeElement;
        }
        if (allElements == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(7);
        }
        return allElements;
    }

    public boolean containsElement(StructureViewTreeElement element) {
        TextRange elementRange;
        Object o = element.getValue();
        return o instanceof PsiElement && (elementRange = ((PsiElement)o).getTextRange()).getStartOffset() >= this.myStartElement.getTextRange().getStartOffset() && elementRange.getEndOffset() <= this.myEndOffset;
    }

    public CustomRegionTreeElement createNestedRegion(@NotNull PsiElement element) {
        if (element == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(8);
        }
        if (this.mySubRegions == null) {
            this.mySubRegions = new ArrayList<CustomRegionTreeElement>();
        }
        CustomRegionTreeElement currSubRegion = new CustomRegionTreeElement(element, this.myProvider, this);
        this.mySubRegions.add(currSubRegion);
        return currSubRegion;
    }

    public CustomRegionTreeElement endRegion(@NotNull PsiElement element) {
        if (element == null) {
            CustomRegionTreeElement.$$$reportNull$$$0(9);
        }
        this.myEndOffset = element.getTextRange().getEndOffset();
        return this.myParent;
    }

    public String toString() {
        return "Region '" + this.myProvider.getPlaceholderText(this.myStartElement.getText()) + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/customRegions/CustomRegionTreeElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNestedRegion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "endRegion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

