/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiMethodTreeElement
extends JavaClassTreeElementBase<PsiMethod>
implements SortableTreeElement {
    public PsiMethodTreeElement(PsiMethod method, boolean isInherited) {
        super(isInherited, method);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        List<StructureViewTreeElement> emptyResult = Collections.emptyList();
        PsiMethod element = (PsiMethod)this.getElement();
        if (element == null || element instanceof SyntheticElement) {
            List<StructureViewTreeElement> list = emptyResult;
            if (list == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(0);
            }
            return list;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile instanceof PsiCompiledElement) {
            List<StructureViewTreeElement> list = emptyResult;
            if (list == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(1);
            }
            return list;
        }
        TextRange range = element.getTextRange();
        if (range == null) {
            List<StructureViewTreeElement> list = emptyResult;
            if (list == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(2);
            }
            return list;
        }
        String fileText = psiFile.getText();
        if (fileText == null) {
            List<StructureViewTreeElement> list = emptyResult;
            if (list == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (!range.substring(fileText).contains("class")) {
            List<StructureViewTreeElement> list = emptyResult;
            if (list == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(4);
            }
            return list;
        }
        final ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
        element.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitClass(PsiClass aClass) {
                if (!(aClass instanceof PsiAnonymousClass) && !(aClass instanceof PsiTypeParameter)) {
                    result2.add(new JavaClassTreeElement(aClass, PsiMethodTreeElement.this.isInherited()));
                }
            }
        });
        ArrayList<StructureViewTreeElement> arrayList = result2;
        if (arrayList == null) {
            PsiMethodTreeElement.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    public String getPresentableText() {
        PsiMethod psiMethod = (PsiMethod)this.getElement();
        if (psiMethod == null) {
            return "";
        }
        boolean dumb = DumbService.isDumb(psiMethod.getProject());
        String method = PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 0x105 | (dumb ? 0 : 2), dumb ? 1 : 2);
        return StringUtil.replace(method, ":", ": ");
    }

    @Override
    public String getLocationString() {
        if (!Registry.is("show.method.base.class.in.java.file.structure")) {
            return null;
        }
        PsiMethod method = (PsiMethod)this.getElement();
        if (this.myLocation == null && method != null && !DumbService.isDumb(method.getProject())) {
            if (this.isInherited()) {
                return super.getLocationString();
            }
            try {
                PsiMethod base;
                PsiClass baseClass;
                MethodSignatureBackedByPsiMethod baseMethod = SuperMethodsSearch.search(method, null, true, false).findFirst();
                if (baseMethod != null && !method.isEquivalentTo(baseMethod.getMethod()) && (baseClass = (base = baseMethod.getMethod()).getContainingClass()) != null && baseClass.getMethods().length > 1) {
                    this.myLocation = baseClass.getName();
                }
            }
            catch (IndexNotReadyException baseMethod) {
                // empty catch block
            }
            if (StringUtil.isEmpty(this.myLocation)) {
                this.myLocation = "";
            } else {
                char upArrow = '\u2191';
                this.myLocation = UIUtil.getLabelFont().canDisplay(upArrow) ? upArrow + this.myLocation : this.myLocation;
            }
        }
        return StringUtil.isEmpty(this.myLocation) ? null : this.myLocation;
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        if (this.isInherited()) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        return super.getTextAttributesKey();
    }

    public PsiMethod getMethod() {
        return (PsiMethod)this.getElement();
    }

    @Override
    @NotNull
    public String getAlphaSortKey() {
        PsiMethod method = (PsiMethod)this.getElement();
        if (method != null) {
            String string = method.getName() + " " + StringUtil.join(method.getParameterList().getParameters(), psiParameter -> {
                PsiTypeElement typeElement = psiParameter.getTypeElement();
                return typeElement != null ? typeElement.getText() : "";
            }, " ");
            if (string == null) {
                PsiMethodTreeElement.$$$reportNull$$$0(6);
            }
            return string;
        }
        if ("" == null) {
            PsiMethodTreeElement.$$$reportNull$$$0(7);
        }
        return "";
    }

    @Override
    public String getLocationPrefix() {
        return " ";
    }

    @Override
    public String getLocationSuffix() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/structureView/impl/java/PsiMethodTreeElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlphaSortKey";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

