/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModifiableModelCommitter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.module.impl.ModifiableModelCommitter");

    public static void multiCommit(@NotNull ModifiableRootModel[] rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(0);
        }
        if (moduleModel == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(1);
        }
        ModifiableModelCommitter.multiCommit(Arrays.asList(rootModels), moduleModel);
    }

    public static void multiCommit(@NotNull Collection<ModifiableRootModel> rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(2);
        }
        if (moduleModel == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<RootModelImpl> modelsToCommit = ModifiableModelCommitter.getSortedChangedModels(rootModels, moduleModel);
        SmartList<ModifiableRootModel> modelsToDispose = new SmartList<ModifiableRootModel>(rootModels);
        modelsToDispose.removeAll(modelsToCommit);
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, () -> {
            for (ModifiableRootModel model : modelsToCommit) {
                ModuleRootManagerImpl.doCommit((RootModelImpl)model);
            }
            for (ModifiableRootModel model : modelsToDispose) {
                if (model instanceof RootModelImpl) {
                    ((RootModelImpl)model).checkModuleExtensionModification();
                }
                model.dispose();
            }
        });
    }

    @NotNull
    private static List<RootModelImpl> getSortedChangedModels(Collection<ModifiableRootModel> rootModels, ModifiableModuleModel moduleModel) {
        SmartList<RootModelImpl> result2 = null;
        for (ModifiableRootModel model : rootModels) {
            RootModelImpl rootModel = (RootModelImpl)model;
            if (!rootModel.isChanged()) continue;
            if (result2 == null) {
                result2 = new SmartList<RootModelImpl>();
            }
            result2.add(rootModel);
        }
        if (result2 == null) {
            List<RootModelImpl> list = Collections.emptyList();
            if (list == null) {
                ModifiableModelCommitter.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (result2.size() > 1) {
            result2.sort(ModifiableModelCommitter.createDFSTBuilder((List<RootModelImpl>)result2, moduleModel).comparator());
        }
        SmartList<RootModelImpl> smartList = result2;
        if (smartList == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(List<RootModelImpl> rootModels, final ModifiableModuleModel moduleModel) {
        Module[] modules;
        final HashMap<String, RootModelImpl> nameToModel = ContainerUtil.newHashMap();
        for (RootModelImpl rootModelImpl : rootModels) {
            String name = rootModelImpl.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name), name);
            nameToModel.put(name, rootModelImpl);
        }
        for (Module module : modules = moduleModel.getModules()) {
            String name = module.getName();
            if (nameToModel.containsKey(name)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance(module)).getRootModel();
            nameToModel.put(name, rootModel);
        }
        final Collection collection = nameToModel.values();
        InboundSemiGraph<RootModelImpl> graph = new InboundSemiGraph<RootModelImpl>(){

            @Override
            public Collection<RootModelImpl> getNodes() {
                return collection;
            }

            @Override
            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                OrderEnumerator entries = rootModel.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries();
                List namesList = entries.process(new RootPolicy<List<String>>(){

                    @Override
                    public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, List<String> strings) {
                        Module module;
                        if (moduleOrderEntry == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((module = moduleOrderEntry.getModule()) != null && !module.isDisposed()) {
                            strings.add(module.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOrderEntry", "com/intellij/openapi/roots/impl/ModifiableModelCommitter$1$1", "visitModuleOrderEntry"));
                    }
                }, new ArrayList());
                String[] names = ArrayUtil.toStringArray(namesList);
                ArrayList<RootModelImpl> result2 = new ArrayList<RootModelImpl>();
                for (String name : names) {
                    RootModelImpl depRootModel = (RootModelImpl)nameToModel.get(name);
                    if (depRootModel == null) continue;
                    result2.add(depRootModel);
                }
                return result2.iterator();
            }
        };
        return new DFSTBuilder<RootModelImpl>(GraphGenerator.generate(CachingSemiGraph.cache(graph)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModels";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModifiableModelCommitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModifiableModelCommitter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedChangedModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiCommit";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

