/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.MarkerCache;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPointerTracker {
    private int nextAvailableIndex;
    private int size;
    private PointerReference[] references = new PointerReference[10];
    private final MarkerCache markerCache = new MarkerCache(this);
    private boolean mySorted;

    SmartPointerTracker() {
    }

    synchronized boolean addReference(@NotNull PointerReference reference, @NotNull SmartPsiElementPointerImpl pointer) {
        if (reference == null) {
            SmartPointerTracker.$$$reportNull$$$0(0);
        }
        if (pointer == null) {
            SmartPointerTracker.$$$reportNull$$$0(1);
        }
        if (!this.isActual(reference.file, reference.trackerMap)) {
            return false;
        }
        if (this.needsExpansion() || this.isTooSparse()) {
            this.resize();
            assert (this.isActual(reference.file, reference.trackerMap));
        }
        assert (this.references[this.nextAvailableIndex] == null) : this.references[this.nextAvailableIndex];
        SmartPointerTracker.storePointerReference(this.references, this.nextAvailableIndex++, reference);
        ++this.size;
        this.mySorted = false;
        if (((SelfElementInfo)pointer.getElementInfo()).hasRange()) {
            this.markerCache.rangeChanged();
        }
        return true;
    }

    boolean isActual(VirtualFile file, @NotNull Map<VirtualFile, SmartPointerTracker> trackerMap) {
        if (trackerMap == null) {
            SmartPointerTracker.$$$reportNull$$$0(2);
        }
        return trackerMap.get(file) == this;
    }

    private boolean needsExpansion() {
        return this.nextAvailableIndex >= this.references.length;
    }

    private boolean isTooSparse() {
        return this.nextAvailableIndex > this.size * 2;
    }

    private void resize() {
        PointerReference[] newReferences = new PointerReference[this.size * 3 / 2 + 1];
        int index = 0;
        for (PointerReference ref : this.references) {
            if (ref == null) continue;
            SmartPointerTracker.storePointerReference(newReferences, index++, ref);
        }
        assert (index == this.size) : index + " != " + this.size;
        this.references = newReferences;
        this.nextAvailableIndex = index;
    }

    synchronized void removeReference(@NotNull PointerReference reference, @NotNull Map<VirtualFile, SmartPointerTracker> trackerMap) {
        int index;
        if (reference == null) {
            SmartPointerTracker.$$$reportNull$$$0(3);
        }
        if (trackerMap == null) {
            SmartPointerTracker.$$$reportNull$$$0(4);
        }
        if ((index = reference.index) < 0) {
            return;
        }
        this.assertActual(trackerMap, reference.file);
        assert (this.references[index] == reference) : "At " + index + " expected " + reference + ", found " + this.references[index];
        this.references[index].index = -1;
        this.references[index] = null;
        if (--this.size == 0) {
            trackerMap.remove(reference.file, this);
        }
    }

    private void assertActual(@NotNull Map<VirtualFile, SmartPointerTracker> trackerMap, VirtualFile file) {
        if (trackerMap == null) {
            SmartPointerTracker.$$$reportNull$$$0(5);
        }
        assert (this.isActual(file, trackerMap)) : "Smart pointer list mismatch mismatch:" + (trackerMap.containsKey(file) ? "; has another pointer list" : "");
    }

    private void processAlivePointers(@NotNull Processor<SmartPsiElementPointerImpl<?>> processor) {
        if (processor == null) {
            SmartPointerTracker.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < this.nextAvailableIndex; ++i) {
            PointerReference ref = this.references[i];
            if (ref == null) continue;
            assert (this.isActual(ref.file, ref.trackerMap));
            SmartPsiElementPointerImpl pointer = (SmartPsiElementPointerImpl)ref.get();
            if (pointer == null) {
                this.removeReference(ref, ref.trackerMap);
                continue;
            }
            if (processor.process(pointer)) continue;
            return;
        }
    }

    private void ensureSorted() {
        if (!this.mySorted) {
            ArrayList pointers = new ArrayList();
            this.processAlivePointers(new CommonProcessors.CollectProcessor(pointers));
            assert (this.size == pointers.size());
            pointers.sort((p1, p2) -> MarkerCache.INFO_COMPARATOR.compare((SelfElementInfo)p1.getElementInfo(), (SelfElementInfo)p2.getElementInfo()));
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerTracker.storePointerReference(this.references, i, ((SmartPsiElementPointerImpl)pointers.get((int)i)).pointerReference);
            }
            Arrays.fill(this.references, pointers.size(), this.nextAvailableIndex, null);
            this.nextAvailableIndex = pointers.size();
            this.mySorted = true;
        }
    }

    synchronized void updateMarkers(FrozenDocument frozen, List<DocumentEvent> events) {
        boolean stillSorted = this.markerCache.updateMarkers(frozen, events);
        if (!stillSorted) {
            this.mySorted = false;
        }
    }

    @Nullable
    synchronized Segment getUpdatedRange(SelfElementInfo info, FrozenDocument document, List<DocumentEvent> events) {
        return this.markerCache.getUpdatedRange(info, document, events);
    }

    @Nullable
    synchronized Segment getUpdatedRange(@NotNull PsiFile containingFile, @NotNull Segment segment, boolean isSegmentGreedy, @NotNull FrozenDocument frozen, @NotNull List<DocumentEvent> events) {
        if (containingFile == null) {
            SmartPointerTracker.$$$reportNull$$$0(7);
        }
        if (segment == null) {
            SmartPointerTracker.$$$reportNull$$$0(8);
        }
        if (frozen == null) {
            SmartPointerTracker.$$$reportNull$$$0(9);
        }
        if (events == null) {
            SmartPointerTracker.$$$reportNull$$$0(10);
        }
        return MarkerCache.getUpdatedRange(containingFile, segment, isSegmentGreedy, frozen, events);
    }

    synchronized void switchStubToAst(AnchorElementInfo info, PsiElement element) {
        info.switchToTreeRange(element);
        this.markerCache.rangeChanged();
        this.mySorted = false;
    }

    synchronized void fastenBelts() {
        this.processAlivePointers(pointer -> {
            pointer.getElementInfo().fastenBelt();
            return true;
        });
    }

    synchronized void updatePointerTargetsAfterReparse() {
        this.processAlivePointers(pointer -> {
            if (!(pointer instanceof SmartPsiFileRangePointerImpl)) {
                SmartPointerTracker.updatePointerTarget(pointer, pointer.getPsiRange());
            }
            return true;
        });
    }

    private static <E extends PsiElement> void updatePointerTarget(@NotNull SmartPsiElementPointerImpl<E> pointer, @Nullable Segment pointerRange) {
        E cachedElement;
        if (pointer == null) {
            SmartPointerTracker.$$$reportNull$$$0(11);
        }
        if ((cachedElement = pointer.getCachedElement()) == null) {
            return;
        }
        if (cachedElement.isValid()) {
            if (pointerRange == null) {
                ((SelfElementInfo)pointer.getElementInfo()).switchToAnchor((PsiElement)cachedElement);
                return;
            }
            if (pointerRange.equals(cachedElement.getTextRange())) {
                return;
            }
        }
        pointer.cacheElement(pointer.doRestoreElement());
    }

    private static void storePointerReference(PointerReference[] references, int index, PointerReference ref) {
        references[index] = ref;
        ref.index = index;
    }

    synchronized List<SelfElementInfo> getSortedInfos() {
        this.ensureSorted();
        ArrayList<SelfElementInfo> infos = ContainerUtil.newArrayListWithCapacity(this.size);
        this.processAlivePointers(pointer -> {
            SelfElementInfo info = (SelfElementInfo)pointer.getElementInfo();
            if (!info.hasRange()) {
                return false;
            }
            infos.add(info);
            return true;
        });
        return infos;
    }

    synchronized int getSize() {
        return this.size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackerMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frozen";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPointerTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isActual";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "assertActual";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processAlivePointers";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpdatedRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePointerTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class PointerReference
    extends WeakReference<SmartPsiElementPointerImpl> {
        @NotNull
        final VirtualFile file;
        @NotNull
        final Map<VirtualFile, SmartPointerTracker> trackerMap;
        private int index;

        PointerReference(@NotNull SmartPsiElementPointerImpl<?> pointer, @NotNull VirtualFile containingFile, @NotNull Map<VirtualFile, SmartPointerTracker> trackerMap, @NotNull ReferenceQueue<SmartPsiElementPointerImpl> queue) {
            if (pointer == null) {
                PointerReference.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                PointerReference.$$$reportNull$$$0(1);
            }
            if (trackerMap == null) {
                PointerReference.$$$reportNull$$$0(2);
            }
            if (queue == null) {
                PointerReference.$$$reportNull$$$0(3);
            }
            super(pointer, queue);
            this.index = -2;
            this.file = containingFile;
            this.trackerMap = trackerMap;
            pointer.pointerReference = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pointer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "trackerMap";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "queue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/smartPointers/SmartPointerTracker$PointerReference";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

