/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class InnerClassReferenceVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiClass innerClass;
    private boolean referencesStaticallyAccessible;

    public InnerClassReferenceVisitor(@NotNull PsiClass innerClass) {
        if (innerClass == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(0);
        }
        this.referencesStaticallyAccessible = true;
        this.innerClass = innerClass;
    }

    public boolean canInnerClassBeStatic() {
        PsiClass superClass = this.innerClass.getSuperClass();
        if (superClass != null && !this.isClassStaticallyAccessible(superClass)) {
            return false;
        }
        return this.referencesStaticallyAccessible;
    }

    private boolean isClassStaticallyAccessible(@NotNull PsiClass aClass) {
        if (aClass == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(1);
        }
        if (PsiTreeUtil.isAncestor(this.innerClass, aClass, false) || aClass.hasModifierProperty("static")) {
            return true;
        }
        if (aClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)aClass).getOwner();
            return owner != null && PsiTreeUtil.isAncestor(this.innerClass, owner, false);
        }
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass == null || InheritanceUtil.isInheritorOrSelf(this.innerClass, containingClass, true);
    }

    @Override
    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(2);
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitThisExpression(expression);
        if (this.hasContainingClassQualifier(expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    @Override
    public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
        if (expression == null) {
            InnerClassReferenceVisitor.$$$reportNull$$$0(3);
        }
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitSuperExpression(expression);
        if (this.hasContainingClassQualifier(expression)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private boolean hasContainingClassQualifier(PsiQualifiedExpression expression) {
        PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
        return qualifier != null && !this.innerClass.equals(qualifier.resolve());
    }

    @Override
    public void visitReferenceElement(PsiJavaCodeReferenceElement expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitReferenceElement(expression);
        if (expression.isQualified()) {
            return;
        }
        PsiElement target = expression.resolve();
        if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
            return;
        }
        if (target instanceof PsiMethod || target instanceof PsiField) {
            PsiMember member = (PsiMember)target;
            if (member.hasModifierProperty("static") || PsiTreeUtil.isAncestor(this.innerClass, member, true)) {
                return;
            }
            if (!member.hasModifierProperty("private")) {
                PsiClass containingClass = member.getContainingClass();
                if (InheritanceUtil.isInheritorOrSelf(this.innerClass, containingClass, true)) {
                    return;
                }
                PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                while (parentClass != null && PsiTreeUtil.isAncestor(this.innerClass, parentClass, true)) {
                    if (InheritanceUtil.isInheritorOrSelf(parentClass, containingClass, true)) {
                        return;
                    }
                    parentClass = PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, true);
                }
            }
            this.referencesStaticallyAccessible = false;
        } else if (target instanceof PsiClass && !this.isClassStaticallyAccessible((PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitNewExpression(expression);
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        if (classReference == null) {
            return;
        }
        PsiElement target = classReference.resolve();
        if (!(target instanceof PsiClass)) {
            return;
        }
        if (!this.isClassStaticallyAccessible((PsiClass)target)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    @Override
    public void visitTypeElement(PsiTypeElement typeElement) {
        if (!this.referencesStaticallyAccessible) {
            return;
        }
        super.visitTypeElement(typeElement);
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(typeElement.getType());
        if (aClass instanceof PsiTypeParameter && !PsiTreeUtil.isAncestor(this.innerClass, aClass, true)) {
            this.referencesStaticallyAccessible = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/memory/InnerClassReferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassStaticallyAccessible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThisExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSuperExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

