/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsClassNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.name.same.as.class.name.display.name", new Object[0]);
        if (string == null) {
            MethodNameSameAsClassNameInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.name.same.as.class.name.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodNameSameAsClassNameInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNameSameAsClassNameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/MethodNameSameAsClassNameInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MethodNameSameAsClassNameVisitor
    extends BaseInspectionVisitor {
        private MethodNameSameAsClassNameVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodNameSameAsClassNameVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor()) {
                return;
            }
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getName();
            if (!methodName.equals(className)) {
                return;
            }
            MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
            boolean canReplaceWithConstructor = method.getBody() != null && !containingClass.isInterface() && Arrays.stream(containingClass.getConstructors()).noneMatch(ctor -> MethodSignatureUtil.areErasedParametersEqual(signature, ctor.getSignature(PsiSubstitutor.EMPTY)));
            this.registerMethodError(method, this.isOnTheFly(), canReplaceWithConstructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/MethodNameSameAsClassNameInspectionBase$MethodNameSameAsClassNameVisitor", "visitMethod"));
        }
    }
}

