/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationInvocationHandler
implements InvocationHandler {
    @NotNull
    private final Class<? extends Annotation> type;
    @NotNull
    private final PsiAnnotation myAnnotation;

    AnnotationInvocationHandler(@NotNull Class<? extends Annotation> type, @NotNull PsiAnnotation annotation) {
        if (type == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(1);
        }
        this.type = type;
        this.myAnnotation = annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object[] paramTypes = method.getParameterTypes();
        assert (paramTypes.length == 0) : Arrays.toString(paramTypes);
        String member = method.getName();
        if (member.equals("toString")) {
            return this.toStringImpl();
        }
        if (member.equals("annotationType")) {
            return this.type;
        }
        Pair<PsiAnnotationMemberValue, String> pair = AnnotationInvocationHandler.attributeValueOrError(this.myAnnotation, member);
        PsiAnnotationMemberValue value = (PsiAnnotationMemberValue)pair.first;
        if (value == null) {
            String error = (String)pair.second;
            throw new IncompleteAnnotationException(this.type, member + ". (Unable to find attribute in '" + this.myAnnotation.getText() + "': " + error + ")");
        }
        Object result2 = JavaPsiFacade.getInstance(this.myAnnotation.getProject()).getConstantEvaluationHelper().computeConstantExpression(value);
        if (result2 == null) {
            throw new IncompleteAnnotationException(this.type, member + ". (Unable to evaluate annotation value '" + value + "')");
        }
        return result2;
    }

    @NotNull
    private static Pair<PsiAnnotationMemberValue, String> attributeValueOrError(@NotNull PsiAnnotation annotation, @Nullable @NonNls String attributeName) {
        PsiMethod[] methods;
        PsiClass psiClass;
        PsiJavaCodeReferenceElement referenceElement;
        PsiNameValuePair attribute;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(2);
        }
        PsiAnnotationMemberValue psiAnnotationMemberValue = value = (attribute = AnnotationUtil.findDeclaredAttribute(annotation, attributeName)) == null ? null : attribute.getValue();
        if (value != null) {
            Pair<PsiAnnotationMemberValue, Object> pair = Pair.create(value, null);
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(3);
            }
            return pair;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) == null) {
            Pair<Object, String> pair = Pair.create(null, "no reference found in " + annotation.getText());
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(4);
            }
            return pair;
        }
        PsiElement resolved = referenceElement.resolve();
        if (resolved == null) {
            Pair<Object, String> pair = Pair.create(null, "can't resolve reference '" + referenceElement.getText() + "'");
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(5);
            }
            return pair;
        }
        if (!(resolved instanceof PsiClass) || !(psiClass = (PsiClass)resolved).isAnnotationType()) {
            Pair<Object, String> pair = Pair.create(null, "reference '" + referenceElement.getText() + "' resolved to " + resolved + " (" + resolved.getClass() + ") instead of enum");
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(6);
            }
            return pair;
        }
        for (PsiMethod method : methods = psiClass.findMethodsByName(attributeName, false)) {
            if (!(method instanceof PsiAnnotationMethod)) continue;
            PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)method).getDefaultValue();
            if (defaultValue != null) {
                Pair<PsiAnnotationMemberValue, Object> pair = Pair.create(defaultValue, null);
                if (pair == null) {
                    AnnotationInvocationHandler.$$$reportNull$$$0(7);
                }
                return pair;
            }
            Pair<Object, String> pair = Pair.create(null, "method has no value nor default value: " + method.getText());
            if (pair == null) {
                AnnotationInvocationHandler.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair<Object, String> pair = Pair.create(null, "method '" + attributeName + "' not found in " + psiClass.getQualifiedName() + " among methods " + Arrays.asList(psiClass.getMethods()));
        if (pair == null) {
            AnnotationInvocationHandler.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private String toStringImpl() {
        PsiNameValuePair[] attributes;
        StringBuilder result2 = new StringBuilder(128);
        result2.append('@');
        result2.append(this.type.getName());
        result2.append('(');
        boolean firstMember = true;
        for (PsiNameValuePair e : attributes = this.myAnnotation.getParameterList().getAttributes()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result2.append(", ");
            }
            result2.append(e.getName());
            result2.append('=');
            PsiAnnotationMemberValue value = e.getValue();
            result2.append(value == null ? "null" : value.getText());
        }
        result2.append(')');
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/AnnotationInvocationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/AnnotationInvocationHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "attributeValueOrError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attributeValueOrError";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

