/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaUtilImpl
extends RefJavaUtil {
    @Override
    public void addReferences(final @NotNull PsiModifierListOwner psiFrom, @NotNull RefJavaElement ref, @Nullable PsiElement findIn) {
        if (psiFrom == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(1);
        }
        final RefJavaElementImpl refFrom = (RefJavaElementImpl)ref;
        if (findIn == null) {
            return;
        }
        findIn.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                this.visitElement(reference);
                PsiElement target = reference.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference(aClass);
                    refFrom.addReference(refClass, aClass, psiFrom, false, true, null);
                }
                if (target instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated(target)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
            }

            @Override
            public void visitLiteralExpression(PsiLiteralExpression expression) {
                for (PsiReference reference : expression.getReferences()) {
                    PsiElement resolve = reference.resolve();
                    if (!(resolve instanceof PsiMember)) continue;
                    RefElement refResolved = refFrom.getRefManager().getReference(resolve);
                    refFrom.addReference(refResolved, resolve, psiFrom, false, true, null);
                    if (!(refResolved instanceof RefMethod)) continue;
                    RefJavaUtilImpl.this.updateRefMethod(resolve, refResolved, expression, psiFrom, refFrom);
                }
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                RefElement refContainingClass;
                PsiClass containingClass;
                this.visitElement(expression);
                JavaResolveResult result2 = expression.advancedResolve(false);
                PsiElement psiResolved = result2.getElement();
                if (psiResolved instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated(psiResolved)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
                RefElement refResolved = refFrom.getRefManager().getReference(psiResolved);
                refFrom.addReference(refResolved, psiResolved, psiFrom, PsiUtil.isAccessedForWriting(expression), PsiUtil.isAccessedForReading(expression), expression);
                if (refResolved instanceof RefMethod) {
                    RefJavaUtilImpl.this.updateRefMethod(psiResolved, refResolved, expression, psiFrom, refFrom);
                }
                if (psiResolved instanceof PsiMember && result2.getCurrentFileResolveScope() instanceof PsiImportStaticStatement && (containingClass = ((PsiMember)psiResolved).getContainingClass()) != null && (refContainingClass = refFrom.getRefManager().getReference(containingClass)) != null) {
                    refFrom.addReference(refContainingClass, containingClass, psiFrom, false, true, expression);
                }
            }

            @Override
            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                super.visitEnumConstant(enumConstant);
                this.processNewLikeConstruct(enumConstant.resolveConstructor(), enumConstant.getArgumentList());
            }

            @Override
            public void visitNewExpression(PsiNewExpression newExpr) {
                PsiType newType;
                super.visitNewExpression(newExpr);
                PsiMethod psiConstructor = newExpr.resolveConstructor();
                PsiExpressionList argumentList = newExpr.getArgumentList();
                RefMethod refConstructor = this.processNewLikeConstruct(psiConstructor, argumentList);
                if (refConstructor == null && (newType = newExpr.getType()) instanceof PsiClassType) {
                    this.processClassReference(PsiUtil.resolveClassInType(newType), refFrom, psiFrom, true);
                }
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                this.processFunctionalExpression(expression);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                super.visitMethodReferenceExpression(expression);
                this.processFunctionalExpression(expression);
            }

            private void processFunctionalExpression(PsiFunctionalExpression expression) {
                PsiClass aClass = PsiUtil.resolveClassInType(expression.getFunctionalInterfaceType());
                if (aClass != null) {
                    refFrom.addReference(refFrom.getRefManager().getReference(aClass), aClass, psiFrom, false, true, null);
                    PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(aClass);
                    if (interfaceMethod != null) {
                        refFrom.addReference(refFrom.getRefManager().getReference(interfaceMethod), interfaceMethod, psiFrom, false, true, null);
                        refFrom.getRefManager().fireNodeMarkedReferenced(interfaceMethod, expression);
                    }
                }
            }

            @Nullable
            private RefMethod processNewLikeConstruct(PsiMethod psiConstructor, PsiExpressionList argumentList) {
                if (psiConstructor != null && RefJavaUtil.isDeprecated(psiConstructor)) {
                    refFrom.setUsesDeprecatedApi(true);
                }
                RefMethodImpl refConstructor = (RefMethodImpl)refFrom.getRefManager().getReference(psiConstructor);
                refFrom.addReference(refConstructor, psiConstructor, psiFrom, false, true, null);
                if (argumentList != null) {
                    PsiExpression[] psiParams;
                    for (PsiExpression param : psiParams = argumentList.getExpressions()) {
                        param.accept(this);
                    }
                    if (refConstructor != null) {
                        refConstructor.updateParameterValues(psiParams);
                    }
                }
                return refConstructor;
            }

            @Override
            public void visitClass(PsiClass psiClass) {
                super.visitClass(psiClass);
                RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference(psiClass);
                refFrom.addReference(refClass, psiClass, psiFrom, false, true, null);
            }

            @Override
            public void visitReturnStatement(PsiReturnStatement statement) {
                super.visitReturnStatement(statement);
                if (refFrom instanceof RefMethodImpl) {
                    RefMethodImpl refMethod = (RefMethodImpl)refFrom;
                    refMethod.updateReturnValueTemplate(statement.getReturnValue());
                }
            }

            @Override
            public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
                super.visitClassObjectAccessExpression(expression);
                PsiTypeElement operand = expression.getOperand();
                PsiType type = operand.getType();
                if (type instanceof PsiClassType) {
                    this.processClassReference(((PsiClassType)type).resolve(), refFrom, psiFrom, false);
                }
            }

            private void processClassReference(PsiClass psiClass, RefJavaElementImpl refFrom2, PsiModifierListOwner psiFrom2, boolean defaultConstructorOnly) {
                RefClassImpl refClass;
                if (psiClass != null && (refClass = (RefClassImpl)refFrom2.getRefManager().getReference(psiClass)) != null) {
                    boolean hasConstructorsMarked = false;
                    if (defaultConstructorOnly) {
                        RefMethodImpl refDefaultConstructor = (RefMethodImpl)refClass.getDefaultConstructor();
                        if (refDefaultConstructor != null) {
                            refDefaultConstructor.addInReference(refFrom2);
                            refFrom2.addOutReference(refDefaultConstructor);
                            hasConstructorsMarked = true;
                        }
                    } else {
                        for (RefMethod cons : refClass.getConstructors()) {
                            if (cons instanceof RefImplicitConstructor) continue;
                            ((RefMethodImpl)cons).addInReference(refFrom2);
                            refFrom2.addOutReference(cons);
                            hasConstructorsMarked = true;
                        }
                    }
                    if (!hasConstructorsMarked) {
                        refFrom2.addReference(refClass, psiClass, psiFrom2, false, true, null);
                    }
                }
            }
        });
    }

    private void updateRefMethod(PsiElement psiResolved, RefElement refResolved, PsiElement refExpression, PsiElement psiFrom, RefElement refFrom) {
        PsiMethod psiMethod = (PsiMethod)psiResolved;
        RefMethodImpl refMethod = (RefMethodImpl)refResolved;
        if (refExpression instanceof PsiMethodReferenceExpression) {
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && !PsiType.VOID.equals(returnType)) {
                refMethod.setReturnValueUsed(true);
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            return;
        }
        if (refExpression instanceof PsiLiteralExpression) {
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && !PsiType.VOID.equals(returnType)) {
                refMethod.setReturnValueUsed(true);
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            return;
        }
        PsiMethodCallExpression call = PsiTreeUtil.getParentOfType(refExpression, PsiMethodCallExpression.class);
        if (call != null) {
            PsiClassType methodOwnerType;
            String fqName;
            PsiType usedType;
            PsiExpression psiExpression;
            PsiExpressionList argumentList;
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && !PsiType.VOID.equals(returnType)) {
                if (!(call.getParent() instanceof PsiExpressionStatement)) {
                    refMethod.setReturnValueUsed(true);
                }
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            if (!(argumentList = call.getArgumentList()).isEmpty()) {
                refMethod.updateParameterValues(argumentList.getExpressions());
            }
            if ((psiExpression = call.getMethodExpression().getQualifierExpression()) != null && (usedType = psiExpression.getType()) != null && (fqName = psiMethod.getContainingClass().getQualifiedName()) != null && !usedType.equals(methodOwnerType = JavaPsiFacade.getInstance(call.getProject()).getElementFactory().createTypeByFQClassName(fqName, GlobalSearchScope.allScope(psiMethod.getProject())))) {
                refMethod.setCalledOnSubClass(true);
            }
        }
    }

    @Override
    public RefClass getTopLevelClass(@NotNull RefElement refElement) {
        if (refElement == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(2);
        }
        RefEntity refParent = refElement.getOwner();
        while (refParent instanceof RefElement && !(refParent instanceof RefFile)) {
            refElement = (RefElementImpl)refParent;
            refParent = refParent.getOwner();
        }
        return refElement instanceof RefClass ? (RefClass)refElement : null;
    }

    @Override
    public boolean isInheritor(@NotNull RefClass subClass, RefClass superClass) {
        if (subClass == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(3);
        }
        if (subClass == superClass) {
            return true;
        }
        for (RefClass baseClass : subClass.getBaseClasses()) {
            if (!this.isInheritor(baseClass, superClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getPackageName(RefEntity refEntity) {
        if (refEntity instanceof RefProject || refEntity instanceof RefJavaModule) {
            return null;
        }
        RefPackage refPackage = RefJavaUtilImpl.getPackage(refEntity);
        return refPackage == null ? InspectionsBundle.message("inspection.reference.default.package", new Object[0]) : refPackage.getQualifiedName();
    }

    @Override
    @NotNull
    public String getAccessModifier(@NotNull PsiModifierListOwner psiElement) {
        if (psiElement == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(4);
        }
        if (psiElement instanceof PsiParameter) {
            if ("packageLocal" == null) {
                RefJavaUtilImpl.$$$reportNull$$$0(5);
            }
            return "packageLocal";
        }
        PsiModifierList list = psiElement.getModifierList();
        String result2 = "packageLocal";
        if (list != null) {
            if (list.hasModifierProperty("private")) {
                result2 = "private";
            } else if (list.hasModifierProperty("protected")) {
                result2 = "protected";
            } else if (list.hasModifierProperty("public")) {
                result2 = "public";
            } else if (psiElement.getParent() instanceof PsiClass) {
                PsiClass ownerClass = (PsiClass)psiElement.getParent();
                if (ownerClass.isInterface()) {
                    result2 = "public";
                }
                if (ownerClass.isEnum() && result2.equals("packageLocal")) {
                    result2 = "private";
                }
            }
        }
        String string = result2;
        if (string == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public RefClass getOwnerClass(RefManager refManager, PsiElement psiElement) {
        while (psiElement != null && !(psiElement instanceof PsiClass)) {
            psiElement = psiElement.getParent();
        }
        return psiElement != null ? (RefClass)refManager.getReference(psiElement) : null;
    }

    @Override
    @Nullable
    public RefClass getOwnerClass(RefElement refElement) {
        RefEntity parent = refElement.getOwner();
        while (!(parent instanceof RefClass) && parent instanceof RefElement) {
            parent = parent.getOwner();
        }
        if (parent instanceof RefClass) {
            return (RefClass)parent;
        }
        return null;
    }

    @Override
    public boolean isMethodOnlyCallsSuper(PsiMethod method) {
        boolean hasStatements = false;
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            PsiStatement[] statements = body.getStatements();
            for (PsiElement psiElement : statements) {
                boolean isCallToSameSuper = false;
                if (psiElement instanceof PsiExpressionStatement) {
                    isCallToSameSuper = this.isCallToSuperMethod(((PsiExpressionStatement)psiElement).getExpression(), method);
                } else if (psiElement instanceof PsiReturnStatement) {
                    PsiExpression expression = ((PsiReturnStatement)psiElement).getReturnValue();
                    isCallToSameSuper = expression == null || this.isCallToSuperMethod(expression, method);
                }
                hasStatements = true;
                if (isCallToSameSuper) continue;
                return false;
            }
        }
        if (hasStatements) {
            PsiMethod[] superMethods = method.findSuperMethods();
            for (PsiElement psiElement : superMethods) {
                if (VisibilityUtil.compare(VisibilityUtil.getVisibilityModifier(psiElement.getModifierList()), VisibilityUtil.getVisibilityModifier(method.getModifierList())) <= 0) continue;
                return false;
            }
        }
        return hasStatements;
    }

    @Override
    public boolean isCallToSuperMethod(PsiExpression expression, PsiMethod method) {
        PsiMethodCallExpression methodCall;
        if (expression instanceof PsiMethodCallExpression && (methodCall = (PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression() instanceof PsiSuperExpression) {
            PsiMethod superMethod = (PsiMethod)methodCall.getMethodExpression().resolve();
            if (superMethod == null || !MethodSignatureUtil.areSignaturesEqual(method, superMethod)) {
                return false;
            }
            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
            PsiParameter[] parms = method.getParameterList().getParameters();
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = args[i];
                if (!(arg instanceof PsiReferenceExpression)) {
                    return false;
                }
                if (parms[i].equals(((PsiReferenceExpression)arg).resolve())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareAccess(String a1, String a2) {
        int i2;
        int i1 = RefJavaUtilImpl.getAccessNumber(a1);
        if (i1 == (i2 = RefJavaUtilImpl.getAccessNumber(a2))) {
            return 0;
        }
        if (i1 < i2) {
            return -1;
        }
        return 1;
    }

    private static int getAccessNumber(String a) {
        if (a == "private") {
            return 0;
        }
        if (a == "packageLocal") {
            return 1;
        }
        if (a == "protected") {
            return 2;
        }
        if (a == "public") {
            return 3;
        }
        return -1;
    }

    @Override
    public void setAccessModifier(@NotNull RefJavaElement refElement, @NotNull String newAccess) {
        if (refElement == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(7);
        }
        if (newAccess == null) {
            RefJavaUtilImpl.$$$reportNull$$$0(8);
        }
        ((RefJavaElementImpl)refElement).setAccessModifier(newAccess);
    }

    @Override
    public void setIsStatic(RefJavaElement refElement, boolean isStatic) {
        ((RefJavaElementImpl)refElement).setIsStatic(isStatic);
    }

    @Override
    public void setIsFinal(RefJavaElement refElement, boolean isFinal) {
        ((RefJavaElementImpl)refElement).setIsFinal(isFinal);
    }

    @Override
    public void addTypeReference(PsiElement psiElement, PsiType psiType, RefManager refManager) {
        this.addTypeReference(psiElement, psiType, refManager, null);
    }

    @Override
    public void addTypeReference(PsiElement psiElement, PsiType psiType, RefManager refManager, @Nullable RefJavaElement refMethod) {
        RefClass ownerClass;
        if (psiType != null && (ownerClass = this.getOwnerClass(refManager, psiElement)) != null && (psiType = psiType.getDeepComponentType()) instanceof PsiClassType) {
            PsiClass psiClass = PsiUtil.resolveClassInType(psiType);
            if (psiClass != null && refManager.belongsToScope(psiClass)) {
                RefClassImpl refClass = (RefClassImpl)refManager.getReference(psiClass);
                if (refClass != null) {
                    refClass.addTypeReference(ownerClass);
                    if (refMethod != null) {
                        refClass.addClassExporter(refMethod);
                    }
                }
            } else {
                ((RefManagerImpl)refManager).fireNodeMarkedReferenced(psiClass, psiElement);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFrom";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefJavaUtilImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaUtilImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addReferences";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAccessModifier";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setAccessModifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

