/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PsiIconUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.ElementBase");
    public static final int FLAGS_LOCKED = 2048;
    private static final NullableFunction<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        Object element = ((ElementIconRequest)request).myPointer.getElement();
        if (element == null) {
            return null;
        }
        Icon icon = ElementBase.computeIconNow(element, ((ElementIconRequest)request).myFlags);
        Iconable.LastComputedIcon.put(element, icon, ((ElementIconRequest)request).myFlags);
        return icon;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            EmptyIcon emptyIcon = EmptyIcon.create(PlatformIcons.PUBLIC_ICON);
            if (emptyIcon == null) {
                1.$$$reportNull$$$0(0);
            }
            return emptyIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ElementBase$1", "compute"));
        }
    };
    public static final NotNullLazyValue<Icon> ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            Icon icon = AllIcons.Nodes.NodePlaceholder;
            if (icon == null) {
                2.$$$reportNull$$$0(0);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ElementBase$2", "compute"));
        }
    };
    private static final List<IconLayer> ourIconLayers = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(@Iconable.IconFlags int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading")) {
            Icon baseIcon = Iconable.LastComputedIcon.get(psiElement, flags);
            if (baseIcon == null) {
                baseIcon = this.computeBaseIcon(flags);
            }
            return IconDeferrer.getInstance().defer(baseIcon, new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        Icon providersIcon;
        if (element == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        if ((providersIcon = PsiIconUtil.getProvidersIcon(element, flags)) != null) {
            return providersIcon instanceof RowIcon ? (RowIcon)providersIcon : ElementBase.createLayeredIcon(element, providersIcon, flags);
        }
        return ((ElementBase)((Object)element)).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(@Iconable.IconFlags int flags) {
        PsiFile file;
        Icon baseIcon;
        Icon icon = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null) {
            return ElementBase.createLayeredIcon(file, baseIcon, flags);
        }
        return baseIcon;
    }

    protected Icon getBaseIcon() {
        PsiFile file;
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file.getFileType())) {
            return file.getFileType().getIcon();
        }
        return ICON_PLACEHOLDER.getValue();
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon, @Iconable.IconFlags int flags) {
        if (BitUtil.isSet(flags, 1)) {
            return new RowIcon(icon, VISIBILITY_ICON_PLACEHOLDER.getValue());
        }
        return icon;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static Icon overlayIcons(Icon ... icons) {
        if (icons == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        LayeredIcon icon = new LayeredIcon(icons.length);
        int i = 0;
        for (Icon ic : icons) {
            icon.setIcon(ic, i++);
        }
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        return layeredIcon;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon icon = new RowIcon(2);
        icon.setIcon(baseIcon, 0);
        icon.setIcon(visibilityIcon, 1);
        RowIcon rowIcon = icon;
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(3);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(@Iconable.IconFlags int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet(flags, 1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(flags, 2) && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (!(element instanceof ItemPresentation) || ((ItemPresentation)((Object)element)).getIcon(false) == null) {
            if (element instanceof PsiFile) {
                PsiFile file = (PsiFile)element;
                VirtualFile virtualFile = file.getVirtualFile();
                Icon fileTypeIcon = virtualFile == null ? file.getFileType().getIcon() : IconUtil.getIcon(virtualFile, flags & 0xFFFFFFFD, file.getProject());
                return ElementBase.createLayeredIcon(this, fileTypeIcon, elementFlags);
            }
            return null;
        }
        RowIcon baseIcon = ElementBase.createLayeredIcon(this, ((ItemPresentation)((Object)element)).getIcon(false), elementFlags);
        return baseIcon;
    }

    @NotNull
    public static RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon, int flags) {
        if (instance == null) {
            ElementBase.$$$reportNull$$$0(4);
        }
        SmartList<Icon> layersFromProviders = new SmartList<Icon>();
        for (IconLayerProvider provider : Extensions.getExtensions(IconLayerProvider.EP_NAME)) {
            Icon layerIcon = provider.getLayerIcon(instance, BitUtil.isSet(flags, 2048));
            if (layerIcon == null) continue;
            layersFromProviders.add(layerIcon);
        }
        if (flags != 0 || !layersFromProviders.isEmpty()) {
            SmartList<Icon> iconLayers = new SmartList<Icon>();
            for (IconLayer l : ourIconLayers) {
                if (!BitUtil.isSet(flags, l.flagMask)) continue;
                iconLayers.add(l.icon);
            }
            iconLayers.addAll(layersFromProviders);
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon, 0);
            for (int i = 0; i < iconLayers.size(); ++i) {
                Icon icon1 = (Icon)iconLayers.get(i);
                layeredIcon.setIcon(icon1, i + 1);
            }
            icon = layeredIcon;
        }
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(icon, 0);
        RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(5);
        }
        return rowIcon;
    }

    public static int transformFlags(PsiElement element, @Iconable.IconFlags int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear(_flags, 2);
        boolean bl = isLocked = BitUtil.isSet(_flags, 2) && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    public static void registerIconLayer(int flagMask, @NotNull Icon icon) {
        if (icon == null) {
            ElementBase.$$$reportNull$$$0(6);
        }
        for (IconLayer iconLayer : ourIconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        ourIconLayers.add(new IconLayer(flagMask, icon));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "overlayIcons";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayeredIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "overlayIcons";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLayeredIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerIconLayer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IconLayer {
        private final int flagMask;
        @NotNull
        private final Icon icon;

        private IconLayer(int flagMask, @NotNull Icon icon) {
            if (icon == null) {
                IconLayer.$$$reportNull$$$0(0);
            }
            BitUtil.assertOneBitMask(flagMask);
            this.flagMask = flagMask;
            this.icon = icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/psi/impl/ElementBase$IconLayer", "<init>"));
        }
    }

    private static class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        @Iconable.IconFlags
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element, @NotNull Project project, @Iconable.IconFlags int flags) {
            if (element == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer.equals(request.myPointer);
        }

        public int hashCode() {
            int result2 = this.myPointer.hashCode();
            result2 = 31 * result2 + this.myFlags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

