/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAssignmentToParameterInspection
extends BaseInspection {
    public boolean ignoreTransformationOfOriginalParameter = false;

    protected abstract boolean isApplicable(PsiParameter var1);

    @Override
    public final BaseInspectionVisitor buildVisitor() {
        return new AssignmentToParameterVisitor();
    }

    private class AssignmentToParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToParameterVisitor() {
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                AssignmentToParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            PsiExpression lhs = expression.getLExpression();
            PsiParameter parameter = this.getParameter(lhs);
            if (parameter == null) {
                return;
            }
            if (BaseAssignmentToParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                PsiExpression rhs = expression.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed(parameter, rhs)) {
                    return;
                }
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ || tokenType == JavaTokenType.ASTERISKEQ || tokenType == JavaTokenType.DIVEQ || tokenType == JavaTokenType.ANDEQ || tokenType == JavaTokenType.OREQ || tokenType == JavaTokenType.XOREQ || tokenType == JavaTokenType.PERCEQ || tokenType == JavaTokenType.LTLTEQ || tokenType == JavaTokenType.GTGTEQ || tokenType == JavaTokenType.GTGTGTEQ) {
                    return;
                }
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        @Override
        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            if (expression == null) {
                AssignmentToParameterVisitor.$$$reportNull$$$0(1);
            }
            if (BaseAssignmentToParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                return;
            }
            super.visitUnaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiParameter parameter = this.getParameter(operand);
            if (parameter == null) {
                return;
            }
            this.registerError((PsiElement)operand, new Object[0]);
        }

        @Nullable
        private PsiParameter getParameter(PsiExpression expression) {
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement variable = referenceExpression.resolve();
            if (!(variable instanceof PsiParameter)) {
                return null;
            }
            PsiParameter parameter = (PsiParameter)variable;
            return !BaseAssignmentToParameterInspection.this.isApplicable(parameter) ? null : parameter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/assignment/BaseAssignmentToParameterInspection$AssignmentToParameterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

