/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationMissingWhitespaceInspection
extends BaseInspection {
    public boolean ignoreNonStringLiterals = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.display.name", new Object[0]);
        if (string == null) {
            StringConcatenationMissingWhitespaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConcatenationMissingWhitespaceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.option", new Object[0]), this, "ignoreNonStringLiterals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationMissingWhitespaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/StringConcatenationMissingWhitespaceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StringConcatenationMissingWhitespaceVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationMissingWhitespaceVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType) || !ExpressionUtils.hasStringType(expression)) {
                return;
            }
            boolean formatCall = FormatUtils.isFormatCallArgument(expression);
            PsiExpression[] operands = expression.getOperands();
            PsiExpression lhs = operands[0];
            for (int i = 1; i < operands.length; ++i) {
                PsiJavaToken token;
                PsiExpression rhs = operands[i];
                if (this.isMissingWhitespace(lhs, rhs, formatCall) && (token = expression.getTokenBeforeOperand(rhs)) != null) {
                    this.registerError((PsiElement)token, new Object[0]);
                }
                lhs = rhs;
            }
        }

        private boolean isMissingWhitespace(PsiExpression lhs, PsiExpression rhs, boolean formatCall) {
            String rhsLiteral;
            char c;
            String lhsLiteral = this.computeStringValue(lhs);
            if (lhsLiteral != null) {
                int length = lhsLiteral.length();
                if (length == 0 || formatCall && lhsLiteral.endsWith("%n")) {
                    return false;
                }
                c = lhsLiteral.charAt(length - 1);
                if (Character.isWhitespace(c) || !Character.isLetterOrDigit(c)) {
                    return false;
                }
            } else if (StringConcatenationMissingWhitespaceInspection.this.ignoreNonStringLiterals && ExpressionUtils.hasStringType(lhs)) {
                return false;
            }
            if ((rhsLiteral = this.computeStringValue(rhs)) != null) {
                if (rhsLiteral.isEmpty() || formatCall && rhsLiteral.startsWith("%n")) {
                    return false;
                }
                c = rhsLiteral.charAt(0);
                if (Character.isWhitespace(c) || !Character.isLetterOrDigit(c)) {
                    return false;
                }
            } else if (StringConcatenationMissingWhitespaceInspection.this.ignoreNonStringLiterals && ExpressionUtils.hasStringType(rhs)) {
                return false;
            }
            return true;
        }

        @Nullable
        public String computeStringValue(@Nullable PsiExpression expression) {
            Object value = ExpressionUtils.computeConstantExpression(expression);
            return value == null ? null : value.toString();
        }
    }
}

