/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlaceholderCountMatchesArgumentCountInspection
extends BaseInspection {
    @NonNls
    static final Set<String> loggingMethodNames = ContainerUtilRt.newHashSet("log", "trace", "debug", "info", "warn", "error", "fatal");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.display.name", new Object[0]);
        if (string == null) {
            PlaceholderCountMatchesArgumentCountInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer argumentCount = (Integer)infos[0];
        Integer placeholderCount = (Integer)infos[1];
        String string = argumentCount > placeholderCount ? InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.more.problem.descriptor", argumentCount, placeholderCount) : InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.fewer.problem.descriptor", argumentCount, placeholderCount);
        if (string == null) {
            PlaceholderCountMatchesArgumentCountInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PlaceholderCountMatchesArgumentCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/logging/PlaceholderCountMatchesArgumentCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PlaceholderCountMatchesArgumentCountVisitor
    extends BaseInspectionVisitor {
        private PlaceholderCountMatchesArgumentCountVisitor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiExpression logStringArgument;
            int placeholderCount;
            PsiExpression argument;
            PsiType argumentType;
            int index;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!loggingMethodNames.contains(name)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor(aClass, "org.slf4j.Logger") && !InheritanceUtil.isInheritor(aClass, "org.apache.logging.log4j.Logger")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            if (!ExpressionUtils.hasStringType(arguments[0])) {
                if (arguments.length < 2) {
                    return;
                }
                index = 2;
            } else {
                index = 1;
            }
            int argumentCount = arguments.length - index;
            boolean lastArgumentIsException = PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(arguments[arguments.length - 1]);
            if (argumentCount == 1 && (argumentType = (argument = arguments[index]).getType()) instanceof PsiArrayType) {
                if (!argumentType.equalsToText("java.lang.Object[]") || !(argument instanceof PsiNewExpression)) return;
                PsiNewExpression newExpression = (PsiNewExpression)argument;
                PsiArrayInitializerExpression arrayInitializerExpression = newExpression.getArrayInitializer();
                if (arrayInitializerExpression == null) return;
                PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
                argumentCount = initializers.length;
                lastArgumentIsException = initializers.length > 0 && PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(initializers[initializers.length - 1]);
            }
            if ((placeholderCount = PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(logStringArgument = arguments[index - 1])) < 0 || argumentCount < 0 || placeholderCount == argumentCount && (!lastArgumentIsException || argumentCount > 1) || placeholderCount == argumentCount - 1 && lastArgumentIsException) {
                return;
            }
            this.registerError((PsiElement)logStringArgument, lastArgumentIsException ? argumentCount - 1 : argumentCount, placeholderCount);
        }

        private static boolean hasThrowableType(PsiExpression lastArgument) {
            PsiType type = lastArgument.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (InheritanceUtil.isInheritor(disjunction, "java.lang.Throwable")) continue;
                    return false;
                }
                return true;
            }
            return InheritanceUtil.isInheritor(type, "java.lang.Throwable");
        }

        public static int countPlaceholders(PsiExpression expression) {
            Object value = ExpressionUtils.computeConstantExpression(expression);
            if (value == null) {
                StringBuilder builder = new StringBuilder();
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(expression, builder) ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(builder.toString()) : -1;
            }
            return value instanceof String ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders((String)value) : 0;
        }

        private static boolean buildString(PsiExpression expression, StringBuilder builder) {
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(parenthesizedExpression.getExpression(), builder);
            }
            if (expression instanceof PsiPolyadicExpression) {
                if (!TypeUtils.isJavaLangString(type) && !PsiType.CHAR.equals(type)) {
                    return true;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (PlaceholderCountMatchesArgumentCountVisitor.buildString(operand, builder)) continue;
                    return false;
                }
                return true;
            }
            if (expression instanceof PsiLiteralExpression) {
                if (TypeUtils.isJavaLangString(type) || PsiType.CHAR.equals(type)) {
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                    builder.append(literalExpression.getValue());
                }
                return true;
            }
            if (!TypeUtils.isJavaLangString(type)) {
                return true;
            }
            Object value = ExpressionUtils.computeConstantExpression(expression);
            if (value == null) {
                return false;
            }
            builder.append(value);
            return true;
        }

        private static int countPlaceholders(String string) {
            int count = 0;
            int index = string.indexOf("{}");
            while (index >= 0) {
                if (index == 0 || string.charAt(index - 1) != '\\') {
                    ++count;
                }
                index = string.indexOf("{}", index + 1);
            }
            return count;
        }
    }
}

