/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtils {
    @NonNls
    static final Set<String> convertableBoxedClassNames = new HashSet<String>(3);
    private static final CallMatcher KNOWN_SIMPLE_CALLS;
    private static final CallMatcher GET_OR_DEFAULT;

    private ExpressionUtils() {
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression) {
        return ExpressionUtils.computeConstantExpression(expression, false);
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression, boolean throwConstantEvaluationOverflowException) {
        if (expression == null) {
            return null;
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        return constantEvaluationHelper.computeConstantExpression(expression, throwConstantEvaluationOverflowException);
    }

    public static boolean isConstant(PsiField field) {
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        if (CollectionUtils.isEmptyArray(field)) {
            return true;
        }
        PsiType type = field.getType();
        return ClassUtils.isImmutable(type);
    }

    public static boolean hasExpressionCount(@Nullable PsiExpressionList expressionList, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount(expressionList, count, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getFirstExpressionInList(@Nullable PsiExpressionList expressionList) {
        return PsiTreeUtil.getChildOfType(expressionList, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getOnlyExpressionInList(@Nullable PsiExpressionList expressionList) {
        return ControlFlowUtils.getOnlyChildOfType(expressionList, PsiExpression.class);
    }

    public static boolean isDeclaredConstant(PsiExpression expression) {
        PsiField field = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
        if (field == null) {
            PsiAssignmentExpression assignmentExpression = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAssignmentExpression.class);
            if (assignmentExpression == null) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            field = (PsiField)target;
        }
        return field.hasModifierProperty("static") && field.hasModifierProperty("final");
    }

    @Contract(value="null -> false")
    public static boolean isEvaluatedAtCompileTime(@Nullable PsiExpression expression) {
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            PsiExpression operand = prefixExpression.getOperand();
            return ExpressionUtils.isEvaluatedAtCompileTime(operand);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement qualifier = referenceExpression.getQualifier();
            if (qualifier instanceof PsiThisExpression) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiExpression initializer = field.getInitializer();
                return field.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer);
            }
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                if (PsiTreeUtil.isAncestor(variable, expression, true)) {
                    return false;
                }
                PsiExpression initializer = variable.getInitializer();
                return variable.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer);
            }
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression deparenthesizedExpression = parenthesizedExpression.getExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(deparenthesizedExpression);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiExpression condition = conditionalExpression.getCondition();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(condition) && ExpressionUtils.isEvaluatedAtCompileTime(thenExpression) && ExpressionUtils.isEvaluatedAtCompileTime(elseExpression);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiTypeElement castType = typeCastExpression.getCastType();
            if (castType == null) {
                return false;
            }
            PsiType type = castType.getType();
            return TypeUtils.typeEquals("java.lang.String", type) && ExpressionUtils.isEvaluatedAtCompileTime(typeCastExpression.getOperand());
        }
        return false;
    }

    @Nullable
    public static PsiLiteralExpression getLiteral(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiLiteralExpression) {
            return (PsiLiteralExpression)expression;
        }
        if (!(expression instanceof PsiTypeCastExpression)) {
            return null;
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
        PsiExpression operand = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
        if (!(operand instanceof PsiLiteralExpression)) {
            return null;
        }
        return (PsiLiteralExpression)operand;
    }

    public static boolean isLiteral(@Nullable PsiExpression expression) {
        return ExpressionUtils.getLiteral(expression) != null;
    }

    public static boolean isEmptyStringLiteral(@Nullable PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiLiteralExpression)) {
            return false;
        }
        String text2 = expression.getText();
        return "\"\"".equals(text2);
    }

    @Contract(value="null -> false")
    public static boolean isNullLiteral(@Nullable PsiExpression expression) {
        return (expression = PsiUtil.deparenthesizeExpression(expression)) != null && PsiType.NULL.equals(expression.getType());
    }

    public static Stream<PsiExpression> nonStructuralChildren(@NotNull PsiExpression expression) {
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(0);
        }
        return ((StreamEx)StreamEx.ofTree((Object)expression, e -> {
            if (e instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)e;
                return StreamEx.of((Object[])new PsiExpression[]{ternary.getThenExpression(), ternary.getElseExpression()}).nonNull();
            }
            if (e instanceof PsiParenthesizedExpression) {
                return StreamEx.ofNullable((Object)((PsiParenthesizedExpression)e).getExpression());
            }
            return null;
        }).remove(e -> e instanceof PsiConditionalExpression || e instanceof PsiParenthesizedExpression)).map(e -> {
            PsiExpression operand;
            if (e instanceof PsiTypeCastExpression && (operand = ((PsiTypeCastExpression)e).getOperand()) != null && !(e.getType() instanceof PsiPrimitiveType) && (!(operand.getType() instanceof PsiPrimitiveType) || PsiType.NULL.equals(operand.getType()))) {
                return PsiUtil.skipParenthesizedExprDown(operand);
            }
            return e;
        }).flatMap(e -> {
            if (e instanceof PsiMethodCallExpression && GET_OR_DEFAULT.matches((PsiExpression)e)) {
                return StreamEx.of((Object[])new PsiExpression[]{e, ((PsiMethodCallExpression)e).getArgumentList().getExpressions()[1]});
            }
            return StreamEx.of((Object)e);
        });
    }

    public static boolean isZero(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        PsiType expressionType = expression.getType();
        Object value = ConstantExpressionUtil.computeCastTo(expression, expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 0.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 0.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            return true;
        }
        if (value instanceof Long && (Long)value == 0L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 0) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0000') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 0;
    }

    public static boolean isOne(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 1.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 1.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 1) {
            return true;
        }
        if (value instanceof Long && (Long)value == 1L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 1) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0001') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 1;
    }

    public static boolean isNegation(@Nullable PsiExpression condition, boolean ignoreNegatedNullComparison, boolean ignoreNegatedZeroComparison) {
        if ((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            return tokenType.equals(JavaTokenType.EXCL);
        }
        if (condition instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (lhs == null || rhs == null) {
                return false;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.NE)) {
                if (ignoreNegatedNullComparison) {
                    String lhsText = lhs.getText();
                    String rhsText = rhs.getText();
                    if ("null".equals(lhsText) || "null".equals(rhsText)) {
                        return false;
                    }
                }
                return !ignoreNegatedZeroComparison || !ExpressionUtils.isZeroLiteral(lhs) && !ExpressionUtils.isZeroLiteral(rhs);
            }
        }
        return false;
    }

    private static boolean isZeroLiteral(PsiExpression expression) {
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
        Object value = literalExpression.getValue();
        return value instanceof Integer ? (Integer)value == 0 : value instanceof Long && (Long)value == 0L;
    }

    public static boolean isOffsetArrayAccess(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        PsiExpression strippedExpression;
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(1);
        }
        if (!((strippedExpression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiArrayAccessExpression)) {
            return false;
        }
        PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)strippedExpression;
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (VariableAccessUtils.variableIsUsed(variable, arrayExpression)) {
            return false;
        }
        PsiExpression index = arrayAccessExpression.getIndexExpression();
        if (index == null) {
            return false;
        }
        return ExpressionUtils.expressionIsOffsetVariableLookup(index, variable);
    }

    private static boolean expressionIsOffsetVariableLookup(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(2);
        }
        if (VariableAccessUtils.evaluatesToVariable(expression, variable)) {
            return true;
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (!(strippedExpression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)strippedExpression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!JavaTokenType.PLUS.equals(tokenType) && !JavaTokenType.MINUS.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (ExpressionUtils.expressionIsOffsetVariableLookup(lhs, variable)) {
            return true;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        return ExpressionUtils.expressionIsOffsetVariableLookup(rhs, variable) && !JavaTokenType.MINUS.equals(tokenType);
    }

    public static boolean isVariableLessThanComparison(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(3);
        }
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            PsiExpression lhs = binaryExpression.getLOperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable);
        }
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(rhs, variable);
        }
        return false;
    }

    public static boolean isVariableGreaterThanComparison(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(4);
        }
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            PsiExpression lhs = binaryExpression.getLOperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable);
        }
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(rhs, variable);
        }
        return false;
    }

    public static boolean isStringConcatenationOperand(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        if (!JavaTokenType.PLUS.equals(polyadicExpression.getOperationTokenType())) {
            return false;
        }
        Object[] operands = polyadicExpression.getOperands();
        if (operands.length < 2) {
            return false;
        }
        int index = ArrayUtil.indexOf(operands, expression);
        for (int i = 0; i < index; ++i) {
            PsiType type = operands[i].getType();
            if (!TypeUtils.isJavaLangString(type)) continue;
            return true;
        }
        if (index == 0) {
            PsiType type = operands[index + 1].getType();
            return TypeUtils.isJavaLangString(type);
        }
        return false;
    }

    public static boolean isConstructorInvocation(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String callName = methodExpression.getReferenceName();
        return "this".equals(callName) || "super".equals(callName);
    }

    public static boolean hasType(@Nullable PsiExpression expression, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            ExpressionUtils.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        return TypeUtils.typeEquals(typeName, type);
    }

    public static boolean hasStringType(@Nullable PsiExpression expression) {
        return ExpressionUtils.hasType(expression, "java.lang.String");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConversionToStringNecessary(PsiExpression expression, boolean throwable) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses(expression);
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            PsiType type = polyadicExpression.getType();
            if (!TypeUtils.typeEquals("java.lang.String", type)) {
                return true;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean expressionSeen = false;
            int i = 0;
            int length = operands.length;
            while (i < length) {
                PsiExpression operand = operands[i];
                if (PsiTreeUtil.isAncestor(operand, expression, false)) {
                    if (i > 0) {
                        return true;
                    }
                    expressionSeen = true;
                } else if ((!expressionSeen || i == 1) && TypeUtils.isJavaLangString(operand.getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(parent instanceof PsiExpressionList)) return true;
        PsiExpressionList expressionList = (PsiExpressionList)parent;
        PsiElement grandParent = expressionList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return true;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
        String name = methodExpression1.getReferenceName();
        PsiExpression[] expressions = expressionList.getExpressions();
        if ("insert".equals(name)) {
            if (expressions.length < 2) return true;
            if (!expression.equals(ParenthesesUtils.stripParentheses(expressions[1]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("append".equals(name)) {
            if (expressions.length < 1) return true;
            if (!expression.equals(ParenthesesUtils.stripParentheses(expressions[0]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("print".equals(name) || "println".equals(name)) {
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.io.PrintStream", "java.io.PrintWriter")) return false;
            return true;
        }
        if (!("trace".equals(name) || "debug".equals(name) || "info".equals(name) || "warn".equals(name))) {
            if (!"error".equals(name)) return true;
        }
        if (!ExpressionUtils.isCallToMethodIn(methodCallExpression, "org.slf4j.Logger")) {
            return true;
        }
        int l = 1;
        int i = 0;
        while (i < expressions.length) {
            PsiExpression expression1 = expressions[i];
            if (i == 0 && TypeUtils.expressionHasTypeOrSubtype(expression1, "org.slf4j.Marker")) {
                l = 2;
            }
            if (expression1 == expression) {
                if (i < l) return true;
                if (throwable && i == expressions.length - 1) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean isCallToMethodIn(PsiMethodCallExpression methodCallExpression, String ... classNames) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        for (String className : classNames) {
            if (!className.equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNegative(@NotNull PsiExpression expression) {
        PsiElement parent;
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(6);
        }
        if (!((parent = expression.getParent()) instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        return JavaTokenType.MINUS.equals(tokenType);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiVariable getVariableFromNullComparison(PsiExpression expression, boolean equals) {
        PsiReferenceExpression referenceExpression = ExpressionUtils.getReferenceExpressionFromNullComparison(expression, equals);
        PsiElement target = referenceExpression != null ? referenceExpression.resolve() : null;
        return target instanceof PsiVariable ? (PsiVariable)target : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiReferenceExpression getReferenceExpressionFromNullComparison(PsiExpression expression, boolean equals) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (equals ? !JavaTokenType.EQEQ.equals(tokenType) : !JavaTokenType.NE.equals(tokenType)) {
            return null;
        }
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operands.length != 2) {
            return null;
        }
        PsiExpression comparedToNull = null;
        if (PsiType.NULL.equals(operands[0].getType())) {
            comparedToNull = operands[1];
        } else if (PsiType.NULL.equals(operands[1].getType())) {
            comparedToNull = operands[0];
        }
        comparedToNull = ParenthesesUtils.stripParentheses(comparedToNull);
        return comparedToNull instanceof PsiReferenceExpression ? (PsiReferenceExpression)comparedToNull : null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithNull(@NotNull PsiBinaryExpression binOp) {
        IElementType tokenType;
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(7);
        }
        if (!(tokenType = binOp.getOperationTokenType()).equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = binOp.getLOperand();
        PsiExpression right = binOp.getROperand();
        if (ExpressionUtils.isNullLiteral(right)) {
            return left;
        }
        if (ExpressionUtils.isNullLiteral(left)) {
            return right;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(8);
        }
        return ExpressionUtils.getValueComparedWithZero(binOp, JavaTokenType.EQEQ);
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp, IElementType opType) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(9);
        }
        if (!binOp.getOperationTokenType().equals(opType)) {
            return null;
        }
        PsiExpression rOperand = binOp.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiExpression lOperand = binOp.getLOperand();
        if (ExpressionUtils.isZero(lOperand)) {
            return rOperand;
        }
        if (ExpressionUtils.isZero(rOperand)) {
            return lOperand;
        }
        return null;
    }

    public static boolean isConcatenation(PsiElement element) {
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
        PsiType type = expression.getType();
        return type != null && type.equalsToText("java.lang.String");
    }

    public static boolean isAnnotatedNotNull(PsiExpression expression) {
        return ExpressionUtils.isAnnotated(expression, false);
    }

    public static boolean isAnnotatedNullable(PsiExpression expression) {
        return ExpressionUtils.isAnnotated(expression, true);
    }

    private static boolean isAnnotated(PsiExpression expression, boolean nullable) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target;
        return nullable ? NullableNotNullManager.isNullable(modifierListOwner) : NullableNotNullManager.isNotNull(modifierListOwner);
    }

    @Contract(value="null -> false")
    public static boolean isSafelyRecomputableExpression(@Nullable PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiLiteralExpression || expression instanceof PsiThisExpression || expression instanceof PsiClassObjectAccessExpression || ExpressionUtils.isEvaluatedAtCompileTime(expression)) {
            return true;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression).resolve();
            if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
                return true;
            }
            PsiExpression qualifier = ((PsiReferenceExpression)expression).getQualifierExpression();
            if (target == null && qualifier == null) {
                return true;
            }
            if (target instanceof PsiField) {
                PsiField field = (PsiField)target;
                if (!field.hasModifierProperty("final")) {
                    return false;
                }
                return qualifier == null || qualifier instanceof PsiThisExpression || field.hasModifierProperty("static");
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            return KNOWN_SIMPLE_CALLS.test((PsiMethodCallExpression)expression);
        }
        return false;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiAssignmentExpression getAssignment(PsiElement element) {
        PsiAssignmentExpression assignment;
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)element)) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)element).getOperationTokenType().equals(JavaTokenType.EQ)) {
            return assignment;
        }
        return null;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    public static PsiExpression getAssignmentTo(PsiElement element, PsiVariable target) {
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && ExpressionUtils.isReferenceTo(assignment.getLExpression(), target)) {
            return assignment.getRExpression();
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isLiteral(PsiElement element, Object value) {
        return element instanceof PsiLiteralExpression && value.equals(((PsiLiteralExpression)element).getValue());
    }

    public static boolean isAutoBoxed(@NotNull PsiExpression expression) {
        PsiMethodCallExpression methodCallExpression;
        PsiMethod method;
        PsiElement grandParent;
        PsiElement parent;
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(10);
        }
        if ((parent = expression.getParent()) instanceof PsiParenthesizedExpression) {
            return false;
        }
        if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)grandParent).resolveMethod()) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "java.lang.invoke.MethodHandle.PolymorphicSignature", 0)) {
            return false;
        }
        PsiType expressionType = expression.getType();
        if (PsiPrimitiveType.getUnboxedType(expressionType) != null && parent instanceof PsiUnaryExpression) {
            IElementType sign = ((PsiUnaryExpression)parent).getOperationTokenType();
            return sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS;
        }
        if (expressionType == null || expressionType.equals(PsiType.VOID) || !TypeConversionUtil.isPrimitiveAndNotNull(expressionType)) {
            return false;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)expressionType;
        PsiClassType boxedType = primitiveType.getBoxedType(expression);
        if (boxedType == null) {
            return false;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true);
        if (expectedType == null || ClassUtils.isPrimitive(expectedType)) {
            return false;
        }
        if (!expectedType.isAssignableFrom(boxedType)) {
            if (!(expectedType instanceof PsiClassType) || !PsiUtil.isConstantExpression(expression)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)expectedType;
            String className = classType.getCanonicalText();
            if (!convertableBoxedClassNames.contains(className)) {
                return false;
            }
            if (!(PsiType.BYTE.equals(expressionType) || PsiType.CHAR.equals(expressionType) || PsiType.SHORT.equals(expressionType) || PsiType.INT.equals(expressionType))) {
                return false;
            }
        }
        return true;
    }

    @Contract(value="null, _ -> null; !null, null -> null")
    public static PsiExpression getOtherOperand(@Nullable PsiBinaryExpression binOp, @Nullable PsiVariable variable) {
        if (binOp == null || variable == null) {
            return null;
        }
        if (ExpressionUtils.isReferenceTo(binOp.getLOperand(), variable)) {
            return binOp.getROperand();
        }
        if (ExpressionUtils.isReferenceTo(binOp.getROperand(), variable)) {
            return binOp.getLOperand();
        }
        return null;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isReferenceTo(PsiExpression expression, PsiVariable variable) {
        if (variable == null) {
            return false;
        }
        return (expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).isReferenceTo(variable);
    }

    @Contract(value="null -> null", pure=true)
    public static PsiMethodCallExpression getCallForQualifier(PsiExpression qualifier) {
        PsiElement gParent;
        PsiReferenceExpression methodExpression;
        if (qualifier == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(qualifier.getParent());
        if (parent instanceof PsiReferenceExpression && PsiTreeUtil.isAncestor((methodExpression = (PsiReferenceExpression)parent).getQualifierExpression(), qualifier, false) && (gParent = methodExpression.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)gParent;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getArrayFromLengthExpression(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression;
        String referenceName = reference.getReferenceName();
        if (!"length".equals(referenceName)) {
            return null;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type = qualifier.getType();
        if (type == null || type.getArrayDimensions() <= 0) {
            return null;
        }
        return qualifier;
    }

    @NotNull
    public static PsiExpression getQualifierOrThis(@NotNull PsiReferenceExpression ref) {
        PsiClass memberClass;
        PsiExpression qualifier;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(11);
        }
        if ((qualifier = ref.getQualifierExpression()) != null) {
            PsiExpression psiExpression = qualifier;
            if (psiExpression == null) {
                ExpressionUtils.$$$reportNull$$$0(12);
            }
            return psiExpression;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(ref.getProject());
        PsiMember member = ObjectUtils.tryCast(ref.resolve(), PsiMember.class);
        if (member != null && (memberClass = member.getContainingClass()) != null) {
            PsiClass containingClass = ClassUtils.getContainingClass(ref);
            if (containingClass == null) {
                containingClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)ref, PsiClass.class);
            }
            if (!InheritanceUtil.isInheritorOrSelf(containingClass, memberClass, true)) {
                containingClass = ClassUtils.getContainingClass(containingClass);
                while (containingClass != null && !InheritanceUtil.isInheritorOrSelf(containingClass, memberClass, true)) {
                    containingClass = ClassUtils.getContainingClass(containingClass);
                }
                if (containingClass != null) {
                    PsiExpression psiExpression = factory.createExpressionFromText(containingClass.getQualifiedName() + "." + "this", ref);
                    if (psiExpression == null) {
                        ExpressionUtils.$$$reportNull$$$0(13);
                    }
                    return psiExpression;
                }
            }
        }
        PsiExpression psiExpression = factory.createExpressionFromText("this", ref);
        if (psiExpression == null) {
            ExpressionUtils.$$$reportNull$$$0(14);
        }
        return psiExpression;
    }

    public static void bindReferenceTo(@NotNull PsiReferenceExpression ref, @NotNull String newName) {
        PsiMember member;
        PsiMember member2;
        PsiElement nameElement;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            ExpressionUtils.$$$reportNull$$$0(16);
        }
        if ((nameElement = ref.getReferenceNameElement()) == null) {
            throw new IllegalStateException("Name element is null: " + ref);
        }
        if (newName.equals(nameElement.getText())) {
            return;
        }
        PsiClass aClass = null;
        if (ref.getQualifierExpression() == null && (member2 = ObjectUtils.tryCast(ref.resolve(), PsiMember.class)) != null && ImportUtils.isStaticallyImported(member2, ref)) {
            aClass = member2.getContainingClass();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(ref.getProject());
        PsiIdentifier identifier = factory.createIdentifier(newName);
        nameElement.replace(identifier);
        if (aClass != null && ((member = ObjectUtils.tryCast(ref.resolve(), PsiMember.class)) == null || member.getContainingClass() != aClass)) {
            ref.setQualifierExpression(factory.createReferenceExpression(aClass));
        }
    }

    public static void bindCallTo(@NotNull PsiMethodCallExpression call, @NotNull String newName) {
        if (call == null) {
            ExpressionUtils.$$$reportNull$$$0(17);
        }
        if (newName == null) {
            ExpressionUtils.$$$reportNull$$$0(18);
        }
        ExpressionUtils.bindReferenceTo(call.getMethodExpression(), newName);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression resolveExpression(@Nullable PsiExpression expression) {
        PsiExpression initializer;
        PsiReferenceExpression reference;
        PsiLocalVariable variable;
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiReferenceExpression && (variable = ObjectUtils.tryCast((reference = (PsiReferenceExpression)expression).resolve(), PsiLocalVariable.class)) != null && (initializer = variable.getInitializer()) != null && ReferencesSearch.search(variable).forEach(ref -> ref == reference)) {
            return initializer;
        }
        return expression;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiLocalVariable resolveLocalVariable(@Nullable PsiExpression expression) {
        PsiReferenceExpression referenceExpression = ObjectUtils.tryCast(expression, PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return null;
        }
        return ObjectUtils.tryCast(referenceExpression.resolve(), PsiLocalVariable.class);
    }

    public static boolean isOctalLiteral(PsiLiteralExpression literal) {
        PsiType type = literal.getType();
        if (!PsiType.INT.equals(type) && !PsiType.LONG.equals(type)) {
            return false;
        }
        if (literal.getValue() == null) {
            return false;
        }
        String text2 = literal.getText();
        if (text2.charAt(0) != '0' || text2.length() < 2) {
            return false;
        }
        char c1 = text2.charAt(1);
        return c1 == '_' || c1 >= '0' && c1 <= '7';
    }

    @Contract(value="null, _ -> false")
    public static boolean isMatchingChildAlwaysExecuted(@Nullable PsiExpression root, final @NotNull Predicate<PsiExpression> matcher) {
        if (matcher == null) {
            ExpressionUtils.$$$reportNull$$$0(19);
        }
        if (root == null) {
            return false;
        }
        final AtomicBoolean result2 = new AtomicBoolean(false);
        root.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitExpression(PsiExpression expression) {
                super.visitExpression(expression);
                if (matcher.test(expression)) {
                    result2.set(true);
                    this.stopWalking();
                }
            }

            @Override
            public void visitConditionalExpression(PsiConditionalExpression expression) {
                if (ExpressionUtils.isMatchingChildAlwaysExecuted(expression.getCondition(), matcher) || ExpressionUtils.isMatchingChildAlwaysExecuted(expression.getThenExpression(), matcher) && ExpressionUtils.isMatchingChildAlwaysExecuted(expression.getElseExpression(), matcher)) {
                    result2.set(true);
                    this.stopWalking();
                }
            }

            @Override
            public void visitPolyadicExpression(PsiPolyadicExpression expression) {
                IElementType type = expression.getOperationTokenType();
                if (type.equals(JavaTokenType.OROR) || type.equals(JavaTokenType.ANDAND)) {
                    PsiExpression firstOperand = ArrayUtil.getFirstElement(expression.getOperands());
                    if (ExpressionUtils.isMatchingChildAlwaysExecuted(firstOperand, matcher)) {
                        result2.set(true);
                        this.stopWalking();
                    }
                } else {
                    super.visitPolyadicExpression(expression);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        return result2.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null -> false")
    public static boolean isNewObject(@Nullable PsiExpression expression) {
        if (expression == null) return false;
        if (!ExpressionUtils.nonStructuralChildren(expression).allMatch(PsiNewExpression.class::isInstance)) return false;
        return true;
    }

    @Deprecated
    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        return ExpressionUtil.isEffectivelyUnqualified(refExpression);
    }

    public static boolean isDifference(@NotNull PsiExpression from, @NotNull PsiExpression to, @NotNull PsiExpression diff) {
        Integer fromConstant;
        if (from == null) {
            ExpressionUtils.$$$reportNull$$$0(20);
        }
        if (to == null) {
            ExpressionUtils.$$$reportNull$$$0(21);
        }
        if (diff == null) {
            ExpressionUtils.$$$reportNull$$$0(22);
        }
        if ((diff = PsiUtil.skipParenthesizedExprDown(diff)) == null) {
            return false;
        }
        if (ExpressionUtils.isZero(from) && PsiEquivalenceUtil.areElementsEquivalent(to, diff)) {
            return true;
        }
        if (diff instanceof PsiBinaryExpression && ((PsiBinaryExpression)diff).getOperationTokenType().equals(JavaTokenType.MINUS)) {
            PsiExpression left = ((PsiBinaryExpression)diff).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)diff).getROperand();
            if (right != null && PsiEquivalenceUtil.areElementsEquivalent(to, left) && PsiEquivalenceUtil.areElementsEquivalent(from, right)) {
                return true;
            }
        }
        if ((fromConstant = ObjectUtils.tryCast(ExpressionUtils.computeConstantExpression(from), Integer.class)) == null) {
            return false;
        }
        Integer toConstant = ObjectUtils.tryCast(ExpressionUtils.computeConstantExpression(to), Integer.class);
        if (toConstant == null) {
            return false;
        }
        Integer diffConstant = ObjectUtils.tryCast(ExpressionUtils.computeConstantExpression(diff), Integer.class);
        if (diffConstant == null) {
            return false;
        }
        return diffConstant == toConstant - fromConstant;
    }

    @Nullable
    public static PsiExpression getConstantArrayElement(PsiVariable array, int index) {
        if (index < 0) {
            return null;
        }
        PsiExpression initializer = array.getInitializer();
        if (initializer instanceof PsiNewExpression) {
            initializer = ((PsiNewExpression)initializer).getArrayInitializer();
        }
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return null;
        }
        PsiExpression[] initializers = ((PsiArrayInitializerExpression)initializer).getInitializers();
        if (index >= initializers.length) {
            return null;
        }
        if (!(!(array instanceof PsiField) || array.hasModifierProperty("private") && array.hasModifierProperty("static"))) {
            return null;
        }
        Boolean isConstantArray = (Boolean)CachedValuesManager.getCachedValue(array, () -> CachedValueProvider.Result.create(Boolean.valueOf(ExpressionUtils.isConstantArray(array)), PsiModificationTracker.MODIFICATION_COUNT));
        return Boolean.TRUE.equals(isConstantArray) ? initializers[index] : null;
    }

    private static boolean isConstantArray(PsiVariable array) {
        Object scope = PsiTreeUtil.getParentOfType((PsiElement)array, new Class[]{array instanceof PsiField ? PsiClass.class : PsiCodeBlock.class});
        if (scope == null) {
            return false;
        }
        return PsiTreeUtil.processElements(scope, e -> {
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)e;
            if (!ref.isReferenceTo(array)) {
                return true;
            }
            PsiExpression parent = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprUp(ref.getParent()), PsiExpression.class);
            if (parent == null) {
                return false;
            }
            if (parent instanceof PsiReferenceExpression) {
                if (ExpressionUtils.isReferenceTo(ExpressionUtils.getArrayFromLengthExpression(parent), array)) {
                    return true;
                }
                if (parent.getParent() instanceof PsiMethodCallExpression && MethodCallUtils.isCallToMethod((PsiMethodCallExpression)parent.getParent(), "java.lang.Object", null, "clone", PsiType.EMPTY_ARRAY)) {
                    return true;
                }
            }
            return parent instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting(parent);
        });
    }

    public static boolean isLocallyDefinedExpression(PsiExpression expression) {
        return PsiTreeUtil.processElements(expression, e -> {
            PsiElement target;
            if (e instanceof PsiMethodCallExpression) {
                return false;
            }
            if (e instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)e).resolve()) instanceof PsiField) {
                return ((PsiField)target).hasModifierProperty("final");
            }
            return !(e instanceof PsiArrayAccessExpression);
        });
    }

    static {
        convertableBoxedClassNames.add("java.lang.Byte");
        convertableBoxedClassNames.add("java.lang.Character");
        convertableBoxedClassNames.add("java.lang.Short");
        KNOWN_SIMPLE_CALLS = CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet", "emptyIterator", "emptyMap", "emptySortedMap", "emptySortedSet", "emptyListIterator").parameterCount(0);
        GET_OR_DEFAULT = CallMatcher.instanceCall("java.util.Map", "getOrDefault").parameterCount(2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierOrThis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nonStructuralChildren";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetArrayAccess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expressionIsOffsetVariableLookup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVariableLessThanComparison";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVariableGreaterThanComparison";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNegative";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithNull";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithZero";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAutoBoxed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierOrThis";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "bindReferenceTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "bindCallTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingChildAlwaysExecuted";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDifference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

