/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessarilyQualifiedStaticUsageInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreStaticFieldAccesses = false;
    public boolean m_ignoreStaticMethodCalls = false;
    public boolean m_ignoreStaticAccessFromStaticContext = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.display.name", new Object[0]);
        if (string == null) {
            UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)infos[0];
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor", element.getText());
            if (string == null) {
                UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor1", element.getText());
        if (string == null) {
            UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.field.option", new Object[0]), "m_ignoreStaticFieldAccesses");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.method.option", new Object[0]), "m_ignoreStaticMethodCalls");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("only.report.qualified.static.usages.option", new Object[0]), "m_ignoreStaticAccessFromStaticContext");
        return optionsPanel;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedStaticUsageFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedStaticUsageVisitor();
    }

    public static boolean isUnnecessarilyQualifiedAccess(@NotNull PsiJavaCodeReferenceElement referenceElement, boolean ignoreStaticAccessFromStaticContext, boolean ignoreStaticFieldAccesses, boolean ignoreStaticMethodCalls) {
        PsiClass memberClass;
        PsiMember containingMember;
        if (referenceElement == null) {
            UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(3);
        }
        if (referenceElement instanceof PsiMethodReferenceExpression) {
            return false;
        }
        PsiElement parent = referenceElement.getParent();
        if (parent instanceof PsiImportStatementBase) {
            return false;
        }
        PsiElement qualifierElement = referenceElement.getQualifier();
        if (!(qualifierElement instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)qualifierElement;
        if (UnnecessarilyQualifiedStaticUsageInspection.isGenericReference(referenceElement, qualifier)) {
            return false;
        }
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiField && !ignoreStaticFieldAccesses || target instanceof PsiMethod && !ignoreStaticMethodCalls)) {
            return false;
        }
        if (ignoreStaticAccessFromStaticContext && (containingMember = PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiMember.class)) != null && !containingMember.hasModifierProperty("static")) {
            return false;
        }
        String referenceName = referenceElement.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        PsiElement resolvedQualifier = qualifier.resolve();
        if (!(resolvedQualifier instanceof PsiClass)) {
            return false;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiClass.class);
        PsiClass qualifyingClass = (PsiClass)resolvedQualifier;
        if (containingClass == null || !PsiTreeUtil.isAncestor(qualifyingClass, containingClass, false)) {
            return false;
        }
        Project project = referenceElement.getProject();
        JavaPsiFacade manager = JavaPsiFacade.getInstance(project);
        PsiResolveHelper resolveHelper = manager.getResolveHelper();
        PsiMember member = (PsiMember)target;
        if (target instanceof PsiField) {
            PsiVariable variable = resolveHelper.resolveReferencedVariable(referenceName, referenceElement);
            if (variable == null || !variable.equals(member)) {
                return false;
            }
            TextRange referenceElementTextRange = referenceElement.getTextRange();
            if (referenceElementTextRange == null) {
                return false;
            }
            TextRange variableTextRange = variable.getTextRange();
            if (variableTextRange == null) {
                return false;
            }
            if (referenceElementTextRange.getStartOffset() < variableTextRange.getEndOffset()) {
                return false;
            }
            PsiMember memberVariable = (PsiMember)((Object)variable);
            memberClass = memberVariable.getContainingClass();
        } else if (target instanceof PsiClass) {
            PsiClass aClass = resolveHelper.resolveReferencedClass(referenceName, referenceElement);
            if (aClass == null || !aClass.equals(member)) {
                return false;
            }
            memberClass = aClass.getContainingClass();
        } else {
            return UnnecessarilyQualifiedStaticUsageInspection.isMethodAccessibleWithoutQualifier(referenceElement, qualifyingClass);
        }
        return resolvedQualifier.equals(memberClass);
    }

    private static boolean isMethodAccessibleWithoutQualifier(PsiJavaCodeReferenceElement referenceElement, PsiClass qualifyingClass) {
        String referenceName = referenceElement.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass(referenceElement);
        while (containingClass != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = containingClass.findMethodsByName(referenceName, true)) {
                String name = method.getName();
                if (!referenceName.equals(name)) continue;
                return containingClass.equals(qualifyingClass);
            }
            containingClass = ClassUtils.getContainingClass(containingClass);
        }
        return false;
    }

    static boolean isGenericReference(PsiJavaCodeReferenceElement referenceElement, PsiJavaCodeReferenceElement qualifierElement) {
        PsiTypeElement[] typeParameterElements;
        PsiTypeElement[] typeParameterElements2;
        PsiReferenceParameterList qualifierParameterList = qualifierElement.getParameterList();
        if (qualifierParameterList != null && (typeParameterElements2 = qualifierParameterList.getTypeParameterElements()).length > 0) {
            return true;
        }
        PsiReferenceParameterList parameterList = referenceElement.getParameterList();
        return parameterList != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnnecessarilyQualifiedAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UnnecessarilyQualifiedStaticUsageVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedStaticUsageVisitor() {
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement qualifier = reference.getQualifier();
            if (qualifier == null) {
                return;
            }
            if (!UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess(reference, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticAccessFromStaticContext, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticFieldAccesses, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticMethodCalls)) {
                return;
            }
            this.registerError(qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, reference);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitReferenceElement(expression);
        }
    }

    private static class UnnecessarilyQualifiedStaticUsageFix
    extends InspectionGadgetsFix {
        private UnnecessarilyQualifiedStaticUsageFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarilyQualifiedStaticUsageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageFix", "getFamilyName"));
        }
    }
}

