/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessCandidateParameterTypeInferencePolicy
extends DefaultParameterTypeInferencePolicy {
    public static final ProcessCandidateParameterTypeInferencePolicy INSTANCE = new ProcessCandidateParameterTypeInferencePolicy();

    @Override
    public Pair<PsiType, ConstraintType> inferTypeConstraintFromCallContext(PsiExpression innerMethodCall, PsiExpressionList expressionList, @NotNull PsiCallExpression contextCall, PsiTypeParameter typeParameter) {
        if (contextCall == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(0);
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        PsiElement parent = innerMethodCall;
        while (parent.getParent() instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        int i = ArrayUtilRt.find(expressions, parent);
        if (i < 0) {
            return null;
        }
        PsiMethod owner = (PsiMethod)typeParameter.getOwner();
        if (owner == null) {
            return null;
        }
        try {
            JavaResolveResult[] results = this.getResults(contextCall, i);
            PsiType innerReturnType = owner.getReturnType();
            for (JavaResolveResult result : results) {
                PsiSubstitutor substitutor;
                Pair<PsiType, ConstraintType> constraint;
                if (result == null || (constraint = ProcessCandidateParameterTypeInferencePolicy.inferConstraint(typeParameter, innerMethodCall, i, innerReturnType, result, substitutor = this.getSubstitutor(contextCall, expressions, i, result))) == null) continue;
                return constraint;
            }
        }
        catch (MethodProcessorSetupFailedException ev) {
            return null;
        }
        return null;
    }

    protected PsiSubstitutor getSubstitutor(PsiCallExpression contextCall, PsiExpression[] expressions, int i, JavaResolveResult result) {
        if (result instanceof MethodCandidateInfo) {
            List<PsiExpression> leftArgs = this.getExpressions(expressions, i);
            return ((MethodCandidateInfo)result).inferSubstitutorFromArgs(this, leftArgs.toArray(PsiExpression.EMPTY_ARRAY));
        }
        return result.getSubstitutor();
    }

    protected List<PsiExpression> getExpressions(PsiExpression[] expressions, int i) {
        return Arrays.asList(expressions).subList(0, i);
    }

    protected static Pair<PsiType, ConstraintType> inferConstraint(PsiTypeParameter typeParameter, PsiExpression innerMethodCall, int parameterIdx, PsiType innerReturnType, JavaResolveResult result, PsiSubstitutor substitutor) {
        PsiElement element = result.getElement();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiParameter parameter = null;
            if (parameters.length > parameterIdx) {
                parameter = parameters[parameterIdx];
            } else if (method.isVarArgs()) {
                parameter = parameters[parameters.length - 1];
            }
            if (parameter != null) {
                PsiParameter finalParameter = parameter;
                PsiType type = PsiResolveHelper.ourGuard.doPreventingRecursion(innerMethodCall, true, () -> substitutor.substitute(finalParameter.getType()));
                LanguageLevel languageLevel = PsiUtil.getLanguageLevel(finalParameter);
                Pair<PsiType, ConstraintType> constraint = new PsiOldInferenceHelper(element.getManager()).getSubstitutionForTypeParameterConstraint(typeParameter, innerReturnType, type, false, languageLevel);
                if (constraint != null) {
                    return constraint;
                }
            }
        }
        return null;
    }

    @NotNull
    protected JavaResolveResult[] getResults(@NotNull PsiCallExpression contextCall, int exprIdx) throws MethodProcessorSetupFailedException {
        if (contextCall == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(1);
        }
        PsiFile containingFile = contextCall.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(contextCall, containingFile);
        PsiScopesUtil.setupAndRunProcessor(processor, contextCall, false);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(2);
        }
        return javaResolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/ProcessCandidateParameterTypeInferencePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/ProcessCandidateParameterTypeInferencePolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeConstraintFromCallContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResults";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

