/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import com.intellij.psi.impl.java.stubs.impl.PsiNameValuePairStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaNameValuePairType
extends JavaStubElementType<PsiNameValuePairStub, PsiNameValuePair> {
    protected JavaNameValuePairType() {
        super("NAME_VALUE_PAIR", true);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaNameValuePairType.$$$reportNull$$$0(0);
        }
        return new PsiNameValuePairImpl(node);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        NameValuePairElement nameValuePairElement = new NameValuePairElement();
        if (nameValuePairElement == null) {
            JavaNameValuePairType.$$$reportNull$$$0(1);
        }
        return nameValuePairElement;
    }

    @Override
    public PsiNameValuePairStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        String value = null;
        List<LighterASTNode> children = tree.getChildren(node);
        for (LighterASTNode child : children) {
            if (child.getTokenType() == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getTokenType())) continue;
            value = LightTreeUtil.toFilteredString(tree, child, null);
        }
        return new PsiNameValuePairStubImpl(parentStub, name, value);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull PsiNameValuePairStub stub) {
        if (stub == null) {
            JavaNameValuePairType.$$$reportNull$$$0(2);
        }
        return this.getPsiFactory(stub).createNameValuePair(stub);
    }

    @Override
    public void serialize(@NotNull PsiNameValuePairStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaNameValuePairType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            JavaNameValuePairType.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub.getName());
        String value = stub.getValue();
        boolean hasValue = value != null;
        dataStream.writeBoolean(hasValue);
        if (hasValue) {
            dataStream.writeUTFFast(value);
        }
    }

    @Override
    @NotNull
    public PsiNameValuePairStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaNameValuePairType.$$$reportNull$$$0(5);
        }
        String name = dataStream.readNameString();
        boolean hasValue = dataStream.readBoolean();
        PsiNameValuePairStubImpl psiNameValuePairStubImpl = new PsiNameValuePairStubImpl(parentStub, name, hasValue ? dataStream.readUTFFast() : null);
        if (psiNameValuePairStubImpl == null) {
            JavaNameValuePairType.$$$reportNull$$$0(6);
        }
        return psiNameValuePairStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiNameValuePairStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            JavaNameValuePairType.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            JavaNameValuePairType.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaNameValuePairType";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaNameValuePairType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

