/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileElementInfo
extends SmartPointerElementInfo {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private final Language myLanguage;
    private final Class<? extends PsiFile> myFileClass;

    FileElementInfo(@NotNull PsiFile file) {
        if (file == null) {
            FileElementInfo.$$$reportNull$$$0(0);
        }
        this.myVirtualFile = file.getVirtualFile();
        this.myProject = file.getProject();
        this.myLanguage = LanguageUtil.getRootLanguage(file);
        this.myFileClass = file.getClass();
    }

    @Override
    PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        PsiFile file;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(1);
        }
        return this.myFileClass.isInstance(file = SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage)) ? file : null;
    }

    @Override
    PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager) {
        PsiElement element;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(2);
        }
        return (element = this.restoreElement(manager)) == null ? null : element.getContainingFile();
    }

    @Override
    int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        if (other == null) {
            FileElementInfo.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(4);
        }
        return other instanceof FileElementInfo && Comparing.equal(this.myVirtualFile, ((FileElementInfo)other).myVirtualFile);
    }

    @Override
    VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(5);
        }
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        return document == null ? null : TextRange.from(0, document.getTextLength());
    }

    @Override
    @Nullable
    Segment getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        Document currentDoc;
        if (manager == null) {
            FileElementInfo.$$$reportNull$$$0(6);
        }
        DocumentEx committedDoc = (currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile)) == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange(manager) : new TextRange(0, committedDoc.getTextLength());
    }

    public String toString() {
        return "file{" + this.myVirtualFile + ", " + this.myLanguage + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/smartPointers/FileElementInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "pointsToTheSameElementAs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

