/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.ref.Reference;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiParameterImpl
extends JavaStubPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiParameterImpl");
    private volatile Reference<PsiType> myCachedType;

    public PsiParameterImpl(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            PsiParameterImpl.$$$reportNull$$$0(0);
        }
        this(stub, (IStubElementType)JavaStubElementTypes.PARAMETER);
    }

    protected PsiParameterImpl(@NotNull PsiParameterStub stub, @NotNull IStubElementType type) {
        if (stub == null) {
            PsiParameterImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            PsiParameterImpl.$$$reportNull$$$0(2);
        }
        super(stub, type);
    }

    public PsiParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiParameterImpl.$$$reportNull$$$0(3);
        }
        super(node);
    }

    public static PsiType getLambdaParameterType(PsiParameter param) {
        PsiLambdaExpression lambdaExpression;
        int parameterIndex;
        PsiElement paramParent = param.getParent();
        if (paramParent instanceof PsiParameterList && (parameterIndex = ((PsiParameterList)paramParent).getParameterIndex(param)) > -1 && (lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)param, PsiLambdaExpression.class)) != null) {
            PsiType functionalInterfaceType = LambdaUtil.ourParameterGuard.doPreventingRecursion(param, false, () -> LambdaUtil.getFunctionalInterfaceType(lambdaExpression, true));
            PsiType type = lambdaExpression.getGroundTargetType(functionalInterfaceType);
            if (type instanceof PsiIntersectionType) {
                PsiType[] conjuncts;
                for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type).getConjuncts()) {
                    PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(conjunct, parameterIndex);
                    if (lambdaParameterFromType == null) continue;
                    return lambdaParameterFromType;
                }
            } else {
                PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(type, parameterIndex);
                if (lambdaParameterFromType != null) {
                    return lambdaParameterFromType;
                }
            }
        }
        return new PsiLambdaParameterType(param);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiParameterImpl clone = (PsiParameterImpl)super.clone();
        clone.myCachedType = null;
        return clone;
    }

    @Override
    @NotNull
    public final String getName() {
        PsiParameterStub stub = (PsiParameterStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                PsiParameterImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            PsiParameterImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public final PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiParameterImpl.$$$reportNull$$$0(6);
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = PsiTreeUtil.getRequiredChildOfType(this, PsiIdentifier.class);
        if (psiIdentifier == null) {
            PsiParameterImpl.$$$reportNull$$$0(7);
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiParameterImpl.$$$reportNull$$$0(8);
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            PsiType type = SoftReference.dereference(this.myCachedType);
            if (type == null) {
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                type = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createTypeFromText(typeText, this);
                type = JavaSharedImplUtil.applyAnnotations(type, this.getModifierList());
                this.myCachedType = new SoftReference<PsiType>(type);
            }
            PsiType psiType = type;
            if (psiType == null) {
                PsiParameterImpl.$$$reportNull$$$0(9);
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null || this.isLambdaParameter() && typeElement.isInferredType()) {
            assert (this.isLambdaParameter()) : this;
            PsiType psiType = PsiParameterImpl.getLambdaParameterType(this);
            if (psiType == null) {
                PsiParameterImpl.$$$reportNull$$$0(10);
            }
            return psiType;
        }
        PsiType psiType = JavaSharedImplUtil.getType(typeElement, this.getNameIdentifier());
        if (psiType == null) {
            PsiParameterImpl.$$$reportNull$$$0(11);
        }
        return psiType;
    }

    private boolean isLambdaParameter() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiTypeElement)) continue;
            return (PsiTypeElement)child;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList = this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList != null) : this;
        PsiModifierList psiModifierList = modifierList;
        if (psiModifierList == null) {
            PsiParameterImpl.$$$reportNull$$$0(12);
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            PsiParameterImpl.$$$reportNull$$$0(13);
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiParameterImpl.$$$reportNull$$$0(14);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameter(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiParameter:" + this.getName();
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            PsiParameterImpl psiParameterImpl = this;
            if (psiParameterImpl == null) {
                PsiParameterImpl.$$$reportNull$$$0(15);
            }
            return psiParameterImpl;
        }
        if (parent instanceof PsiParameterList) {
            PsiElement psiElement = parent.getParent();
            if (psiElement == null) {
                PsiParameterImpl.$$$reportNull$$$0(16);
            }
            return psiElement;
        }
        if (parent instanceof PsiForeachStatement) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                PsiParameterImpl.$$$reportNull$$$0(17);
            }
            return psiElement;
        }
        if (parent instanceof PsiCatchSection) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                PsiParameterImpl.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        PsiElement[] children = parent.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].equals(this)) continue;
                for (int j = i + 1; j < children.length; ++j) {
                    if (!(children[j] instanceof PsiCodeBlock)) continue;
                    PsiElement psiElement = children[j];
                    if (psiElement == null) {
                        PsiParameterImpl.$$$reportNull$$$0(19);
                    }
                    return psiElement;
                }
                break;
            }
        }
        LOG.error("Code block not found among parameter' (" + this + ") parent' (" + parent + ") children: " + Arrays.asList(children));
        if (null == null) {
            PsiParameterImpl.$$$reportNull$$$0(20);
        }
        return null;
    }

    @Override
    public boolean isVarArgs() {
        PsiParameterStub stub = (PsiParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isParameterTypeEllipsis();
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return typeElement != null && SourceTreeToPsiMap.psiToTreeNotNull(typeElement).findChildByType(JavaTokenType.ELLIPSIS) != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiParameterImpl.createLayeredIcon(this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope = this.getDeclarationScope();
        LocalSearchScope localSearchScope = new LocalSearchScope(declarationScope);
        if (localSearchScope == null) {
            PsiParameterImpl.$$$reportNull$$$0(21);
        }
        return localSearchScope;
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiParameter[] originalParameters;
        int index;
        PsiElement originalMethod;
        PsiElement gParent;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod && (originalMethod = gParent.getOriginalElement()) instanceof PsiMethod && (index = ((PsiParameterList)parent).getParameterIndex(this)) < (originalParameters = ((PsiMethod)originalMethod).getParameterList().getParameters()).length) {
            return originalParameters[index];
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiParameterImpl";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiParameterImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

