/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IntIntFunction;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import gnu.trove.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubList {
    private final ArrayList<StubBase<?>> myPlainList;
    private final MostlyUShortIntList myJoinedChildrenList;
    private static final int IN_TEMP_MAP = -1;
    private final MostlyUShortIntList myStubData;
    @Nullable
    private TempState myTempState = new TempState();

    StubList(int initialCapacity) {
        this.myPlainList = new ArrayList(initialCapacity);
        this.myStubData = new MostlyUShortIntList(initialCapacity * 3);
        this.myJoinedChildrenList = new MostlyUShortIntList(initialCapacity);
        this.myJoinedChildrenList.add(0);
    }

    IStubElementType<?, ?> getStubType(int id) {
        return (IStubElementType)IElementType.find(this.getStubTypeIndex(id));
    }

    private short getStubTypeIndex(int id) {
        return (short)this.myStubData.get(id * 3);
    }

    private static int childrenStartIndex(int id) {
        return id * 3 + 1;
    }

    private static int childrenCountIndex(int id) {
        return id * 3 + 2;
    }

    private int getChildrenStart(int id) {
        return this.myStubData.get(StubList.childrenStartIndex(id));
    }

    private int getChildrenCount(int id) {
        return this.myStubData.get(StubList.childrenCountIndex(id));
    }

    void addStub(@NotNull StubBase<?> stub, @Nullable StubBase<?> parent, @Nullable IStubElementType<?, ?> type) {
        int parentId;
        if (stub == null) {
            StubList.$$$reportNull$$$0(0);
        }
        int stubId = this.myPlainList.size();
        this.setStubToListReferences(stub, stubId);
        int n = parentId = parent == null ? -1 : parent.id;
        if (this.nonDfsOrderDetected(parentId, stubId)) {
            Objects.requireNonNull(this.myTempState).switchChildrenToTempMap(parentId);
        }
        this.addStub(stub, stubId, parentId, type == null ? (short)0 : type.getIndex());
    }

    private boolean nonDfsOrderDetected(int parentId, int childId) {
        return parentId >= 0 && childId != parentId + 1 && this.getChildrenCount(parentId) == 0;
    }

    private void setStubToListReferences(@NotNull StubBase<?> stub, int stubId) {
        if (stub == null) {
            StubList.$$$reportNull$$$0(1);
        }
        stub.myStubList = this;
        stub.id = stubId;
    }

    private void addStub(@NotNull StubBase<?> child, int childId, int parentId, short elementTypeIndex) {
        if (child == null) {
            StubList.$$$reportNull$$$0(2);
        }
        assert (this.myTempState != null);
        assert (childId == this.myPlainList.size());
        this.myPlainList.add(child);
        this.myStubData.add(elementTypeIndex);
        this.myStubData.add(0);
        this.myStubData.add(0);
        if (parentId < 0) {
            return;
        }
        int childrenCount = this.getChildrenCount(parentId);
        int childrenStart = this.myTempState.ensureCapacityForNextChild(childId, parentId, childrenCount);
        ChildrenStorage storage = StubList.getChildrenStorage(childrenStart);
        if (storage == ChildrenStorage.inJoinedList) {
            this.addToJoinedChildren(childrenStart + childrenCount, childId);
        } else if (storage == ChildrenStorage.inTempMap) {
            ((MostlyUShortIntList)this.tempMap().get(parentId)).add(childId);
        }
        this.myStubData.set(StubList.childrenCountIndex(parentId), childrenCount + 1);
    }

    private static ChildrenStorage getChildrenStorage(int childrenStart) {
        return childrenStart == 0 ? ChildrenStorage.inPlainList : (childrenStart == -1 ? ChildrenStorage.inTempMap : ChildrenStorage.inJoinedList);
    }

    private boolean canAddToJoinedList(int index) {
        return this.myJoinedChildrenList.size() == index || this.myJoinedChildrenList.get(index) == 0;
    }

    private void addToJoinedChildren(int index, int childId) {
        if (this.myJoinedChildrenList.size() == index) {
            this.myJoinedChildrenList.add(childId);
        } else {
            assert (this.myJoinedChildrenList.get(index) == 0);
            this.myJoinedChildrenList.set(index, childId);
        }
    }

    void prepareForChildren(StubBase<?> parent, int childrenCount) {
        assert (this.myTempState != null);
        this.myTempState.prepareForChildren(parent.id, childrenCount);
    }

    List<StubBase<?>> getChildrenStubs(int id) {
        int count = this.getChildrenCount(id);
        if (count == 0) {
            return Collections.emptyList();
        }
        int start = this.getChildrenStart(id);
        switch (StubList.getChildrenStorage(start)) {
            case inPlainList: {
                return this.myPlainList.subList(id + 1, id + 1 + count);
            }
            case inJoinedList: {
                return this.idSubList(this.myJoinedChildrenList, start, count);
            }
        }
        return this.idSubList((MostlyUShortIntList)this.tempMap().get(id), 0, count);
    }

    private List<StubBase<?>> idSubList(final MostlyUShortIntList idList, final int start, final int count) {
        return new AbstractList<StubBase<?>>(){

            @Override
            public StubBase<?> get(int index) {
                return (StubBase)StubList.this.myPlainList.get(idList.get(start + index));
            }

            @Override
            public int size() {
                return count;
            }
        };
    }

    private TIntObjectHashMap<MostlyUShortIntList> tempMap() {
        assert (this.myTempState != null);
        return Objects.requireNonNull(this.myTempState.myTempJoinedChildrenMap);
    }

    @Nullable
    <P extends PsiElement, S extends StubElement<P>> S findChildStubByType(int id, @NotNull IStubElementType<S, P> elementType) {
        if (elementType == null) {
            StubList.$$$reportNull$$$0(3);
        }
        int count = this.getChildrenCount(id);
        int start = this.getChildrenStart(id);
        switch (StubList.getChildrenStorage(start)) {
            case inPlainList: {
                return this.findChildStubByType(elementType, IntIntFunction.IDENTITY, id + 1, id + 1 + count);
            }
            case inJoinedList: {
                return this.findChildStubByType(elementType, this.myJoinedChildrenList, start, start + count);
            }
        }
        return this.findChildStubByType(elementType, (IntIntFunction)Objects.requireNonNull(this.tempMap()).get(id), 0, count);
    }

    @Nullable
    private <P extends PsiElement, S extends StubElement<P>> S findChildStubByType(IStubElementType<S, P> elementType, IntIntFunction idList, int start, int end) {
        for (int i = start; i < end; ++i) {
            int id = idList.get(i);
            if (elementType.getIndex() != this.getStubTypeIndex(id)) continue;
            return (S)this.myPlainList.get(id);
        }
        return null;
    }

    @NotNull
    StubList finalizeLoadingStage() {
        if (this.myTempState == null) {
            StubList stubList = this;
            if (stubList == null) {
                StubList.$$$reportNull$$$0(4);
            }
            return stubList;
        }
        if (!this.isChildrenLayoutOptimal()) {
            StubList stubList = this.createOptimizedCopy();
            if (stubList == null) {
                StubList.$$$reportNull$$$0(5);
            }
            return stubList;
        }
        this.myTempState = null;
        this.myPlainList.trimToSize();
        this.myJoinedChildrenList.trimToSize();
        this.myStubData.trimToSize();
        StubList stubList = this;
        if (stubList == null) {
            StubList.$$$reportNull$$$0(6);
        }
        return stubList;
    }

    @NotNull
    List<StubElement<?>> toPlainList() {
        List<StubElement<?>> list = Collections.unmodifiableList(this.myPlainList);
        if (list == null) {
            StubList.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private StubList createOptimizedCopy() {
        final StubList copy = new StubList(this.myPlainList.size());
        new Object(){

            void visitStub(StubBase<?> stub, int parentId) {
                int idInCopy = copy.myPlainList.size();
                copy.addStub(stub, idInCopy, parentId, StubList.this.getStubTypeIndex(stub.id));
                List<StubBase<?>> children = StubList.this.getChildrenStubs(stub.id);
                Objects.requireNonNull(copy.myTempState).prepareForChildren(idInCopy, children.size());
                for (StubBase<?> child : children) {
                    this.visitStub(child, idInCopy);
                }
            }
        }.visitStub(this.myPlainList.get(0), -1);
        assert (copy.isChildrenLayoutOptimal());
        for (int i = 0; i < copy.myPlainList.size(); ++i) {
            copy.setStubToListReferences(copy.myPlainList.get(i), i);
        }
        StubList stubList = copy.finalizeLoadingStage();
        if (stubList == null) {
            StubList.$$$reportNull$$$0(8);
        }
        return stubList;
    }

    boolean isChildrenLayoutOptimal() {
        return this.myTempState == null || this.myTempState.myTempJoinedChildrenMap == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "finalizeLoadingStage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toPlainList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptimizedCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addStub";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setStubToListReferences";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TempState {
        @Nullable
        TIntObjectHashMap<MostlyUShortIntList> myTempJoinedChildrenMap;
        int myCurrentParent = -1;
        int myExpectedChildrenCount;

        private TempState() {
        }

        int ensureCapacityForNextChild(int childId, int parentId, int childrenCount) {
            int childrenStart;
            ChildrenStorage storage;
            if (this.myCurrentParent >= 0) {
                if (childrenCount == this.myExpectedChildrenCount - 1) {
                    this.myCurrentParent = -1;
                } else if (parentId != this.myCurrentParent) {
                    this.myCurrentParent = -1;
                    return this.switchChildrenToJoinedList(parentId, childrenCount, this.myExpectedChildrenCount - childrenCount);
                }
            }
            if ((storage = StubList.getChildrenStorage(childrenStart = StubList.this.getChildrenStart(parentId))) == ChildrenStorage.inPlainList) {
                if (childrenCount == 0) {
                    assert (parentId == childId - 1);
                } else if (this.areChildrenNonAdjacent(childId, parentId)) {
                    return this.switchChildrenToJoinedList(parentId, childrenCount, 0);
                }
            } else if (storage == ChildrenStorage.inJoinedList && !StubList.this.canAddToJoinedList(childrenStart + childrenCount)) {
                this.switchChildrenToTempMap(parentId);
                return -1;
            }
            return childrenStart;
        }

        private boolean areChildrenNonAdjacent(int childId, int parentId) {
            return ((StubBase)StubList.this.myPlainList.get(childId - 1)).getParentStub() != StubList.this.myPlainList.get(parentId);
        }

        private int switchChildrenToJoinedList(int parentId, int childrenCount, int slotsToReserve) {
            int i;
            int start = StubList.this.myJoinedChildrenList.size();
            assert (start > 0);
            for (i = 0; i < childrenCount; ++i) {
                StubList.this.myJoinedChildrenList.add(parentId + i + 1);
            }
            for (i = 0; i < slotsToReserve; ++i) {
                StubList.this.myJoinedChildrenList.add(0);
            }
            StubList.this.myStubData.set(StubList.childrenStartIndex(parentId), start);
            return start;
        }

        private void switchChildrenToTempMap(int parentId) {
            if (this.myTempJoinedChildrenMap == null) {
                this.myTempJoinedChildrenMap = new TIntObjectHashMap();
            }
            int start = StubList.this.getChildrenStart(parentId);
            int count = StubList.this.getChildrenCount(parentId);
            MostlyUShortIntList ids = new MostlyUShortIntList(count + 1);
            switch (StubList.getChildrenStorage(start)) {
                case inPlainList: {
                    int i;
                    for (i = 0; i < count; ++i) {
                        ids.add(parentId + i + 1);
                    }
                    break;
                }
                case inJoinedList: {
                    int i;
                    for (i = start; i < start + count; ++i) {
                        ids.add(StubList.this.myJoinedChildrenList.get(i));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            MostlyUShortIntList prev = (MostlyUShortIntList)this.myTempJoinedChildrenMap.put(parentId, (Object)ids);
            assert (prev == null);
            StubList.this.myStubData.set(StubList.childrenStartIndex(parentId), -1);
        }

        void prepareForChildren(int parentId, int childrenCount) {
            assert (parentId == StubList.this.myPlainList.size() - 1);
            if (childrenCount == 0) {
                return;
            }
            if (this.myCurrentParent >= 0) {
                int currentCount = StubList.this.getChildrenCount(this.myCurrentParent);
                this.switchChildrenToJoinedList(this.myCurrentParent, currentCount, this.myExpectedChildrenCount - currentCount);
            }
            this.myCurrentParent = parentId;
            this.myExpectedChildrenCount = childrenCount;
        }
    }

    private static enum ChildrenStorage {
        inPlainList,
        inJoinedList,
        inTempMap;

    }
}

