/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInputOutputUtil
extends DataInputOutputUtilRt {
    public static final long timeBase = 1040688000000L;

    private DataInputOutputUtil() {
    }

    public static int readINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(0);
        }
        return DataInputOutputUtilRt.readINT(record);
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(1);
        }
        DataInputOutputUtilRt.writeINT(record, val);
    }

    public static long readLONG(@NotNull DataInput record) throws IOException {
        int val;
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(2);
        }
        if ((val = record.readUnsignedByte()) < 192) {
            return val;
        }
        long res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeLONG(@NotNull DataOutput record, long val) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(3);
        }
        if (0L > val || val >= 192L) {
            record.writeByte(192 + (int)(val & 0x3FL));
            val >>>= 6;
            while (val >= 128L) {
                record.writeByte((int)(val & 0x7FL) | 0x80);
                val >>>= 7;
            }
        }
        record.writeByte((int)val);
    }

    public static int readSINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(4);
        }
        return DataInputOutputUtil.readINT(record) - 64;
    }

    public static void writeSINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(5);
        }
        DataInputOutputUtil.writeINT(record, val + 64);
    }

    public static void writeTIME(@NotNull DataOutput record, long timestamp) throws IOException {
        long relStamp;
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(6);
        }
        if ((relStamp = timestamp - 1040688000000L) < 0L || relStamp >= 0xFF00000000L) {
            record.writeByte(255);
            record.writeLong(timestamp);
        } else {
            record.writeByte((int)(relStamp >> 32));
            record.writeByte((int)(relStamp >> 24));
            record.writeByte((int)(relStamp >> 16));
            record.writeByte((int)(relStamp >> 8));
            record.writeByte((int)relStamp);
        }
    }

    public static long readTIME(@NotNull DataInput record) throws IOException {
        int first;
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(7);
        }
        if ((first = record.readUnsignedByte()) == 255) {
            return record.readLong();
        }
        int second = record.readUnsignedByte();
        int third = record.readUnsignedByte() << 16;
        int fourth = record.readUnsignedByte() << 8;
        int fifth = record.readUnsignedByte();
        return ((long)(first << 8 | second) << 24 | (long)(third | fourth | fifth)) + 1040688000000L;
    }

    public static <T> void writeNullable(@NotNull DataOutput out, @Nullable T value, @NotNull ThrowableConsumer<T, IOException> writeValue) throws IOException {
        if (out == null) {
            DataInputOutputUtil.$$$reportNull$$$0(8);
        }
        if (writeValue == null) {
            DataInputOutputUtil.$$$reportNull$$$0(9);
        }
        out.writeBoolean(value != null);
        if (value != null) {
            writeValue.consume(value);
        }
    }

    @Nullable
    public static <T> T readNullable(@NotNull DataInput in, @NotNull ThrowableComputable<T, IOException> readValue) throws IOException {
        if (in == null) {
            DataInputOutputUtil.$$$reportNull$$$0(10);
        }
        if (readValue == null) {
            DataInputOutputUtil.$$$reportNull$$$0(11);
        }
        return in.readBoolean() ? (T)readValue.compute() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readValue";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/DataInputOutputUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readINT";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeINT";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readLONG";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLONG";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readSINT";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSINT";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTIME";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readTIME";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "writeNullable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "readNullable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

