/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;

public final class EKey {
    @NotNull
    final MemberDescriptor member;
    final int dirKey;
    final boolean stable;
    final boolean negated;

    public EKey(@NotNull MemberDescriptor member, Direction direction, boolean stable) {
        if (member == null) {
            EKey.$$$reportNull$$$0(0);
        }
        this(member, direction, stable, false);
    }

    EKey(@NotNull MemberDescriptor member, Direction direction, boolean stable, boolean negated) {
        if (member == null) {
            EKey.$$$reportNull$$$0(1);
        }
        this(member, direction.asInt(), stable, negated);
    }

    EKey(@NotNull MemberDescriptor member, int dirKey, boolean stable, boolean negated) {
        if (member == null) {
            EKey.$$$reportNull$$$0(2);
        }
        this.member = member;
        this.dirKey = dirKey;
        this.stable = stable;
        this.negated = negated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EKey key = (EKey)o;
        if (this.stable != key.stable) {
            return false;
        }
        if (this.negated != key.negated) {
            return false;
        }
        if (this.dirKey != key.dirKey) {
            return false;
        }
        return this.member.equals(key.member);
    }

    public int hashCode() {
        int result2 = this.member.hashCode();
        result2 = 31 * result2 + this.dirKey;
        result2 = 31 * result2 + (this.stable ? 1 : 0);
        result2 = 31 * result2 + (this.negated ? 1 : 0);
        return result2;
    }

    EKey invertStability() {
        return new EKey(this.member, this.dirKey, !this.stable, this.negated);
    }

    EKey mkStable() {
        return this.stable ? this : new EKey(this.member, this.dirKey, true, this.negated);
    }

    EKey mkUnstable() {
        return this.stable ? new EKey(this.member, this.dirKey, false, this.negated) : this;
    }

    public EKey mkBase() {
        return this.withDirection(Direction.Out);
    }

    EKey withDirection(Direction dir) {
        return this.dirKey == dir.asInt() ? this : new EKey(this.member, dir, this.stable, false);
    }

    EKey negate() {
        return new EKey(this.member, this.dirKey, this.stable, true);
    }

    public EKey hashed(MessageDigest md) {
        HMember hMember = this.member.hashed(md);
        return hMember == this.member ? this : new EKey((MemberDescriptor)hMember, this.dirKey, this.stable, this.negated);
    }

    public Direction getDirection() {
        return Direction.fromInt(this.dirKey);
    }

    public String toString() {
        return "Key [" + this.member + "|" + (this.stable ? "S" : "-") + (this.negated ? "N" : "-") + "|" + Direction.fromInt(this.dirKey) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/bytecodeAnalysis/EKey", "<init>"));
    }
}

