/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonDataflow {
    @Contract(value="null -> null")
    @Nullable
    private static DataflowResult runDFA(@Nullable PsiElement block) {
        if (block == null) {
            return null;
        }
        DataFlowRunner runner = new DataFlowRunner(false, block);
        final DataflowResult dfr = new DataflowResult();
        final DfaConstValue fail = runner.getFactory().getConstFactory().getContractFail();
        StandardInstructionVisitor visitor = new StandardInstructionVisitor(){

            @Override
            public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                DfaInstructionState[] states = super.visitPush(instruction, runner, memState);
                PsiExpression place = instruction.getPlace();
                if (place != null && !instruction.isReferenceWrite()) {
                    for (DfaInstructionState state : states) {
                        DfaMemoryState afterState = state.getMemoryState();
                        dfr.add(place, (DfaMemoryStateImpl)afterState, instruction.getValue());
                    }
                }
                return states;
            }

            @Override
            @NotNull
            protected DfaCallArguments popCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, boolean contractOnly) {
                PsiExpression qualifier;
                DfaCallArguments arguments = super.popCall(instruction, runner, memState, contractOnly);
                PsiElement context = instruction.getContext();
                if (instruction.getMethodType() == MethodCallInstruction.MethodType.REGULAR_METHOD_CALL && context instanceof PsiMethodCallExpression && (qualifier = PsiUtil.skipParenthesizedExprDown(((PsiMethodCallExpression)context).getMethodExpression().getQualifierExpression())) != null) {
                    dfr.add(qualifier, (DfaMemoryStateImpl)memState, arguments.myQualifier);
                }
                DfaCallArguments dfaCallArguments = arguments;
                if (dfaCallArguments == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dfaCallArguments;
            }

            @Override
            public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
                PsiExpression context = ObjectUtils.tryCast(instruction.getContext(), PsiExpression.class);
                if (context != null && ExpressionUtils.getCallForQualifier(context) == null) {
                    for (DfaInstructionState state : states) {
                        DfaValue value = state.getMemoryState().peek();
                        if (value == fail) continue;
                        dfr.add(context, (DfaMemoryStateImpl)state.getMemoryState(), state.getMemoryState().peek());
                    }
                }
                return states;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CommonDataflow$1", "popCall"));
            }
        };
        RunnerResult result2 = runner.analyzeMethodRecursively(block, visitor);
        return result2 == RunnerResult.OK ? dfr : null;
    }

    @Nullable
    public static DataflowResult getDataflowResult(PsiExpression context) {
        PsiElement body;
        PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)context, PsiMember.class);
        if (!(member instanceof PsiMethod || member instanceof PsiField || member instanceof PsiClassInitializer)) {
            return null;
        }
        PsiElement psiElement = body = member instanceof PsiMethod ? ((PsiMethod)member).getBody() : member.getContainingClass();
        if (body == null) {
            return null;
        }
        return (DataflowResult)CachedValuesManager.getCachedValue(body, () -> {
            DataflowResult result2 = CommonDataflow.runDFA(body);
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    public static <T> T getExpressionFact(PsiExpression expression, DfaFactType<T> type) {
        DataflowResult result2 = CommonDataflow.getDataflowResult(expression);
        if (result2 == null) {
            return null;
        }
        return result2.getExpressionFact(PsiUtil.skipParenthesizedExprDown(expression), type);
    }

    public static class DataflowResult {
        private final Map<PsiExpression, DfaFactMap> myFacts = new HashMap<PsiExpression, DfaFactMap>();

        void add(PsiExpression expression, DfaMemoryStateImpl memState, DfaValue value) {
            DfaFactMap existing = this.myFacts.get(expression);
            if (existing != DfaFactMap.EMPTY) {
                DfaFactMap newMap = memState.getFactMap(value);
                if (!Boolean.FALSE.equals(newMap.get(DfaFactType.CAN_BE_NULL)) && memState.isNotNull(value)) {
                    newMap = newMap.with(DfaFactType.CAN_BE_NULL, false);
                }
                this.myFacts.put(expression, existing == null ? newMap : existing.union(newMap));
            }
        }

        public boolean expressionWasAnalyzed(PsiExpression expression) {
            assert (!(expression instanceof PsiParenthesizedExpression));
            return this.myFacts.containsKey(expression);
        }

        @Nullable
        public <T> T getExpressionFact(PsiExpression expression, DfaFactType<T> type) {
            DfaFactMap map = this.myFacts.get(expression);
            return map == null ? null : (T)map.get(type);
        }
    }
}

