/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public enum Mutability {
    UNKNOWN,
    MUTABLE,
    UNMODIFIABLE,
    UNMODIFIABLE_VIEW;

    public static final String UNMODIFIABLE_ANNOTATION = "org.jetbrains.annotations.Unmodifiable";
    public static final String UNMODIFIABLE_VIEW_ANNOTATION = "org.jetbrains.annotations.UnmodifiableView";

    public boolean isUnmodifiable() {
        return this == UNMODIFIABLE || this == UNMODIFIABLE_VIEW;
    }

    @NotNull
    public static Mutability getMutability(@NotNull PsiModifierListOwner owner) {
        PsiExpression initializer;
        PsiParameterList list;
        PsiMethod method;
        if (owner == null) {
            Mutability.$$$reportNull$$$0(0);
        }
        if (owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && (method = ObjectUtils.tryCast((list = (PsiParameterList)owner.getParent()).getParent(), PsiMethod.class)) != null) {
            int index = list.getParameterIndex((PsiParameter)owner);
            MutationSignature signature = MutationSignature.fromMethod(method);
            if (signature.mutatesArg(index)) {
                Mutability mutability = MUTABLE;
                if (mutability == null) {
                    Mutability.$$$reportNull$$$0(1);
                }
                return mutability;
            }
            if (signature.preservesArg(index) && PsiTreeUtil.findChildOfAnyType((PsiElement)method.getBody(), PsiLambdaExpression.class, PsiClass.class) == null) {
                Mutability mutability = UNMODIFIABLE_VIEW;
                if (mutability == null) {
                    Mutability.$$$reportNull$$$0(2);
                }
                return mutability;
            }
            Mutability mutability = UNKNOWN;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(3);
            }
            return mutability;
        }
        if (AnnotationUtil.isAnnotated(owner, Collections.singleton(UNMODIFIABLE_ANNOTATION), 7)) {
            Mutability mutability = UNMODIFIABLE;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(4);
            }
            return mutability;
        }
        if (AnnotationUtil.isAnnotated(owner, Collections.singleton(UNMODIFIABLE_VIEW_ANNOTATION), 7)) {
            Mutability mutability = UNMODIFIABLE_VIEW;
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(5);
            }
            return mutability;
        }
        if (owner instanceof PsiField && owner.hasModifierProperty("final") && (initializer = PsiUtil.skipParenthesizedExprDown(((PsiField)owner).getInitializer())) instanceof PsiMethodCallExpression) {
            method = ((PsiMethodCallExpression)initializer).resolveMethod();
            Mutability mutability = method == null ? UNKNOWN : Mutability.getMutability(method);
            if (mutability == null) {
                Mutability.$$$reportNull$$$0(6);
            }
            return mutability;
        }
        Mutability mutability = UNKNOWN;
        if (mutability == null) {
            Mutability.$$$reportNull$$$0(7);
        }
        return mutability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/Mutability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/Mutability";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMutability";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

