/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RedundantTypeArgsInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.miscGenerics.RedundantTypeArgsInspection");
    private static final LocalQuickFix ourQuickFixAction = new MyQuickFixAction();
    public static final String SHORT_NAME = "RedundantTypeArguments";

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.redundant.type.display.name", new Object[0]);
        if (string == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiCodeBlock body;
        if (psiMethod == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(4);
        }
        if ((body = psiMethod.getBody()) != null) {
            return this.getDescriptions(body, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager inspectionManager, final boolean isOnTheFly) {
        if (place == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(5);
        }
        if (inspectionManager == null) {
            RedundantTypeArgsInspection.$$$reportNull$$$0(6);
        }
        final ArrayList problems = new ArrayList();
        place.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0) {
                    RedundantTypeArgsInspection.checkCallExpression(expression.getMethodExpression(), typeArguments, expression, inspectionManager, problems, isOnTheFly);
                }
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement classReference;
                super.visitNewExpression(expression);
                PsiType[] typeArguments = expression.getTypeArguments();
                if (typeArguments.length > 0 && (classReference = expression.getClassReference()) != null) {
                    RedundantTypeArgsInspection.checkCallExpression(classReference, typeArguments, expression, inspectionManager, problems, isOnTheFly);
                }
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                super.visitMethodReferenceExpression(expression);
                RedundantTypeArgsInspection.checkMethodReference(expression, inspectionManager, problems, isOnTheFly);
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void checkCallExpression(PsiJavaCodeReferenceElement reference, PsiType[] typeArguments, PsiCallExpression expression, InspectionManager inspectionManager, List<ProblemDescriptor> problems, boolean isOnTheFly) {
        PsiMethod method;
        PsiTypeParameter[] typeParameters;
        PsiExpressionList argumentList = expression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod && resolveResult.isValidResult() && ((typeParameters = (method = (PsiMethod)element).getTypeParameters()).length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, expression, false, method, typeParameters) || typeParameters.length == 0)) {
            String key = typeParameters.length == 0 ? "inspection.redundant.type.no.generics.problem.descriptor" : "inspection.redundant.type.problem.descriptor";
            ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)expression.getTypeArgumentList(), InspectionsBundle.message(key, new Object[0]), ourQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly);
            problems.add(descriptor);
        }
    }

    private static void checkMethodReference(PsiMethodReferenceExpression expression, InspectionManager inspectionManager, List<ProblemDescriptor> problems, boolean isOnTheFly) {
        PsiTypeElement qualifierTypeElement = expression.getQualifierType();
        if (qualifierTypeElement != null) {
            PsiType psiType = qualifierTypeElement.getType();
            if (psiType instanceof PsiClassType && !((PsiClassType)psiType).isRaw()) {
                PsiClass aClass = ((PsiClassType)psiType).resolve();
                if (aClass == null) {
                    return;
                }
                JavaResolveResult result2 = expression.advancedResolve(false);
                PsiElement element = result2.getElement();
                if (element instanceof PsiTypeParameterListOwner) {
                    PsiMethod method;
                    PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : null;
                    if (PsiDiamondTypeUtil.areTypeArgumentsRedundant(((PsiClassType)psiType).getParameters(), expression, false, method, aClass.getTypeParameters())) {
                        PsiJavaCodeReferenceElement referenceElement = qualifierTypeElement.getInnermostComponentReferenceElement();
                        LOG.assertTrue(referenceElement != null, qualifierTypeElement);
                        PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                        LOG.assertTrue(parameterList != null);
                        ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, InspectionsBundle.message("inspection.redundant.type.problem.descriptor", new Object[0]), ourQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly);
                        problems.add(descriptor);
                    }
                }
            }
        } else {
            PsiType[] typeArguments = expression.getTypeParameters();
            PsiReferenceParameterList parameterList = expression.getParameterList();
            if (typeArguments.length > 0 && parameterList != null) {
                PsiTypeParameter[] typeParameters;
                PsiElement resolve = expression.resolve();
                if (resolve == null) {
                    return;
                }
                PsiTypeParameter[] psiTypeParameterArray = typeParameters = resolve instanceof PsiClass ? PsiTypeParameter.EMPTY_ARRAY : ((PsiMethod)resolve).getTypeParameters();
                if (typeParameters.length == 0 || typeParameters.length == typeArguments.length && PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments, expression, false, (PsiMethod)resolve, typeParameters)) {
                    String key = typeParameters.length == 0 ? "inspection.redundant.type.no.generics.method.reference.problem.descriptor" : "inspection.redundant.type.problem.descriptor";
                    ProblemDescriptor descriptor = inspectionManager.createProblemDescriptor((PsiElement)parameterList, InspectionsBundle.message(key, new Object[0]), new MyQuickFixAction(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly);
                    problems.add(descriptor);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyQuickFixAction
    implements LocalQuickFix {
        private MyQuickFixAction() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.redundant.type.remove.quickfix", new Object[0]);
            if (string == null) {
                MyQuickFixAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                MyQuickFixAction.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFixAction.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof PsiReferenceParameterList)) {
                return;
            }
            PsiReferenceParameterList typeArgumentList = (PsiReferenceParameterList)element;
            try {
                PsiMethodCallExpression expr = (PsiMethodCallExpression)JavaPsiFacade.getInstance(project).getElementFactory().createExpressionFromText("foo()", null);
                typeArgumentList.replace(expr.getTypeArgumentList());
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantTypeArgsInspection$MyQuickFixAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

