/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.TracingData;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
extends FileBasedIndexExtension<Integer, TIntArrayList>
implements PsiDependentIndex {
    static boolean ourEnabled = SystemProperties.getBooleanProperty("idea.enable.duplicates.online.calculation", true);
    static final boolean ourEnabledLightProfiles = true;
    private static boolean ourEnabledOldProfiles = false;
    @NonNls
    public static final ID<Integer, TIntArrayList> NAME = ID.create("DuplicatesIndex");
    private static final int myBaseVersion = 25;
    private final FileBasedIndex.InputFilter myInputFilter = file -> {
        if (!ourEnabled || !file.isInLocalFileSystem()) {
            return false;
        }
        DuplicatesProfile duplicatesProfile = DuplicatesIndex.findDuplicatesProfile(file.getFileType());
        if (duplicatesProfile instanceof LightDuplicateProfile) {
            return ((LightDuplicateProfile)((Object)duplicatesProfile)).acceptsFile(file);
        }
        return duplicatesProfile != null;
    };
    private final DataExternalizer<TIntArrayList> myValueExternalizer = new DataExternalizer<TIntArrayList>(){

        @Override
        public void save(@NotNull DataOutput out, TIntArrayList list) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            if (list.size() == 2) {
                DataInputOutputUtil.writeINT(out, list.getQuick(0));
                DataInputOutputUtil.writeINT(out, list.getQuick(1));
            } else {
                DataInputOutputUtil.writeINT(out, -list.size());
                int prev = 0;
                int len = list.size();
                for (int i = 0; i < len; i += 2) {
                    int value = list.getQuick(i);
                    DataInputOutputUtil.writeINT(out, value - prev);
                    prev = value;
                    DataInputOutputUtil.writeINT(out, list.getQuick(i + 1));
                }
            }
        }

        @Override
        public TIntArrayList read(@NotNull DataInput in) throws IOException {
            int capacityOrValue;
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((capacityOrValue = DataInputOutputUtil.readINT(in)) >= 0) {
                TIntArrayList list = new TIntArrayList(2);
                list.add(capacityOrValue);
                list.add(DataInputOutputUtil.readINT(in));
                return list;
            }
            TIntArrayList list = new TIntArrayList(capacityOrValue);
            int prev = 0;
            for (capacityOrValue = -capacityOrValue; capacityOrValue > 0; capacityOrValue -= 2) {
                int value = DataInputOutputUtil.readINT(in) + prev;
                list.add(value);
                prev = value;
                list.add(DataInputOutputUtil.readINT(in));
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final DataIndexer<Integer, TIntArrayList, FileContent> myIndexer = new DataIndexer<Integer, TIntArrayList, FileContent>(){

        @Override
        @NotNull
        public Map<Integer, TIntArrayList> map(@NotNull FileContent inputData) {
            FileContentImpl fileContent;
            FileType type;
            DuplicatesProfile profile2;
            block9: {
                THashMap tHashMap;
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((profile2 = DuplicatesIndex.findDuplicatesProfile(type = inputData.getFileType())) == null || !profile2.acceptsContentForIndexing(inputData)) {
                    Map<Integer, TIntArrayList> map = Collections.emptyMap();
                    if (map == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                try {
                    fileContent = (FileContentImpl)inputData;
                    if (!(profile2 instanceof LightDuplicateProfile)) break block9;
                    final THashMap result2 = new THashMap();
                    LighterAST ast = fileContent.getLighterASTForPsiDependentIndex();
                    ((LightDuplicateProfile)((Object)profile2)).process(ast, new LightDuplicateProfile.Callback(){

                        @Override
                        public void process(int hash, int hash2, @NotNull LighterAST ast, LighterASTNode ... nodes) {
                            TIntArrayList list;
                            if (ast == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (nodes == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if ((list = (TIntArrayList)result2.get((Object)hash)) == null) {
                                list = new TIntArrayList(2);
                                result2.put((Object)hash, (Object)list);
                            }
                            list.add(nodes[0].getStartOffset());
                            list.add(hash2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "ast";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "nodes";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/dupLocator/index/DuplicatesIndex$2$1";
                            objectArray[2] = "process";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    tHashMap = result2;
                }
                catch (StackOverflowError ae) {
                    Map<Integer, TIntArrayList> map = Collections.emptyMap();
                    if (map == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return map;
                }
                if (tHashMap == null) {
                    2.$$$reportNull$$$0(2);
                }
                return tHashMap;
            }
            MyFragmentsCollector collector = new MyFragmentsCollector(profile2, ((LanguageFileType)type).getLanguage());
            DuplocateVisitor visitor = profile2.createVisitor(collector, true);
            visitor.visitNode(fileContent.getPsiFileForPsiDependentIndex());
            THashMap<Integer, TIntArrayList> tHashMap = collector.getMap();
            if (tHashMap == null) {
                2.$$$reportNull$$$0(3);
            }
            return tHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/index/DuplicatesIndex$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesIndex$2";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final TracingData myTracingData = null;

    @Nullable
    public static DuplicatesProfile findDuplicatesProfile(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        DuplicatesProfile profile2 = DuplicatesProfile.findProfileForLanguage(language);
        return profile2 != null && (ourEnabledOldProfiles && profile2.supportDuplicatesIndex() || profile2 instanceof LightDuplicateProfile) ? profile2 : null;
    }

    @Override
    public int getVersion() {
        return 25 + (ourEnabled ? 255 : 0) + 128 + (ourEnabledOldProfiles ? 33 : 0);
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    @NotNull
    public ID<Integer, TIntArrayList> getName() {
        ID<Integer, TIntArrayList> iD = NAME;
        if (iD == null) {
            DuplicatesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<Integer, TIntArrayList, FileContent> getIndexer() {
        DataIndexer<Integer, TIntArrayList, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            DuplicatesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        DataExternalizer<TIntArrayList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            DuplicatesIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            DuplicatesIndex.$$$reportNull$$$0(3);
        }
        return enumeratorIntegerDescriptor;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            DuplicatesIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    static boolean isIndexedFragment(@Nullable PsiFragment frag, int cost, DuplicatesProfile profile2, DuplocatorState duplocatorState) {
        if (frag == null) {
            return false;
        }
        return profile2.shouldPutInIndex(frag, cost, duplocatorState);
    }

    public static boolean setEnabled(boolean value) {
        boolean old = ourEnabled;
        ourEnabled = value;
        return old;
    }

    public static boolean setEnabledOldProfiles(boolean value) {
        boolean old = ourEnabledOldProfiles;
        ourEnabledOldProfiles = value;
        return old;
    }

    @Override
    public boolean hasSnapshotMapping() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/dupLocator/index/DuplicatesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyFragmentsCollector
    implements FragmentsCollector {
        private final THashMap<Integer, TIntArrayList> myMap = new THashMap();
        private final DuplicatesProfile myProfile;
        private final DuplocatorState myDuplocatorState;

        public MyFragmentsCollector(DuplicatesProfile profile2, Language language) {
            this.myProfile = profile2;
            this.myDuplocatorState = profile2.getDuplocatorState(language);
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            TIntArrayList list;
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, this.myProfile, this.myDuplocatorState)) {
                return;
            }
            if (myTracingData != null) {
                myTracingData.record(hash, cost, frag);
            }
            if ((list = (TIntArrayList)this.myMap.get((Object)hash)) == null) {
                list = new TIntArrayList();
                this.myMap.put((Object)hash, (Object)list);
            }
            list.add(frag.getStartOffset());
            list.add(0);
        }

        public THashMap<Integer, TIntArrayList> getMap() {
            return this.myMap;
        }
    }
}

