/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginBean;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginHelpSet;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginDescriptor");
    private final File myPath;
    private final boolean myBundled;
    private final NullableLazyValue<String> myDescription;
    private String myName;
    private PluginId myId;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String url;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private Map<PluginId, List<String>> myOptionalConfigs;
    private Map<PluginId, List<IdeaPluginDescriptorImpl>> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionElements;
    private ComponentConfig[] myAppComponents;
    private ComponentConfig[] myProjectComponents;
    private ComponentConfig[] myModuleComponents;
    private boolean myDeleted;
    private ClassLoader myLoader;
    private HelpSetPath[] myHelpSets;
    @Nullable
    private MultiMap<String, Pair<String, Element>> myExtensions;
    @Nullable
    private MultiMap<String, Element> myExtensionsPoints;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myEnabled;
    private String mySinceBuild;
    private String myUntilBuild;
    private Boolean mySkipped;
    private List<String> myModules;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath, boolean bundled) {
        if (pluginPath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myDescription = new NullableLazyValue<String>(){

            @Override
            protected String compute() {
                return IdeaPluginDescriptorImpl.this.computeDescription();
            }
        };
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myEnabled = true;
        this.myPath = pluginPath;
        this.myBundled = bundled;
    }

    @Nullable
    private static List<Element> copyChildren(@Nullable Element[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        SmartList<Element> result2 = new SmartList<Element>();
        for (Element extensionsRoot : elements) {
            result2.addAll(extensionsRoot.getChildren());
        }
        return result2;
    }

    @Nullable
    private static List<Pair<String, Element>> copyChildrenAndNs(@Nullable Element[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        SmartList<Pair<String, Element>> result2 = new SmartList<Pair<String, Element>>();
        for (Element extensionsRoot : elements) {
            String ns = extensionsRoot.getAttributeValue("defaultExtensionNs");
            result2.addAll(ContainerUtil.map(extensionsRoot.getChildren(), e -> Pair.create(ns, e)));
        }
        return result2;
    }

    private static String createDescriptionKey(PluginId id) {
        return "plugin." + id + ".description";
    }

    private static ComponentConfig[] mergeComponents(ComponentConfig[] first, ComponentConfig[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return ArrayUtil.mergeArrays(first, second);
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public void setPath(File path) {
    }

    public void readExternal(@NotNull Document document, @NotNull URL url, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException {
        Application application;
        if (document == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(3);
        }
        this.readExternal(document, url, (application = ApplicationManager.getApplication()) != null && application.isUnitTestMode(), pathResolver);
    }

    public void readExternal(@NotNull Document document, @NotNull URL url, boolean ignoreMissingInclude, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException {
        if (document == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(4);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(6);
        }
        document = JDOMXIncluder.resolve(document, url.toExternalForm(), ignoreMissingInclude, pathResolver);
        Element rootElement = document.getRootElement();
        Element newElement = JDOMUtil.internElement(rootElement);
        this.readExternal(newElement);
    }

    public void readExternal(@NotNull URL url) throws InvalidDataException, FileNotFoundException {
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(7);
        }
        try {
            Document document = JDOMUtil.loadDocument(url);
            this.readExternal(document, url, JDOMXIncluder.DEFAULT_PATH_RESOLVER);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException | JDOMException e) {
            throw new InvalidDataException(e);
        }
    }

    protected void readExternal(@NotNull Element element) {
        List<Element> extensionPoints;
        List<Pair<String, Element>> extensions;
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(8);
        }
        PluginBean pluginBean = XmlSerializer.deserialize(element, PluginBean.class);
        this.url = pluginBean.url;
        this.myName = pluginBean.name;
        String idString = pluginBean.id;
        if (idString == null || idString.isEmpty()) {
            idString = this.myName;
        }
        this.myId = idString == null ? null : PluginId.getId(idString);
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        this.myAllowBundledUpdate = pluginBean.allowBundledUpdate;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(pluginBean.ideaVersion.untilBuild);
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        if (this.myVersion == null) {
            this.myVersion = PluginManagerCore.getBuildNumber().asStringWithoutProductCode();
        }
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> optionalDependentPlugins = new LinkedHashSet<PluginId>();
        if (pluginBean.dependencies != null) {
            this.myOptionalConfigs = new THashMap();
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text2 = dependency.pluginId;
                if (StringUtil.isEmpty(text2)) continue;
                PluginId id = PluginId.getId(text2);
                dependentPlugins.add(id);
                if (!dependency.optional) continue;
                optionalDependentPlugins.add(id);
                if (StringUtil.isEmpty(dependency.configFile)) continue;
                this.myOptionalConfigs.computeIfAbsent(id, it -> new SmartList()).add(dependency.configFile);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(PluginId.EMPTY_ARRAY);
        PluginId[] pluginIdArray = this.myOptionalDependencies = optionalDependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : optionalDependentPlugins.toArray(PluginId.EMPTY_ARRAY);
        if (pluginBean.helpSets == null || pluginBean.helpSets.length == 0) {
            this.myHelpSets = HelpSetPath.EMPTY;
        } else {
            this.myHelpSets = new HelpSetPath[pluginBean.helpSets.length];
            for (PluginHelpSet pluginHelpSet : pluginBean.helpSets) {
                this.myHelpSets[i] = new HelpSetPath(pluginHelpSet.file, pluginHelpSet.path);
            }
        }
        this.myAppComponents = pluginBean.applicationComponents;
        this.myProjectComponents = pluginBean.projectComponents;
        this.myModuleComponents = pluginBean.moduleComponents;
        if (this.myAppComponents == null) {
            this.myAppComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myProjectComponents == null) {
            this.myProjectComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myModuleComponents == null) {
            this.myModuleComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if ((extensions = IdeaPluginDescriptorImpl.copyChildrenAndNs(pluginBean.extensions)) != null) {
            this.myExtensions = MultiMap.createSmart();
            for (Pair<String, Element> pair : extensions) {
                String ns = (String)pair.first;
                Element extension = (Element)pair.second;
                this.myExtensions.putValue(ExtensionsAreaImpl.extractEPName(extension, ns), Pair.create(ns, extension));
            }
        }
        if ((extensionPoints = IdeaPluginDescriptorImpl.copyChildren(pluginBean.extensionPoints)) != null) {
            this.myExtensionsPoints = MultiMap.createSmart();
            for (Element extensionPoint : extensionPoints) {
                this.myExtensionsPoints.putValue(StringUtil.notNullize(extensionPoint.getAttributeValue("area")), extensionPoint);
            }
        }
        this.myActionElements = IdeaPluginDescriptorImpl.copyChildren(pluginBean.actions);
        if (pluginBean.modules != null && !pluginBean.modules.isEmpty()) {
            this.myModules = pluginBean.modules;
        }
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build) {
        if (build == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build);
        if (matcher.matches()) {
            return matcher.group(1) + ".*";
        }
        return build;
    }

    public void registerExtensionPoints(@NotNull ExtensionsArea area) {
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(9);
        }
        if (this.myExtensionsPoints != null) {
            for (Element element : this.myExtensionsPoints.get(StringUtil.notNullize(area.getAreaClass()))) {
                area.registerExtensionPoint(this, element);
            }
        }
    }

    public void registerExtensions(@NotNull ExtensionsArea area, @NotNull String epName) {
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(10);
        }
        if (epName == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(11);
        }
        if (this.myExtensions != null) {
            for (Pair<String, Element> pair : this.myExtensions.get(epName)) {
                Element element = (Element)pair.second;
                String ns = (String)pair.first;
                area.registerExtension(this, element, ns);
            }
        }
    }

    @Override
    public String getDescription() {
        return this.myDescription.getValue();
    }

    @Override
    public String getChangeNotes() {
        return this.myChangeNotes;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(12);
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(13);
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVendor() {
        return this.myVendor;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getResourceBundleBaseName() {
        return this.myResourceBundleBaseName;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    public void setCategory(String category) {
        this.myCategory = category;
    }

    @Nullable
    public MultiMap<String, Element> getExtensionsPoints() {
        return this.myExtensionsPoints;
    }

    @Nullable
    public MultiMap<String, Element> getExtensions() {
        if (this.myExtensions == null) {
            return null;
        }
        MultiMap<String, Element> result2 = MultiMap.create();
        for (Map.Entry<String, Collection<Pair<String, Element>>> entry : this.myExtensions.entrySet()) {
            result2.put(entry.getKey(), ContainerUtil.map(entry.getValue(), p -> (Element)p.second));
        }
        return result2;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files;
            ArrayList<File> result2 = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result2.add(classesDir);
            }
            if ((files = new File(this.myPath, "lib").listFiles()) != null && files.length > 0) {
                for (File f : files) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                        result2.add(f);
                        continue;
                    }
                    result2.add(f);
                }
            }
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        List<File> list = Collections.singletonList(this.myPath);
        if (list == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @Nullable
    public List<Element> getActionsDescriptionElements() {
        return this.myActionElements;
    }

    @Override
    @NotNull
    public ComponentConfig[] getAppComponents() {
        if (this.myAppComponents == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(16);
        }
        return this.myAppComponents;
    }

    @Override
    @NotNull
    public ComponentConfig[] getProjectComponents() {
        if (this.myProjectComponents == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(17);
        }
        return this.myProjectComponents;
    }

    @Override
    @NotNull
    public ComponentConfig[] getModuleComponents() {
        if (this.myModuleComponents == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(18);
        }
        return this.myModuleComponents;
    }

    @Override
    public String getVendorEmail() {
        return this.myVendorEmail;
    }

    @Override
    public String getVendorUrl() {
        return this.myVendorUrl;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String val) {
        this.url = val;
    }

    public String toString() {
        return "PluginDescriptor[name='" + this.myName + "', classpath='" + this.myPath + "']";
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.myDeleted = deleted;
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeaPluginDescriptorImpl)) {
            return false;
        }
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)o;
        return this.myName == null ? pluginDescriptor.myName == null : this.myName.equals(pluginDescriptor.myName);
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    @Override
    @NotNull
    public HelpSetPath[] getHelpSets() {
        if (this.myHelpSets == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(19);
        }
        return this.myHelpSets;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public String getDownloads() {
        return null;
    }

    public long getDate() {
        return 0L;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public String getVendorLogoPath() {
        return this.myVendorLogoPath;
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    public boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    public void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault(bundle, IdeaPluginDescriptorImpl.createDescriptionKey(this.myId), this.myDescriptionChildText == null ? "" : this.myDescriptionChildText, new Object[0]);
    }

    public void insertDependency(@NotNull IdeaPluginDescriptor d) {
        if (d == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(20);
        }
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, List<String>> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    Map<PluginId, List<IdeaPluginDescriptorImpl>> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(@NotNull Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors) {
        if (optionalDescriptors == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(21);
        }
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(IdeaPluginDescriptorImpl descriptor) {
        if (this.myExtensions == null) {
            this.myExtensions = descriptor.myExtensions;
        } else if (descriptor.myExtensions != null) {
            this.myExtensions.putAllValues(descriptor.myExtensions);
        }
        if (this.myExtensionsPoints == null) {
            this.myExtensionsPoints = descriptor.myExtensionsPoints;
        } else if (descriptor.myExtensionsPoints != null) {
            this.myExtensionsPoints.putAllValues(descriptor.myExtensionsPoints);
        }
        if (this.myActionElements == null) {
            this.myActionElements = descriptor.myActionElements;
        } else if (descriptor.myActionElements != null) {
            this.myActionElements.addAll(descriptor.myActionElements);
        }
        this.myAppComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myAppComponents, descriptor.myAppComponents);
        this.myProjectComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myProjectComponents, descriptor.myProjectComponents);
        this.myModuleComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myModuleComponents, descriptor.myModuleComponents);
    }

    public Boolean getSkipped() {
        return this.mySkipped;
    }

    public void setSkipped(Boolean skipped) {
        this.mySkipped = skipped;
    }

    @Override
    public boolean isBundled() {
        return this.myBundled;
    }

    @Override
    public boolean allowBundledUpdate() {
        return this.myAllowBundledUpdate;
    }

    @Nullable
    public List<String> getModules() {
        return this.myModules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPluginIds";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalDependentPluginIds";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppComponents";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectComponents";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleComponents";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "insertDependency";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setOptionalDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

