/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginClassCache;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializationException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerCore {
    private static final Logger LOG = Logger.getInstance(PluginManagerCore.class);
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    public static final String CORE_PLUGIN_ID = "com.intellij";
    private static final String META_INF = "META-INF";
    public static final String PLUGIN_XML = "plugin.xml";
    public static final float PLUGINS_PROGRESS_PART = 0.3f;
    public static final float LOADERS_PROGRESS_PART = 0.35f;
    public static String BUILD_NUMBER;
    private static final TObjectIntHashMap<PluginId> ourId2Index;
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins;
    private static final PluginClassCache ourPluginClasses;
    private static final String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
    private static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    static final String DISABLE = "disable";
    static final String ENABLE = "enable";
    static final String EDIT = "edit";
    private static List<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static IdeaPluginDescriptor[] ourPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    private static List<Runnable> myDisablePluginListeners;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins(null);
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    @NotNull
    public static synchronized IdeaPluginDescriptor[] getPlugins(@Nullable StartupProgress progress) {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(progress);
        }
        if (ourPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return ourPlugins;
    }

    public static synchronized void setPlugins(@NotNull IdeaPluginDescriptor[] descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(2);
        }
        ourPlugins = descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        File file;
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        if ((file = new File(configPath, DISABLED_PLUGINS_FILENAME)).isFile()) {
            List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
            try {
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (requiredPlugins.contains(id = id.trim())) continue;
                        disabledPlugins.add(id);
                    }
                }
                finally {
                    if (!requiredPlugins.isEmpty()) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME));
                        PluginManagerCore.fireEditDisablePlugins();
                    }
                }
            }
            catch (IOException e) {
                LOG.info("Unable to load disabled plugins list from " + file, e);
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        List<String> list = ourDisabledPlugins;
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId pluginId;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        return (pluginId = descriptor.getPluginId()) == null || PluginManagerCore.getBrokenPluginVersions().get(pluginId.getIdString()).contains(descriptor.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt")));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List<String> tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = tokens.get(0);
                        List<String> versions = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues(pluginId, versions);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream(br);
                }
            }
        }
        MultiMap<String, String> multiMap = ourBrokenPluginVersions;
        if (multiMap == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static void addDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManagerCore.$$$reportNull$$$0(8);
        }
        if (myDisablePluginListeners == null) {
            myDisablePluginListeners = new ArrayList<Runnable>();
        }
        myDisablePluginListeners.add(listener);
    }

    public static void removeDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManagerCore.$$$reportNull$$$0(9);
        }
        if (myDisablePluginListeners != null) {
            myDisablePluginListeners.remove(listener);
        }
    }

    private static void fireEditDisablePlugins() {
        if (myDisablePluginListeners != null) {
            for (Runnable listener : myDisablePluginListeners) {
                listener.run();
            }
        }
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append, @NotNull File plugins) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile(plugins);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(plugins, append));){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        Object[] sortedIds = ArrayUtil.toStringArray(ids);
        Arrays.sort(sortedIds);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (Object id : sortedIds) {
            writer.write((String)id);
            writer.write(separator);
        }
    }

    public static boolean disablePlugin(@NotNull String id) {
        List<String> disabledPlugins;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        if ((disabledPlugins = PluginManagerCore.getDisabledPlugins()).contains(id)) {
            return false;
        }
        disabledPlugins.add(id);
        return PluginManagerCore.trySaveDisabledPlugins(disabledPlugins);
    }

    public static boolean enablePlugin(@NotNull String id) {
        List<String> disabledPlugins;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        if (!(disabledPlugins = PluginManagerCore.getDisabledPlugins()).contains(id)) {
            return false;
        }
        disabledPlugins.remove(id);
        return PluginManagerCore.trySaveDisabledPlugins(disabledPlugins);
    }

    private static boolean trySaveDisabledPlugins(@NotNull List<String> disabledPlugins) {
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        try {
            PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
            return true;
        }
        catch (IOException e) {
            LOG.warn("Unable to save disabled plugins list", e);
            return false;
        }
    }

    public static void saveDisabledPlugins(@NotNull Collection<String> ids, boolean append) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        PluginManagerCore.saveDisabledPlugins(PathManager.getConfigPath(), ids, append);
    }

    public static void saveDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> ids, boolean append) throws IOException {
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        File plugins = new File(configPath, DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, append, plugins);
        ourDisabledPlugins = null;
        PluginManagerCore.fireEditDisablePlugins();
    }

    public static int getPluginLoadingOrder(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        return ourId2Index.get((Object)id);
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        if (check == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check, (Set<PluginId>)new THashSet());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check, @NotNull Set<PluginId> processed2) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (check == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (processed2 == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        processed2.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet optionalDependencies = new THashSet(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed2.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check.value(dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = pluginId2Descriptor.fun(dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check, processed2)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        ourPluginClasses.addPluginClass(pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.")) {
            return null;
        }
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (!PluginManagerCore.hasLoadedClass(className, descriptor.getPluginClassLoader())) continue;
            PluginId id = descriptor.getPluginId();
            return CORE_PLUGIN_ID.equals(id.getIdString()) ? null : id;
        }
        return null;
    }

    private static boolean hasLoadedClass(@NotNull String className, ClassLoader loader) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className);
        }
        try {
            return (Boolean)loader.getClass().getMethod("hasLoadedClass", String.class).invoke((Object)loader, className);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void dumpPluginClassStatistics() {
        ourPluginClasses.dumpPluginClassStatistics();
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map, boolean checkModuleDependencies) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        if (on == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        for (PluginId id : descriptor.getDependentPluginIds()) {
            if (ArrayUtil.contains(id, (Object[])descriptor.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId[] dependentPluginIds;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        for (PluginId dependentPluginId : dependentPluginIds = descriptor.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    public static void configureExtensions() {
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        Extensions.registerAreaClass("IDEA_MODULE", "IDEA_PROJECT");
    }

    @NotNull
    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        Method method = ReflectionUtil.getDeclaredMethod(loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass(), "addURL", URL.class);
        if (method == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        return method;
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file.toURI().toURL());
                }
                return loader;
            }
            catch (IOException | IllegalAccessException | InvocationTargetException e) {
                PluginManagerCore.getLogger().warn(e);
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file = aClassPath.getCanonicalFile();
                urls.add(file.toURI().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn(e);
            return null;
        }
    }

    public static void invalidatePlugins() {
        ourPlugins = null;
        ourDisabledPlugins = null;
    }

    public static boolean isPluginClass(@NotNull String className) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        return ourPlugins != null && PluginManagerCore.getPluginByClassName(className) != null;
    }

    private static void logPlugins() {
        ArrayList<String> bundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> custom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : ourPlugins) {
            String version = descriptor.getVersion();
            String s = descriptor.getName() + (version != null ? " (" + version + ")" : "");
            if (!descriptor.isEnabled()) {
                disabled.add(s);
                continue;
            }
            if (SPECIAL_IDEA_PLUGIN.equals(descriptor.getName()) || descriptor.isBundled()) {
                bundled.add(s);
                continue;
            }
            custom.add(s);
        }
        Collections.sort(bundled);
        Collections.sort(custom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(bundled, ", "));
        if (!custom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(custom, ", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, ", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull PluginId[] pluginIds) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        if (pluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if (PluginManagerCore.isUnitTestMode()) {
            ClassLoader[] classLoaderArray = new ClassLoader[]{};
            if (classLoaderArray == null) {
                PluginManagerCore.$$$reportNull$$$0(44);
            }
            return classLoaderArray;
        }
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>(pluginIds.length);
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            loaders.add(loader);
        }
        ClassLoader[] classLoaderArray = loaders.toArray(new ClassLoader[0]);
        if (classLoaderArray == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        return classLoaderArray;
    }

    public static boolean isRunningFromSources() {
        return Holder.ourIsRunningFromSources;
    }

    private static int countPlugins(@NotNull String pluginsPath) {
        String[] list;
        File configuredPluginsDir;
        if (pluginsPath == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        if ((configuredPluginsDir = new File(pluginsPath)).exists() && (list = configuredPluginsDir.list()) != null) {
            return list.length;
        }
        return 0;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (!errors.isEmpty()) {
            String errorMessage = IdeBundle.message("error.problems.found.loading.plugins", new Object[0]) + StringUtil.join(errors, "<p/>");
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && !app.isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManagerCore.getLogger().error(errorMessage);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map) {
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map.put(PluginId.getId(entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull List<String> errors) {
        Graph<PluginId> graph;
        DFSTBuilder<PluginId> builder;
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (!(builder = new DFSTBuilder<PluginId>(graph = PluginManagerCore.createPluginIdGraph(idToDescriptorMap))).isAcyclic()) {
            String cyclePresentation;
            if (ApplicationManager.getApplication().isInternal()) {
                StringBuilder cycles = new StringBuilder();
                for (Collection<PluginId> component : builder.getComponents()) {
                    if (cycles.length() > 0) {
                        cycles.append(';');
                    }
                    for (PluginId id : component) {
                        idToDescriptorMap.get(id).setEnabled(false);
                        cycles.append(id.getIdString()).append(' ');
                    }
                }
                cyclePresentation = cycles.toString();
            } else {
                Couple<PluginId> circularDependency = builder.getCircularDependency();
                PluginId id = (PluginId)circularDependency.getFirst();
                PluginId parentId = (PluginId)circularDependency.getSecond();
                cyclePresentation = id + "->" + parentId + "->...->" + id;
            }
            errors.add(IdeBundle.message("error.plugins.should.not.have.cyclic.dependencies", new Object[0]) + " " + cyclePresentation);
        }
        Comparator<PluginId> idComparator = builder.comparator();
        Comparator comparator = (o1, o2) -> {
            PluginId pluginId1 = o1.getPluginId();
            PluginId pluginId2 = o2.getPluginId();
            if (pluginId1.getIdString().equals(CORE_PLUGIN_ID)) {
                return -1;
            }
            if (pluginId2.getIdString().equals(CORE_PLUGIN_ID)) {
                return 1;
            }
            return idComparator.compare(pluginId1, pluginId2);
        };
        if (comparator == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        return comparator;
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        ids.sort((o1, o2) -> o2.getIdString().compareTo(o1.getIdString()));
        Graph<PluginId> graph = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<PluginId>(){

            @Override
            public Collection<PluginId> getNodes() {
                return ids;
            }

            @Override
            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor.getDependentPluginIds()) {
                    PluginId realPluginId;
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null || !idToDescriptorMap.containsKey(realPluginId = dep.getPluginId())) continue;
                    plugins.add(realPluginId);
                }
                return plugins.iterator();
            }
        }));
        if (graph == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        return graph;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file, @NotNull String pathName, @Nullable File pluginPath, boolean bundled) {
        File descriptorFile;
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        if ((descriptorFile = new File(file, "META-INF/" + pathName)).exists()) {
            try {
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file), bundled);
                descriptor.readExternal(descriptorFile.toURI().toURL());
                return descriptor;
            }
            catch (XmlSerializationException e) {
                PluginManagerCore.getLogger().info("Cannot load " + file, e);
                PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file.getName() + "' contains invalid plugin descriptor."));
            }
            catch (Throwable e) {
                PluginManagerCore.getLogger().info("Cannot load " + file, e);
            }
        }
        return null;
    }

    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file, @NotNull String pathName, boolean bundled) {
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        try (LoadingContext context = new LoadingContext();){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptorFromJar(file, pathName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context, null, bundled);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file, @NotNull String fileName, @NotNull JDOMXIncluder.PathResolver pathResolver, @NotNull LoadingContext context, @Nullable File pluginPath, boolean bundled) {
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        try {
            ZipEntry entry;
            URL jarURL = URLUtil.getJarEntryURL(file, FileUtil.toCanonicalPath("META-INF/" + fileName, '/'));
            ZipFile zipFile = (ZipFile)context.myOpenedFiles.get(file);
            if (zipFile == null) {
                zipFile = new ZipFile(file);
                context.myOpenedFiles.put(file, zipFile);
            }
            if ((entry = zipFile.getEntry("META-INF/" + fileName)) != null) {
                Document document = JDOMUtil.loadDocument(zipFile.getInputStream(entry));
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file), bundled);
                descriptor.readExternal(document, jarURL, pathResolver);
                context.myLastZipFileContainingDescriptor = file;
                return descriptor;
            }
        }
        catch (XmlSerializationException e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file.getName() + "' contains invalid plugin descriptor."));
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + file, e);
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file, @NotNull String fileName) {
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        return PluginManagerCore.loadDescriptor(file, fileName, false);
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file, @NotNull String fileName, boolean bundled) {
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        try (LoadingContext context = new LoadingContext();){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptor(file, fileName, context, bundled);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file, @NotNull String pathName, @NotNull LoadingContext context, boolean bundled) {
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        IdeaPluginDescriptorImpl descriptor = null;
        boolean directory = file.isDirectory();
        if (directory) {
            descriptor = PluginManagerCore.loadDescriptorFromDir(file, pathName, null, bundled);
            if (descriptor == null) {
                File libDir = new File(file, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files = libDir.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                PluginManagerCore.putMoreLikelyPluginJarsFirst(file, files);
                PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(files);
                for (File f : files) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (FileUtil.isJarOrZip(f)) {
                        descriptor = PluginManagerCore.loadDescriptorFromJar(f, pathName, pathResolver, context, file, bundled);
                        if (descriptor == null) continue;
                        break;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, pathName, file, bundled)) == null) continue;
                    if (descriptor != null) {
                        PluginManagerCore.getLogger().info("Cannot load " + file + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor = descriptor1;
                }
            }
        } else if (StringUtil.endsWithIgnoreCase(file.getName(), ".jar") && file.isFile()) {
            descriptor = PluginManagerCore.loadDescriptorFromJar(file, pathName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context, null, bundled);
        }
        if (descriptor != null) {
            PluginManagerCore.resolveOptionalDescriptors(pathName, descriptor, optPathName -> {
                URL resource;
                if (context == null) {
                    PluginManagerCore.$$$reportNull$$$0(120);
                }
                if (file == null) {
                    PluginManagerCore.$$$reportNull$$$0(121);
                }
                IdeaPluginDescriptorImpl optionalDescriptor = null;
                if (context.myLastZipFileContainingDescriptor != null) {
                    optionalDescriptor = PluginManagerCore.loadDescriptor(context.myLastZipFileContainingDescriptor, optPathName, context, bundled);
                }
                if (optionalDescriptor == null) {
                    optionalDescriptor = PluginManagerCore.loadDescriptor(file, optPathName, context, bundled);
                }
                if (optionalDescriptor == null && (directory || PluginManagerCore.resolveDescriptorsInResources()) && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optPathName)) != null) {
                    optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource, optPathName, bundled);
                }
                return optionalDescriptor;
            });
        }
        return descriptor;
    }

    private static boolean resolveDescriptorsInResources() {
        return System.getProperty("resolve.descriptors.in.resources") != null;
    }

    private static void putMoreLikelyPluginJarsFirst(File pluginDir, File[] filesInLibUnderPluginDir) {
        String pluginDirName = pluginDir.getName();
        Arrays.sort(filesInLibUnderPluginDir, (o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getName();
            String o1Name = o1.getName();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase(o2Name, pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase(o1Name, pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(String name) {
        int i = name.lastIndexOf(45);
        if (i == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            if ((c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2))) {
                return true;
            }
        }
        return false;
    }

    public static void resolveOptionalDescriptors(@NotNull String fileName, @NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Function<String, IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        Map<PluginId, List<String>> optionalConfigs;
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        if (optionalDescriptorLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        if ((optionalConfigs = descriptor.getOptionalConfigs()) != null && !optionalConfigs.isEmpty()) {
            THashMap descriptors = new THashMap(optionalConfigs.size());
            for (Map.Entry<PluginId, List<String>> entry : optionalConfigs.entrySet()) {
                for (String optionalDescriptorName : entry.getValue()) {
                    if (fileName.equals(optionalDescriptorName)) {
                        PluginManagerCore.getLogger().info("recursive dependency (" + fileName + ") in " + descriptor);
                        continue;
                    }
                    IdeaPluginDescriptorImpl optionalDescriptor = optionalDescriptorLoader.fun(optionalDescriptorName);
                    if (optionalDescriptor == null) {
                        PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
                        continue;
                    }
                    descriptors.computeIfAbsent(entry.getKey(), it -> new SmartList()).add(optionalDescriptor);
                }
            }
            descriptor.setOptionalDescriptors((Map<PluginId, List<IdeaPluginDescriptorImpl>>)descriptors);
        }
    }

    private static void loadDescriptors(@NotNull File pluginsHome, @NotNull List<IdeaPluginDescriptorImpl> result2, @Nullable StartupProgress progress, int pluginsCount, boolean bundled) {
        File[] files;
        if (pluginsHome == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if ((files = pluginsHome.listFiles()) != null) {
            int i = result2.size();
            HashSet<IdeaPluginDescriptorImpl> existingResults = ContainerUtil.newHashSet(result2);
            for (File file : files) {
                int oldIndex;
                IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file, PLUGIN_XML, bundled);
                if (descriptor == null) continue;
                if (descriptor.getName() == null) {
                    PluginManagerCore.getLogger().warn("Skipped plugin without name: " + descriptor);
                    continue;
                }
                if (progress != null) {
                    progress.showProgress(descriptor.getName(), 0.3f * ((float)(++i) / (float)pluginsCount));
                }
                int n = oldIndex = !existingResults.add(descriptor) ? result2.indexOf(descriptor) : -1;
                if (oldIndex >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result2.get(oldIndex);
                    if (StringUtil.compareVersionNumbers(oldDescriptor.getVersion(), descriptor.getVersion()) >= 0) continue;
                    result2.set(oldIndex, descriptor);
                    continue;
                }
                result2.add(descriptor);
            }
        }
    }

    private static void filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptor> result2, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        THashMap idToDescriptorMap = new THashMap();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it = result2.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor = it.next();
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                errors.add(IdeBundle.message("message.duplicate.plugin.id", new Object[0]) + id);
                it.remove();
                continue;
            }
            if (!descriptor.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor);
        }
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)idToDescriptorMap);
        SmartList<String> disabledPluginIds = new SmartList<String>();
        LinkedHashSet faultyDescriptors = new LinkedHashSet();
        Iterator<? extends IdeaPluginDescriptor> it2 = result2.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, ((Map)idToDescriptorMap)::get, arg_0 -> PluginManagerCore.lambda$filterBadPlugins$5((Map)idToDescriptorMap, pluginDescriptor, faultyDescriptors, disabledPluginIds, disabledPluginNames, errors, it2, arg_0));
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            String error = "<br><a href=\"disable\">Disable ";
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)disabledPluginIds.iterator().next());
                error = error + (idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                error = error + "not loaded plugins";
            }
            errors.add(error + "</a>");
            boolean possibleToEnable = true;
            for (String descriptor : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                String name = faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins";
                errors.add("<a href=\"enable\">Enable " + name + "</a>");
            }
            errors.add("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            errors.add(IdeBundle.message("error.plugins.without.id.found", new Object[0]));
        }
    }

    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        List<IdeaPluginDescriptorImpl> descriptors = ContainerUtil.newSmartList();
        PluginManagerCore.loadDescriptorsFromClassPath(descriptors, loader, null);
        return descriptors;
    }

    private static void loadDescriptorsFromClassPath(List<IdeaPluginDescriptorImpl> result2, ClassLoader loader, StartupProgress progress) {
        LinkedHashMap<URL, String> urls = ContainerUtil.newLinkedHashMap();
        String platformPrefix = System.getProperty("idea.platform.prefix");
        if (platformPrefix != null) {
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource("META-INF/" + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
            }
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), PLUGIN_XML);
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info(e);
            return;
        }
        HashSet<IdeaPluginDescriptorImpl> existingResults = ContainerUtil.newHashSet(result2);
        int i = 0;
        for (URL url : urls.keySet()) {
            IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptorFromResource(url, (String)urls.get(url), true);
            if (descriptor == null || !existingResults.add(descriptor)) continue;
            descriptor.setUseCoreClassLoader(true);
            result2.add(descriptor);
            if (progress == null || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) continue;
            progress.showProgress("Plugin loaded: " + descriptor.getName(), 0.3f * (float)(++i) / (float)urls.size());
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName, boolean bundled) {
        if (resource == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                String pathname = StringUtil.trimEnd(FileUtil.toSystemIndependentName(descriptorFile.getPath()), pathName);
                File pluginDir = new File(pathname).getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, pathName, bundled);
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path.substring(0, path.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, pathName, bundled);
            }
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace(str, " ", "%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<IdeaPluginDescriptorImpl> result2) {
        String pathProperty;
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if ((pathProperty = System.getProperty(PROPERTY_PLUGIN_PATH)) == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), PLUGIN_XML, false);
            if (ideaPluginDescriptor == null) continue;
            result2.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress, @NotNull List<String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            if (IdeaPluginDescriptorImpl.EMPTY_ARRAY == null) {
                PluginManagerCore.$$$reportNull$$$0(82);
            }
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        int pluginsCount = PluginManagerCore.countPlugins(PathManager.getPluginsPath()) + PluginManagerCore.countPlugins(PathManager.getPreInstalledPluginsPath());
        PluginManagerCore.loadDescriptors(new File(PathManager.getPluginsPath()), result2, progress, pluginsCount, false);
        Application application = ApplicationManager.getApplication();
        boolean fromSources = false;
        if (application == null || !application.isUnitTestMode()) {
            int size = result2.size();
            PluginManagerCore.loadDescriptors(new File(PathManager.getPreInstalledPluginsPath()), result2, progress, pluginsCount, true);
            fromSources = size == result2.size();
        }
        PluginManagerCore.loadDescriptorsFromProperty(result2);
        PluginManagerCore.loadDescriptorsFromClassPath(result2, PluginManagerCore.class.getClassLoader(), fromSources ? progress : null);
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = PluginManagerCore.topoSortPlugins(result2, errors);
        if (ideaPluginDescriptorImplArray == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        return ideaPluginDescriptorImplArray;
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] topoSortPlugins(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        IdeaPluginDescriptorImpl[] pluginDescriptors = result2.toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        THashMap idToDescriptorMap = new THashMap();
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                LOG.error("null 'id': " + descriptor);
            }
            idToDescriptorMap.put(id, descriptor);
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, errors));
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        THashMap descriptorsWithModules = new THashMap(descriptors);
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor : descriptors.values()) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors = descriptor.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                for (IdeaPluginDescriptorImpl optionalDescriptor : entry.getValue()) {
                    descriptor.mergeOptionalConfig(optionalDescriptor);
                }
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor) {
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        List<File> classPath = descriptor.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[0]), new ClassLoader[]{parentLoader}, descriptor);
        descriptor.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    @Nullable
    private static String detectReasonToNotLoad(@NotNull IdeaPluginDescriptor descriptor, @NotNull IdeaPluginDescriptor[] loaded) {
        String reasonToNotLoad;
        boolean checkModuleDependencies;
        String idString;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        if (loaded == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (CORE_PLUGIN_ID.equals(idString = descriptor.getPluginId().getIdString())) {
            return null;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor instanceof IdeaPluginDescriptorImpl && !descriptor.isEnabled()) {
                return "Plugin is not enabled";
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return "Plugins should not be loaded";
            }
        }
        List<String> pluginIds = pluginId == null ? null : StringUtil.split(pluginId, ",");
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor)) {
            return "Plugin does not include any module dependency tags in its plugin.xml therefore is assumed legacy and can be loaded only in IntelliJ IDEA";
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            reasonToNotLoad = loadPluginCategory.equals(descriptor.getCategory()) ? null : "Plugin category doesn't match 'idea.load.plugins.category' value";
        } else {
            if (pluginIds != null) {
                String string = reasonToNotLoad = pluginIds.contains(idString) ? null : "'idea.load.plugins.id' doesn't contain this plugin id";
                if (reasonToNotLoad != null) {
                    THashMap map = new THashMap();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)map);
                    for (String id : pluginIds) {
                        IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map.get(PluginId.getId(id));
                        if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor.getPluginId(), (Map<PluginId, IdeaPluginDescriptor>)map, checkModuleDependencies)) continue;
                        reasonToNotLoad = null;
                        break;
                    }
                }
            } else {
                String string = reasonToNotLoad = PluginManagerCore.getDisabledPlugins().contains(idString) ? "Plugin is disabled" : null;
            }
            if (reasonToNotLoad == null && descriptor instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor)) {
                return "Plugin since-build or until-build don't match this product's build number";
            }
        }
        return reasonToNotLoad;
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        return !PluginManagerCore.isIncompatible(descriptor);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        return !PluginManagerCore.isIncompatible(descriptor, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        return PluginManagerCore.isIncompatible(descriptor, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            return PluginManagerCore.isIncompatible(buildNumber, descriptor.getSinceBuild(), descriptor.getUntilBuild(), descriptor.getName(), descriptor.toString());
        }
        catch (RuntimeException e) {
            LOG.error(e);
            return false;
        }
    }

    static boolean isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild, @Nullable String descriptorName, @Nullable String descriptorDebugString) {
        BuildNumber untilBuildNumber;
        BuildNumber sinceBuildNumber;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        JBIterable<String> messages = JBIterable.empty();
        BuildNumber buildNumber2 = sinceBuildNumber = StringUtil.isEmpty(sinceBuild) ? null : BuildNumber.fromString(sinceBuild, descriptorName, null);
        if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
            messages = messages.append("since build " + sinceBuildNumber + " > " + buildNumber);
        }
        BuildNumber buildNumber3 = untilBuildNumber = StringUtil.isEmpty(untilBuild) ? null : BuildNumber.fromString(untilBuild, descriptorName, null);
        if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
            messages = messages.append("until build " + untilBuildNumber + " < " + buildNumber);
        }
        if (messages.isNotEmpty()) {
            LOG.warn(ObjectUtils.coalesce(descriptorName, descriptorDebugString) + " not loaded: " + StringUtil.join(messages, ", "));
            return true;
        }
        return false;
    }

    public static boolean shouldSkipPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        if (descriptor instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)descriptor;
            Boolean skipped = descriptorImpl.getSkipped();
            if (skipped != null) {
                return skipped;
            }
            boolean result2 = PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
            descriptorImpl.setSkipped(result2);
            return result2;
        }
        return PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
    }

    private static void checkEssentialPluginsAreAvailable(IdeaPluginDescriptorImpl[] plugins) {
        Set<String> availableIds = ContainerUtil.map2Set(plugins, plugin -> plugin.getPluginId().getIdString());
        List<String> ids = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        Set<String> missing = JBIterable.from(ids).filter(id -> !availableIds.contains(id)).toSet();
        if (!missing.isEmpty()) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    private static void initializePlugins(@Nullable StartupProgress progress) {
        int i;
        PluginManagerCore.configureExtensions();
        ArrayList<String> errors = ContainerUtil.newArrayList();
        IdeaPluginDescriptorImpl[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress, errors);
        PluginManagerCore.checkEssentialPluginsAreAvailable(pluginDescriptors);
        Class callerClass = ReflectionUtil.findCallerClass(1);
        assert (callerClass != null);
        ClassLoader parentLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap idToDescriptorMap = new THashMap();
        THashMap disabledPluginNames = new THashMap();
        SmartList<String> brokenPluginsList = new SmartList<String>();
        PluginManagerCore.fixDescriptors(pluginDescriptors, parentLoader, (Map<PluginId, IdeaPluginDescriptorImpl>)idToDescriptorMap, (Map<String, String>)disabledPluginNames, brokenPluginsList, result2, errors);
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph);
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors);
        Comparator<PluginId> idComparator = builder.comparator();
        result2.sort((o1, o2) -> idComparator.compare(o1.getPluginId(), o2.getPluginId()));
        for (i = 0; i < result2.size(); ++i) {
            ourId2Index.put((Object)((IdeaPluginDescriptorImpl)result2.get(i)).getPluginId(), i);
        }
        i = 0;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result2) {
            if (pluginDescriptor.getPluginId().getIdString().equals(CORE_PLUGIN_ID) || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(parentLoader);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = pluginDescriptor.getClassPath();
                PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[0]), classLoaderArray, pluginDescriptor);
                pluginDescriptor.setLoader(pluginClassLoader);
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)i++ / (float)result2.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result2);
        Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension(new AreaListener(){

            @Override
            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (areaInstance == null) {
                    2.$$$reportNull$$$0(1);
                }
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea(areaInstance), result2);
            }

            @Override
            public void areaDisposing(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (areaInstance == null) {
                    2.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "areaClass";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "areaInstance";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaCreated";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaDisposing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ourPlugins = pluginDescriptors;
    }

    public static void fixDescriptors(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<String> errors) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        PluginManagerCore.checkCanLoadPlugins(pluginDescriptors, parentLoader, disabledPluginNames, brokenPluginsList, result2);
        PluginManagerCore.filterBadPlugins(result2, disabledPluginNames, errors);
        if (!brokenPluginsList.isEmpty()) {
            errors.add("The following plugins are incompatible with the current IDE build: " + StringUtil.join(brokenPluginsList, ", "));
        }
        PluginManagerCore.fixDependencies(result2, idToDescriptorMap);
    }

    private static void checkCanLoadPlugins(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            String toNotLoadReason = PluginManagerCore.detectReasonToNotLoad(descriptor, pluginDescriptors);
            if (toNotLoadReason == null && PluginManagerCore.isBrokenPlugin(descriptor)) {
                brokenPluginsList.add(descriptor.getName());
                toNotLoadReason = "This plugin version was marked as incompatible";
            }
            if (toNotLoadReason == null) {
                List<String> modules = descriptor.getModules();
                if (modules != null) {
                    for (String module : modules) {
                        if (ourModulesToContainingPlugins.containsKey(module)) continue;
                        ourModulesToContainingPlugins.put(module, descriptor);
                    }
                }
                result2.add(descriptor);
                continue;
            }
            descriptor.setEnabled(false);
            PluginManagerCore.getLogger().info(String.format("Plugin '%s' can't be loaded because: %s", descriptor.getName(), toNotLoadReason));
            disabledPluginNames.put(descriptor.getPluginId().getIdString(), descriptor.getName());
            PluginManagerCore.initClassLoader(parentLoader, descriptor);
        }
    }

    private static void fixDependencies(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        for (IdeaPluginDescriptorImpl descriptor : result2) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        IdeaPluginDescriptor corePluginDescriptor = idToDescriptorMap.get(PluginId.getId(CORE_PLUGIN_ID));
        assert (corePluginDescriptor != null) : "com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl descriptor : result2) {
            if (descriptor == corePluginDescriptor) continue;
            descriptor.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsArea area, @NotNull List<IdeaPluginDescriptorImpl> loadedPlugins) {
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (loadedPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            descriptor.registerExtensionPoints(area);
        }
        ExtensionPoint[] extensionPoints = area.getExtensionPoints();
        THashSet epNames = new THashSet(extensionPoints.length);
        for (ExtensionPoint point : extensionPoints) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            for (String epName : epNames) {
                descriptor.registerExtensions(area, epName);
            }
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor;
        if (pluginRoot == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        if ((descriptor = pluginRoot.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot, fileName, null, true) : PluginManagerCore.loadDescriptorFromJar(pluginRoot, fileName, true)) != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions(area, Collections.singletonList(descriptor));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
        }
    }

    private static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (PicoPluginExtensionInitializationException e) {
            throw new PluginException((Throwable)((Object)e), e.getPluginId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = LoggerHolder.ourLogger;
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        return logger;
    }

    private static /* synthetic */ boolean lambda$filterBadPlugins$5(Map idToDescriptorMap, IdeaPluginDescriptor pluginDescriptor, LinkedHashSet faultyDescriptors, List disabledPluginIds, @NotNull Map disabledPluginNames, @NotNull List errors, Iterator it, PluginId pluginId) {
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        if (!idToDescriptorMap.containsKey(pluginId)) {
            pluginDescriptor.setEnabled(false);
            if (!pluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX)) {
                boolean disabled;
                String pluginName;
                faultyDescriptors.add(pluginId.getIdString());
                disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                String name = pluginDescriptor.getName();
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                if (descriptor == null) {
                    pluginName = pluginId.getIdString();
                    if (disabledPluginNames.containsKey(pluginName)) {
                        pluginName = (String)disabledPluginNames.get(pluginName);
                    }
                } else {
                    pluginName = descriptor.getName();
                }
                errors.add(IdeBundle.message((disabled = PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString())) ? "error.required.plugin.disabled" : "error.required.plugin.not.installed", name, pluginName));
            }
            it.remove();
            return false;
        }
        return true;
    }

    static {
        ourId2Index = new TObjectIntHashMap();
        ourModulesToContainingPlugins = new THashMap();
        ourPluginClasses = new PluginClassCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 2: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 6: 
            case 32: 
            case 35: 
            case 70: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: 
            case 12: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 22: 
            case 25: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId2Descriptor";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 30: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "on";
                break;
            }
            case 34: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 36: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 42: 
            case 49: 
            case 52: 
            case 100: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsPath";
                break;
            }
            case 47: 
            case 50: 
            case 76: 
            case 81: 
            case 85: 
            case 104: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 54: 
            case 56: 
            case 58: 
            case 62: 
            case 64: 
            case 66: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 55: 
            case 57: 
            case 67: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 59: 
            case 63: 
            case 65: 
            case 69: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 61: 
            case 68: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalDescriptorLoader";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsHome";
                break;
            }
            case 73: 
            case 74: 
            case 80: 
            case 84: 
            case 103: 
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 75: 
            case 101: 
            case 107: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPluginNames";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 88: 
            case 99: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoader";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaded";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 98: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptors";
                break;
            }
            case 102: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginsList";
                break;
            }
            case 112: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPlugins";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPlugins";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddUrlMethod";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentLoaders";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptorComparator";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginIdGraph";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "topoSortPlugins";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPluginLoadingOrder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkDependants";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addPluginClass";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isDependent";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAddUrlMethod";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isPluginClass";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getParentLoaders";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "countPlugins";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addModulesAsDependents";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorComparator";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptionalDescriptors";
                break;
            }
            case 72: 
            case 73: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptors";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "filterBadPlugins";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "topoSortPlugins";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "detectReasonToNotLoad";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipPlugin";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "fixDescriptors";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "checkCanLoadPlugins";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "fixDependencies";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointsAndExtensions";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterBadPlugins$5";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadDescriptor$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class EssentialPluginMissingException
    extends RuntimeException {
        final Set<String> pluginIds;

        EssentialPluginMissingException(@NotNull Set<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + StringUtil.join(ids, ", "));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");

        private LoggerHolder() {
        }
    }

    private static class LoadingContext
    implements AutoCloseable {
        private final Map<File, ZipFile> myOpenedFiles = new THashMap();
        private File myLastZipFileContainingDescriptor;

        private LoadingContext() {
        }

        @Override
        public void close() {
            for (ZipFile file : this.myOpenedFiles.values()) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();
        private static final boolean ourIsRunningFromSources = new File(PathManager.getHomePath(), ".idea").isDirectory();

        private Holder() {
        }

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString(System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString(BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.currentVersion();
                }
            }
            return ourBuildNumber;
        }
    }
}

