/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
extends EditorFontCacheImpl
implements EditorColorsScheme,
SerializableScheme {
    public static final TextAttributes INHERITED_ATTRS_MARKER = new TextAttributes();
    public static final Color INHERITED_COLOR_MARKER = ColorUtil.marker("INHERITED_COLOR_MARKER");
    public static final Color NULL_COLOR_MARKER = ColorUtil.marker("NULL_COLOR_MARKER");
    public static final int CURR_VERSION = 142;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    @NotNull
    private FontPreferences myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
    @NotNull
    private FontPreferences myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String mySchemeName;
    private boolean myIsSaveNeeded;
    private boolean myCanBeDeleted = true;
    private int myVersion = 142;
    protected Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = new THashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String FONT_SCALE = "FONT_SCALE";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    private final Properties myMetaInfo = new Properties();
    private static final SimpleDateFormat META_INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    private static final String META_INFO_ORIGINAL = "originalScheme";
    private static final Map<String, Couple<Color>> DEFAULT_STRIPE_COLORS = new THashMap<String, Couple<Color>>(){
        {
            this.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Couple.of(Color.red, ColorUtil.fromHex("CF5B56")));
            this.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Couple.of(Color.yellow, ColorUtil.fromHex("EBC700")));
            this.put("EXECUTIONPOINT_ATTRIBUTES", Couple.of(Color.blue, ColorUtil.fromHex("3763b0")));
            this.put(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("CCCFFF"), ColorUtil.fromHex("BAA8FF")));
            this.put(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("FFCCE5"), ColorUtil.fromHex("F0ADF0")));
            this.put(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("586E75"), ColorUtil.fromHex("71B362")));
            this.put(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("268BD2"), ColorUtil.fromHex("54AAE3")));
        }
    };

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.myMetaInfo.setProperty(META_INFO_CREATION_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        this.myMetaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.myMetaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfoEx.getInstanceEx().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.INSTANCE) {
            this.myMetaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
        }
    }

    @Override
    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            AbstractColorsScheme.$$$reportNull$$$0(0);
        }
        return color;
    }

    @Override
    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            AbstractColorsScheme.$$$reportNull$$$0(1);
        }
        return color;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            AbstractColorsScheme.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setFont(EditorFontType key, Font font) {
    }

    @Override
    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        if (this.myConsoleFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseEditorFontPreferencesInConsole();
        } else {
            newScheme.setConsoleFontPreferences(this.myConsoleFontPreferences);
        }
        if (this.myFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseAppFontPreferencesInEditor();
        } else {
            newScheme.setFontPreferences(this.myFontPreferences);
        }
        newScheme.myAttributesMap = new THashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap<ColorKey, Color>(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    @NotNull
    public Set<ColorKey> getColorKeys() {
        Set<ColorKey> set = this.myColorsMap.keySet();
        if (set == null) {
            AbstractColorsScheme.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<TextAttributesKey> getAttributeKeys() {
        HashSet<TextAttributesKey> result2 = new HashSet<TextAttributesKey>(this.myAttributesMap.keySet());
        if (this.myParentScheme instanceof DefaultColorsScheme) {
            result2.addAll(((DefaultColorsScheme)this.myParentScheme).getAttributeKeys());
        }
        HashSet<TextAttributesKey> hashSet = result2;
        if (hashSet == null) {
            AbstractColorsScheme.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Override
    public void setEditorFontName(String fontName) {
        ModifiableFontPreferences currPreferences = this.ensureEditableFontPreferences();
        boolean useLigatures = currPreferences.useLigatures();
        int editorFontSize = this.getEditorFontSize();
        currPreferences.clear();
        currPreferences.register(fontName, editorFontSize);
        currPreferences.setUseLigatures(useLigatures);
        this.initFonts();
    }

    @Override
    public void setEditorFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.ensureEditableFontPreferences().register(this.myFontPreferences.getFontFamily(), fontSize);
        this.initFonts();
    }

    @Override
    public void setUseAppFontPreferencesInEditor() {
        this.myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
        this.initFonts();
    }

    @Override
    public boolean isUseAppFontPreferencesInEditor() {
        return this.myFontPreferences instanceof DelegatingFontPreferences;
    }

    @Override
    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            AbstractColorsScheme.$$$reportNull$$$0(5);
        }
        if (this.myQuickDocFontSize != fontSize) {
            this.myQuickDocFontSize = fontSize;
            this.myIsSaveNeeded = true;
        }
    }

    @Override
    public void setLineSpacing(float lineSpacing) {
        this.ensureEditableFontPreferences().setLineSpacing(lineSpacing);
    }

    @Override
    @NotNull
    public Font getFont(EditorFontType key) {
        Font font = this.myFontPreferences instanceof DelegatingFontPreferences ? EditorFontCache.getInstance().getFont(key) : super.getFont(key);
        if (font == null) {
            AbstractColorsScheme.$$$reportNull$$$0(6);
        }
        return font;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            AbstractColorsScheme.$$$reportNull$$$0(7);
        }
        this.mySchemeName = name;
    }

    @Override
    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(8);
        }
        return fontPreferences;
    }

    @Override
    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(9);
        }
        preferences.copyTo(this.ensureEditableFontPreferences());
        this.initFonts();
    }

    @Override
    public String getEditorFontName() {
        return this.getFont(EditorFontType.PLAIN).getFamily();
    }

    @Override
    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.myFontPreferences.getFontFamily());
    }

    @Override
    @NotNull
    public FontSize getQuickDocFontSize() {
        FontSize fontSize = this.myQuickDocFontSize;
        if (fontSize == null) {
            AbstractColorsScheme.$$$reportNull$$$0(10);
        }
        return fontSize;
    }

    @Override
    public float getLineSpacing() {
        return this.myFontPreferences.getLineSpacing();
    }

    protected void initFonts() {
        this.reset();
    }

    @Override
    protected EditorColorsScheme getFontCacheScheme() {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void readExternal(@NotNull Element parentNode) {
        UISettings settings;
        if (parentNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(11);
        }
        ColorBlindness blindness = (settings = UISettings.getInstanceOrNull()) == null ? null : settings.getColorBlindness();
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            List children = parentNode.getChildren(SCHEME_ELEMENT);
            if (children.isEmpty()) {
                throw new InvalidDataException("Scheme is not valid");
            }
            for (Element element : children) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Empty"));
        }
        this.myMetaInfo.clear();
        Ref<Float> fontScale = Ref.create();
        boolean clearEditorFonts = true;
        boolean clearConsoleFonts = true;
        for (Element childNode : node.getChildren()) {
            String childName;
            switch (childName = childNode.getName()) {
                case "option": {
                    this.readSettings(childNode, isDefault, fontScale);
                    break;
                }
                case "font": {
                    this.readFontSettings(this.ensureEditableFontPreferences(), childNode, isDefault, fontScale.get(), clearEditorFonts);
                    clearEditorFonts = false;
                    break;
                }
                case "console-font": {
                    this.readFontSettings(this.ensureEditableConsoleFontPreferences(), childNode, isDefault, fontScale.get(), clearConsoleFonts);
                    clearConsoleFonts = false;
                    break;
                }
                case "colors": {
                    this.readColors(childNode);
                    break;
                }
                case "attributes": {
                    this.readAttributes(childNode);
                    break;
                }
                case "metaInfo": {
                    this.readMetaInfo(childNode);
                }
            }
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        DefaultColorSchemesManager manager;
        EditorColorsScheme defaultScheme;
        if (name == null) {
            AbstractColorsScheme.$$$reportNull$$$0(12);
        }
        if ((defaultScheme = (manager = DefaultColorSchemesManager.getInstance()).getScheme(name)) == null) {
            defaultScheme = new TemporaryParent(name);
        }
        EditorColorsScheme editorColorsScheme = defaultScheme;
        if (editorColorsScheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(13);
        }
        return editorColorsScheme;
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        if (metaInfoElement == null) {
            AbstractColorsScheme.$$$reportNull$$$0(14);
        }
        this.myMetaInfo.clear();
        for (Element e : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e.getName()) || (propertyName = e.getAttributeValue("name")) == null) continue;
            this.myMetaInfo.setProperty(propertyName, e.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(15);
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = e.getAttributeValue("name");
            Element valueElement = e.getChild(VALUE_ELEMENT);
            TextAttributesKey key = TextAttributesKey.find(keyName);
            TextAttributes attr = valueElement != null ? this.myValueReader.read(TextAttributes.class, valueElement) : (e.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null ? INHERITED_ATTRS_MARKER : null);
            if (attr == null) continue;
            this.myAttributesMap.put(key, attr);
            this.migrateErrorStripeColorFrom14(key, attr);
        }
    }

    private void migrateErrorStripeColorFrom14(@NotNull TextAttributesKey name, @NotNull TextAttributes attr) {
        if (name == null) {
            AbstractColorsScheme.$$$reportNull$$$0(16);
        }
        if (attr == null) {
            AbstractColorsScheme.$$$reportNull$$$0(17);
        }
        if (this.myVersion >= 141 || this.myParentScheme == null) {
            return;
        }
        Couple<Color> m = DEFAULT_STRIPE_COLORS.get(name.getExternalName());
        if (m != null && Comparing.equal(m.first, attr.getErrorStripeColor())) {
            attr.setErrorStripeColor((Color)m.second);
        }
    }

    private void readColors(Element childNode) {
        for (Element colorElement : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = colorElement.getAttributeValue("name");
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            if (valueColor == null && colorElement.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null) {
                valueColor = INHERITED_COLOR_MARKER;
            }
            if (BACKGROUND_COLOR_NAME.equals(keyName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find(keyName);
            this.myColorsMap.put(name, ObjectUtils.notNull(valueColor, NULL_COLOR_MARKER));
        }
    }

    private void readSettings(@NotNull Element childNode, boolean isDefault, @NotNull Ref<Float> fontScale) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(18);
        }
        if (fontScale == null) {
            AbstractColorsScheme.$$$reportNull$$$0(19);
        }
        switch (childNode.getAttributeValue("name")) {
            case "FONT_SCALE": {
                fontScale.set(this.myValueReader.read(Float.class, childNode));
                break;
            }
            case "LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setLineSpacing(value.floatValue());
                break;
            }
            case "EDITOR_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault, fontScale.get());
                if (value <= 0) break;
                this.setEditorFontSize(value);
                break;
            }
            case "EDITOR_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setEditorFontName(value);
                break;
            }
            case "CONSOLE_LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setConsoleLineSpacing(value.floatValue());
                break;
            }
            case "CONSOLE_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault, fontScale.get());
                if (value <= 0) break;
                this.setConsoleFontSize(value);
                break;
            }
            case "CONSOLE_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setConsoleFontName(value);
                break;
            }
            case "EDITOR_QUICK_DOC_FONT_SIZE": {
                FontSize value = this.myValueReader.read(FontSize.class, childNode);
                if (value == null) break;
                this.myQuickDocFontSize = value;
                break;
            }
            case "EDITOR_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableFontPreferences().setUseLigatures(value);
                break;
            }
            case "CONSOLE_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableConsoleFontPreferences().setUseLigatures(value);
                break;
            }
        }
    }

    private int readFontSize(Element element, boolean isDefault, Float fontScale) {
        if (isDefault) {
            return UISettings.getDefFontSize();
        }
        Integer intSize = this.myValueReader.read(Integer.class, element);
        if (intSize == null) {
            return -1;
        }
        return UISettings.restoreFontSize(intSize, fontScale);
    }

    private void readFontSettings(@NotNull ModifiableFontPreferences preferences, @NotNull Element element, boolean isDefaultScheme, @Nullable Float fontScale, boolean clearFonts) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(20);
        }
        if (element == null) {
            AbstractColorsScheme.$$$reportNull$$$0(21);
        }
        if (clearFonts) {
            preferences.clearFonts();
        }
        List children = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child : children) {
            Element e = (Element)child;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue("name"))) continue;
            size = this.readFontSize(e, isDefaultScheme, fontScale);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences) || !(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag(parentNode, FONT_SCALE, String.valueOf(UISettings.getDefFontScale()));
        }
        if (this.myParentScheme != null && this.myParentScheme != EmptyColorScheme.INSTANCE) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        if (!this.myMetaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        if (this.getLineSpacing() != 1.0f) {
            JdomKt.addOptionTag(parentNode, LINE_SPACING, String.valueOf(this.getLineSpacing()));
        }
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences)) {
            if (useOldFontFormat) {
                JdomKt.addOptionTag(parentNode, EDITOR_FONT_SIZE, String.valueOf(this.getEditorFontSize()));
                JdomKt.addOptionTag(parentNode, EDITOR_FONT_NAME, this.myFontPreferences.getFontFamily());
            } else {
                AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myFontPreferences, EDITOR_LIGATURES);
        }
        if (!(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                JdomKt.addOptionTag(parentNode, CONSOLE_FONT_NAME, this.getConsoleFontName());
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    JdomKt.addOptionTag(parentNode, CONSOLE_FONT_SIZE, Integer.toString(this.getConsoleFontSize()));
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myConsoleFontPreferences, CONSOLE_LIGATURES);
            if (this.getConsoleLineSpacing() != 1.0f) {
                JdomKt.addOptionTag(parentNode, CONSOLE_LINE_SPACING, Float.toString(this.getConsoleLineSpacing()));
            }
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            JdomKt.addOptionTag(parentNode, EDITOR_QUICK_JAVADOC_FONT_SIZE, this.getQuickDocFontSize().toString());
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (!colorElements.getChildren().isEmpty()) {
            parentNode.addContent(colorElements);
        }
        if (!attrElements.getChildren().isEmpty()) {
            parentNode.addContent(attrElements);
        }
        this.myIsSaveNeeded = false;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            JdomKt.addOptionTag(parentNode, optionName, String.valueOf(true));
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(22);
        }
        if (parent == null) {
            AbstractColorsScheme.$$$reportNull$$$0(23);
        }
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(24);
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            JdomKt.addOptionTag(element, EDITOR_FONT_NAME, fontFamily);
            JdomKt.addOptionTag(element, EDITOR_FONT_SIZE, String.valueOf(preferences.getSize(fontFamily)));
            parent.addContent(element);
        }
    }

    private void writeAttributes(@NotNull Element attrElements) throws WriteExternalException {
        if (attrElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(25);
        }
        ArrayList<TextAttributesKey> list = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        list.sort(null);
        for (TextAttributesKey key : list) {
            this.writeAttribute(attrElements, key);
        }
    }

    private void writeAttribute(@NotNull Element attrElements, @NotNull TextAttributesKey key) {
        TextAttributes attributes;
        if (attrElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(26);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(27);
        }
        if ((attributes = this.myAttributesMap.get(key)) == INHERITED_ATTRS_MARKER) {
            boolean parentOverwritingInheritance;
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            TextAttributes parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
            boolean bl = parentOverwritingInheritance = parentAttributes != null && parentAttributes != INHERITED_ATTRS_MARKER;
            if (baseKey != null && parentOverwritingInheritance) {
                attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, baseKey.getExternalName()));
            }
            return;
        }
        if (this.myParentScheme != null) {
            TextAttributes parentAttributes;
            TextAttributes textAttributes = parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : this.myParentScheme.getAttributes(key);
            if (parentAttributes != null && attributes.equals(parentAttributes)) {
                return;
            }
        }
        Element valueElement = new Element(VALUE_ELEMENT);
        attributes.writeExternal(valueElement);
        attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).addContent(valueElement));
    }

    public void optimizeAttributeMap() {
        EditorColorsScheme parentScheme = this.myParentScheme;
        if (parentScheme == null) {
            return;
        }
        this.myAttributesMap.keySet().removeAll(JBIterable.from(this.myAttributesMap.keySet()).filter(key -> {
            TextAttributes attrs = this.myAttributesMap.get(key);
            if (attrs == INHERITED_ATTRS_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedAttributes(parentScheme, key);
            }
            TextAttributes parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getAttributes((TextAttributesKey)key, false) : parentScheme.getAttributes((TextAttributesKey)key);
            return Comparing.equal(parent, attrs);
        }).toList());
        this.myColorsMap.keySet().removeAll(JBIterable.from(this.myColorsMap.keySet()).filter(key -> {
            Color color = this.myColorsMap.get(key);
            if (color == INHERITED_COLOR_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedColors(parentScheme, key);
            }
            Color parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getColor((ColorKey)key, false) : parentScheme.getColor((ColorKey)key);
            return Comparing.equal(parent, color == NULL_COLOR_MARKER ? null : color);
        }).toList());
    }

    private static boolean hasExplicitlyDefinedAttributes(@NotNull EditorColorsScheme scheme, @NotNull TextAttributesKey key) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(28);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(29);
        }
        TextAttributes directAttrs = scheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme).getDirectlyDefinedAttributes(key) : null;
        return directAttrs != null && directAttrs != INHERITED_ATTRS_MARKER;
    }

    private static boolean hasExplicitlyDefinedColors(@NotNull EditorColorsScheme scheme, @NotNull ColorKey key) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(30);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(31);
        }
        Color directColor = scheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme).getDirectlyDefinedColor(key) : null;
        return directColor != null && directColor != INHERITED_COLOR_MARKER;
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        this.myMetaInfo.setProperty(META_INFO_MODIFIED_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.myMetaInfo.stringPropertyNames());
        sortedPropertyNames.sort(null);
        for (String propertyName : sortedPropertyNames) {
            String value = this.myMetaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value);
            metaInfoElement.addContent(propertyInfo);
        }
        Element element = metaInfoElement;
        if (element == null) {
            AbstractColorsScheme.$$$reportNull$$$0(32);
        }
        return element;
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        list.sort(null);
        for (ColorKey key : list) {
            this.writeColor(colorElements, key);
        }
    }

    private void writeColor(@NotNull Element colorElements, @NotNull ColorKey key) {
        Color color;
        if (colorElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(33);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(34);
        }
        if ((color = this.myColorsMap.get(key)) == INHERITED_COLOR_MARKER) {
            boolean parentOverwritingInheritance;
            ColorKey fallbackKey = key.getFallbackColorKey();
            Color parentFallback = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : null;
            boolean bl = parentOverwritingInheritance = parentFallback != null && parentFallback != INHERITED_COLOR_MARKER;
            if (fallbackKey != null && parentOverwritingInheritance) {
                colorElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, fallbackKey.getExternalName()));
            }
            return;
        }
        if (this.myParentScheme != null) {
            Color parent;
            Color color2 = parent = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : this.myParentScheme.getColor(key);
            if (parent != null && AbstractColorsScheme.colorsEqual(color, parent)) {
                return;
            }
        }
        String rgb = color == NULL_COLOR_MARKER ? "" : Integer.toString(color.getRGB() & 0xFFFFFF, 16);
        JdomKt.addOptionTag(colorElements, key.getExternalName(), rgb);
    }

    private static boolean colorsEqual(@Nullable Color c1, @Nullable Color c2) {
        if (c1 == NULL_COLOR_MARKER) {
            return c1 == c2;
        }
        return Comparing.equal(c1, c2 == NULL_COLOR_MARKER ? null : c2);
    }

    private ModifiableFontPreferences ensureEditableFontPreferences() {
        if (!(this.myFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myFontPreferences.copyTo(editablePrefs);
            this.myFontPreferences = editablePrefs;
            ((FontPreferencesImpl)this.myFontPreferences).setChangeListener(() -> this.initFonts());
        }
        return (ModifiableFontPreferences)this.myFontPreferences;
    }

    @Override
    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(35);
        }
        return fontPreferences;
    }

    @Override
    public void setUseEditorFontPreferencesInConsole() {
        this.myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
        this.initFonts();
    }

    @Override
    public boolean isUseEditorFontPreferencesInConsole() {
        return this.myConsoleFontPreferences instanceof DelegatingFontPreferences;
    }

    @Override
    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(36);
        }
        preferences.copyTo(this.ensureEditableConsoleFontPreferences());
        this.initFonts();
    }

    @Override
    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    private ModifiableFontPreferences ensureEditableConsoleFontPreferences() {
        if (!(this.myConsoleFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myConsoleFontPreferences.copyTo(editablePrefs);
            this.myConsoleFontPreferences = editablePrefs;
        }
        return (ModifiableFontPreferences)this.myConsoleFontPreferences;
    }

    @Override
    public void setConsoleFontName(String fontName) {
        ModifiableFontPreferences consolePreferences = this.ensureEditableConsoleFontPreferences();
        int consoleFontSize = this.getConsoleFontSize();
        consolePreferences.clear();
        consolePreferences.register(fontName, consoleFontSize);
    }

    @Override
    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if ((uiSettings == null || !uiSettings.getPresentationMode()) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    @Override
    public void setConsoleFontSize(int fontSize) {
        ModifiableFontPreferences consoleFontPreferences = this.ensureEditableConsoleFontPreferences();
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        consoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    @Override
    public float getConsoleLineSpacing() {
        return this.myConsoleFontPreferences.getLineSpacing();
    }

    @Override
    public void setConsoleLineSpacing(float lineSpacing) {
        this.ensureEditableConsoleFontPreferences().setLineSpacing(lineSpacing);
    }

    @Nullable
    protected TextAttributes getFallbackAttributes(@NotNull TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            AbstractColorsScheme.$$$reportNull$$$0(37);
        }
        TextAttributesKey cur = fallbackKey;
        while (true) {
            TextAttributes attrs = this.getDirectlyDefinedAttributes(cur);
            TextAttributesKey next = cur.getFallbackAttributeKey();
            if (attrs != null && (attrs != INHERITED_ATTRS_MARKER || next == null)) {
                return attrs;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
    }

    @Nullable
    protected Color getFallbackColor(@NotNull ColorKey fallbackKey) {
        if (fallbackKey == null) {
            AbstractColorsScheme.$$$reportNull$$$0(38);
        }
        ColorKey cur = fallbackKey;
        Color color;
        while ((color = this.getDirectlyDefinedColor(cur)) != NULL_COLOR_MARKER) {
            ColorKey next = cur.getFallbackColorKey();
            if (color != null && (color != INHERITED_COLOR_MARKER || next == null)) {
                return color;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
        return null;
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        TextAttributes attributes;
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(39);
        }
        return (attributes = this.myAttributesMap.get(key)) != null ? attributes : (this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null);
    }

    @Nullable
    public Color getDirectlyDefinedColor(@NotNull ColorKey key) {
        Color color;
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(40);
        }
        return (color = this.myColorsMap.get(key)) != null ? color : (this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : null);
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        SchemeState schemeState = this.myIsSaveNeeded ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
        if (schemeState == null) {
            AbstractColorsScheme.$$$reportNull$$$0(41);
        }
        return schemeState;
    }

    public void setSaveNeeded(boolean value) {
        this.myIsSaveNeeded = value;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    @NotNull
    public Properties getMetaProperties() {
        Properties properties = this.myMetaInfo;
        if (properties == null) {
            AbstractColorsScheme.$$$reportNull$$$0(42);
        }
        return properties;
    }

    public boolean canBeDeleted() {
        return this.myCanBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.myCanBeDeleted = canBeDeleted;
    }

    public boolean isVisible() {
        return true;
    }

    public static boolean isVisible(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(43);
        }
        return !(scheme instanceof AbstractColorsScheme) || ((AbstractColorsScheme)scheme).isVisible();
    }

    @Nullable
    public AbstractColorsScheme getOriginal() {
        EditorColorsScheme originalScheme;
        String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
        if (originalSchemeName != null && (originalScheme = EditorColorsManager.getInstance().getScheme(originalSchemeName)) instanceof AbstractColorsScheme) {
            return (AbstractColorsScheme)originalScheme;
        }
        return null;
    }

    public EditorColorsScheme getParentScheme() {
        return this.myParentScheme;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element root = new Element(SCHEME_ELEMENT);
        this.writeExternal(root);
        Element element = root;
        if (element == null) {
            AbstractColorsScheme.$$$reportNull$$$0(44);
        }
        return element;
    }

    public boolean settingsEqual(Object other) {
        return this.settingsEqual(other, null);
    }

    public boolean settingsEqual(Object other, @Nullable Predicate<ColorKey> colorKeyFilter) {
        if (!(other instanceof AbstractColorsScheme)) {
            return false;
        }
        AbstractColorsScheme otherScheme = (AbstractColorsScheme)other;
        if (AbstractColorsScheme.getBaseDefaultScheme(this) != AbstractColorsScheme.getBaseDefaultScheme(otherScheme)) {
            return false;
        }
        for (String propertyName : this.myMetaInfo.stringPropertyNames()) {
            if (propertyName.equals(META_INFO_CREATION_TIME) || propertyName.equals(META_INFO_MODIFIED_TIME) || propertyName.equals(META_INFO_IDE) || propertyName.equals(META_INFO_IDE_VERSION) || propertyName.equals(META_INFO_ORIGINAL) || Comparing.equal(this.myMetaInfo.getProperty(propertyName), otherScheme.myMetaInfo.getProperty(propertyName))) continue;
            return false;
        }
        return AbstractColorsScheme.areDelegatingOrEqual(this.myFontPreferences, otherScheme.getFontPreferences()) && AbstractColorsScheme.areDelegatingOrEqual(this.myConsoleFontPreferences, otherScheme.getConsoleFontPreferences()) && this.attributesEqual(otherScheme) && this.colorsEqual(otherScheme, colorKeyFilter);
    }

    protected static boolean areDelegatingOrEqual(@NotNull FontPreferences preferences1, @NotNull FontPreferences preferences2) {
        if (preferences1 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(45);
        }
        if (preferences2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(46);
        }
        boolean isDelegating1 = preferences1 instanceof DelegatingFontPreferences;
        boolean isDelegating2 = preferences2 instanceof DelegatingFontPreferences;
        return isDelegating1 || isDelegating2 ? isDelegating1 && isDelegating2 : preferences1.equals(preferences2);
    }

    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.myAttributesMap.equals(otherScheme.myAttributesMap);
    }

    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<ColorKey> colorKeyFilter) {
        if (this.myColorsMap.size() != otherScheme.myColorsMap.size()) {
            return false;
        }
        for (ColorKey key : this.myColorsMap.keySet()) {
            Color c2;
            Color c1 = this.myColorsMap.get(key);
            if (AbstractColorsScheme.colorsEqual(c1, c2 = otherScheme.myColorsMap.get(key))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static EditorColorsScheme getBaseDefaultScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(47);
        }
        if (!(scheme instanceof AbstractColorsScheme)) {
            return null;
        }
        if (scheme instanceof DefaultColorsScheme) {
            return scheme;
        }
        EditorColorsScheme parent = ((AbstractColorsScheme)scheme).myParentScheme;
        return parent != null ? AbstractColorsScheme.getBaseDefaultScheme(parent) : null;
    }

    public void setParent(@NotNull EditorColorsScheme newParent) {
        if (newParent == null) {
            AbstractColorsScheme.$$$reportNull$$$0(48);
        }
        assert (newParent instanceof ReadOnlyColorsScheme) : "New parent scheme must be read-only";
        this.myParentScheme = newParent;
    }

    void resolveParent(@NotNull Function<String, EditorColorsScheme> nameResolver) {
        if (nameResolver == null) {
            AbstractColorsScheme.$$$reportNull$$$0(49);
        }
        if (this.myParentScheme instanceof TemporaryParent) {
            String parentName = ((TemporaryParent)this.myParentScheme).getParentName();
            EditorColorsScheme newParent = nameResolver.apply(parentName);
            if (!(newParent instanceof ReadOnlyColorsScheme)) {
                throw new InvalidDataException(parentName);
            }
            this.myParentScheme = newParent;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontSize";
                break;
            }
            case 7: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 20: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaInfoElement";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontScale";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrElements";
                break;
            }
            case 28: 
            case 30: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCHEME_ELEMENT;
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorElements";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackKey";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences1";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences2";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBackground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorKeys";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeKeys";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickDocFontSize";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScheme";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "metaInfoToElement";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleFontPreferences";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeState";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaProperties";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setQuickDocFontSize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFontPreferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultScheme";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readMetaInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readAttributes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "migrateErrorStripeColorFrom14";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readFontSettings";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeFontPreferences";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitlyDefinedAttributes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitlyDefinedColors";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "writeColor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleFontPreferences";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackAttributes";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackColor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyDefinedAttributes";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyDefinedColor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "areDelegatingOrEqual";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDefaultScheme";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TemporaryParent
    extends EditorColorsSchemeImpl {
        private static final Logger LOG = Logger.getInstance(TemporaryParent.class);
        private final String myParentName;
        private boolean isErrorReported;

        public TemporaryParent(@NotNull String parentName) {
            if (parentName == null) {
                TemporaryParent.$$$reportNull$$$0(0);
            }
            super(EmptyColorScheme.INSTANCE);
            this.myParentName = parentName;
        }

        public String getParentName() {
            return this.myParentName;
        }

        @Override
        public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
            this.reportError();
            return super.getAttributes(key);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            this.reportError();
            return super.getColor(key);
        }

        private void reportError() {
            if (!this.isErrorReported) {
                LOG.error("Unresolved link to " + this.myParentName);
                this.isErrorReported = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentName", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme$TemporaryParent", "<init>"));
        }
    }
}

