/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;
    private final VirtualFileFilter myContentFilter;

    public FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (directoryIndex == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        if (fileTypeManager == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        this.myContentFilter = file -> {
            assert (file != null);
            return ReadAction.compute(() -> !this.isScopeDisposed() && this.isInContent(file));
        };
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    protected abstract boolean isScopeDisposed();

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor) {
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        return this.iterateContent(processor, null);
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor, @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        VirtualFileFilter filter = customFilter != null ? file -> this.myContentFilter.accept(file) && customFilter.accept(file) : this.myContentFilter;
        return FileIndexBase.iterateContentUnderDirectoryWithFilter(dir, processor, filter);
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return this.iterateContentUnderDirectory(dir, processor, null);
    }

    private static boolean iterateContentUnderDirectoryWithFilter(@NotNull VirtualFile dir, @NotNull ContentIterator iterator, @NotNull VirtualFileFilter filter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        if (iterator == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        return VfsUtilCore.iterateChildrenRecursively(dir, filter, iterator);
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file);
        if (directoryInfo == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        return directoryInfo;
    }

    @Override
    public boolean isContentSourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            FileIndexBase.$$$reportNull$$$0(12);
        }
        return !file.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file) && this.isInSourceContent(file);
    }

    @NotNull
    protected static VirtualFile[][] getModuleContentAndSourceRoots(Module module) {
        VirtualFile[][] virtualFileArray = new VirtualFile[][]{ModuleRootManager.getInstance(module).getContentRoots(), ModuleRootManager.getInstance(module).getSourceRoots()};
        if (virtualFileArray == null) {
            FileIndexBase.$$$reportNull$$$0(13);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFileOrDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentAndSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectoryWithFilter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFileOrDirectory";
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isContentSourceFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

