/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
    private final Project myProject;

    public ProjectFileIndexImpl(@NotNull Project project, @NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (project == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(0);
        }
        if (directoryIndex == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(1);
        }
        if (fileTypeManager == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(2);
        }
        super(directoryIndex, fileTypeManager);
        this.myProject = project;
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter) {
        Module[] modules;
        if (processor == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(3);
        }
        for (Module module : modules = ReadAction.compute(() -> ModuleManager.getInstance(this.myProject).getModules())) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module)) {
                if (this.iterateContentUnderDirectory(contentRoot, processor, filter)) continue;
                return false;
            }
        }
        return true;
    }

    private Set<VirtualFile> getRootsToIterate(Module module) {
        return ReadAction.compute(() -> {
            if (module.isDisposed()) {
                return Collections.emptySet();
            }
            LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
            VirtualFile[][] virtualFileArray = ProjectFileIndexImpl.getModuleContentAndSourceRoots(module);
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = virtualFileArray[i]) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = this.getInfoForFileOrDirectory(root);
                    if (!info.isInProject(root) || !module.equals(info.getModule()) || (parent = root.getParent()) != null && ProjectFileIndexImpl.isFileInContent(parent, parentInfo = this.getInfoForFileOrDirectory(parent))) continue;
                    result2.add(root);
                }
            }
            return result2;
        });
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file) {
        DirectoryInfo info;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(4);
        }
        return (info = this.getInfoForFileOrDirectory(file)).isIgnored() || info.isExcluded(file);
    }

    @Override
    public boolean isUnderIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(5);
        }
        return this.getInfoForFileOrDirectory(file).isIgnored();
    }

    @Override
    public Module getModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(6);
        }
        return this.getModuleForFile(file, true);
    }

    @Override
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        DirectoryInfo info;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(7);
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        if ((info = this.getInfoForFileOrDirectory(file)).isInProject(file) || !honorExclusion && info.isExcluded(file)) {
            return info.getModule();
        }
        return null;
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(8);
        }
        List<OrderEntry> list = this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(file));
        if (list == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    public VirtualFile getClassRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(10);
        }
        return ProjectFileIndexImpl.getClassRootForFile(file, this.getInfoForFileOrDirectory(file));
    }

    @Nullable
    public static VirtualFile getClassRootForFile(@NotNull VirtualFile file, DirectoryInfo info) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(11);
        }
        return info.isInProject(file) ? info.getLibraryClassRoot() : null;
    }

    @Override
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(12);
        }
        return ProjectFileIndexImpl.getSourceRootForFile(file, this.getInfoForFileOrDirectory(file));
    }

    @Nullable
    public static VirtualFile getSourceRootForFile(@NotNull VirtualFile file, DirectoryInfo info) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(13);
        }
        return info.isInProject(file) ? info.getSourceRoot() : null;
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(14);
        }
        return this.getContentRootForFile(file, true);
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(15);
        }
        return ProjectFileIndexImpl.getContentRootForFile(this.getInfoForFileOrDirectory(file), file, honorExclusion);
    }

    @Nullable
    public static VirtualFile getContentRootForFile(DirectoryInfo info, @NotNull VirtualFile file, boolean honorExclusion) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(16);
        }
        if (info.isInProject(file) || !honorExclusion && info.isExcluded(file)) {
            return info.getContentRoot();
        }
        return null;
    }

    @Override
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(17);
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myDirectoryIndex.getPackageName(dir);
    }

    @Override
    public boolean isLibraryClassFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(18);
        }
        if (file.isDirectory()) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file);
        return parentInfo.isInProject(file) && parentInfo.hasLibraryClassRoot();
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(19);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) || info.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(20);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.hasLibraryClassRoot();
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(21);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && info.isInLibrarySource(fileOrDir);
    }

    @Override
    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(22);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInProject(fileOrDir) && (info.hasLibraryClassRoot() || info.isInLibrarySource(fileOrDir));
    }

    @Override
    public boolean isIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(23);
        }
        return this.isExcluded(file);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(24);
        }
        return ProjectFileIndexImpl.isFileInContent(fileOrDir, this.getInfoForFileOrDirectory(fileOrDir));
    }

    public static boolean isFileInContent(@NotNull VirtualFile fileOrDir, @NotNull DirectoryInfo info) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(25);
        }
        if (info == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(26);
        }
        return info.isInProject(fileOrDir) && info.getModule() != null;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(27);
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource(fileOrDir);
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(28);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        DirectoryInfo info;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(29);
        }
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(30);
        }
        return (info = this.getInfoForFileOrDirectory(fileOrDir)).isInModuleSource(fileOrDir) && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myProject.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnderIgnored";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassRootForFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootForFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryClassFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInSource";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFileInContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

