/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NullAppendable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import com.intellij.util.text.StringFactory;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil
extends FileUtilRt {
    public static final String ASYNC_DELETE_EXTENSION = ".__del__";
    public static final int REGEX_PATTERN_FLAGS;
    public static final TObjectHashingStrategy<String> PATH_HASHING_STRATEGY;
    public static final TObjectHashingStrategy<File> FILE_HASHING_STRATEGY;
    private static final Logger LOG;
    private static final JBTreeTraverser<File> FILE_TRAVERSER;
    static final /* synthetic */ boolean $assertionsDisabled;

    @NotNull
    public static String join(String ... parts) {
        if (parts == null) {
            FileUtil.$$$reportNull$$$0(0);
        }
        String string = StringUtil.join(parts, File.separator);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(File base, File file) {
        return FileUtilRt.getRelativePath(base, file);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            FileUtil.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(3);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        if (basePath == null) {
            FileUtil.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            FileUtil.$$$reportNull$$$0(5);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, caseSensitive);
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(6);
        }
        return new File(path).isAbsolute();
    }

    public static boolean exists(@Nullable String path) {
        return path != null && new File(path).exists();
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(8);
        }
        return FileUtil.isAncestor(ancestor.getPath(), file.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull String ancestor, @NotNull String file, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(10);
        }
        return !ThreeState.NO.equals((Object)FileUtil.isAncestorThreeState(ancestor, file, strict));
    }

    @NotNull
    public static ThreeState isAncestorThreeState(@NotNull String ancestor, @NotNull String file, boolean strict) {
        if (ancestor == null) {
            FileUtil.$$$reportNull$$$0(11);
        }
        if (file == null) {
            FileUtil.$$$reportNull$$$0(12);
        }
        String ancestorPath = FileUtil.toCanonicalPath(ancestor);
        String filePath = FileUtil.toCanonicalPath(file);
        ThreeState threeState = FileUtil.startsWith(filePath, ancestorPath, strict, SystemInfo.isFileSystemCaseSensitive, true);
        if (threeState == null) {
            FileUtil.$$$reportNull$$$0(13);
        }
        return threeState;
    }

    public static boolean startsWith(@NotNull String path, @NotNull String start) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(14);
        }
        if (start == null) {
            FileUtil.$$$reportNull$$$0(15);
        }
        return !ThreeState.NO.equals((Object)FileUtil.startsWith(path, start, false, SystemInfo.isFileSystemCaseSensitive, false));
    }

    public static boolean startsWith(@NotNull String path, @NotNull String start, boolean caseSensitive) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(16);
        }
        if (start == null) {
            FileUtil.$$$reportNull$$$0(17);
        }
        return !ThreeState.NO.equals((Object)FileUtil.startsWith(path, start, false, caseSensitive, false));
    }

    @NotNull
    private static ThreeState startsWith(@NotNull String path, @NotNull String prefix, boolean strict, boolean caseSensitive, boolean checkImmediateParent) {
        char next1;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(18);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(19);
        }
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            ThreeState threeState = pathLength == 0 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(20);
            }
            return threeState;
        }
        if (prefixLength > pathLength) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(21);
            }
            return threeState;
        }
        if (!path.regionMatches(!caseSensitive, 0, prefix, 0, prefixLength)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(22);
            }
            return threeState;
        }
        if (pathLength == prefixLength) {
            ThreeState threeState = strict ? ThreeState.NO : ThreeState.YES;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(23);
            }
            return threeState;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == File.separatorChar) {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        if ((next1 = path.charAt(slashOrSeparatorIdx)) == '/' || next1 == File.separatorChar) {
            if (!checkImmediateParent) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    FileUtil.$$$reportNull$$$0(24);
                }
                return threeState;
            }
            if (slashOrSeparatorIdx == pathLength - 1) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    FileUtil.$$$reportNull$$$0(25);
                }
                return threeState;
            }
            int idxNext = path.indexOf(next1, slashOrSeparatorIdx + 1);
            idxNext = idxNext == -1 ? path.indexOf(next1 == '/' ? 92 : 47, slashOrSeparatorIdx + 1) : idxNext;
            ThreeState threeState = idxNext == -1 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                FileUtil.$$$reportNull$$$0(26);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            FileUtil.$$$reportNull$$$0(27);
        }
        return threeState;
    }

    public static <T> Collection<T> removeAncestors(Collection<T> files, Convertor<T, String> convertor, PairProcessor<T, T> removeProcessor) {
        if (files.isEmpty()) {
            return files;
        }
        TreeMap<String, T> paths = new TreeMap<String, T>();
        for (T file : files) {
            String path = convertor.convert(file);
            if (!$assertionsDisabled && path == null) {
                throw new AssertionError();
            }
            String canonicalPath = FileUtil.toCanonicalPath(path);
            paths.put(canonicalPath, file);
        }
        ArrayList ordered = new ArrayList(paths.entrySet());
        ArrayList result2 = new ArrayList(ordered.size());
        result2.add(((Map.Entry)ordered.get(0)).getValue());
        for (int i = 1; i < ordered.size(); ++i) {
            Map.Entry entry = (Map.Entry)ordered.get(i);
            String child = (String)entry.getKey();
            boolean parentNotFound = true;
            for (int j = i - 1; j >= 0; --j) {
                String parent = (String)((Map.Entry)ordered.get(j)).getKey();
                if (parent == null || !FileUtil.startsWith(child, parent) || !removeProcessor.process(((Map.Entry)ordered.get(j)).getValue(), entry.getValue())) continue;
                parentNotFound = false;
                break;
            }
            if (!parentNotFound) continue;
            result2.add(entry.getValue());
        }
        return result2;
    }

    @Nullable
    public static File findAncestor(@NotNull File f1, @NotNull File f2) {
        File ancestor;
        if (f1 == null) {
            FileUtil.$$$reportNull$$$0(28);
        }
        if (f2 == null) {
            FileUtil.$$$reportNull$$$0(29);
        }
        for (ancestor = f1; ancestor != null && !FileUtil.isAncestor(ancestor, f2, false); ancestor = ancestor.getParentFile()) {
        }
        return ancestor;
    }

    @Nullable
    public static File getParentFile(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(30);
        }
        return FileUtilRt.getParentFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] loadFileBytes(@NotNull File file) throws IOException {
        byte[] bytes;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(31);
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            long len = file.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileUtil.isTooLarge(len)) {
                throw new FileTooBigException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        finally {
            ((InputStream)stream).close();
        }
        if (bytes == null) {
            FileUtil.$$$reportNull$$$0(32);
        }
        return bytes;
    }

    @NotNull
    public static byte[] loadFirstAndClose(@NotNull InputStream stream, int maxLength) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(33);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            FileUtil.copy(stream, maxLength, (OutputStream)buffer);
        }
        finally {
            stream.close();
        }
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(34);
        }
        return byArray;
    }

    @NotNull
    public static String loadTextAndClose(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(35);
        }
        String string = FileUtil.loadTextAndClose(new InputStreamReader(stream));
        if (string == null) {
            FileUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static String loadTextAndClose(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(37);
        }
        String string = StringFactory.createShared(FileUtil.adaptiveLoadText(reader));
        String string2 = string;
        if (string2 == null) {
            FileUtil.$$$reportNull$$$0(38);
        }
        return string2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static char[] adaptiveLoadText(@NotNull Reader reader) throws IOException {
        int n;
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(39);
        }
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result2 = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result2, result2.length - total, total);
        if (result2 == null) {
            FileUtil.$$$reportNull$$$0(40);
        }
        return result2;
    }

    @NotNull
    public static byte[] adaptiveLoadBytes(@NotNull InputStream stream) throws IOException {
        int n;
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(41);
        }
        byte[] bytes = FileUtil.getThreadLocalBuffer();
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + stream);
            }
            total += n;
            if (count != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count = 0;
        }
        byte[] result2 = new byte[total];
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result2, result2.length - total, total);
        if (result2 == null) {
            FileUtil.$$$reportNull$$$0(42);
        }
        return result2;
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(43);
        }
        Future<Void> future = FileUtil.asyncDelete(Collections.singleton(file));
        if (future == null) {
            FileUtil.$$$reportNull$$$0(44);
        }
        return future;
    }

    @NotNull
    public static Future<Void> asyncDelete(@NotNull Collection<File> files) {
        if (files == null) {
            FileUtil.$$$reportNull$$$0(45);
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file : files) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        if (!tempFiles.isEmpty()) {
            Future<Void> future = FileUtil.startDeletionThread(tempFiles.toArray(new File[0]));
            if (future == null) {
                FileUtil.$$$reportNull$$$0(46);
            }
            return future;
        }
        FixedFuture<Object> fixedFuture = new FixedFuture<Object>(null);
        if (fixedFuture == null) {
            FileUtil.$$$reportNull$$$0(47);
        }
        return fixedFuture;
    }

    private static Future<Void> startDeletionThread(final File ... tempFiles) {
        if (tempFiles == null) {
            FileUtil.$$$reportNull$$$0(48);
        }
        FutureTask<Object> deleteFilesTask = new FutureTask<Object>(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                int priority = currentThread.getPriority();
                currentThread.setPriority(1);
                try {
                    for (File tempFile : tempFiles) {
                        FileUtil.delete(tempFile);
                    }
                }
                finally {
                    currentThread.setPriority(priority);
                }
            }
        }, null);
        try {
            Class<?> aClass = Class.forName("com.intellij.openapi.application.ApplicationManager");
            Method getApplicationMethod = aClass.getMethod("getApplication", new Class[0]);
            Object application = getApplicationMethod.invoke(null, new Object[0]);
            Method executeOnPooledThreadMethod = application.getClass().getMethod("executeOnPooledThread", Runnable.class);
            executeOnPooledThreadMethod.invoke(application, deleteFilesTask);
        }
        catch (Exception ignored) {
            new Thread(deleteFilesTask, "File deletion thread").start();
        }
        return deleteFilesTask;
    }

    @Nullable
    private static File renameToTempFileOrDelete(@NotNull File file) {
        String originalFileName;
        File tempFile;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(49);
        }
        String tempDir = FileUtil.getTempDirectory();
        boolean isSameDrive = true;
        if (SystemInfo.isWindows) {
            String tempDirDrive = tempDir.substring(0, 2);
            String fileDrive = file.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file);
        return null;
    }

    private static File getTempFile(@NotNull String originalFileName, @NotNull String parent) {
        int randomSuffix;
        if (originalFileName == null) {
            FileUtil.$$$reportNull$$$0(50);
        }
        if (parent == null) {
            FileUtil.$$$reportNull$$$0(51);
        }
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        String name;
        File tempFile;
        while ((tempFile = new File(parent, name = "___" + originalFileName + i + ASYNC_DELETE_EXTENSION)).exists()) {
            ++i;
        }
        return tempFile;
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(52);
        }
        if (FileUtilRt.NIOReflect.IS_AVAILABLE) {
            return FileUtil.deleteRecursivelyNIO(file);
        }
        return FileUtil.deleteRecursively(file);
    }

    private static boolean deleteRecursively(@NotNull File file) {
        File[] files;
        FileAttributes attributes;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(53);
        }
        if ((attributes = FileSystemUtil.getAttributes(file)) == null) {
            return true;
        }
        if (attributes.isDirectory() && !attributes.isSymLink() && (files = file.listFiles()) != null) {
            for (File child : files) {
                if (FileUtil.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtil.deleteFile(file);
    }

    public static boolean createParentDirs(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(54);
        }
        return FileUtilRt.createParentDirs(file);
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(55);
        }
        return FileUtilRt.createDirectory(path);
    }

    public static boolean createIfDoesntExist(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(56);
        }
        return FileUtilRt.createIfNotExists(file);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(57);
        }
        return FileUtilRt.ensureCanCreateFile(file);
    }

    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(58);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(59);
        }
        FileUtil.performCopy(fromFile, toFile, true);
    }

    public static void copyContent(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(60);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(61);
        }
        FileUtil.performCopy(fromFile, toFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCopy(@NotNull File fromFile, @NotNull File toFile, boolean syncTimestamp) throws IOException {
        if (fromFile == null) {
            FileUtil.$$$reportNull$$$0(62);
        }
        if (toFile == null) {
            FileUtil.$$$reportNull$$$0(63);
        }
        if (FileUtil.filesEqual(fromFile, toFile)) {
            return;
        }
        FileOutputStream fos = FileUtil.openOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtil.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        if (syncTimestamp) {
            long timeStamp = fromFile.lastModified();
            if (timeStamp < 0L) {
                LOG.warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
            } else if (!toFile.setLastModified(timeStamp)) {
                LOG.warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
            }
        }
        if (SystemInfo.isUnix && fromFile.canExecute()) {
            FileSystemUtil.clonePermissionsToExecute(fromFile.getPath(), toFile.getPath());
        }
    }

    private static FileOutputStream openOutputStream(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(64);
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                throw new IOException("Parent file is null for " + file.getPath(), e);
            }
            FileUtil.createParentDirs(file);
            return new FileOutputStream(file);
        }
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(65);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(66);
        }
        FileUtilRt.copy(inputStream, outputStream);
    }

    public static void copy(@NotNull InputStream inputStream, int maxSize, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(67);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(68);
        }
        FileUtil.copy(inputStream, (long)maxSize, outputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(@NotNull InputStream inputStream, long maxSize, @NotNull OutputStream outputStream) throws IOException {
        int read2;
        if (inputStream == null) {
            FileUtil.$$$reportNull$$$0(69);
        }
        if (outputStream == null) {
            FileUtil.$$$reportNull$$$0(70);
        }
        byte[] buffer = FileUtil.getThreadLocalBuffer();
        for (long toRead = maxSize; toRead > 0L && (read2 = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, toRead))) >= 0; toRead -= (long)read2) {
            void outputStream2;
            outputStream2.write(buffer, 0, read2);
        }
    }

    public static void copyFileOrDir(@NotNull File from, @NotNull File to) throws IOException {
        if (from == null) {
            FileUtil.$$$reportNull$$$0(71);
        }
        if (to == null) {
            FileUtil.$$$reportNull$$$0(72);
        }
        FileUtil.copyFileOrDir(from, to, from.isDirectory());
    }

    public static void copyFileOrDir(@NotNull File from, @NotNull File to, boolean isDir) throws IOException {
        if (from == null) {
            FileUtil.$$$reportNull$$$0(73);
        }
        if (to == null) {
            FileUtil.$$$reportNull$$$0(74);
        }
        if (isDir) {
            FileUtil.copyDir(from, to);
        } else {
            FileUtil.copy(from, to);
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(75);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(76);
        }
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDirContent(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        File[] children;
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(77);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(78);
        }
        for (File child : children = ObjectUtils.notNull(fromDir.listFiles(), ArrayUtil.EMPTY_FILE_ARRAY)) {
            FileUtil.copyFileOrDir(child, new File(toDir, child.getName()));
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, boolean copySystemFiles) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(79);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(80);
        }
        FileUtil.copyDir(fromDir, toDir, copySystemFiles ? null : new FileFilter(){

            @Override
            public boolean accept(@NotNull File file) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return !StringUtil.startsWithChar(file.getName(), '.');
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil$3", "accept"));
            }
        });
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, @Nullable FileFilter filter) throws IOException {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(81);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(82);
        }
        FileUtil.ensureExists(toDir);
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(CommonBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        if (!fromDir.canRead()) {
            throw new IOException(CommonBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        for (File file : files) {
            if (filter != null && !filter.accept(file)) continue;
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(toDir, file.getName()), filter);
                continue;
            }
            FileUtil.copy(file, new File(toDir, file.getName()));
        }
    }

    public static void ensureExists(@NotNull File dir) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(83);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException(CommonBundle.message("exception.directory.can.not.create", dir.getPath()));
        }
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(84);
        }
        String string = FileUtil.getNameWithoutExtension(file.getName());
        if (string == null) {
            FileUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(86);
        }
        String string = FileUtilRt.getNameWithoutExtension(name);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(87);
        }
        return string;
    }

    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull String aFilePrefix, @NotNull String aExtension) {
        if (aParentFolder == null) {
            FileUtil.$$$reportNull$$$0(88);
        }
        if (aFilePrefix == null) {
            FileUtil.$$$reportNull$$$0(89);
        }
        if (aExtension == null) {
            FileUtil.$$$reportNull$$$0(90);
        }
        return FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
    }

    @NotNull
    public static File findSequentNonexistentFile(@NotNull File parentFolder, @NotNull String filePrefix, @NotNull String extension) {
        if (parentFolder == null) {
            FileUtil.$$$reportNull$$$0(91);
        }
        if (filePrefix == null) {
            FileUtil.$$$reportNull$$$0(92);
        }
        if (extension == null) {
            FileUtil.$$$reportNull$$$0(93);
        }
        int postfix = 0;
        String ext = extension.isEmpty() ? "" : '.' + extension;
        File candidate = new File(parentFolder, filePrefix + ext);
        while (candidate.exists()) {
            candidate = new File(parentFolder, filePrefix + Integer.toString(++postfix) + ext);
        }
        File file = candidate;
        if (file == null) {
            FileUtil.$$$reportNull$$$0(94);
        }
        return file;
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String aFileName) {
        if (aFileName == null) {
            FileUtil.$$$reportNull$$$0(95);
        }
        String string = FileUtilRt.toSystemDependentName(aFileName);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(96);
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NotNull String aFileName) {
        if (aFileName == null) {
            FileUtil.$$$reportNull$$$0(97);
        }
        String string = FileUtilRt.toSystemIndependentName(aFileName);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(98);
        }
        return string;
    }

    @Contract(value="null -> null")
    public static String toCanonicalPath(@Nullable String path) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true);
    }

    @Contract(value="null, _ -> null")
    public static String toCanonicalPath(@Nullable String path, boolean resolveSymlinksIfNecessary) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true, resolveSymlinksIfNecessary);
    }

    @Contract(value="null, _ -> null")
    public static String toCanonicalPath(@Nullable String path, char separatorChar) {
        return FileUtil.toCanonicalPath(path, separatorChar, true);
    }

    @Contract(value="null -> null")
    public static String toCanonicalUriPath(@Nullable String path) {
        return FileUtil.toCanonicalPath(path, '/', false);
    }

    @Contract(value="null, _, _ -> null")
    private static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash) {
        return FileUtil.toCanonicalPath(path, separatorChar, removeLastSlash, false);
    }

    @Contract(value="null, _, _, _ -> null")
    private static String toCanonicalPath(@Nullable String path, final char separatorChar, final boolean removeLastSlash, boolean resolveSymlinks) {
        char next;
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (StringUtil.startsWithChar(path, '.')) {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/' || c == separatorChar) {
                path = path.substring(2);
            }
        }
        path = path.replace(separatorChar, '/');
        int index = -1;
        do {
            char c = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            if (removeLastSlash) {
                int start = FileUtil.processRoot(path, NullAppendable.INSTANCE);
                int slashIndex = path.lastIndexOf(47);
                return slashIndex != -1 && slashIndex > start ? StringUtil.trimEnd(path, '/') : path;
            }
            return path;
        }
        final String finalPath = path;
        NotNullProducer<String> realCanonicalPath = resolveSymlinks ? new NotNullProducer<String>(){

            @Override
            @NotNull
            public String produce() {
                String string;
                try {
                    string = new File(finalPath).getCanonicalPath().replace(separatorChar, '/');
                }
                catch (IOException ignore) {
                    String string2 = FileUtil.toCanonicalPath(finalPath, separatorChar, removeLastSlash, false);
                    if (string2 == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return string2;
                }
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil$4", "produce"));
            }
        } : null;
        StringBuilder result2 = new StringBuilder(path.length());
        int start = FileUtil.processRoot(path, result2);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    if (!FileUtil.processDots(result2, dots, start, resolveSymlinks)) {
                        return (String)realCanonicalPath.produce();
                    }
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            if (dots > 0) {
                StringUtil.repeatSymbol(result2, '.', dots);
                dots = 0;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0 && !FileUtil.processDots(result2, dots, start, resolveSymlinks)) {
            return (String)realCanonicalPath.produce();
        }
        int lastChar = result2.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result2.charAt(lastChar) == '/' && lastChar > start) {
            result2.deleteCharAt(lastChar);
        }
        return result2.toString();
    }

    private static int processRoot(@NotNull String path, @NotNull Appendable result2) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(99);
        }
        if (result2 == null) {
            FileUtil.$$$reportNull$$$0(100);
        }
        try {
            if (SystemInfo.isWindows && path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) == '/') {
                int shareStart;
                int hostStart;
                result2.append("//");
                for (hostStart = 2; hostStart < path.length() && path.charAt(hostStart) == '/'; ++hostStart) {
                }
                if (hostStart == path.length()) {
                    return hostStart;
                }
                int hostEnd = path.indexOf(47, hostStart);
                if (hostEnd < 0) {
                    hostEnd = path.length();
                }
                result2.append(path, hostStart, hostEnd);
                result2.append('/');
                for (shareStart = hostEnd; shareStart < path.length() && path.charAt(shareStart) == '/'; ++shareStart) {
                }
                if (shareStart == path.length()) {
                    return shareStart;
                }
                int shareEnd = path.indexOf(47, shareStart);
                if (shareEnd < 0) {
                    shareEnd = path.length();
                }
                result2.append(path, shareStart, shareEnd);
                result2.append('/');
                return shareEnd;
            }
            if (!path.isEmpty() && path.charAt(0) == '/') {
                result2.append('/');
                return 1;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
                result2.append(path, 0, 3);
                return 3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    @Contract(value="_, _, _, false -> true")
    private static boolean processDots(@NotNull StringBuilder result2, int dots, int start, boolean resolveSymlinks) {
        if (result2 == null) {
            FileUtil.$$$reportNull$$$0(101);
        }
        if (dots == 2) {
            int pos = -1;
            if (!StringUtil.endsWith(result2, "/../") && !StringUtil.equals(result2, "../")) {
                pos = StringUtil.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                if (resolveSymlinks && FileSystemUtil.isSymLink(new File(result2.toString()))) {
                    return false;
                }
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            StringUtil.repeatSymbol(result2, '.', dots);
            result2.append('/');
        }
        return true;
    }

    @NotNull
    public static String normalize(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(102);
        }
        int start = 0;
        boolean separator = false;
        if (SystemInfo.isWindows) {
            if (path.startsWith("//")) {
                start = 2;
                separator = true;
            } else if (path.startsWith("\\\\")) {
                String string = FileUtil.normalizeTail(0, path, false);
                if (string == null) {
                    FileUtil.$$$reportNull$$$0(103);
                }
                return string;
            }
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (separator) {
                    String string = FileUtil.normalizeTail(i, path, true);
                    if (string == null) {
                        FileUtil.$$$reportNull$$$0(104);
                    }
                    return string;
                }
                separator = true;
                continue;
            }
            if (c == '\\') {
                String string = FileUtil.normalizeTail(i, path, separator);
                if (string == null) {
                    FileUtil.$$$reportNull$$$0(105);
                }
                return string;
            }
            separator = false;
        }
        String string = path;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(106);
        }
        return string;
    }

    @NotNull
    private static String normalizeTail(int prefixEnd, @NotNull String path, boolean separator) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(107);
        }
        StringBuilder result2 = new StringBuilder(path.length());
        result2.append(path, 0, prefixEnd);
        int start = prefixEnd;
        if (start == 0 && SystemInfo.isWindows && (path.startsWith("//") || path.startsWith("\\\\"))) {
            start = 2;
            result2.append("//");
            separator = true;
        }
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                if (!separator) {
                    result2.append('/');
                }
                separator = true;
                continue;
            }
            result2.append(c);
            separator = false;
        }
        String string = result2.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(108);
        }
        return string;
    }

    @NotNull
    public static String unquote(@NotNull String urlString) {
        if (urlString == null) {
            FileUtil.$$$reportNull$$$0(109);
        }
        urlString = urlString.replace('/', File.separatorChar);
        String string = URLUtil.unescapePercentSequences(urlString);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(110);
        }
        return string;
    }

    public static boolean isFilePathAcceptable(@NotNull File root, @Nullable FileFilter fileFilter) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(111);
        }
        if (fileFilter == null) {
            return true;
        }
        File file = root;
        do {
            if (fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static boolean rename(@NotNull File source, @NotNull String newName) throws IOException {
        if (source == null) {
            FileUtil.$$$reportNull$$$0(112);
        }
        if (newName == null) {
            FileUtil.$$$reportNull$$$0(113);
        }
        File target = new File(source.getParent(), newName);
        if (!SystemInfo.isFileSystemCaseSensitive && newName.equalsIgnoreCase(source.getName())) {
            File intermediate = FileUtil.createTempFile(source.getParentFile(), source.getName(), ".tmp", false, false);
            return source.renameTo(intermediate) && intermediate.renameTo(target);
        }
        return source.renameTo(target);
    }

    public static void rename(@NotNull File source, @NotNull File target) throws IOException {
        if (source == null) {
            FileUtil.$$$reportNull$$$0(114);
        }
        if (target == null) {
            FileUtil.$$$reportNull$$$0(115);
        }
        if (source.renameTo(target)) {
            return;
        }
        if (!source.exists()) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtil.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtil.toCanonicalPath(path1);
        path2 = FileUtil.toCanonicalPath(path2);
        return PATH_HASHING_STRATEGY.equals((Object)path1, (Object)path2);
    }

    public static boolean namesEqual(@Nullable String name1, @Nullable String name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return PATH_HASHING_STRATEGY.equals((Object)name1, (Object)name2);
    }

    public static int compareFiles(@Nullable File file1, @Nullable File file2) {
        return FileUtil.comparePaths(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static int comparePaths(@Nullable String path1, @Nullable String path2) {
        path1 = path1 == null ? null : FileUtil.toSystemIndependentName(path1);
        path2 = path2 == null ? null : FileUtil.toSystemIndependentName(path2);
        return StringUtil.compare(path1, path2, !SystemInfo.isFileSystemCaseSensitive);
    }

    public static int fileHashCode(@Nullable File file) {
        return FileUtil.pathHashCode(file == null ? null : file.getPath());
    }

    public static int pathHashCode(@Nullable String path) {
        return StringUtil.isEmpty(path) ? 0 : PATH_HASHING_STRATEGY.computeHashCode((Object)FileUtil.toCanonicalPath(path));
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            FileUtil.$$$reportNull$$$0(116);
        }
        String string = FileUtilRt.getExtension(fileName).toLowerCase();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(117);
        }
        return string;
    }

    @NotNull
    public static String resolveShortWindowsName(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(118);
        }
        String string = SystemInfo.isWindows && FileUtil.containsWindowsShortName(path) ? new File(path).getCanonicalPath() : path;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(119);
        }
        return string;
    }

    public static boolean containsWindowsShortName(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(120);
        }
        if (StringUtil.containsChar(path, '~')) {
            path = FileUtil.toSystemIndependentName(path);
            int start = 0;
            while (start < path.length()) {
                int dot;
                int end = path.indexOf(47, start);
                if (end < 0) {
                    end = path.length();
                }
                if ((dot = path.lastIndexOf(46, end)) < start) {
                    dot = end;
                }
                if (dot - start > 2 && dot - start <= 8 && end - dot - 1 <= 3 && path.charAt(dot - 2) == '~' && Character.isDigit(path.charAt(dot - 1))) {
                    return true;
                }
                start = end + 1;
            }
        }
        return false;
    }

    public static void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<File> outFiles) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(121);
        }
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(122);
        }
        if (outFiles == null) {
            FileUtil.$$$reportNull$$$0(123);
        }
        FileUtil.collectMatchedFiles(root, root, pattern, outFiles);
    }

    private static void collectMatchedFiles(@NotNull File absoluteRoot, @NotNull File root, @NotNull Pattern pattern, @NotNull List<File> files) {
        File[] dirs;
        if (absoluteRoot == null) {
            FileUtil.$$$reportNull$$$0(124);
        }
        if (root == null) {
            FileUtil.$$$reportNull$$$0(125);
        }
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(126);
        }
        if (files == null) {
            FileUtil.$$$reportNull$$$0(127);
        }
        if ((dirs = root.listFiles()) == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path;
                String relativePath = FileUtil.getRelativePath(absoluteRoot, dir);
                if (relativePath == null || !pattern.matcher(path = FileUtil.toSystemIndependentName(relativePath)).matches()) continue;
                files.add(dir);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir, pattern, files);
        }
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(128);
        }
        String string = FileUtil.convertAntToRegexp(antPattern, true);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(129);
        }
        return string;
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        if (antPattern == null) {
            FileUtil.$$$reportNull$$$0(130);
        }
        StringBuilder builder = new StringBuilder();
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (StringUtil.startsWithChar(antPattern, '/') || StringUtil.startsWithChar(antPattern, '\\')) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        String string = builder.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(131);
        }
        return string;
    }

    public static boolean moveDirWithContent(@NotNull File fromDir, @NotNull File toDir) {
        if (fromDir == null) {
            FileUtil.$$$reportNull$$$0(132);
        }
        if (toDir == null) {
            FileUtil.$$$reportNull$$$0(133);
        }
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files) {
            File toFile = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile);
        }
        fromDir.delete();
        return success;
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(134);
        }
        String string = FileUtil.sanitizeFileName(name, true);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(135);
        }
        return string;
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name, boolean strict) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(136);
        }
        String string = FileUtil.sanitizeFileName(name, strict, "_");
        if (string == null) {
            FileUtil.$$$reportNull$$$0(137);
        }
        return string;
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name, boolean strict, String replacement) {
        if (name == null) {
            FileUtil.$$$reportNull$$$0(138);
        }
        StringBuilder result2 = null;
        int last = 0;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            boolean appendReplacement = true;
            if (c > '\u0000' && c < '\u00ff') {
                if (strict ? Character.isLetterOrDigit(c) || c == '_' : Character.isJavaIdentifierPart(c) || c == ' ' || c == '@' || c == '-') {
                    continue;
                }
            } else {
                appendReplacement = false;
            }
            if (result2 == null) {
                result2 = new StringBuilder();
            }
            if (last < i) {
                result2.append(name, last, i);
            }
            if (appendReplacement) {
                result2.append(replacement);
            }
            last = i + 1;
        }
        if (result2 == null) {
            String string = name;
            if (string == null) {
                FileUtil.$$$reportNull$$$0(139);
            }
            return string;
        }
        if (last < length) {
            result2.append(name, last, length);
        }
        String string = result2.toString();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(140);
        }
        return string;
    }

    public static boolean canExecute(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(141);
        }
        return file.canExecute();
    }

    public static boolean canWrite(@NotNull String path) {
        FileAttributes attributes;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(142);
        }
        return (attributes = FileSystemUtil.getAttributes(path)) != null && attributes.isWritable();
    }

    public static void setReadOnlyAttribute(@NotNull String path, boolean readOnlyFlag) {
        boolean writableFlag;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(143);
        }
        boolean bl = writableFlag = !readOnlyFlag;
        if (!new File(path).setWritable(writableFlag, false) && FileUtil.canWrite(path) != writableFlag) {
            LOG.warn("Can't set writable attribute of '" + path + "' to '" + readOnlyFlag + "'");
        }
    }

    public static void appendToFile(@NotNull File file, @NotNull String text2) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(144);
        }
        if (text2 == null) {
            FileUtil.$$$reportNull$$$0(145);
        }
        FileUtil.writeToFile(file, text2.getBytes(CharsetToolkit.UTF8_CHARSET), true);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text2) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(146);
        }
        if (text2 == null) {
            FileUtil.$$$reportNull$$$0(147);
        }
        FileUtil.writeToFile(file, text2, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull String text2) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(148);
        }
        if (text2 == null) {
            FileUtil.$$$reportNull$$$0(149);
        }
        FileUtil.writeToFile(file, text2, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull String text2, boolean append) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(150);
        }
        if (text2 == null) {
            FileUtil.$$$reportNull$$$0(151);
        }
        FileUtil.writeToFile(file, text2.getBytes(CharsetToolkit.UTF8_CHARSET), append);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text2, int off, int len) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(152);
        }
        if (text2 == null) {
            FileUtil.$$$reportNull$$$0(153);
        }
        FileUtil.writeToFile(file, text2, off, len, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text2, boolean append) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(154);
        }
        if (text2 == null) {
            FileUtil.$$$reportNull$$$0(155);
        }
        FileUtil.writeToFile(file, text2, 0, text2.length, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(@NotNull File file, @NotNull byte[] text2, int off, int len, boolean append) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(156);
        }
        if (text2 == null) {
            FileUtil.$$$reportNull$$$0(157);
        }
        FileUtil.createParentDirs(file);
        FileOutputStream stream = new FileOutputStream(file, append);
        try {
            ((OutputStream)stream).write(text2, off, len);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    @NotNull
    public static JBTreeTraverser<File> fileTraverser(@Nullable File root) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)FILE_TRAVERSER.withRoot(root);
        if (jBTreeTraverser == null) {
            FileUtil.$$$reportNull$$$0(158);
        }
        return jBTreeTraverser;
    }

    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<File> processor) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(159);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(160);
        }
        return FileUtil.fileTraverser(root).bfsTraversal().processEach(processor);
    }

    @Deprecated
    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<File> processor, @Nullable Processor<File> directoryFilter) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(161);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(162);
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children;
            File file = (File)queue.removeFirst();
            if (!processor.process(file)) {
                return false;
            }
            if (directoryFilter != null && (!file.isDirectory() || !directoryFilter.process(file)) || (children = file.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, children);
        }
        return true;
    }

    @Nullable
    public static File findFirstThatExist(String ... paths) {
        if (paths == null) {
            FileUtil.$$$reportNull$$$0(163);
        }
        for (String path : paths) {
            File file;
            if (StringUtil.isEmptyOrSpaces(path) || !(file = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static List<File> findFilesByMask(@NotNull Pattern pattern, @NotNull File dir) {
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(164);
        }
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(165);
        }
        ArrayList<File> found = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    found.addAll(FileUtil.findFilesByMask(pattern, file));
                    continue;
                }
                if (!pattern.matcher(file.getName()).matches()) continue;
                found.add(file);
            }
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(166);
        }
        return arrayList;
    }

    @NotNull
    public static List<File> findFilesOrDirsByMask(@NotNull Pattern pattern, @NotNull File dir) {
        if (pattern == null) {
            FileUtil.$$$reportNull$$$0(167);
        }
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(168);
        }
        ArrayList<File> found = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (pattern.matcher(file.getName()).matches()) {
                    found.add(file);
                }
                if (!file.isDirectory()) continue;
                found.addAll(FileUtil.findFilesOrDirsByMask(pattern, file));
            }
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(169);
        }
        return arrayList;
    }

    @Nullable
    public static String findFileInProvidedPath(String providedPath, String ... fileNames) {
        File file;
        if (StringUtil.isEmpty(providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists() && ArrayUtil.indexOf(fileNames, providedFile.getName()) >= 0) {
            return FileUtil.toSystemDependentName(providedFile.getPath());
        }
        if (providedFile.isDirectory()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        if ((providedFile = providedFile.getParentFile()) != null && providedFile.exists()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        return null;
    }

    public static boolean isAbsolutePlatformIndependent(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(170);
        }
        return FileUtil.isUnixAbsolutePath(path) || FileUtil.isWindowsAbsolutePath(path);
    }

    public static boolean isUnixAbsolutePath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(171);
        }
        return path.startsWith("/");
    }

    public static boolean isWindowsAbsolutePath(@NotNull String pathString) {
        if (pathString == null) {
            FileUtil.$$$reportNull$$$0(172);
        }
        return pathString.length() >= 2 && Character.isLetter(pathString.charAt(0)) && pathString.charAt(1) == ':';
    }

    @Contract(value="null -> null; !null -> !null")
    public static String getLocationRelativeToUserHome(@Nullable String path) {
        return FileUtil.getLocationRelativeToUserHome(path, true);
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    public static String getLocationRelativeToUserHome(@Nullable String path, boolean unixOnly) {
        if (path == null) {
            return null;
        }
        if (SystemInfo.isUnix || !unixOnly) {
            File projectDir = new File(path);
            File userHomeDir = new File(SystemProperties.getUserHome());
            if (FileUtil.isAncestor(userHomeDir, projectDir, true)) {
                return '~' + File.separator + FileUtil.getRelativePath(userHomeDir, projectDir);
            }
        }
        return path;
    }

    @NotNull
    public static String expandUserHome(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(173);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        String string = path;
        if (string == null) {
            FileUtil.$$$reportNull$$$0(174);
        }
        return string;
    }

    @NotNull
    public static File[] notNullize(@Nullable File[] files) {
        File[] fileArray = FileUtil.notNullize(files, ArrayUtil.EMPTY_FILE_ARRAY);
        if (fileArray == null) {
            FileUtil.$$$reportNull$$$0(175);
        }
        return fileArray;
    }

    @NotNull
    public static File[] notNullize(@Nullable File[] files, @NotNull File[] defaultFiles) {
        if (defaultFiles == null) {
            FileUtil.$$$reportNull$$$0(176);
        }
        File[] fileArray = files == null ? defaultFiles : files;
        if (fileArray == null) {
            FileUtil.$$$reportNull$$$0(177);
        }
        return fileArray;
    }

    public static boolean isHashBangLine(@Nullable CharSequence firstCharsIfText, @NotNull String marker) {
        if (marker == null) {
            FileUtil.$$$reportNull$$$0(178);
        }
        if (firstCharsIfText == null) {
            return false;
        }
        if (!StringUtil.startsWith(firstCharsIfText, "#!")) {
            return false;
        }
        int lineBreak = StringUtil.indexOf(firstCharsIfText, '\n', 2);
        return lineBreak >= 0 && StringUtil.indexOf(firstCharsIfText, marker, 2, lineBreak) != -1;
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(179);
        }
        File file = FileUtilRt.createTempDirectory(prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(180);
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(181);
        }
        File file = FileUtilRt.createTempDirectory(prefix, suffix, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(182);
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull String prefix, @Nullable String suffix) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(183);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(184);
        }
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(185);
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            FileUtil.$$$reportNull$$$0(186);
        }
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(187);
        }
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(188);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(189);
        }
        File file = FileUtilRt.createTempFile(prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(190);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(191);
        }
        File file = FileUtilRt.createTempFile(prefix, suffix, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(192);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(File dir, @NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(193);
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(194);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(File dir, @NotNull String prefix, @Nullable String suffix, boolean create) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(195);
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, create);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(196);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(File dir, @NotNull String prefix, @Nullable String suffix, boolean create, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtil.$$$reportNull$$$0(197);
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, create, deleteOnExit);
        if (file == null) {
            FileUtil.$$$reportNull$$$0(198);
        }
        return file;
    }

    @NotNull
    public static String getTempDirectory() {
        String string = FileUtilRt.getTempDirectory();
        if (string == null) {
            FileUtil.$$$reportNull$$$0(199);
        }
        return string;
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        FileUtilRt.resetCanonicalTempPathCache(tempPath);
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file = FileUtilRt.generateRandomTemporaryPath();
        if (file == null) {
            FileUtil.$$$reportNull$$$0(200);
        }
        return file;
    }

    public static void setExecutableAttribute(@NotNull String path, boolean executableFlag) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(201);
        }
        FileUtilRt.setExecutableAttribute(path, executableFlag);
    }

    public static void setLastModified(@NotNull File file, long timeStamp) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(202);
        }
        if (!file.setLastModified(timeStamp)) {
            LOG.warn(file.getPath());
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(203);
        }
        String string = FileUtilRt.loadFile(file);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(204);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(205);
        }
        String string = FileUtilRt.loadFile(file, convertLineSeparators);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(206);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(207);
        }
        String string = FileUtilRt.loadFile(file, encoding);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(208);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @NotNull Charset encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(209);
        }
        if (encoding == null) {
            FileUtil.$$$reportNull$$$0(210);
        }
        String string = String.valueOf(FileUtilRt.loadFileText(file, encoding));
        if (string == null) {
            FileUtil.$$$reportNull$$$0(211);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(212);
        }
        String string = FileUtilRt.loadFile(file, encoding, convertLineSeparators);
        if (string == null) {
            FileUtil.$$$reportNull$$$0(213);
        }
        return string;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(214);
        }
        char[] cArray = FileUtilRt.loadFileText(file);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(215);
        }
        return cArray;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(216);
        }
        char[] cArray = FileUtilRt.loadFileText(file, encoding);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(217);
        }
        return cArray;
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(218);
        }
        char[] cArray = FileUtilRt.loadText(reader, length);
        if (cArray == null) {
            FileUtil.$$$reportNull$$$0(219);
        }
        return cArray;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(220);
        }
        List<String> list = FileUtilRt.loadLines(file);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(221);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(222);
        }
        List<String> list = FileUtilRt.loadLines(file, encoding);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(223);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(224);
        }
        List<String> list = FileUtilRt.loadLines(path);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(225);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable String encoding) throws IOException {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(226);
        }
        List<String> list = FileUtilRt.loadLines(path, encoding);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(227);
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(228);
        }
        List<String> list = FileUtilRt.loadLines(reader);
        if (list == null) {
            FileUtil.$$$reportNull$$$0(229);
        }
        return list;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(230);
        }
        byte[] byArray = FileUtilRt.loadBytes(stream);
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(231);
        }
        return byArray;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        if (stream == null) {
            FileUtil.$$$reportNull$$$0(232);
        }
        byte[] byArray = FileUtilRt.loadBytes(stream, length);
        if (byArray == null) {
            FileUtil.$$$reportNull$$$0(233);
        }
        return byArray;
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path) {
        int nextSeparator;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(234);
        }
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while ((nextSeparator = path.indexOf(File.separatorChar, index)) != -1) {
            list.add(path.substring(index, nextSeparator));
            index = nextSeparator + 1;
        }
        list.add(path.substring(index));
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            FileUtil.$$$reportNull$$$0(235);
        }
        return arrayList;
    }

    public static boolean isJarOrZip(@NotNull File file) {
        if (file == null) {
            FileUtil.$$$reportNull$$$0(236);
        }
        if (file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        return StringUtil.endsWithIgnoreCase(name, ".jar") || StringUtil.endsWithIgnoreCase(name, ".zip");
    }

    public static boolean visitFiles(@NotNull File root, @NotNull Processor<File> processor) {
        if (root == null) {
            FileUtil.$$$reportNull$$$0(237);
        }
        if (processor == null) {
            FileUtil.$$$reportNull$$$0(238);
        }
        if (!processor.process(root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (FileUtil.visitFiles(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Map<String, String> loadProperties(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            FileUtil.$$$reportNull$$$0(239);
        }
        final LinkedHashMap<String, String> map = ContainerUtil.newLinkedHashMap();
        new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                map.put(String.valueOf(key), String.valueOf(value));
                return super.put(key, value);
            }
        }.load(reader);
        LinkedHashMap<String, String> linkedHashMap = map;
        if (linkedHashMap == null) {
            FileUtil.$$$reportNull$$$0(240);
        }
        return linkedHashMap;
    }

    public static boolean isRootPath(@NotNull String path) {
        if (path == null) {
            FileUtil.$$$reportNull$$$0(241);
        }
        return path.equals("/") || path.matches("[a-zA-Z]:[/\\\\]");
    }

    public static boolean deleteWithRenaming(File file) {
        File tempFileNameForDeletion = FileUtil.findSequentNonexistentFile(file.getParentFile(), file.getName(), "");
        boolean success = file.renameTo(tempFileNameForDeletion);
        return FileUtil.delete(success ? tempFileNameForDeletion : file);
    }

    public static boolean isFileSystemCaseSensitive(@NotNull String path) throws FileNotFoundException {
        FileAttributes attributes;
        if (path == null) {
            FileUtil.$$$reportNull$$$0(242);
        }
        if ((attributes = FileSystemUtil.getAttributes(path)) == null) {
            throw new FileNotFoundException(path);
        }
        FileAttributes upper = FileSystemUtil.getAttributes(path.toUpperCase(Locale.ENGLISH));
        FileAttributes lower = FileSystemUtil.getAttributes(path.toLowerCase(Locale.ENGLISH));
        return !attributes.equals(upper) || !attributes.equals(lower);
    }

    static {
        boolean bl = $assertionsDisabled = !FileUtil.class.desiredAssertionStatus();
        if (!Patches.USE_REFLECTION_TO_ACCESS_JDK7) {
            throw new RuntimeException("Please migrate FileUtilRt to JDK8");
        }
        REGEX_PATTERN_FLAGS = SystemInfo.isFileSystemCaseSensitive ? 0 : 2;
        PATH_HASHING_STRATEGY = FilePathHashingStrategy.create();
        FILE_HASHING_STRATEGY = SystemInfo.isFileSystemCaseSensitive ? ContainerUtil.canonicalStrategy() : new TObjectHashingStrategy<File>(){

            public int computeHashCode(File object) {
                return FileUtil.fileHashCode(object);
            }

            public boolean equals(File o1, File o2) {
                return FileUtil.filesEqual(o1, o2);
            }
        };
        LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileUtil");
        FILE_TRAVERSER = JBTreeTraverser.from(new Function<File, Iterable<File>>(){

            @Override
            public Iterable<File> fun(File file) {
                return file != null && file.isDirectory() ? JBIterable.of(file.listFiles()) : JBIterable.empty();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 85: 
            case 87: 
            case 94: 
            case 96: 
            case 98: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 117: 
            case 119: 
            case 129: 
            case 131: 
            case 135: 
            case 137: 
            case 139: 
            case 140: 
            case 158: 
            case 166: 
            case 169: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 182: 
            case 185: 
            case 188: 
            case 190: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 204: 
            case 206: 
            case 208: 
            case 211: 
            case 213: 
            case 215: 
            case 217: 
            case 219: 
            case 221: 
            case 223: 
            case 225: 
            case 227: 
            case 229: 
            case 231: 
            case 233: 
            case 235: 
            case 240: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 85: 
            case 87: 
            case 94: 
            case 96: 
            case 98: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 117: 
            case 119: 
            case 129: 
            case 131: 
            case 135: 
            case 137: 
            case 139: 
            case 140: 
            case 158: 
            case 166: 
            case 169: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 182: 
            case 185: 
            case 188: 
            case 190: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 204: 
            case 206: 
            case 208: 
            case 211: 
            case 213: 
            case 215: 
            case 217: 
            case 219: 
            case 221: 
            case 223: 
            case 225: 
            case 227: 
            case 229: 
            case 231: 
            case 233: 
            case 235: 
            case 240: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 1: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 85: 
            case 87: 
            case 94: 
            case 96: 
            case 98: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 117: 
            case 119: 
            case 129: 
            case 131: 
            case 135: 
            case 137: 
            case 139: 
            case 140: 
            case 158: 
            case 166: 
            case 169: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 182: 
            case 185: 
            case 188: 
            case 190: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 204: 
            case 206: 
            case 208: 
            case 211: 
            case 213: 
            case 215: 
            case 217: 
            case 219: 
            case 221: 
            case 223: 
            case 225: 
            case 227: 
            case 229: 
            case 231: 
            case 233: 
            case 235: 
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 55: 
            case 99: 
            case 102: 
            case 107: 
            case 118: 
            case 120: 
            case 142: 
            case 143: 
            case 170: 
            case 171: 
            case 173: 
            case 201: 
            case 224: 
            case 226: 
            case 234: 
            case 241: 
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 30: 
            case 31: 
            case 43: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 64: 
            case 84: 
            case 141: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 202: 
            case 203: 
            case 205: 
            case 207: 
            case 209: 
            case 212: 
            case 214: 
            case 216: 
            case 220: 
            case 222: 
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 19: 
            case 179: 
            case 181: 
            case 184: 
            case 187: 
            case 189: 
            case 191: 
            case 193: 
            case 195: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f2";
                break;
            }
            case 33: 
            case 35: 
            case 41: 
            case 230: 
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 37: 
            case 39: 
            case 218: 
            case 228: 
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 45: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFiles";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 59: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 66: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 83: 
            case 165: 
            case 168: 
            case 183: 
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 86: 
            case 134: 
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aParentFolder";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aFilePrefix";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aExtension";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFolder";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aFileName";
                break;
            }
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 111: 
            case 121: 
            case 125: 
            case 159: 
            case 161: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 122: 
            case 126: 
            case 164: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFiles";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteRoot";
                break;
            }
            case 128: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "antPattern";
                break;
            }
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 160: 
            case 162: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathString";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFiles";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isAncestorThreeState";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "startsWith";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileBytes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFirstAndClose";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTextAndClose";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptiveLoadText";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptiveLoadBytes";
                break;
            }
            case 44: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncDelete";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "findSequentNonexistentFile";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentName";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeTail";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveShortWindowsName";
                break;
            }
            case 129: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAntToRegexp";
                break;
            }
            case 135: 
            case 137: 
            case 139: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeFileName";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "fileTraverser";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesByMask";
                break;
            }
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesOrDirsByMask";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "expandUserHome";
                break;
            }
            case 175: 
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 180: 
            case 182: 
            case 185: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 190: 
            case 192: 
            case 194: 
            case 196: 
            case 198: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRandomTemporaryPath";
                break;
            }
            case 204: 
            case 206: 
            case 208: 
            case 211: 
            case 213: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 215: 
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 221: 
            case 223: 
            case 225: 
            case 227: 
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 231: 
            case 233: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 1: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 85: 
            case 87: 
            case 94: 
            case 96: 
            case 98: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 117: 
            case 119: 
            case 129: 
            case 131: 
            case 135: 
            case 137: 
            case 139: 
            case 140: 
            case 158: 
            case 166: 
            case 169: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 182: 
            case 185: 
            case 188: 
            case 190: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 204: 
            case 206: 
            case 208: 
            case 211: 
            case 213: 
            case 215: 
            case 217: 
            case 219: 
            case 221: 
            case 223: 
            case 225: 
            case 227: 
            case 229: 
            case 231: 
            case 233: 
            case 235: 
            case 240: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAncestorThreeState";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findAncestor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadFileBytes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "loadFirstAndClose";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loadTextAndClose";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "adaptiveLoadText";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "adaptiveLoadBytes";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "asyncDelete";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "startDeletionThread";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "renameToTempFileOrDelete";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getTempFile";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirs";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createIfDoesntExist";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanCreateFile";
                break;
            }
            case 58: 
            case 59: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "openOutputStream";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "copyFileOrDir";
                break;
            }
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "copyDir";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContent";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "ensureExists";
                break;
            }
            case 84: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "createSequentFileName";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "findSequentNonexistentFile";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentName";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "processRoot";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "processDots";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTail";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isFilePathAcceptable";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "resolveShortWindowsName";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "containsWindowsShortName";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchedFiles";
                break;
            }
            case 128: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "convertAntToRegexp";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "moveDirWithContent";
                break;
            }
            case 134: 
            case 136: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeFileName";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "canExecute";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "canWrite";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnlyAttribute";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "appendToFile";
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "processFilesRecursively";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "findFirstThatExist";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "findFilesByMask";
                break;
            }
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "findFilesOrDirsByMask";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePlatformIndependent";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "isUnixAbsolutePath";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsAbsolutePath";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "expandUserHome";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "isHashBangLine";
                break;
            }
            case 179: 
            case 181: 
            case 183: 
            case 184: 
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 189: 
            case 191: 
            case 193: 
            case 195: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "setExecutableAttribute";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "setLastModified";
                break;
            }
            case 203: 
            case 205: 
            case 207: 
            case 209: 
            case 210: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 214: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 220: 
            case 222: 
            case 224: 
            case 226: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 230: 
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "isJarOrZip";
                break;
            }
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "visitFiles";
                break;
            }
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "loadProperties";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "isRootPath";
                break;
            }
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "isFileSystemCaseSensitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 85: 
            case 87: 
            case 94: 
            case 96: 
            case 98: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 110: 
            case 117: 
            case 119: 
            case 129: 
            case 131: 
            case 135: 
            case 137: 
            case 139: 
            case 140: 
            case 158: 
            case 166: 
            case 169: 
            case 174: 
            case 175: 
            case 177: 
            case 180: 
            case 182: 
            case 185: 
            case 188: 
            case 190: 
            case 192: 
            case 194: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 204: 
            case 206: 
            case 208: 
            case 211: 
            case 213: 
            case 215: 
            case 217: 
            case 219: 
            case 221: 
            case 223: 
            case 225: 
            case 227: 
            case 229: 
            case 231: 
            case 233: 
            case 235: 
            case 240: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

