/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiReferenceListImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassReferenceListElementType
extends JavaStubElementType<PsiClassReferenceListStub, PsiReferenceList> {
    public JavaClassReferenceListElementType(@NotNull String id) {
        if (id == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(0);
        }
        super(id, true);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull PsiClassReferenceListStub stub) {
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(1);
        }
        return this.getPsiFactory(stub).createClassReferenceList(stub);
    }

    @Override
    public PsiReferenceList createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(2);
        }
        return new PsiReferenceListImpl(node);
    }

    @Override
    public PsiClassReferenceListStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        JavaClassReferenceListElementType type = (JavaClassReferenceListElementType)node.getTokenType();
        return new PsiClassReferenceListStubImpl(type, parentStub, JavaClassReferenceListElementType.getTexts(tree, node));
    }

    @NotNull
    private static String[] getTexts(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        if (tree == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(4);
        }
        List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(tree, node, JavaElementType.JAVA_CODE_REFERENCE);
        String[] texts = ArrayUtil.newStringArray(refs.size());
        for (int i = 0; i < refs.size(); ++i) {
            texts[i] = LightTreeUtil.toFilteredString(tree, refs.get(i), null);
        }
        if (texts == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(5);
        }
        return texts;
    }

    @Override
    public void serialize(@NotNull PsiClassReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(6);
        }
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(7);
        }
        String[] names = stub.getReferencedNames();
        dataStream.writeVarInt(names.length);
        for (String name : names) {
            dataStream.writeName(name);
        }
    }

    @Override
    @NotNull
    public PsiClassReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(8);
        }
        int len = dataStream.readVarInt();
        String[] names = ArrayUtil.newStringArray(len);
        for (int i = 0; i < names.length; ++i) {
            names[i] = dataStream.readNameString();
        }
        PsiClassReferenceListStubImpl psiClassReferenceListStubImpl = new PsiClassReferenceListStubImpl(this, parentStub, names);
        if (psiClassReferenceListStubImpl == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(9);
        }
        return psiClassReferenceListStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiClassReferenceListStub stub, @NotNull IndexSink sink) {
        PsiReferenceList.Role role;
        if (stub == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(11);
        }
        if ((role = stub.getRole()) == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names;
            for (String name : names = stub.getReferencedNames()) {
                String shortName = PsiNameHelper.getShortClassName(name);
                if (StringUtil.isEmptyOrSpaces(shortName)) continue;
                sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, shortName);
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, "Annotation");
                }
            }
        }
    }

    @NotNull
    public static PsiReferenceList.Role elementTypeToRole(@NotNull IElementType type) {
        if (type == null) {
            JavaClassReferenceListElementType.$$$reportNull$$$0(12);
        }
        if (type == JavaStubElementTypes.EXTENDS_BOUND_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(13);
            }
            return role;
        }
        if (type == JavaStubElementTypes.EXTENDS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.EXTENDS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(14);
            }
            return role;
        }
        if (type == JavaStubElementTypes.IMPLEMENTS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.IMPLEMENTS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(15);
            }
            return role;
        }
        if (type == JavaStubElementTypes.THROWS_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.THROWS_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(16);
            }
            return role;
        }
        if (type == JavaStubElementTypes.PROVIDES_WITH_LIST) {
            PsiReferenceList.Role role = PsiReferenceList.Role.PROVIDES_WITH_LIST;
            if (role == null) {
                JavaClassReferenceListElementType.$$$reportNull$$$0(17);
            }
            return role;
        }
        throw new RuntimeException("Unknown element type: " + type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaClassReferenceListElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTexts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "elementTypeToRole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTexts";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "elementTypeToRole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

