/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPolyExpressionUtil {
    public static boolean hasStandaloneForm(PsiExpression expression) {
        return !(expression instanceof PsiFunctionalExpression) && !(expression instanceof PsiParenthesizedExpression) && !(expression instanceof PsiConditionalExpression) && !(expression instanceof PsiCallExpression);
    }

    public static boolean isPolyExpression(PsiExpression expression) {
        ConditionalKind conditionalKind;
        if (expression instanceof PsiFunctionalExpression) {
            return true;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isPolyExpression(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression)) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        if (expression instanceof PsiMethodCallExpression) {
            return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, (PsiExpression expr) -> {
                MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(((PsiMethodCallExpression)expr).getArgumentList());
                return candidateProperties != null ? candidateProperties.getMethod() : ((PsiMethodCallExpression)expr).resolveMethod();
            });
        }
        if (expression instanceof PsiConditionalExpression && (conditionalKind = PsiPolyExpressionUtil.isBooleanOrNumeric(expression)) == null) {
            return PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression);
        }
        return false;
    }

    public static boolean isMethodCallPolyExpression(PsiExpression expression, PsiMethod method) {
        return PsiPolyExpressionUtil.isMethodCallPolyExpression(expression, (PsiExpression e) -> method);
    }

    private static boolean isMethodCallPolyExpression(PsiExpression expression, Function<PsiExpression, PsiMethod> methodResolver) {
        if (PsiPolyExpressionUtil.isInAssignmentOrInvocationContext(expression) && ((PsiCallExpression)expression).getTypeArguments().length == 0) {
            PsiMethod method = methodResolver.apply(expression);
            return method == null || PsiPolyExpressionUtil.isMethodCallTypeDependsOnInference(expression, method);
        }
        return false;
    }

    public static boolean isMethodCallTypeDependsOnInference(PsiExpression expression, PsiMethod method) {
        HashSet<PsiTypeParameter> typeParameters = new HashSet<PsiTypeParameter>(Arrays.asList(method.getTypeParameters()));
        if (!typeParameters.isEmpty()) {
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                return PsiPolyExpressionUtil.mentionsTypeParameters(returnType, typeParameters);
            }
        } else if (method.isConstructor() && expression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)expression)) {
            return true;
        }
        return false;
    }

    public static Boolean mentionsTypeParameters(@Nullable PsiType returnType, final Set<PsiTypeParameter> typeParameters) {
        if (returnType == null) {
            return false;
        }
        return returnType.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @NotNull
            public Boolean visitType(PsiType type) {
                Boolean bl = false;
                if (bl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return bl;
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return bound.accept(this);
                }
                return false;
            }

            @Override
            @NotNull
            public Boolean visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
                PsiClass psiClass = result2.getElement();
                if (psiClass != null) {
                    PsiSubstitutor substitutor = result2.getSubstitutor();
                    for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(psiClass)) {
                        PsiType type = substitutor.substitute(parameter);
                        if (type == null || !type.accept(this).booleanValue()) continue;
                        Boolean bl = true;
                        if (bl == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return bl;
                    }
                }
                Boolean bl = psiClass instanceof PsiTypeParameter && typeParameters.contains(psiClass);
                if (bl == null) {
                    1.$$$reportNull$$$0(2);
                }
                return bl;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/impl/source/resolve/graphInference/PsiPolyExpressionUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitType";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitClassType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    private static boolean isInAssignmentOrInvocationContext(PsiExpression expr) {
        PsiElement context = PsiUtil.skipParenthesizedExprUp(expr.getParent());
        return context instanceof PsiExpressionList || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && (expr instanceof PsiCallExpression || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)context)) || PsiPolyExpressionUtil.isAssignmentContext(expr, context);
    }

    private static boolean isAssignmentContext(PsiExpression expr, PsiElement context) {
        return PsiUtil.isCondition(expr, context) || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)context).getOperationTokenType() == JavaTokenType.EQ || context instanceof PsiVariable && !PsiPolyExpressionUtil.isVarContext((PsiVariable)context) || context instanceof PsiLambdaExpression;
    }

    private static boolean isVarContext(PsiVariable variable) {
        PsiTypeElement typeElement;
        return PsiUtil.getLanguageLevel(variable).isAtLeast(LanguageLevel.JDK_10) && (typeElement = variable.getTypeElement()) != null && typeElement.isInferredType();
    }

    public static boolean isExpressionOfPrimitiveType(@Nullable PsiExpression arg) {
        if (arg != null && !PsiPolyExpressionUtil.isPolyExpression(arg)) {
            PsiType type = arg.getType();
            return type instanceof PsiPrimitiveType && type != PsiType.NULL;
        }
        if (arg instanceof PsiNewExpression || arg instanceof PsiFunctionalExpression) {
            return false;
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isExpressionOfPrimitiveType(((PsiParenthesizedExpression)arg).getExpression());
        }
        if (arg instanceof PsiConditionalExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(arg) != null;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)arg).resolveMethod();
            return method != null && method.getReturnType() instanceof PsiPrimitiveType;
        }
        assert (false) : arg;
        return false;
    }

    private static ConditionalKind isBooleanOrNumeric(PsiExpression expr) {
        PsiMethod method;
        if (expr instanceof PsiParenthesizedExpression) {
            return PsiPolyExpressionUtil.isBooleanOrNumeric(((PsiParenthesizedExpression)expr).getExpression());
        }
        if (expr == null) {
            return null;
        }
        PsiType type = null;
        if (expr instanceof PsiNewExpression && !PsiDiamondType.hasDiamond((PsiNewExpression)expr) || PsiPolyExpressionUtil.hasStandaloneForm(expr)) {
            type = expr.getType();
        } else if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            type = method.getReturnType();
        }
        ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(type);
        if (kind != null) {
            return kind;
        }
        if (expr instanceof PsiConditionalExpression) {
            ConditionalKind elseKind;
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            ConditionalKind thenKind = PsiPolyExpressionUtil.isBooleanOrNumeric(thenExpression);
            if (thenKind == (elseKind = PsiPolyExpressionUtil.isBooleanOrNumeric(elseExpression)) || elseKind == ConditionalKind.NULL) {
                return thenKind;
            }
            if (thenKind == ConditionalKind.NULL) {
                return elseKind;
            }
        }
        return null;
    }

    @Nullable
    private static ConditionalKind isBooleanOrNumericType(PsiType type) {
        if (type == PsiType.NULL) {
            return ConditionalKind.NULL;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
        if (TypeConversionUtil.isNumericType(type)) {
            return ConditionalKind.NUMERIC;
        }
        if (TypeConversionUtil.isBooleanType(type)) {
            return ConditionalKind.BOOLEAN;
        }
        if (psiClass instanceof PsiTypeParameter) {
            for (PsiClassType classType : psiClass.getExtendsListTypes()) {
                ConditionalKind kind = PsiPolyExpressionUtil.isBooleanOrNumericType(classType);
                if (kind == null) continue;
                return kind;
            }
        }
        return null;
    }

    private static enum ConditionalKind {
        BOOLEAN,
        NUMERIC,
        NULL;

    }
}

