/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiSearchHelper {
    @NotNull
    public static PsiSearchHelper getInstance(@NotNull Project project) {
        if (project == null) {
            PsiSearchHelper.$$$reportNull$$$0(0);
        }
        PsiSearchHelper psiSearchHelper = ServiceManager.getService(project, PsiSearchHelper.class);
        if (psiSearchHelper == null) {
            PsiSearchHelper.$$$reportNull$$$0(1);
        }
        return psiSearchHelper;
    }

    @NotNull
    public PsiElement[] findCommentsContainingIdentifier(@NotNull String var1, @NotNull SearchScope var2);

    public boolean processCommentsContainingIdentifier(@NotNull String var1, @NotNull SearchScope var2, @NotNull Processor<PsiElement> var3);

    @NotNull
    public PsiFile[] findFilesWithPlainTextWords(@NotNull String var1);

    public boolean processUsagesInNonJavaFiles(@NotNull String var1, @NotNull PsiNonJavaFileReferenceProcessor var2, @NotNull GlobalSearchScope var3);

    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement var1, @NotNull String var2, @NotNull PsiNonJavaFileReferenceProcessor var3, @NotNull GlobalSearchScope var4);

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement var1);

    public boolean processAllFilesWithWord(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<PsiFile> var3, boolean var4);

    public boolean processAllFilesWithWordInText(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<PsiFile> var3, boolean var4);

    public boolean processAllFilesWithWordInComments(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<PsiFile> var3);

    public boolean processAllFilesWithWordInLiterals(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<PsiFile> var3);

    public boolean processRequests(@NotNull SearchRequestCollector var1, @NotNull Processor<PsiReference> var2);

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector var1, @NotNull Processor<PsiReference> var2);

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor var1, @NotNull SearchScope var2, @NotNull String var3, short var4, boolean var5);

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor var1, @NotNull SearchScope var2, @NotNull String var3, short var4, boolean var5, boolean var6);

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor var1, @NotNull SearchScope var2, @NotNull String var3, short var4, boolean var5);

    @NotNull
    public SearchCostResult isCheapEnoughToSearch(@NotNull String var1, @NotNull GlobalSearchScope var2, @Nullable PsiFile var3, @Nullable ProgressIndicator var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PsiSearchHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PsiSearchHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SearchCostResult {
        ZERO_OCCURRENCES,
        FEW_OCCURRENCES,
        TOO_MANY_OCCURRENCES;

    }

    public static class SERVICE {
        private SERVICE() {
        }

        public static PsiSearchHelper getInstance(@NotNull Project project) {
            if (project == null) {
                SERVICE.$$$reportNull$$$0(0);
            }
            return PsiSearchHelper.getInstance(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/PsiSearchHelper$SERVICE", "getInstance"));
        }
    }
}

