/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.TObjectFloatHashMap;
import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanBinding
extends NotNullDeserializeBinding {
    private static final Map<Class, List<MutableAccessor>> ourAccessorCache = ContainerUtil.createConcurrentSoftValueMap();
    private final String myTagName;
    private Binding[] myBindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable MutableAccessor accessor) {
        if (beanClass == null) {
            BeanBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        this.compareByFields = ThreeState.UNSURE;
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        if (originalType == null) {
            BeanBinding.$$$reportNull$$$0(1);
        }
        if (serializer2 == null) {
            BeanBinding.$$$reportNull$$$0(2);
        }
        assert (this.myBindings == null);
        Property classAnnotation = this.myBeanClass.getAnnotation(Property.class);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = BeanBinding.createBinding(accessors.get(i), serializer2, classAnnotation == null ? Property.Style.OPTION_TAG : classAnnotation.style());
            binding.init(originalType, serializer2);
            this.myBindings[i] = binding;
        }
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        if (o == null) {
            BeanBinding.$$$reportNull$$$0(3);
        }
        return this.serializeInto(o, context == null ? null : new Element(this.myTagName), filter);
    }

    public Element serialize(@NotNull Object object, boolean createElementIfEmpty, @Nullable SerializationFilter filter) {
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(4);
        }
        return this.serializeInto(object, createElementIfEmpty ? new Element(this.myTagName) : null, filter);
    }

    @Nullable
    public Element serializeInto(@NotNull Object o, @Nullable Element element, @Nullable SerializationFilter filter) {
        if (o == null) {
            BeanBinding.$$$reportNull$$$0(5);
        }
        for (Binding binding : this.myBindings) {
            Object node;
            MutableAccessor accessor = binding.getAccessor();
            if (o instanceof SerializationFilter && !((SerializationFilter)o).accepts(accessor, o)) continue;
            Property property2 = accessor.getAnnotation(Property.class);
            if (property2 == null || !property2.alwaysWrite()) {
                if (filter != null && (!(filter instanceof SkipDefaultsSerializationFilter) ? !filter.accepts(accessor, o) : ((SkipDefaultsSerializationFilter)filter).equal(binding, o))) continue;
                if (property2 != null && property2.filter() != SerializationFilter.class && !ReflectionUtil.newInstance(property2.filter()).accepts(accessor, o)) continue;
            }
            if (element == null) {
                element = new Element(this.myTagName);
            }
            if ((node = binding.serialize(o, element, filter)) == null) continue;
            if (node instanceof org.jdom.Attribute) {
                element.setAttribute((org.jdom.Attribute)node);
                continue;
            }
            BeanBinding.addContent(element, node);
        }
        return element;
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(6);
        }
        Object instance = ReflectionUtil.newInstance(this.myBeanClass);
        this.deserializeInto(instance, element);
        Object obj = instance;
        if (obj == null) {
            BeanBinding.$$$reportNull$$$0(7);
        }
        return obj;
    }

    boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter) {
        if (currentValue == null) {
            BeanBinding.$$$reportNull$$$0(8);
        }
        if (defaultValue == null) {
            BeanBinding.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            BeanBinding.$$$reportNull$$$0(10);
        }
        for (Binding binding : this.myBindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (filter.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TObjectFloatHashMap<String> computeBindingWeights(@NotNull LinkedHashSet<String> accessorNameTracker) {
        if (accessorNameTracker == null) {
            BeanBinding.$$$reportNull$$$0(11);
        }
        TObjectFloatHashMap weights = new TObjectFloatHashMap(accessorNameTracker.size());
        float weight = 0.0f;
        float step = (float)this.myBindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put((Object)name, weight);
            weight += step;
        }
        weight = 0.0f;
        for (Binding binding : this.myBindings) {
            String name = binding.getAccessor().getName();
            if (!weights.containsKey((Object)name)) {
                weights.put((Object)name, weight);
            }
            weight += 1.0f;
        }
        TObjectFloatHashMap tObjectFloatHashMap = weights;
        if (tObjectFloatHashMap == null) {
            BeanBinding.$$$reportNull$$$0(12);
        }
        return tObjectFloatHashMap;
    }

    public void sortBindings(final @NotNull TObjectFloatHashMap<String> weights) {
        if (weights == null) {
            BeanBinding.$$$reportNull$$$0(13);
        }
        Arrays.sort(this.myBindings, new Comparator<Binding>(){

            @Override
            public int compare(@NotNull Binding o1, @NotNull Binding o2) {
                if (o1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (o2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                String n1 = o1.getAccessor().getName();
                String n2 = o2.getAccessor().getName();
                float w1 = weights.get((Object)n1);
                float w2 = weights.get((Object)n2);
                return (int)(w1 - w2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/xmlb/BeanBinding$1";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void deserializeInto(@NotNull Object result2, @NotNull Element element) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(14);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(15);
        }
        this.deserializeInto(result2, element, null);
    }

    public void deserializeInto(@NotNull Object result2, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        if (result2 == null) {
            BeanBinding.$$$reportNull$$$0(16);
        }
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(17);
        }
        block0: for (org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (Binding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result2, attribute.getValue());
                continue block0;
            }
        }
        MultiMap<Binding, Element> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (Binding binding : this.myBindings) {
                if (content instanceof org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result2, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = MultiMap.createLinked();
                    }
                    data.putValue(binding, child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result2, child);
                continue block2;
            }
        }
        for (Binding binding : this.myBindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat()) continue;
            ((AccessorBindingWrapper)binding).deserialize(result2, element);
        }
        if (data != null) {
            for (Binding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result2, (List)data.get(binding));
            }
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            BeanBinding.$$$reportNull$$$0(18);
        }
        return element.getName().equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass) {
        int lastIndexOf;
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(19);
        }
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            String string = name;
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(20);
            }
            return string;
        }
        String name = aClass.getSimpleName();
        if (name.isEmpty()) {
            name = aClass.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf + 1) {
            String string = name.substring(lastIndexOf + 1);
            if (string == null) {
                BeanBinding.$$$reportNull$$$0(21);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            BeanBinding.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    private static String getTagNameFromAnnotation(@NotNull Class<?> aClass) {
        Tag tag;
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(23);
        }
        return (tag = aClass.getAnnotation(Tag.class)) != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        List<MutableAccessor> accessors;
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(24);
        }
        if ((accessors = ourAccessorCache.get(aClass)) != null) {
            List<MutableAccessor> list = accessors;
            if (list == null) {
                BeanBinding.$$$reportNull$$$0(25);
            }
            return list;
        }
        accessors = new ArrayList<MutableAccessor>();
        Map<Object, Object> nameToAccessors = aClass == Rectangle.class ? Collections.emptyMap() : BeanBinding.collectPropertyAccessors(aClass, accessors);
        int propertyAccessorCount = accessors.size();
        BeanBinding.collectFieldAccessors(aClass, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = accessors.get(j).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!accessors.get(i).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        ourAccessorCache.put(aClass, accessors);
        List<MutableAccessor> list = accessors;
        if (list == null) {
            BeanBinding.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<MutableAccessor> accessors) {
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(27);
        }
        if (accessors == null) {
            BeanBinding.$$$reportNull$$$0(28);
        }
        TreeMap<String, Couple<Method>> candidates = new TreeMap<String, Couple<Method>>();
        for (Method method : aClass.getMethods()) {
            NameAndIsSetter propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || propertyData.name.equals("class") || method.getParameterTypes().length != (propertyData.isSetter ? 1 : 0)) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.name);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if ((propertyData.isSetter ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = Couple.of(propertyData.isSetter ? (Method)candidate.first : method, propertyData.isSetter ? method : (Method)candidate.second);
            candidates.put(propertyData.name, candidate);
        }
        Iterator iterator = candidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry candidate = iterator.next();
            Couple methods = (Couple)candidate.getValue();
            Method getter = (Method)methods.first;
            Method setter = (Method)methods.second;
            if (BeanBinding.isAcceptableProperty(getter, setter)) {
                accessors.add(new PropertyAccessor((String)candidate.getKey(), getter.getReturnType(), getter, setter));
                continue;
            }
            iterator.remove();
        }
        TreeMap<String, Couple<Method>> treeMap = candidates;
        if (treeMap == null) {
            BeanBinding.$$$reportNull$$$0(29);
        }
        return treeMap;
    }

    private static boolean isAcceptableProperty(@Nullable Method getter, @Nullable Method setter) {
        if (getter == null || getter.getAnnotation(Transient.class) != null) {
            return false;
        }
        if (setter == null) {
            return (Collection.class.isAssignableFrom(getter.getReturnType()) || Map.class.isAssignableFrom(getter.getReturnType())) && BeanBinding.hasStoreAnnotations(getter);
        }
        return setter.getAnnotation(Transient.class) == null && getter.getReturnType().equals(setter.getParameterTypes()[0]);
    }

    private static boolean hasStoreAnnotations(@NotNull AccessibleObject object) {
        if (object == null) {
            BeanBinding.$$$reportNull$$$0(30);
        }
        return object.getAnnotation(OptionTag.class) != null || object.getAnnotation(Tag.class) != null || object.getAnnotation(Attribute.class) != null || object.getAnnotation(Property.class) != null || object.getAnnotation(Text.class) != null || object.getAnnotation(CollectionBean.class) != null || object.getAnnotation(MapAnnotation.class) != null || object.getAnnotation(XMap.class) != null || object.getAnnotation(XCollection.class) != null || object.getAnnotation(AbstractCollection.class) != null;
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass, @NotNull List<MutableAccessor> accessors) {
        if (aClass == null) {
            BeanBinding.$$$reportNull$$$0(31);
        }
        if (accessors == null) {
            BeanBinding.$$$reportNull$$$0(32);
        }
        Class<?> currentClass = aClass;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                Class<?> fieldType;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !BeanBinding.hasStoreAnnotations(field) && (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) && !Collection.class.isAssignableFrom(fieldType = field.getType()) && !Map.class.isAssignableFrom(fieldType) || field.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static NameAndIsSetter getPropertyData(@NotNull String methodName) {
        if (methodName == null) {
            BeanBinding.$$$reportNull$$$0(33);
        }
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2);
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3);
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            part = part.substring(0, suffixIndex);
        }
        return new NameAndIsSetter(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer2, @NotNull Property.Style propertyStyle) {
        XMap xMap;
        Binding binding;
        if (accessor == null) {
            BeanBinding.$$$reportNull$$$0(34);
        }
        if (serializer2 == null) {
            BeanBinding.$$$reportNull$$$0(35);
        }
        if (propertyStyle == null) {
            BeanBinding.$$$reportNull$$$0(36);
        }
        if ((binding = serializer2.getBinding(accessor)) instanceof JDOMElementBinding) {
            Binding binding2 = binding;
            if (binding2 == null) {
                BeanBinding.$$$reportNull$$$0(37);
            }
            return binding2;
        }
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, attribute);
            if (attributeBinding == null) {
                BeanBinding.$$$reportNull$$$0(38);
            }
            return attributeBinding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            TagBinding tagBinding = new TagBinding(accessor, tag);
            if (tagBinding == null) {
                BeanBinding.$$$reportNull$$$0(39);
            }
            return tagBinding;
        }
        Text text2 = accessor.getAnnotation(Text.class);
        if (text2 != null) {
            TextBinding textBinding = new TextBinding(accessor);
            if (textBinding == null) {
                BeanBinding.$$$reportNull$$$0(40);
            }
            return textBinding;
        }
        if (binding instanceof CompactCollectionBinding) {
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, false, Property.Style.OPTION_TAG);
            if (accessorBindingWrapper == null) {
                BeanBinding.$$$reportNull$$$0(41);
            }
            return accessorBindingWrapper;
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property2 = accessor.getAnnotation(Property.class);
        if (property2 != null) {
            surroundWithTag = property2.surroundWithTag();
            inline = property2.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            AccessorBindingWrapper accessorBindingWrapper = new AccessorBindingWrapper(accessor, binding, inline, property2.style());
            if (accessorBindingWrapper == null) {
                BeanBinding.$$$reportNull$$$0(42);
            }
            return accessorBindingWrapper;
        }
        XCollection xCollection = accessor.getAnnotation(XCollection.class);
        if (!(xCollection == null || xCollection.propertyElementName().isEmpty() && xCollection.style() != XCollection.Style.v2)) {
            TagBinding tagBinding = new TagBinding(accessor, xCollection.propertyElementName());
            if (tagBinding == null) {
                BeanBinding.$$$reportNull$$$0(43);
            }
            return tagBinding;
        }
        OptionTag optionTag = accessor.getAnnotation(OptionTag.class);
        if (optionTag == null && (xMap = accessor.getAnnotation(XMap.class)) != null) {
            TagBinding tagBinding = new TagBinding(accessor, xMap.propertyElementName());
            if (tagBinding == null) {
                BeanBinding.$$$reportNull$$$0(44);
            }
            return tagBinding;
        }
        if (propertyStyle == Property.Style.ATTRIBUTE) {
            AttributeBinding attributeBinding = new AttributeBinding(accessor, null);
            if (attributeBinding == null) {
                BeanBinding.$$$reportNull$$$0(45);
            }
            return attributeBinding;
        }
        OptionTagBinding optionTagBinding = new OptionTagBinding(accessor, optionTag);
        if (optionTagBinding == null) {
            BeanBinding.$$$reportNull$$$0(46);
        }
        return optionTagBinding;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorNameTracker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weights";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/BeanBinding";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeBindingWeights";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPropertyAccessors";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeInto";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalByFields";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeBindingWeights";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortBindings";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deserializeInto";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTagNameFromAnnotation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAccessors";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertyAccessors";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasStoreAnnotations";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldAccessors";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NameAndIsSetter {
        final String name;
        final boolean isSetter;

        public NameAndIsSetter(String name, boolean isSetter) {
            this.name = name;
            this.isSetter = isSetter;
        }
    }
}

