/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReplacementUtil {
    private static final Logger LOG = Logger.getInstance(PsiReplacementUtil.class);

    public static void replaceExpression(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(0);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(1);
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, expression);
        PsiElement replacementExpression = expression.replace(newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        styleManager.reformat(replacementExpression);
    }

    public static void replaceExpression(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(2);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(3);
        }
        Project project = expression.getProject();
        PsiElement replacementExpression = tracker.replaceAndRestoreComments((PsiElement)expression, newExpressionText);
        CodeStyleManager.getInstance(project).reformat(replacementExpression);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(4);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(5);
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, expression);
        PsiElement replacementExp = expression.replace(newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression, @NotNull @NonNls String newExpressionText, CommentTracker tracker) {
        if (expression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(6);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(7);
        }
        Project project = expression.getProject();
        PsiElement replacementExp = tracker.replaceAndRestoreComments((PsiElement)expression, newExpressionText);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(8);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(9);
        }
        Project project = statement.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, statement);
        PsiElement replacementExp = statement.replace(newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, CommentTracker commentTracker) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(10);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(11);
        }
        Project project = statement.getProject();
        PsiElement replacementExp = commentTracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        return styleManager.reformat(replacementExp);
    }

    public static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText) {
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(12);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(13);
        }
        PsiReplacementUtil.replaceStatementAndShortenClassNames(statement, newStatementText, null);
    }

    public static PsiElement replaceStatementAndShortenClassNames(@NotNull PsiStatement statement, @NotNull @NonNls String newStatementText, @Nullable CommentTracker tracker) {
        PsiStatement newStatement;
        if (statement == null) {
            PsiReplacementUtil.$$$reportNull$$$0(14);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(15);
        }
        Project project = statement.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance(project);
        if (tracker != null) {
            newStatement = (PsiStatement)tracker.replaceAndRestoreComments((PsiElement)statement, newStatementText);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            newStatement = (PsiStatement)statement.replace(factory.createStatementFromText(newStatementText, statement));
        }
        return styleManager.reformat(javaStyleManager.shortenClassReferences(newStatement));
    }

    @NotNull
    public static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(16);
        }
        StringBuilder out = new StringBuilder();
        PsiReplacementUtil.getElementText(element, elementToReplace, replacement, out);
        String string = out.toString();
        if (string == null) {
            PsiReplacementUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(18);
        }
        if (out == null) {
            PsiReplacementUtil.$$$reportNull$$$0(19);
        }
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children) {
            PsiReplacementUtil.getElementText(child, elementToReplace, replacement, out);
        }
    }

    public static void replaceOperatorAssignmentWithAssignmentExpression(@NotNull PsiAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(20);
        }
        CommentTracker tracker = new CommentTracker();
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator = sign.getText();
        String newOperator = operator.substring(0, operator.length() - 1);
        String lhsText = tracker.text(lhs);
        String rhsText = rhs == null ? "" : tracker.text(rhs);
        boolean parentheses = ParenthesesUtils.areParenthesesNeeded(sign, rhs);
        String cast = PsiReplacementUtil.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        PsiReplacementUtil.replaceExpression(assignmentExpression, newExpression.toString(), tracker);
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        if (lhs == null || rhs == null) {
            return "";
        }
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (TypeConversionUtil.isNumericType(rType)) {
            rType = TypeConversionUtil.binaryNumericPromotion(lType, rType);
        }
        if (lType == null || rType == null || TypeConversionUtil.isAssignable(lType, rType) || !TypeConversionUtil.areTypesConvertible(lType, rType)) {
            return "";
        }
        return '(' + lType.getCanonicalText() + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpressionText";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatementText";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndShorten";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementAndShortenClassNames";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 17: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "replaceOperatorAssignmentWithAssignmentExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

