/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AssignmentToNullInspection
extends BaseInspection {
    public boolean ignoreAssignmentsToFields = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.null.display.name", new Object[0]);
        if (string == null) {
            AssignmentToNullInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.null.problem.descriptor", new Object[0]);
        if (string == null) {
            AssignmentToNullInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Object info = infos[0];
        if (!(info instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)info;
        if (TypeUtils.isOptional(referenceExpression.getType())) {
            return null;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)target;
        if (NullableNotNullManager.isNotNull(variable)) {
            return null;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(target.getProject());
        return new DelegatingFix(new AddAnnotationPsiFix(manager.getDefaultNullable(), variable, PsiNameValuePair.EMPTY_ARRAY, new String[0]));
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assignment.to.null.option", new Object[0]), this, "ignoreAssignmentsToFields");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToNullVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/assignment/AssignmentToNullInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class AssignmentToNullVisitor
    extends BaseInspectionVisitor {
        private AssignmentToNullVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression value) {
            if (value == null) {
                AssignmentToNullVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(value);
            String text2 = value.getText();
            if (!"null".equals(text2)) {
                return;
            }
            PsiElement parent = value.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
            if (lhs == null || this.isReferenceToNullableVariable(lhs)) {
                return;
            }
            this.registerError((PsiElement)lhs, lhs);
        }

        private boolean isReferenceToNullableVariable(PsiExpression lhs) {
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)element;
            if (AssignmentToNullInspection.this.ignoreAssignmentsToFields && variable instanceof PsiField) {
                return true;
            }
            return NullableNotNullManager.isNullable(variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/siyeh/ig/assignment/AssignmentToNullInspection$AssignmentToNullVisitor", "visitLiteralExpression"));
        }
    }
}

