/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

class ParameterClassCheckVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiParameter parameter;
    private boolean checked;

    ParameterClassCheckVisitor(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(0);
        }
        this.parameter = parameter;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(1);
        }
        if (!this.checked) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(2);
        }
        if (this.checked) {
            return;
        }
        super.visitMethodCallExpression(expression);
        if (this.isGetClassCall(expression) || this.isGetInstanceCall(expression) || this.isCallToSuperEquals(expression)) {
            this.checked = true;
        }
    }

    private boolean isGetInstanceCall(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"isInstance".equals(methodName)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (!"java.lang.Class".equals(className)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions = argumentList.getExpressions();
        if (expressions.length != 1) {
            return false;
        }
        PsiExpression expression = expressions[0];
        return this.isParameterReference(expression);
    }

    private boolean isGetClassCall(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"getClass".equals(methodName) || !methodCallExpression.getArgumentList().isEmpty()) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (!"java.lang.Object".equals(className)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        return this.isParameterReference(qualifier);
    }

    private boolean isCallToSuperEquals(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (!(qualifierExpression instanceof PsiSuperExpression)) {
            return false;
        }
        String name = methodExpression.getReferenceName();
        if (!"equals".equals(name)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return false;
        }
        PsiExpression argument = arguments[0];
        if (!(argument instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
        PsiElement target = referenceExpression.resolve();
        return this.parameter.equals(target);
    }

    @Override
    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            ParameterClassCheckVisitor.$$$reportNull$$$0(3);
        }
        if (this.checked) {
            return;
        }
        super.visitInstanceOfExpression(expression);
        PsiExpression operand = expression.getOperand();
        if (this.isParameterReference(operand)) {
            this.checked = true;
        }
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        if (this.checked) {
            return;
        }
        super.visitTypeCastExpression(expression);
        PsiExpression operand = expression.getOperand();
        if (!this.isParameterReference(operand)) {
            return;
        }
        PsiTryStatement statement = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTryStatement.class);
        if (statement == null) {
            return;
        }
        PsiParameter[] parameters = statement.getCatchBlockParameters();
        if (parameters.length < 2) {
            return;
        }
        boolean nullPointerExceptionFound = false;
        boolean classCastExceptionFound = false;
        for (PsiParameter parameter : parameters) {
            PsiType type = parameter.getType();
            if (type.equalsToText("java.lang.NullPointerException")) {
                nullPointerExceptionFound = true;
                if (!classCastExceptionFound) continue;
                break;
            }
            if (!type.equalsToText("java.lang.ClassCastException")) continue;
            classCastExceptionFound = true;
            if (nullPointerExceptionFound) break;
        }
        if (classCastExceptionFound && nullPointerExceptionFound) {
            this.checked = true;
        }
    }

    private boolean isParameterReference(PsiExpression operand) {
        if (operand == null) {
            return false;
        }
        if (!(operand instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression expression = (PsiReferenceExpression)operand;
        PsiElement referent = expression.resolve();
        return referent != null && referent.equals(this.parameter);
    }

    public boolean isChecked() {
        return this.checked;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bugs/ParameterClassCheckVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInstanceOfExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

