/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class StaticFieldReferenceOnSubclassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getID() {
        if ("StaticFieldReferencedViaSubclass" == null) {
            StaticFieldReferenceOnSubclassInspection.$$$reportNull$$$0(0);
        }
        return "StaticFieldReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.field.via.subclass.display.name", new Object[0]);
        if (string == null) {
            StaticFieldReferenceOnSubclassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("static.field.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
        if (string == null) {
            StaticFieldReferenceOnSubclassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticFieldOnSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticFieldOnSubclassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StaticFieldOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticFieldOnSubclassVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            PsiElement qualifier = expression.getQualifier();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiElement qualifierReferent = ((PsiReferenceExpression)qualifier).resolve();
            if (!(qualifierReferent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)qualifierReferent;
            PsiClass declaringClass = field.getContainingClass();
            if (declaringClass == null || declaringClass.equals(referencedClass)) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(expression.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible(declaringClass, expression, null)) {
                return;
            }
            PsiElement identifier = expression.getReferenceNameElement();
            if (identifier == null) {
                return;
            }
            this.registerError(identifier, declaringClass, referencedClass);
        }
    }

    private static class StaticFieldOnSubclassFix
    extends InspectionGadgetsFix {
        private StaticFieldOnSubclassFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("static.field.via.subclass.rationalize.quickfix", new Object[0]);
            if (string == null) {
                StaticFieldOnSubclassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIdentifier name = ObjectUtils.tryCast(descriptor.getPsiElement(), PsiIdentifier.class);
            if (name == null) {
                return;
            }
            PsiReferenceExpression expression = ObjectUtils.tryCast(name.getParent(), PsiReferenceExpression.class);
            if (expression == null) {
                return;
            }
            PsiField field = ObjectUtils.tryCast(expression.resolve(), PsiField.class);
            if (field == null) {
                return;
            }
            expression.bindToElement(field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection$StaticFieldOnSubclassFix", "getFamilyName"));
        }
    }
}

