/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UseOfCloneInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.of.clone.display.name", new Object[0]);
        if (string == null) {
            UseOfCloneInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object errorElement = infos[0];
        if (errorElement instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("use.of.clone.call.problem.descriptor", new Object[0]);
            if (string == null) {
                UseOfCloneInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (errorElement instanceof PsiMethod) {
            String string = InspectionGadgetsBundle.message("use.of.clone.call.method.problem.descriptor", new Object[0]);
            if (string == null) {
                UseOfCloneInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("use.of.clone.reference.problem.descriptor", new Object[0]);
        if (string == null) {
            UseOfCloneInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfCloneVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/cloneable/UseOfCloneInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UseOfCloneVisitor
    extends BaseInspectionVisitor {
        private UseOfCloneVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiType type;
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"clone".equals(referenceName) || !expression.getArgumentList().isEmpty()) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null && (type = qualifierExpression.getType()) instanceof PsiArrayType) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiMethod) || !CloneUtils.isClone((PsiMethod)target)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            String qualifiedName = reference.getQualifiedName();
            if (!"java.lang.Cloneable".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)reference, reference);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            if (!CloneUtils.isClone(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }
    }
}

