/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.dataflow.ScopeUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooBroadScopeInspectionBase
extends BaseInspection {
    public boolean m_allowConstructorAsInitializer = false;
    public boolean m_onlyLookAtBlocks = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.scope.display.name", new Object[0]);
        if (string == null) {
            TooBroadScopeInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("TooBroadScope" == null) {
            TooBroadScopeInspectionBase.$$$reportNull$$$0(1);
        }
        return "TooBroadScope";
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel checkboxOptionsPanel = new MultipleCheckboxOptionsPanel(this);
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.only.blocks.option", new Object[0]), "m_onlyLookAtBlocks");
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.allow.option", new Object[0]), "m_allowConstructorAsInitializer");
        return checkboxOptionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("too.broad.scope.problem.descriptor", new Object[0]);
        if (string == null) {
            TooBroadScopeInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean isMoveable(PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return true;
        }
        if (PsiUtil.isConstantExpression(expression) || ExpressionUtils.isNullLiteral(expression)) {
            return true;
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression;
            for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
                if (this.isMoveable(initializer)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof PsiNewExpression) {
            PsiExpression[] expressions;
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
            if (arrayDimensions.length > 0) {
                for (PsiExpression arrayDimension : arrayDimensions) {
                    if (this.isMoveable(arrayDimension)) continue;
                    return false;
                }
                return true;
            }
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer != null) {
                PsiExpression[] initializers;
                for (PsiExpression initializerExpression : initializers = arrayInitializer.getInitializers()) {
                    if (this.isMoveable(initializerExpression)) continue;
                    return false;
                }
                return true;
            }
            PsiType type = newExpression.getType();
            if (type == null) {
                return false;
            }
            if (!this.m_allowConstructorAsInitializer && !TooBroadScopeInspectionBase.isAllowedType(type)) {
                return false;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            for (PsiExpression argumentExpression : expressions = argumentList.getExpressions()) {
                if (this.isMoveable(argumentExpression)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (!this.isMoveable(qualifier)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiClass) {
                return true;
            }
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            if (!ClassUtils.isImmutable(variable.getType()) && !CollectionUtils.isEmptyArray(variable)) {
                return false;
            }
            if (variable.hasModifierProperty("final")) {
                return true;
            }
            PsiElement context = PsiUtil.getVariableCodeBlock(variable, referenceExpression);
            return context != null && !(variable instanceof PsiField) && HighlightControlFlowUtil.isEffectivelyFinal(variable, context, referenceExpression);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (this.isMoveable(operand)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof PsiMethodCallExpression) {
            if (!TooBroadScopeInspectionBase.isAllowedType(expression.getType())) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (!TooBroadScopeInspectionBase.isAllowedMethod(method)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null && !this.isMoveable(qualifierExpression)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            for (PsiExpression argument : argumentList.getExpressions()) {
                if (this.isMoveable(argument)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAllowedMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null || !qualifiedName.startsWith("java.") || qualifiedName.equals("java.lang.Thread")) {
            return false;
        }
        String methodName = method.getName();
        return !"now".equals(methodName) && !"currentTimeMillis".equals(methodName) && !"nanoTime".equals(methodName) && !"waitFor".equals(methodName);
    }

    private static boolean isAllowedType(PsiType type) {
        if (ClassUtils.isImmutable(type)) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type);
        return TooBroadScopeInspectionBase.isAllowedClass(aClass);
    }

    private static boolean isAllowedClass(@Nullable PsiClass aClass) {
        if (InheritanceUtil.isInheritor(aClass, "java.util.Collection") || InheritanceUtil.isInheritor(aClass, "java.util.Map")) {
            return true;
        }
        return aClass != null && aClass.isEnum();
    }

    static List<PsiReferenceExpression> findReferences(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            TooBroadScopeInspectionBase.$$$reportNull$$$0(3);
        }
        SmartList<PsiReferenceExpression> result2 = new SmartList<PsiReferenceExpression>();
        ReferencesSearch.search(variable, variable.getUseScope()).forEach(reference -> reference instanceof PsiReferenceExpression && result2.add((PsiReferenceExpression)reference));
        return result2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadScopeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dataflow/TooBroadScopeInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dataflow/TooBroadScopeInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TooBroadScopeVisitor
    extends BaseInspectionVisitor {
        TooBroadScopeVisitor() {
        }

        @Override
        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (variable instanceof PsiResourceVariable) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (!TooBroadScopeInspectionBase.this.isMoveable(initializer)) {
                return;
            }
            List<PsiReferenceExpression> references = TooBroadScopeInspectionBase.findReferences(variable);
            if (references.isEmpty()) {
                return;
            }
            PsiElement commonParent = ScopeUtils.getCommonParent(references);
            if (commonParent == null) {
                return;
            }
            Object variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class, PsiForStatement.class);
            if (variableScope == null) {
                return;
            }
            if (initializer != null && (commonParent = ScopeUtils.moveOutOfLoopsAndClasses(commonParent, variableScope)) == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(commonParent, variableScope, true)) {
                return;
            }
            if (PsiTreeUtil.isAncestor(variableScope, commonParent, true)) {
                this.registerVariableError(variable, variable);
                return;
            }
            if (TooBroadScopeInspectionBase.this.m_onlyLookAtBlocks) {
                return;
            }
            if (commonParent instanceof PsiForStatement) {
                return;
            }
            PsiElement referenceElement = references.get(0);
            PsiElement blockChild = ScopeUtils.getChildWhichContainsElement(variableScope, referenceElement);
            if (blockChild == null) {
                return;
            }
            PsiElement insertionPoint = ScopeUtils.findTighterDeclarationLocation(blockChild, variable);
            if (insertionPoint == null) {
                if (!(blockChild instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)blockChild;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQ) {
                    return;
                }
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!lhs.equals(referenceElement)) {
                    return;
                }
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed(variable, rhs)) {
                    return;
                }
            }
            if (insertionPoint != null && FileTypeUtils.isInServerPageFile(insertionPoint)) {
                PsiElement variableParent;
                PsiElement elementBefore = insertionPoint.getPrevSibling();
                if ((elementBefore = PsiTreeUtil.skipWhitespacesBackward(elementBefore)) instanceof PsiDeclarationStatement && elementBefore.equals(variableParent = variable.getParent())) {
                    return;
                }
            }
            this.registerVariableError(variable, variable);
        }
    }
}

