/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NewExceptionWithoutArgumentsInspection
extends BaseInspection {
    @Deprecated
    public boolean ignoreWithoutParameters;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("new.exception.without.arguments.display.name", new Object[0]);
        if (string == null) {
            NewExceptionWithoutArgumentsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("new.exception.without.arguments.problem.descriptor", new Object[0]);
        if (string == null) {
            NewExceptionWithoutArgumentsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NewExceptionWithoutArgumentsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/NewExceptionWithoutArgumentsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NewExceptionWithoutArgumentsVisitor
    extends BaseInspectionVisitor {
        private NewExceptionWithoutArgumentsVisitor() {
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null || !argumentList.isEmpty()) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            if (classReference == null) {
                return;
            }
            PsiElement target = classReference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (!InheritanceUtil.isInheritor(aClass, "java.lang.Exception")) {
                return;
            }
            if (NewExceptionWithoutArgumentsVisitor.hasAccessibleConstructorWithParameters(aClass, expression)) {
                this.registerNewExpressionError(expression, new Object[0]);
            }
        }

        private static boolean hasAccessibleConstructorWithParameters(PsiClass aClass, PsiElement context) {
            PsiMethod[] constructors;
            for (PsiMethod constructor : constructors = aClass.getConstructors()) {
                PsiResolveHelper resolveHelper;
                PsiParameterList parameterList = constructor.getParameterList();
                int count = parameterList.getParametersCount();
                if (count <= 0 || !(resolveHelper = JavaPsiFacade.getInstance(context.getProject()).getResolveHelper()).isAccessible(constructor, context, aClass)) continue;
                return true;
            }
            return false;
        }
    }
}

